<div class="container">
    <h1>Daily Time Record</h2>
    <h5>Hello <span><?php echo $first_name; ?></span>.</h5>
    <hr>



    <table id="data-table" class="display" cellspacing="0" width="100%">
        <thead>
        <tr>
            <th>
                Name
            </th>
            <th>
                Year
            </th>
        	<th>
                Month
            </th>
            <th>
                Day
            </th>
            <th>
                In Time
            </th>
            <th>
                Out Time
            </th>
        </tr>
        </thead>
        <tbody>
        </tbody>
    </table>
</div>

</div><!--row-->

<footer>
    <div class="col-md-12" style="text-align:center;">
        <hr>
        Copyright&copy; - <?php echo date('Y'); ?> | Create by <a
                href="https://connectwithdev.com/">connectwithdev.com</a>
    </div>
</footer>
</div><!-- /container -->

<!-- Modal -->
<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title" id="myModalLabel">Attendance Login System</h4>
            </div>
            <div class="modal-body">
                <h2>Version</h2>
                <p>V3.0</p>
                <h2>About</h2>
                <p>Attendance login system is based on the <a
                            href="https://github.com/bcit-ci/CodeIgniter">codeigniter</a>.
                <p>If you have question, please email me : <a
                            href="mailto:abedputra@gmail.com">abedputra@gmail.com</a><br>
                    Visit: <a href="https://connectwithdev.com/page/contact" rel="nofollow">https://connectwithdev.com/</a></p>
                <h2>License</h2>
                <p>The MIT License (MIT).</p>
                <p>Copyright&copy; <?php echo date('Y'); ?>, Abed Putra.</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>


<!-- /Load Js -->
<script src="https://code.jquery.com/jquery-1.12.4.js"></script>
<script src="https://cdn.jsdelivr.net/clipboard.js/1.5.12/clipboard.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>
<script src="<?php echo base_url() . 'public/js/main.js' ?>"></script>
<script type="text/javascript"
        src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/js/bootstrap-datepicker.min.js"></script>
<!--script type="text/javascript"
        src="https://cdn.datatables.net/r/dt/jq-2.1.4,jszip-2.5.0,pdfmake-0.1.18,dt-1.10.9,af-2.0.0,b-1.0.3,b-colvis-1.0.3,b-html5-1.0.3,b-print-1.0.3,se-1.0.1/datatables.min.js"></script-->
<script type="text/javascript" src="<?php echo base_url() . 'public/js/datatables/datatables.min.js' ?>"></script>
<script src="https://cdn.datatables.net/1.10.13/js/dataTables.bootstrap.min.js"></script>


<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/pdfmake.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/vfs_fonts.js"></script>
<!--script type="text/javascript" src="https://cdn.datatables.net/v/dt/jq-3.3.1/jszip-2.5.0/dt-1.10.21/af-2.3.5/b-1.6.2/b-colvis-1.6.2/b-flash-1.6.2/b-html5-1.6.2/b-print-1.6.2/cr-1.5.2/fc-3.3.1/fh-3.1.7/kt-2.5.2/r-2.2.5/rg-1.1.2/rr-1.2.7/sc-2.0.2/sp-1.1.1/sl-1.3.1/datatables.min.js"></script-->
<script src="<?php echo base_url() . 'public/js/moment.js' ?>"></script>
<script src="<?php echo base_url() . 'public/js/datetime.js' ?>"></script>

<script>

    var table;
    $(document).ready(function () {

        $.fn.dataTableExt.oApi.fnPagingInfo = function (oSettings) {
            return {
                "iStart": oSettings._iDisplayStart,
                "iEnd": oSettings.fnDisplayEnd(),
                "iLength": oSettings._iDisplayLength,
                "iTotal": oSettings.fnRecordsTotal(),
                "iFilteredTotal": oSettings.fnRecordsDisplay(),
                "iPage": Math.ceil(oSettings._iDisplayStart / oSettings._iDisplayLength),
                "iTotalPages": Math.ceil(oSettings.fnRecordsDisplay() / oSettings._iDisplayLength)
            };
        };

        table = $("#data-table").DataTable({
            initComplete: function () {
                var api = this.api();
                $('#data-table_filter input')
                    .off('.DT')
                    .on('input.DT', function () {
                        api.search(this.value).draw();
                    });
            },
            oLanguage: {
                sProcessing: "loading..."
            },
            processing: true,
            serverSide: false,
            "scrollX": true,
        	select: true,
            
            ajax: {
                "url": "<?php echo site_url('report/dataTableJson'); ?>",
                "type": "POST",
                "data": {"role": "<?php echo $role; ?>", "name": "<?php echo $name; ?>"}
            },
        	searchPane: true,
       		searchPanes:{
            	cascadePanes: true,
                viewTotal: true,
           		columns:[0, 1, 2, 3],
            	layout: 'columns-4',
	        },
    	    



        	dom: 'PlBfrtip',
            buttons: [
            'colvis',
            'selectRows',
             /*{
                extend: 'copyHtml5',
                exportOptions: {
                    columns: [ 0, ':visible' ]
                }
            },*/
            {
                extend: 'excelHtml5',
                exportOptions: {
                    columns: [0, 2, 3, 4, 5 ]
                }
            },
            
            {
                extend: 'pdfHtml5',
                exportOptions: {
                    columns: [0, 2, 3, 4, 5 ]
                },

            },
            
            {
                extend: 'print',
                title: $('h1').text(),
                exportOptions: {
                    columns: [0, 2, 3, 4, 5 ]
                }



            },
            
            
            ],
            columns: [
               
                {"data": "name", width: 170},
            	{"data": "date",  render: $.fn.dataTable.render.moment( 'YYYY' ), width: 70},    
            	{"data": "date",  render: $.fn.dataTable.render.moment( 'MMMM' ), width: 70},
                {"data": "date",  render: $.fn.dataTable.render.moment( 'D' ), width: 10},
                {"data": "in_time", width: 70},
                {"data": "out_time", width: 70}
            ],
            order: [[2, 'desc'],[3, 'desc']],
            rowCallback: function (row, data, iDisplayIndex) {
                var info = this.fnPagingInfo();
                var page = info.iPage;
                var length = info.iLength;
                $('td:eq(0)', row).html();
            },

columnDefs:[


          
            {
                searchPanes:{
                    show: true,
                
                         },
                    targets: [0, 1, 2]
             }],




        });

        $(".form-control.input-sm").attr("placeholder", "Search multi columns");
        $(".dataTables_length").css("margin-right", "10px");

    });

/* // {"data": "id", width: 10},
  	 {
                searchPanes: {
                    options:[
                        {
                            label: 'Day 1',
                            value: function(rowData, rowIdx){
                                return rowData[2] == 01;
                            }
                        },
                        {
                            label: 'Day 2',
                            value: function(rowData, rowIdx){
                                return rowData[2] == 02;
                            }
                        },
                        
                    ]
                },
                targets:[2],
            },
 */               


</script>



</body>
</html>

