<?php 
/*
   Generated by Manuigniter v2.0 
   www.manuigniter.com
*/
class Resource_model extends CI_Model 
{ 
     function __construct()
      {
          parent::__construct();
          $this->load->model('Loans_model');
      }
      /*
        * Get resource by id 
      */ 
      function get_resource($id)
      {
        try{
           return $this->db->get_where('resource',array('id'=>$id))->row_array();
           } catch (Exception $ex) {
             throw new Exception('Resource_model Model : Error in get_resource function - ' . $ex);
           }  
      }
      /*
        * Get resource by  column name
      */ 
      function get_resourcebyclm_name($clm_name,$clm_value)
      {
        try{
           return $this->db->get_where('resource',array($clm_name=>$clm_value))->row_array();
           } catch (Exception $ex) {
             throw new Exception('Resource_model Madel : Error in get_resourcebyclm_name function - ' . $ex);
           }  
      }
     /*
        * Get All resource count 
      */ 
      function get_all_resource_count()
      {
        try{
           $this->db->from('resource');
           return $this->db->count_all_results();
           } catch (Exception $ex) {
             throw new Exception('Resource_model model : Error in get_all_resource_count function - ' . $ex);
           }  
      }


function available_count($book_id)
      {
        try{
           $this->db->select( '*');
           $this->db->from('loans');
           $this->db->where('book_id', $book_id);
           $this->db->where('status', 0);
            return $this->db->count_all_results();
           } catch (Exception $ex) {
             throw new Exception('Loans_model model : Error in get_all_loans_count function - ' . $ex);
             }
      }



     /*
        * Get All with associated tables join resourcecount 
      */ 
      function get_all_with_asso_resource()
      {
        try{
           $this->db->select('*');
           $this->db->from('resource a  ' );
            $this->db->join('classification b', 'b.id_class=a. classification','left');
          $query = $this->db->get(); 
            if($query->num_rows() != 0){
               return $query->result_array();
            }else{
                return false;
            }
           } catch (Exception $ex) {
             throw new Exception('Resource_model model : Error in get_all_with_asso_resource function - ' . $ex);
           }  
      }
      /*
          * Get all resource 
      */ 
      function get_all_resource($params = array())
      {
        try{
              $this->db->order_by('id', 'desc');
              if(isset($params) && !empty($params)){
               $this->db->limit($params['limit'], $params['offset']);
              }
               return $this->db->get('resource')->result_array();
           } catch (Exception $ex) {
             throw new Exception('Resource_model model : Error in get_all_resource function - ' . $ex);
           }  
      } 
      /*
         * function to add new resource 
      */
      function add_resource($params)
      {
        try{
          $this->db->insert('resource',$params);
        return $this->db->insert_id();
           } catch (Exception $ex) {
             throw new Exception('Resource_model model : Error in add_resource function - ' . $ex);
           }  
      }
      /* 
          * function to update resource 
      */
      function update_resource($id,$params)
      {
        try{
            $this->db->where('id',$id);
        return $this->db->update('resource',$params);
           } catch (Exception $ex) {
             throw new Exception('Resource_model model : Error in update_resource function - ' . $ex);
           }  
       }
     /* 
          * function to delete resource 
      */
       function delete_resource($id)
       {
        try{
             return $this->db->delete('resource',array('id'=>$id));
           } catch (Exception $ex) {
             throw new Exception('Resource_model model : Error in delete_resource function - ' . $ex);
           }  
       }
      /*
        * Get resource by  column name where not in particular id
      */ 
      function get_resourcebyclm_name_not_id($clm_name,$clm_value,$where_cond)
      {
        try{
            $this->db->where('id!=', $where_cond);
           return $this->db->get_where('resource',array($clm_name=>$clm_value))->row_array();
           } catch (Exception $ex) {
             throw new Exception('Resource_model model : Error in get_resourcebyclm_name_not_id function - ' . $ex);
           }  
      }
     /*
        * Get All with associated tables join resourcecount 
      */ 
      function get_all_with_asso_resource_by_cat($column_name=null,$value_id=null,$params=array())
      {
        try{
           $this->db->select('*');
           $this->db->from('resource a  ' );
              //$this->db->where($column_name, $value_id);
            $this->db->join('classification b', 'b.id_class=a. classification','left');
              $this->db->where('a.'.$column_name, $value_id);
          $query = $this->db->get(); 
            if($query->num_rows() != 0){
               return $query->result_array();
            }else{
                return false;
            }
           } catch (Exception $ex) {
             throw new Exception('Resource_model model : Error in get_all_with_asso_resource_by_cat function - ' . $ex);
           }  
      }
      /*
          * Get all resource_by_cat 
      */ 
      function get_all_resource_by_cat($column_name=null,$value_id=null,$params=array())
      {
        try{
              $this->db->order_by('id', 'desc');
              $this->db->where($column_name, $value_id);
              if(isset($params) && !empty($params)){
               $this->db->limit($params['limit'], $params['offset']);
              }
               return $this->db->get('resource')->result_array();
           } catch (Exception $ex) {
             throw new Exception('Resource_model model : Error in get_all_resource_by_cat function - ' . $ex);
           }  
      } 
 }
