<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Allotment extends MY_Controller {

	public function __construct() {
		parent::__construct();
		$this->isLogin();
	}

	public function index()
	{
		$this->list();
	}

	public function list()
	{
		$this->redirect_disbursement_user();
		
		$login_user_data = $this->login_user_data();
		$this->data['body_class'] = "sidebar-collapse";
		$this->data["allotment_type"] = $this->input->get("type") ? $this->input->get("type") : "received";
		if($this->data["allotment_type"] == "received") {
			$this->data['nav_bar'] = array("allotment","received");
		}  else if($this->data["allotment_type"] == "realignment")  {
			$this->data['nav_bar'] = array("allotment","realignment");
		}
		
		$this->data["error_allotment_class"] = isset($this->data["error_allotment_class"]) ? $this->data["error_allotment_class"] : array();
		$this->data["error_message"] = $this->session->flashdata('error_message') ? $this->session->flashdata('error_message') : false ;

		$this->load->model('allotment_model', '', TRUE);
		$this->load->model('responsibility_center_model', '', TRUE);
		$this->load->model('funds_model', '', TRUE);
		$this->load->model('prexc_model', '', TRUE);
		$this->load->model('legal_basis_model', '', TRUE);

		$this->data['content'] = 'allotment/list';

		$this->data['fund_list'] = $this->funds_model->get_fund_list();
		$this->data['prexc'] = $this->prexc_model->get_prexc_list();
		$this->data["fund_id"] = $this->input->get("fund_id") ? $this->input->get("fund_id") : sha1($this->data['fund_list'][0]->id);
		$fund_id = $this->data["fund_id"] == sha1(1) ? 1 : 2;
		
		
		$this->data['year'] = $this->input->get("year") ? $this->input->get("year") : date("Y");
		$this->data['fund_legal_basis'] = $this->legal_basis_model->get_fund_legal_basis($fund_id, $this->data['year'], true);
		$this->data['legal_basis_id'] = $this->input->get("legal_basis_id") ? $this->input->get("legal_basis_id") : (count( $this->data['fund_legal_basis']) > 0 ? $this->data['fund_legal_basis'][0]->id : 0);
		$this->data['prexc_id'] = $this->input->get("prexc_id") ? $this->input->get("prexc_id") : (count( $this->data['prexc']) > 0 ? $this->data['prexc'][0]->id : 0);
		$this->data["object_amounts"] = isset($this->data["object_amounts"]) ? $this->data["object_amounts"] : false;
		
		if($login_user_data["type"] != 1) {
			$this->data['rc'] = $this->funds_model->get_fund_rc_list($this->data["fund_id"] , $this->data['year'],  false,  false, $login_user_data["id"]);
		} else {
			$this->data['rc'] = $this->funds_model->get_fund_rc_list($this->data["fund_id"] , $this->data['year']);
		}

		$this->data['fund_rc_id'] = $this->input->get("fund_rc_id") ? $this->input->get("fund_rc_id") : (count($this->data['rc']) > 0 ? $this->data['rc'][0]->fund_rc_id : 0);

		if($this->data['legal_basis_id'] == 0 || $this->data['prexc_id'] == 0 || $this->data['fund_rc_id'] == 0) {
			$this->data['allotment_list_has_data'] = false;
			$this->data['show_table'] = false;
			$this->data['show_table_edit_button'] = false;
			$this->data['allotment_list'] = array();
		} else {
			$this->data['invalid_filter'] = false;
			$this->data['allotment_list'] = $this->allotment_model->get_allotment_list($this->data['year'], $fund_id, $this->data['fund_rc_id'], $this->data['prexc_id'], $this->data['legal_basis_id'], true);
		
			$allotment_list_by_class = array();
			$grand_total = array("allotment" => 0, "obligation" => 0);
			if(count($this->data['allotment_list']) > 0) {
				foreach($this->data['allotment_list'] as $list) {
					$_list = $list;
					$_list->total_allotment = ($list->first_amount + $list->second_amount + $list->third_amount + $list->fourth_amount); 
					$grand_total_allotment = (isset($allotment_list_by_class[$list->allotment_class]["grand_total_allotment"]) ? $allotment_list_by_class[$list->allotment_class]["grand_total_allotment"] : 0 ) ; 
					$grand_total_obligation = (isset($allotment_list_by_class[$list->allotment_class]["grand_total_obligation"]) ? $allotment_list_by_class[$list->allotment_class]["grand_total_obligation"] : 0 ) ; 
					$allotment_list_by_class[$list->allotment_class]["list"][] = $_list;
					$allotment_list_by_class[$list->allotment_class]["grand_total_allotment"] = $grand_total_allotment + $_list->total_allotment;
					$allotment_list_by_class[$list->allotment_class]["grand_total_obligation"] = $grand_total_obligation + $_list->total_obligation;
					$grand_total["allotment"] += $_list->total_allotment;
					$grand_total["obligation"] += $_list->total_obligation;
				}
			}
	
			$this->data['grand_total'] = $grand_total;
			$this->data['allotment_list_by_class'] = $allotment_list_by_class;
	
			$this->data['allotment_list_has_data'] = $this->allotment_model->check_if_allotment_list_has_data($this->data['fund_rc_id'], $this->data['prexc_id'], $this->data['legal_basis_id']);
			$this->data['show_table'] = $this->data['allotment_type'] == "received" || ($this->data['allotment_type'] != "received" && $this->data['allotment_list_has_data']);
			$this->data['show_table_edit_button'] = ($this->data['allotment_type'] == "received" && !$this->data['allotment_list_has_data']) || ($this->data['allotment_type'] != "received" && $this->data['allotment_list_has_data']) ;  
		}
		$this->load->view('template/admin', $this->data);
	}

	public function ogmentation()
	{
		$this->data['body_class'] = "sidebar-collapse";
		$this->data['nav_bar'] = array("allotment","ogmentation");
		$this->data['content'] = 'allotment/ogmentation';
		
		$this->data["error_allotment_class"] = isset($this->data["error_allotment_class"]) ? $this->data["error_allotment_class"] : array();
		$this->data["error_message"] = $this->session->flashdata('error_message') ? $this->session->flashdata('error_message') : false ;

		$this->load->model('allotment_model', '', TRUE);
		$this->load->model('responsibility_center_model', '', TRUE);
		$this->load->model('funds_model', '', TRUE);
		$this->load->model('prexc_model', '', TRUE);
		$this->load->model('legal_basis_model', '', TRUE);

		$this->data['fund_list'] = $this->funds_model->get_fund_list();
		$this->data['prexc'] = $this->prexc_model->get_prexc_list();
		$this->data["fund_id"] = $this->input->get("fund_id") ? $this->input->get("fund_id") : sha1($this->data['fund_list'][0]->id);
		$fund_id = $this->data["fund_id"] == sha1(1) ? 1 : 2;

		$this->data['year'] = $this->input->get("year") ? $this->input->get("year") : date("Y");
		$this->data['fund_legal_basis'] = $this->legal_basis_model->get_fund_legal_basis($fund_id, $this->data['year'], true);
		
		$this->data['legal_basis_id_from'] = $this->input->get("legal_basis_id_from") ? $this->input->get("legal_basis_id_from") : (count( $this->data['fund_legal_basis']) > 0 ? $this->data['fund_legal_basis'][0]->id : 0);
		$this->data['legal_basis_id_to'] = $this->input->get("legal_basis_id_to") ? $this->input->get("legal_basis_id_to") : (count( $this->data['fund_legal_basis']) > 0 ? $this->data['fund_legal_basis'][0]->id : 0);
		
		$this->data['prexc_id_from'] = $this->input->get("prexc_id_from") ? $this->input->get("prexc_id_from") : count( $this->data['prexc']) > 0 ? $this->data['prexc'][0]->id : 0;
		$this->data['prexc_id_to'] = $this->input->get("prexc_id_to") ? $this->input->get("prexc_id_to") : count( $this->data['prexc']) > 0 ? $this->data['prexc'][0]->id : 0;

		$this->data["object_amounts"] = isset($this->data["object_amounts"]) ? $this->data["object_amounts"] : false;
		$this->data['rc'] = $this->funds_model->get_fund_rc_list($this->data["fund_id"] , $this->data['year'], true);
		
		$this->data['fund_rc_id_from'] = $this->input->get("fund_rc_id") ? $this->input->get("fund_rc_id") : (count($this->data['rc']) > 0 ? $this->data['rc'][0]->fund_rc_id : 0);
		$this->data['fund_rc_id_to'] = $this->input->get("fund_rc_id") ? $this->input->get("fund_rc_id") : (count($this->data['rc']) > 1 ? $this->data['rc'][1]->fund_rc_id : 0);
		
		if(	$this->data['legal_basis_id_from'] == 0 
			|| $this->data['prexc_id_from'] == 0 
			|| $this->data['fund_rc_id_from'] == 0
			|| $this->data['legal_basis_id_to'] == 0 
			|| $this->data['prexc_id_to'] == 0 
			|| $this->data['fund_rc_id_to'] == 0
		) {
			$this->data['allotment_list_has_data'] = false;
			$this->data['show_table'] = false;
			$this->data['show_table_edit_button'] = false;
			$this->data['allotment_list'] = array();
		} else {
			$this->data['invalid_filter'] = false;
			$this->data['allotment_list_from'] = $this->allotment_model->get_allotment_list($this->data['year'], $fund_id, $this->data['fund_rc_id_from'], $this->data['prexc_id_from'], $this->data['legal_basis_id_from'], true);
			$this->data['allotment_list_to'] = $this->allotment_model->get_allotment_list($this->data['year'], $fund_id, $this->data['fund_rc_id_to'], $this->data['prexc_id_to'], $this->data['legal_basis_id_to'], true);
		
			$allotment_list_by_class = array();
			$grand_from_total = array("allotment" => 0, "obligation" => 0);
			if(count($this->data['allotment_list_from']) > 0) {
				foreach($this->data['allotment_list_from'] as $list) {
					$_list = $list;
					$_list->total_allotment = ($list->first_amount + $list->second_amount + $list->third_amount + $list->fourth_amount); 
					$grand_total_allotment = (isset($allotment_list_from_by_class[$list->allotment_class]["grand_total_allotment"]) ? $allotment_list_from_by_class[$list->allotment_class]["grand_total_allotment"] : 0 ) ; 
					$grand_total_obligation = (isset($allotment_list_from_by_class[$list->allotment_class]["grand_total_obligation"]) ? $allotment_list_from_by_class[$list->allotment_class]["grand_total_obligation"] : 0 ) ; 
					$allotment_list_from_by_class[$list->allotment_class]["list"][] = $_list;
					$allotment_list_from_by_class[$list->allotment_class]["grand_total_allotment"] = $grand_total_allotment + $_list->total_allotment;
					$allotment_list_from_by_class[$list->allotment_class]["grand_total_obligation"] = $grand_total_obligation + $_list->total_obligation;
					$grand_from_total["allotment"] += $_list->total_allotment;
					$grand_from_total["obligation"] += $_list->total_obligation;
				}
			}

			$grand_to_total = array("allotment" => 0, "obligation" => 0);
			if(count($this->data['allotment_list_from']) > 0) {
				foreach($this->data['allotment_list_to'] as $list) {
					$_list = $list;
					$_list->total_allotment = ($list->first_amount + $list->second_amount + $list->third_amount + $list->fourth_amount); 
					$grand_total_allotment = (isset($allotment_list_to_by_class[$list->allotment_class]["grand_total_allotment"]) ? $allotment_list_to_by_class[$list->allotment_class]["grand_total_allotment"] : 0 ) ; 
					$grand_total_obligation = (isset($allotment_list_to_by_class[$list->allotment_class]["grand_total_obligation"]) ? $allotment_list_to_by_class[$list->allotment_class]["grand_total_obligation"] : 0 ) ; 
					$allotment_list_to_by_class[$list->allotment_class]["list"][] = $_list;
					$allotment_list_to_by_class[$list->allotment_class]["grand_total_allotment"] = $grand_total_allotment + $_list->total_allotment;
					$allotment_list_to_by_class[$list->allotment_class]["grand_total_obligation"] = $grand_total_obligation + $_list->total_obligation;
					$grand_to_total["allotment"] += $_list->total_allotment;
					$grand_to_total["obligation"] += $_list->total_obligation;
				}
			}
	
			$this->data['grand_total_from'] = $grand_from_total;
			$this->data['grand_total_to'] = $grand_to_total;
			$this->data['allotment_list_from_by_class'] = $allotment_list_from_by_class;
			$this->data['allotment_list_to_by_class'] = $allotment_list_to_by_class;
	
			//$this->data['allotment_list_has_data'] = $this->allotment_model->check_if_allotment_list_has_data( $fund_id, $this->data['fund_rc_id'], $this->data['prexc_id'], $this->data['legal_basis_id']);
			$this->data['show_table'] = true;
                         
		}

		$this->load->view('template/admin', $this->data);
	}

	public function save_new()
	{
		$this->load->model('allotment_model', '', TRUE);
		$this->load->model('responsibility_center_model', '', TRUE);
		$this->load->model('object_of_expenditures_model', '', TRUE);

		$year = $this->input->post("year");
		$fund_id = $this->input->post("fund_id") == sha1(1) ? 1 : 2;
		$legal_basis_id = $this->input->post("legal_basis_id");
		$fund_rc_id = $this->input->post("fund_rc_id");
		$prexc_id = $this->input->post("prexc_id");

		$obj_ids = $this->input->post("obj_id");
		$first_amounts = $this->input->post("first_amounts");
		$second_amounts = $this->input->post("second_amounts");
		$third_amounts = $this->input->post("third_amounts");
		$fourth_amounts = $this->input->post("fourth_amounts");
		
		$this->data["object_amounts"] = array();

		$allotment_received = array(
			"fund_rc_id" => $fund_rc_id,
			"legal_basis_id" => $legal_basis_id,
			"prexc_id" => $prexc_id
		);
		$allotment_received_details = array();
		$total_amount = 0;
		$objects = array();
		foreach($first_amounts as $obj_id => $first_amount) {
			$temp_data = array();

			$temp_data["object_id"] = $obj_id;
			$temp_data["first_amount"] = $first_amounts[$obj_id];
			$temp_data["second_amount"] = $second_amounts[$obj_id];
			$temp_data["third_amount"] = $third_amounts[$obj_id];
			$temp_data["fourth_amount"] = $fourth_amounts[$obj_id];
			$allotment_received_details[] = $temp_data;
		}							
		// if($err_message == "") {
			$this->allotment_model->edit_allotment($allotment_received, $allotment_received_details, $fund_rc_id, $prexc_id, $legal_basis_id);
			redirect(site_url("allotment/list?fund_id=" . $this->input->post("fund_id") . "&year=" . $year . "&legal_basis_id=" . $legal_basis_id . "&fund_rc_id=" . $fund_rc_id . "&prexc_id=" . $prexc_id));
		// } else {
		// 	$this->session->set_flashdata('error_message', $err_message);
		// 	$_GET = $_POST;
		// 	$this->list();
		// }
	}

	public function add_new()
	{
		$this->data['content'] = 'allotment/add_new';
		$this->load->model('prexc_model', '', TRUE);
		$this->load->model('responsibility_center_model', '', TRUE);
		$this->load->model('object_of_expenditures_model', '', TRUE);
		$this->load->model('funds_model', '', TRUE);

		$this->data['fund_list'] = $this->funds_model->get_fund_list();
		$this->data['rc'] = $this->responsibility_center_model->get_responsibility_center_list();
		$this->data['prexc'] = $this->prexc_model->get_prexc_list();
		$this->data['objects'] = $this->object_of_expenditures_model->get_object_list();

		$this->load->view('template/admin', $this->data);
	}

	public function get_available_allotment_received()
	{
		$this->load->model('allotment_model', '', TRUE);
		$this->load->model('object_of_expenditures_model', '', TRUE);
		$message = "";

		$object_id = $this->input->post('object_id');
		$fund_id = $this->input->post('fund_id') == sha1(1) ? 1 : 2;
		$fund_rc_id = $this->input->post('fund_rc_id');
		$prexc_id = $this->input->post('prexc_id');
		$legal_basis_id = $this->input->post('legal_basis_id');

		$date = $this->input->post("date");
		$year = date("Y", strtotime($date));

		$total_available_amount = $this->allotment_model->get_available_allotment_recieved_per_object($year, $fund_id, $fund_rc_id, $prexc_id, $legal_basis_id, $object_id);
	
		$url_param = "fund_id=" . $this->input->post('fund_id') . "&year=" . $year ."&fund_rc_id=" . $fund_rc_id . "&prexc_id=" . $prexc_id . "&legal_basis_id=" . $legal_basis_id ;
		output_to_json($this,array("available_amount" => $total_available_amount, "url_param" => $url_param,  "message" => $message));
	}

	// public function get_available_allotment_class_budget()
	// {
	// 	$this->load->model('allotment_model', '', TRUE);
	// 	$this->load->model('object_of_expenditures_model', '', TRUE);
	// 	$message = "";
	// 	$available_amount = 0;
	// 	// $object_id = $this->input->post('object_id');
	// 	$object_id = 1;
	// 	$allotment_class = $this->object_of_expenditures_model->get_allotment_class_by_object($object_id) ;
	// 	$total_amount_allotment_class_budget = $this->allotment_model->get_total_amount_allotment_class_budget_by_id(2018, $allotment_class->id);
	// 	//$total_fund_budget = $this->fund_model->get_total_fund_budget(2018);
	// 	$available_amount ;
	// 	//$available_amount = ($total_fund_budget - $total_amount_allotment_class_budget);
	// 	$available_amount = $total_amount_allotment_class_budget;
	// 	output_to_json($this,array("available_amount" => $available_amount, "allotment_class" => $allotment_class,  "message" => $message));
	// }

	// public function get_total_allotment()
	// {
	// 	$this->load->model('allotment_model', '', TRUE);
	// 	$message = "";
	// 	$fund_id = $this->input->get('fund_id') == sha1(1) ? 1 : 2;
	// 	$total_allotment = $this->allotment_model->get_total_allotment($this->input->get('year'), $fund_id);

	// 	output_to_json($this,array("total_allotment" => $total_allotment,  "message" => $message));
	// }

}
