<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Appropriations extends MY_Controller {

	public function __construct() {
		parent::__construct();
		$this->isLogin();
	}

	public function index()
	{
		$this->list();
	
	}

	public function list()
	{
		$this->redirect_disbursement_user();
		$this->data['nav_bar'] = array("appropriations","list");
		$this->data['year'] = $this->input->get("year") ? $this->input->get("year") : date("Y");
		$this->data['content'] = 'appropriations/list';
		$this->load->model('appropriations_model', '', TRUE);

		if($this->login_user_data["type"] != 1) {
			$this->data['new_general_appropriations_list'] = $this->appropriations_model->get_appropriations_list(1, $this->data['year'], false, $this->login_user_data["id"]);
			$this->data['continuing_appropriations_list'] = $this->appropriations_model->get_appropriations_list(2, $this->data['year'], false, $this->login_user_data["id"]);
		} else {
			$this->data['new_general_appropriations_list'] = $this->appropriations_model->get_appropriations_list(1, $this->data['year']);
			$this->data['continuing_appropriations_list'] = $this->appropriations_model->get_appropriations_list(2, $this->data['year']);
		}
		
		$this->load->view('template/admin', $this->data);
	}

	public function edit_allotment_class_budget()
	{
		$amounts = $this->input->post('amount');
		$year = $this->input->post('year');
		$fund_id = $this->input->post('fund_id');
		$data = array();
		foreach ($amounts as $ac_id => $amount) {
			$temp_data = array();
			$temp_data["amount"] = $amount;
			$temp_data["year"] = 2018;
			$temp_data["allotment_class_id"] = $ac_id;
			$temp_data["fund_id"] = $fund_id;
			$data[] = $temp_data;
		}

		$this->load->model('appropriations_model', '', TRUE);
		$this->appropriations_model->edit_allotment_class_budget($data, $fund_id,  $year);
		
		redirect(site_url("appropriations/list"));
	}

	public function get_total_appropriations_budget()
	{
		$message = "";
		$fund_id = $this->input->get('fund_id') == sha1(1) ? 1 : 2;
		$this->load->model('allotment_model', '', TRUE);
		$total_appropriations = $this->allotment_model->get_total_amount_allotment_class_budget($this->input->get('year'), $fund_id);
		
		output_to_json($this,array("total_appropriations" => $total_appropriations,  "message" => $message));
	}

}
