<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Authentication extends MY_Controller {

	public function __construct() {
		parent::__construct();
	}
	
	public function index()
	{
		$this->login_page();
	}
	
	public function login_page()
	{
		if(!$this->session->userdata('login_admin_data'))
		{
			$this->data['page_title'] = 'Login';
			$this->data['content'] = 'admin/login_view';
			$this->data['validation_message'] = '';
			$this->load->view('authentication/login', $this->data);
		} else {
			redirect(site_url("appropriations"));
		}
	}
	
	public function login()
	{
		$message = "Not Validation";
		

		if(trim($this->input->post('username')) != "" && trim($this->input->post('password')) != "")
		{
			$username = $this->input->post('username');
			$password = $this->input->post('password');		
		
			$this->load->model('user_information_model', '', TRUE);
				$user_information = $this->user_information_model->backend_authentication_details($username, $password);
				
				if($user_information != false) 
				{
					$login_admin_data = array( 'login_admin_data' =>
						array (
							'id'  => $user_information->id,
							'username'  => $user_information->username,
							'name'  => $user_information->name,
							'type'  => $user_information->type
						)
					);					
					$this->session->set_userdata($login_admin_data);

					$message = "Completed";
				}
				else
				{
					$message = "Please enter correct username and password";
				}					
		} 
		else 
		{
			$message = "Please enter correct values";					
		}	
		output_to_json($this, $message);	
	}	

	public function logout()
	{
		if($this->session->userdata('login_admin_data')) {
			$login_user_data = $this->session->userdata('login_admin_data');
		}
	
		$this->session->unset_userdata('login_admin_data');
		redirect('authentication');
	}

	public function update_profile()
	{
		$this->load->model('user_information_model', '', TRUE);
		$success = true;
		$message = "Not Validation";
		$data = array();

		$data["name"] =  $this->input->post('name');
		if($this->input->post('change_password') == true){
			$data["password"] =  sha1($this->input->post('npassword'));
			$username = $this->login_user_data['username'];
			$password = $this->input->post('opassword');		
			

			$user_information = $this->user_information_model->backend_authentication_details($username, $password);	
			if(!$user_information != false) 
			{
				$success = false;
			}	
		}
		
		
		if($success) {
			$this->user_information_model->update_user_details($this->login_user_data['id'], $data);

			$login_admin_data = array( 'login_admin_data' =>
				array (
					'id'  => $this->login_user_data['id'],
					'username' => $this->login_user_data['username'],
					'name'  => $this->input->post('name'),
					'type'  => $this->login_user_data['type']
				)
			);					
			$this->session->set_userdata($login_admin_data);
		}
		
		output_to_json($this, array("success" => $success));	
	}

	public function user_default_page()
	{
		switch ($this->login_user_data["type"]) {

			case 4:
				redirect('superadmin');
				break;
			default:
				redirect('appropriations');
				break;
		}
	}
	
}
