<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Funds extends MY_Controller {

	public function __construct() {
		parent::__construct();
		$this->isLogin();
	}

	public function index()
	{
		$this->responsibility_center();
	
	}

	public function add_fund_rc()
	{
		$this->load->model('funds_model', '', TRUE);
		$login_user_data = $this->login_user_data();
		$data = array();
		$year = $this->input->post('year');
		$fund_id = $this->input->post('fund_id');

		$data["fund_rc"] = array(
			"year" => $this->input->post('year'),
			"fund_id" => $this->input->post('fund_id') == sha1(1) ? 1 : 2 ,
			"rc_id" => $this->input->post('rc_id'),
			"created_by" => $login_user_data["id"] 
		);

		$data["fund_rc_objects"] = $this->input->post('object_ids');

		$this->funds_model->add_fund_rc($data);
		redirect(site_url("funds/responsibility_center?fund_id=$fund_id&year=$year"));
	}

	public function add_fund_rc_objects()
	{
		$this->load->model('funds_model', '', TRUE);
		$data = array();
		$year = $this->input->post('year');
		$fund_id = $this->input->post('fund_id');
		$fund_rc_id = $this->input->post('fund_rc_id');
		$fund_rc_objects = array();
		foreach($this->input->post('object_ids') as $object_id) {
			$fund_rc_objects[] = array( "object_id" => $object_id, "fund_rc_id" => $fund_rc_id) ;
		}

		$this->funds_model->add_fund_rc_objects($fund_rc_objects);

		redirect(site_url("funds/objects?fund_id=$fund_id&year=$year&fund_rc_id=$fund_rc_id"));
	}

	public function add_legal_basis()
	{
		$this->load->model('funds_model', '', TRUE);

		$data = array();
		$year = $this->input->post('year');
		$fund_id = $this->input->post('fund_id');

		$data = array(
			"year" => $this->input->post('year'),
			"fund_id" => $this->input->post('fund_id') == sha1(1) ? 1 : 2 ,
			"legal_basis_id" => $this->input->post('legal_basis_id')
		);

		$this->funds_model->add_legal_basis($data);
		redirect(site_url("funds/legal_basis?fund_id=$fund_id&year=$year"));
	}

	public function delete_legal_basis()
	{
		$this->load->model('funds_model', '', TRUE);

		$data = array();
		$year = $this->input->post('year');
		$fund_id = $this->input->post('fund_id');
		$fund_legal_basis_id = $this->input->post('fund_legal_basis_id');
		$action = $this->input->post('action');
		$this->funds_model->delete_legal_basis($fund_legal_basis_id, $action);
		redirect(site_url("funds/legal_basis?fund_id=$fund_id&year=$year"));
	}

	public function legal_basis()
	{
		$this->redirect_disbursement_user();
		$this->data['content'] = 'funds/legal_basis';
		$this->data['nav_bar'] = array("funds","legal_basis");
		$this->load->model('funds_model', '', TRUE);
		$this->load->model('legal_basis_model', '', TRUE);
		$this->load->model('object_of_expenditures_model', '', TRUE);

		$this->data['year'] = $this->input->get("year") ? $this->input->get("year") : date("Y");
		$this->data["fund_id"] = $this->input->get("fund_id") ? $this->input->get("fund_id") : sha1(1);

		$fund_id = $this->data["fund_id"] == sha1(1) ? 1 : 2 ;
		$this->data["fund_legal_basis"] = $this->legal_basis_model->get_fund_legal_basis($fund_id, $this->data['year'] );

		$this->data['fund_list'] = $this->funds_model->get_fund_list();
		$this->data['new_fund_lb_list'] = $this->funds_model->get_new_fund_lb_list($this->data["fund_id"] , $this->data['year']);
		$this->load->view('template/admin', $this->data);
	}

	public function responsibility_center()
	{
		$this->redirect_disbursement_user();
		$this->data['content'] = 'funds/rc';
		$this->data['nav_bar'] = array("funds","rc");
		$this->load->model('user_information_model', '', TRUE);
		$this->load->model('funds_model', '', TRUE);
		$this->load->model('object_of_expenditures_model', '', TRUE);

		$this->data['year'] = $this->input->get("year") ? $this->input->get("year") : date("Y");
		$this->data["fund_id"] = $this->input->get("fund_id") ? $this->input->get("fund_id") : sha1(1);
		$login_user_data = $this->login_user_data();
		if($login_user_data["type"] != 1) {
			$this->data['responsibility'] = $this->funds_model->get_fund_rc_with_allotment_list($this->data["fund_id"] , $this->data['year'], false, $login_user_data["id"]);
		} else {
			$this->data['responsibility'] = $this->funds_model->get_fund_rc_with_allotment_list($this->data["fund_id"] , $this->data['year'], true, null, null);
		}
		$this->data['users'] = $this->user_information_model->backend_users();
		$this->data['fund_list'] = $this->funds_model->get_fund_list();
		$this->data['new_fund_rc_list'] = $this->funds_model->get_new_fund_rc_list($this->data["fund_id"] , $this->data['year']);
		$this->data['objects'] = $this->object_of_expenditures_model->get_object_list();
		$this->load->view('template/admin', $this->data);
	}

	public function objects()
	{
		$this->redirect_disbursement_user();
		$this->data['content'] = 'funds/objects';
		$this->data['nav_bar'] = array("funds","objects");
		$this->load->model('funds_model', '', TRUE);
		$this->load->model('object_of_expenditures_model', '', TRUE);

		$this->data['year'] = $this->input->get("year") ? $this->input->get("year") : date("Y");
		$this->data["fund_id"] = $this->input->get("fund_id") ? $this->input->get("fund_id") : sha1(1);
		$login_user_data = $this->login_user_data();
		if($login_user_data["type"] != 1) {
			$this->data['rc'] = $this->funds_model->get_fund_rc_list($this->data["fund_id"] , $this->data['year'], true, false, $login_user_data["id"]);
		} else {
			$this->data['rc'] = $this->funds_model->get_fund_rc_list($this->data["fund_id"] , $this->data['year']);
		}
		
		$this->data['fund_rc_id'] = $this->input->get("fund_rc_id") ? $this->input->get("fund_rc_id") : (count($this->data['rc']) > 0 ? $this->data['rc'][0]->fund_rc_id : 0);
		$this->data['fund_list'] = $this->funds_model->get_fund_list();
		
		$this->data['objects'] = $this->funds_model->get_fund_rc_object_list($this->data['fund_rc_id']);
		$this->data['fund_rc_new_objects'] = $this->funds_model->get_new_fund_rc_object_list($this->data["fund_rc_id"]);
		$this->load->view('template/admin', $this->data);
	}


	public function get_fund_rc()
	{
		$message = "";
		$year = $this->input->get('year');
		$fund_id = $this->input->get('fund_id')	 ;
		$this->load->model('funds_model', '', TRUE);

		$login_user_data = $this->login_user_data();
		if($login_user_data["type"] != 1) {
			$fund_rc = $this->funds_model->get_fund_rc_list($fund_id, $year, true, false, $login_user_data["id"]);
		} else {
			$fund_rc = $this->funds_model->get_fund_rc_list($fund_id, $year, true);
		}
		output_to_json($this,array("fund_rc" => $fund_rc,  "message" => $message));
	}

	public function get_rc_objects_json()
	{
		$message = "";
		$fund_rc_id = $this->input->get('fund_rc_id');
		$this->load->model('funds_model', '', TRUE);

		$rc_objects = $this->funds_model->get_fund_rc_object_list($fund_rc_id);
		output_to_json($this,array("rc_objects" => $rc_objects,  "message" => $message));
	}
	

	public function delete_fund_rc()
	{
		$this->load->model('funds_model', '', TRUE);

		$data = array();
		$year = $this->input->post('year');
		$fund_id = $this->input->post('fund_id');
		$fund_rc_id = $this->input->post('fund_rc_id');
		$action = $this->input->post('action');
		$this->funds_model->delete_fund_rc($fund_rc_id, $action);
		redirect(site_url("funds/responsibility_center?fund_id=$fund_id&year=$year"));
	}

	public function update_fund_rc()
	{
		$this->load->model('funds_model', '', TRUE);

		$data = array();
		$year = $this->input->post('year');
		$fund_id = $this->input->post('fund_id');
		$fund_rc_id = $this->input->post('fund_rc_id');
		$user_id = $this->input->post('user_id');
		$data = ["created_by" => $user_id];


		$this->funds_model->update_fund_rc($fund_rc_id, $data);
		redirect(site_url("funds/responsibility_center?fund_id=$fund_id&year=$year"));
	}

	public function delete_fund_rc_objects()
	{
		$this->load->model('funds_model', '', TRUE);
		$data = array();
		$year = $this->input->post('year');
		$fund_id = $this->input->post('fund_id');
		$fund_rc_id = $this->input->post('fund_rc_id');
		$fund_rc_objects_id = $this->input->post('fund_rc_object_id');
		$action = $this->input->post('action');
		$this->funds_model->delete_fund_rc_objects($fund_rc_objects_id, $action);

		redirect(site_url("funds/objects?fund_id=$fund_id&year=$year&fund_rc_id=$fund_rc_id"));
	}
}
