<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Legal_basis extends MY_Controller {

	public function __construct() {
		parent::__construct();
		$this->isLogin();
	}

	public function index()
	{
		$this->list();
	}

	public function list()
	{
		$this->redirect_disbursement_user();
		$this->load->model('legal_basis_model', '', TRUE);
		$this->load->model('funds_model', '', TRUE);
		$this->data['content'] = 'legal_basis/list';
		$this->data['nav_bar'] = array("maintenance","legal_basis");
		$this->data['legal_basis'] = $this->legal_basis_model->get_legal_basis_list();
		$this->data['fund_list'] = $this->funds_model->get_fund_list();
		$this->load->view('template/admin', $this->data);
	}

	public function get_fund_legal_basis()
	{
		$message = "";
		$fund_id = $this->input->get('fund_id') == sha1(1) ? 1 : 2 ;
		$year = $this->input->get('year') ? $this->input->get('year') : date("Y") ;
		$this->load->model('legal_basis_model', '', TRUE);
		$fund_legal_basis = $this->legal_basis_model->get_fund_legal_basis($fund_id, $year, true);

		output_to_json($this,array("fund_legal_basis" => $fund_legal_basis,  "message" => $message));
	}

	public function add_legal_basis()
	{
		$this->load->model('legal_basis_model', '', TRUE);
		$data = array();
		$data["name"] = $this->input->post('name');
		$this->legal_basis_model->add_legal_basis($data);
		redirect(site_url("legal_basis/list"));
	}

	public function delete_legal_basis()
	{
		$this->load->model('legal_basis_model', '', TRUE);
		$data = array();
		$legal_basis_id = $this->input->post('legal_basis_id');
		$this->legal_basis_model->delete_legal_basis($legal_basis_id);
		redirect(site_url("legal_basis/list"));
	}

	public function edit_legal_basis()
	{
		$this->load->model('legal_basis_model', '', TRUE);
		$data = array();
		$data["id"] = $this->input->post('legal_basis_id');
		$data["name"] = $this->input->post('name');
		$this->legal_basis_model->edit_legal_basis($data);
		redirect(site_url("legal_basis/list"));
	}
}
