<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Object_of_expenditures extends MY_Controller {

	public function __construct() {
		parent::__construct();
		$this->isLogin();
	}

	public function index()
	{
		$this->list();
	}

	public function list()
	{
		$this->redirect_disbursement_user();
		$this->data['nav_bar'] = array("maintenance","object_of_expenditures");
		$this->data['object_of_expenditures'] = array("object_of_expenditures","list");
		$this->load->model('object_of_expenditures_model', '', TRUE);
		$this->data['content'] = 'object_of_expenditures/list';
		$this->data['objects'] = $this->object_of_expenditures_model->get_object_list();
		$this->load->view('template/admin', $this->data);
	}

	public function add_object()
	{
		$this->load->model('object_of_expenditures_model', '', TRUE);

		$data = array();
		$data["code"] = $this->input->post('code');
		$data["allotment_class_id"] = $this->input->post('allotment_class');
		$data["description"] = $this->input->post('description');

		$this->object_of_expenditures_model->add_object($data);

		redirect(site_url("object_of_expenditures/list"));
	}

	public function delete_object()
	{
		$this->load->model('object_of_expenditures_model', '', TRUE);
		$data = array();
		$id = $this->input->post('object_id');
		$this->object_of_expenditures_model->delete_object($id);
		redirect(site_url("object_of_expenditures/list"));
	}

	public function edit_object()
	{
		$this->load->model('object_of_expenditures_model', '', TRUE);
		$data = array();
		$data["id"] = $this->input->post('object_id');
		$data["code"] = $this->input->post('code');
		$data["description"] = $this->input->post('description');
		$this->object_of_expenditures_model->edit_object($data);
		redirect(site_url("object_of_expenditures/list"));
	}

}
