<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Obligations extends MY_Controller {

	public function __construct() {
		parent::__construct();
		$this->isLogin();
	}

	public function index()
	{
		$this->status();
	}

	public function status()
	{
		$this->data['nav_bar'] = array("obligations","status");
		$this->load->model('obligations_model', '', TRUE);
		$this->load->model('funds_model', '', TRUE);
		$this->load->model('legal_basis_model', '', TRUE);
		$this->load->model('payee_model', '', TRUE);
		$this->load->model('office_model', '', TRUE);
		$this->data['content'] = 'obligations/status';
		
		$this->data['payees'] = $this->payee_model->get_payee_list();
		$this->data['offices'] = $this->office_model->get_office_list();

		$this->data['fund_list'] = $this->funds_model->get_fund_list();
		$this->data["fund_id"] = $this->input->get("fund_id") ? $this->input->get("fund_id") : sha1($this->data['fund_list'][0]->id);
		$fund_id = $this->data["fund_id"] == sha1(1) ? 1 : 2;
		$this->data['year'] = $this->input->get("year") ? $this->input->get("year") : date("Y");
		
		$this->data['fund_legal_basis'] = $this->legal_basis_model->get_fund_legal_basis($fund_id, $this->data['year']);
		$this->data['legal_basis_id'] = $this->input->get("legal_basis_id") ? $this->input->get("legal_basis_id") : (count( $this->data['fund_legal_basis']) > 0 ? $this->data['fund_legal_basis'][0]->id : 0);
				
		$login_user_data = $this->login_user_data();
		// if($login_user_data["type"] == 2 ) {
		// 	$this->data['obligations'] = $this->obligations_model->get_obligation_list($this->data['year'], $fund_id, $this->data['legal_basis_id'], false, $login_user_data["id"]);
		// } else {
		//	$this->data['obligations'] = $this->obligations_model->get_obligation_list($this->data['year'], $fund_id, $this->data['legal_basis_id']);
		// }
		$this->load->view('template/admin', $this->data);
	}

	public function get_dt_obligation_list()
	{
		$this->load->model('obligations_model', '', TRUE);
		$this->load->model('funds_model', '', TRUE);
		$this->load->model('legal_basis_model', '', TRUE);
		$this->load->model('payee_model', '', TRUE);
		$this->load->model('office_model', '', TRUE);
		$this->data['content'] = 'obligations/status';
		$year = $this->data['year'] = $this->input->get("year") ? $this->input->get("year") : date("Y");
		$this->data['fund_list'] = $this->funds_model->get_fund_list();
		
		$this->data["fund_id"] = $this->input->get("fund_id") ? $this->input->get("fund_id") : sha1($this->data['fund_list'][0]->id);
		$fund_id = $this->data["fund_id"] == sha1(1) ? 1 : 2;
	
		$this->data['fund_legal_basis'] = $this->legal_basis_model->get_fund_legal_basis($fund_id, $this->data['year']);
	
		$this->data['legal_basis_id'] = $this->input->get("legal_basis_id") ? $this->input->get("legal_basis_id") : (count( $this->data['fund_legal_basis']) > 0 ? $this->data['fund_legal_basis'][0]->id : 0);
		
		$limit = $this->input->post("length") ? $this->input->post("length") : 10;
		$offset = $this->input->post("start") ? $this->input->post("start") : 0;
		$search =  $this->input->post("search")["value"];
		$count_all = $this->obligations_model->get_obligation_list_count($this->data['year'], $fund_id, $this->data['legal_basis_id'], true, 0, $search);
		$obligations = $this->obligations_model->get_obligation_list($this->data['year'], $fund_id, $this->data['legal_basis_id'], true, $user_id = 0, $search, $limit, $offset );


		$tmp = [];
        if($obligations){
            foreach ($obligations as $obligation)
            {

				$actions = "";
				$onclick_edit = "";

				if($this->login_user_data["type"] == 2 || $this->login_user_data["type"] == 1)  {
					$onclick_edit = "alert('Only the creator and admin can update this ORS'); return false;";  
					$allowed_pointer = " cursor: not-allowed; ";
					if($this->login_user_data["id"]  == $obligation->obligation_created_id || $this->login_user_data["type"] == 1)  {
						$onclick_edit = "show_edit_obligation_modal(this); return false;";
						$allowed_pointer = " cursor:pointer; ";
					}
				
					$actions .= '<a href="#" onclick="'.$onclick_edit.'" title="Update adjusted obligation" style="padding-right: 5px; ' .$allowed_pointer.'" >';
					$actions .= '<i class="fa fa-pencil-square-o"></i> </a> ';
					$actions .= '<a class="btn_show_details" href="'. base_url() . 'obligations/norsa?fund_id=' . $this->data["fund_id"] . '&year=' . $year . '&obligation_id=' . $obligation->obligation_id . '" title="NORSA" style="padding-right: 5px; cursor:pointer" >';
					$actions .= '<i class="fa fa-list"></i> </a> ';
				}
					
				if($this->login_user_data["type"] == 3 || $this->login_user_data["type"] == 1) {
					$actions .= '<a class="btn_show_details" href="'. base_url() . 'obligations/disbursement?fund_id=' . $this->data["fund_id"] . '&year=' . $year . '&obligation_id=' . $obligation->obligation_id . '" title="Disbursement" style="padding-right: 5px; cursor:pointer" >';
					$actions .= '<i class="fa fa-book"></i> </a> ';
				}
				if(!$obligation->has_disbursement && !$obligation->has_norsa && $this->login_user_data['type'] == 1) {
					$actions .= '<a class="btn_show_details" href="javascript:void(0);" onclick="show_confirm_delete_data_modal(' ."'" . $obligation->obligation_id ."', '" .  $obligation->obligation_no . "'" .')" title="Cancel Obligation" style="padding-right: 5px; cursor:pointer" >';
					$actions .= '<i class="fa fa-trash-o"></i> </a> ';
				}

                $tmp[] = [
                    "DT_RowId" => $obligation->obligation_id,
                    "actions" => $actions,
                    "formatted_obligation_no" => ' <input type="hidden" class="obligation_id" value="'.$obligation->obligation_id.'">
													<input type="hidden" class="obligation_no" value="'.$obligation->obligation_no.'">
													<input type="hidden" class="payee_id" value="'.$obligation->payee_id.'">
													<input type="hidden" class="office_id" value="'.$obligation->office_id.'">
													<input type="hidden" class="date" value="'.$obligation->date.'">
													<input type="hidden" class="particulars" value="'.$obligation->particulars.'">' . 
													$obligation->obligation_no,
                    "obligation_no" => $obligation->obligation_no,
                    "date" => $obligation->date,
                    "payee_description" => $obligation->payee_description,
                    "office_name" => $obligation->office_name,
                    "particulars" => $obligation->particulars,
                    "total_obligation" => $obligation->total_obligation,
                    "obligation_created_name" => $obligation->obligation_created_name,
                    "formatted_total_obligation" => money_format($obligation->total_obligation),
                ];
            }
        }

        $data["data"] = $tmp;
        $data["recordsTotal"] = $data["recordsFiltered"] = $count_all;

		

		echo json_encode($data);
	 	exit();
	}

	public function disbursement()
	{
		$login_user_data = $this->login_user_data();
		if($login_user_data["type"] != 1) {
			$this->redirect_disbursement_user(false);
		}
		$this->data['nav_bar'] = array("disbursement");
		$this->load->model('obligations_model', '', TRUE);
		$this->load->model('funds_model', '', TRUE);
		$this->load->model('legal_basis_model', '', TRUE);
		$this->data['content'] = 'obligations/disbursement';
		
		$this->data['fund_list'] = $this->funds_model->get_fund_list();
		$this->data["fund_id"] = $this->input->get("fund_id") ? $this->input->get("fund_id") : sha1($this->data['fund_list'][0]->id);
		$fund_id = $this->data["fund_id"] == sha1(1) ? 1 : 2;
		$this->data['year'] = $this->input->get("year") ? $this->input->get("year") : date("Y");

		$this->data['fund_obligations'] = $this->obligations_model->get_fund_obligations_numbers($this->data['year'], $fund_id);
		
		$this->data['obligation_id'] = $this->input->get("obligation_id") ? $this->input->get("obligation_id") : (count($this->data['fund_obligations']) > 0  ? $this->data['fund_obligations'][0]->id : 0);
		
		$this->data['obligation_details'] = $this->obligations_model->get_obligation_details($this->data['obligation_id']);
		$this->load->view('template/admin', $this->data);
	}

	public function norsa()
	{
		$this->redirect_disbursement_user();
		$this->data['nav_bar'] = array("obligations","norsa");
		$this->load->model('obligations_model', '', TRUE);
		$this->load->model('funds_model', '', TRUE);
		$this->load->model('legal_basis_model', '', TRUE);
		$this->load->model('prexc_model', '', TRUE);
		$this->data['prexc'] = $this->prexc_model->get_prexc_list();
		$this->data['content'] = 'obligations/norsa';
		$this->data['fund_list'] = $this->funds_model->get_fund_list();
		$this->data["fund_id"] = $this->input->get("fund_id") ? $this->input->get("fund_id") : sha1($this->data['fund_list'][0]->id);
		$fund_id = $this->data["fund_id"] == sha1(1) ? 1 : 2;
		$this->data['year'] = $this->input->get("year") ? $this->input->get("year") : date("Y");

		// if($this->login_user_data["type"] == 2) {
		// 	$this->data['fund_obligations'] = $this->obligations_model->get_fund_obligations_numbers($this->data['year'], $fund_id, false, $this->login_user_data["id"]);
		// } else {
			$this->data['fund_obligations'] = $this->obligations_model->get_fund_obligations_numbers($this->data['year'], $fund_id);
		// }

		$this->data['obligation_id'] = $this->input->get("obligation_id") ? $this->input->get("obligation_id") : (count($this->data['fund_obligations']) > 0  ? $this->data['fund_obligations'][0]->id : 0);
		$this->data['obligation'] = $this->obligations_model->get_obligation_data($this->data['obligation_id']);
		$this->data['obligation_details'] = $this->obligations_model->get_obligation_details($this->data['obligation_id']);

		$this->load->view('template/admin', $this->data);
	}

	public function request()
	{
		$this->redirect_disbursement_user();
		$this->data['nav_bar'] = array("obligations","request");
		$this->data['content'] = 'obligations/request';
		$this->load->model('prexc_model', '', TRUE);
		$this->load->model('payee_model', '', TRUE);
		$this->load->model('office_model', '', TRUE);
		$this->load->model('responsibility_center_model', '', TRUE);
		$this->load->model('object_of_expenditures_model', '', TRUE);
		$this->load->model('funds_model', '', TRUE);
		$this->load->model('legal_basis_model', '', TRUE);

		$this->data['fund_list'] = $this->funds_model->get_fund_list();

		$this->data['fund_legal_basis'] = $this->legal_basis_model->get_fund_legal_basis($this->data['fund_list'][0]->id, date("Y"));
		$this->data['rc'] = $this->responsibility_center_model->get_responsibility_center_list();
		$this->data['prexc'] = $this->prexc_model->get_prexc_list();
		$this->data['objects'] = $this->object_of_expenditures_model->get_object_list();

		$this->data['payees'] = $this->payee_model->get_payee_list();
		$this->data['offices'] = $this->office_model->get_office_list();

		$this->load->view('template/admin', $this->data);
	}

	public function save_new()
	{

		$this->load->model('obligations_model', '', TRUE);

		$data = array();
		$login_user_data = $this->login_user_data();
		$data["obligations"]["obligation_no"] = $this->input->post("obligation_no");
		
		$data["obligations"]["fund_id"] = $this->input->post("fund_id") == sha1(1) ? 1 : 2;
		$data["obligations"]["payee_id"] = $this->input->post("payee_id");
		$data["obligations"]["office_id"] = $this->input->post("office_id");
		$data["obligations"]["created_by"] = $login_user_data["id"];

		$date = $this->input->post("date");


		$curMonth = date("m", strtotime($date));
		$curQuarter = ceil($curMonth/3);

		$data["obligations"]["date"] =	date("Y-m-d", strtotime($date));

		$data["obligations"]["particulars"] = $this->input->post("particulars");
		$data["obligations"]["quarter"] = $curQuarter;
		$data["obligations"]["address"] = $this->input->post("address");
		$data["obligations"]["legal_basis_id"] = $this->input->post("legal_basis_id");

		$object_ids = $this->input->post("object_ids");
		$amounts = $this->input->post("amounts");
		$fund_rc_ids = $this->input->post("fund_rc_ids");
		$prexc_ids = $this->input->post("prexc_ids");

		foreach($object_ids as $key => $object_id) {
			$_temp_data = array();
			$_temp_data["object_id"] = $object_id;
			$_temp_data["amount"] = $amounts[$key];
			$_temp_data["fund_rc_id"] = $fund_rc_ids[$key];
			$_temp_data["prexc_id"] = $prexc_ids[$key];
			$_temp_data["created_by"] = $login_user_data["id"];
			$data["obligation_details"][] = $_temp_data;
		}

		$this->obligations_model->add_obligation($data);

		redirect(site_url("obligations/status?year=".$year."&fund_id=".$this->input->post("fund_id")."&legal_basis_id=".$this->input->post("legal_basis_id")));
	}

	public function edit_adjusted_obligation_amount()
	{
		$this->load->model('obligations_model', '', TRUE);
		$data = array();
		$obligation_details_id = $this->input->post('obligation_details_id');
		$obligations_id = $this->input->post('obligations_id');
		$year = $this->input->post('year');
		$fund_id = $this->input->post('fund_id') == sha1(1) ? 1 : 2;
		$obligation_id = $this->input->post('obligation_id');
		$adjusted_amount = $this->input->post('adjusted_amount');
		
		$this->obligations_model->edit_adjusted_obligation_amount($adjusted_amount, $obligation_details_id);
		redirect(site_url("obligations/norsa?fund_id=" . $this->input->post('fund_id') . "&year=$year&obligation_id=$obligation_id"));
	}

	public function edit_norsa_amount()
	{
		$this->load->model('obligations_model', '', TRUE);
		$data = array();
		$obligation_details_id = $this->input->post('obligation_details_id');
		$obligations_id = $this->input->post('obligations_id');
		$year = $this->input->post('year');
		$fund_id = $this->input->post('fund_id') == sha1(1) ? 1 : 2;
		$obligation_id = $this->input->post('obligation_id');
		$adjusted_amount = $this->input->post('adjusted_amount');
		
		$this->obligations_model->edit_norsa_amount($adjusted_amount, $obligation_details_id);
		redirect(site_url("obligations/norsa?fund_id=" . $this->input->post('fund_id') . "&year=$year&obligation_id=$obligation_id"));
	}


	public function save_new_disbursement()
	{
		$login_user_data = $this->login_user_data();
		$this->load->model('obligations_model', '', TRUE);
		$data = array();
		$obligation_details_id = $this->input->post('obligation_details_id');
		$obligations_id = $this->input->post('obligations_id');
		$year = $this->input->post('year');
		$fund_id = $this->input->post('fund_id') == sha1(1) ? 1 : 2;
		$obligation_id = $this->input->post('obligation_id');
		$adjusted_amount = $this->input->post('adjusted_amount');

		$date = $this->input->post("date");
		$data["date"] =	date("Y-m-d", strtotime($date));
		$data["obligation_details_id"] = $this->input->post('obligation_details_id');
		$data["ada_number"] = $this->input->post('ada_number');
		$data["dv_number"] = $this->input->post('dv_number');
		$data["net_amount"] = $this->input->post('net_amount');
		$data["bir_amount"] = $this->input->post('bir_amount');
		$data["total_amount"] = $this->input->post('total_amount');
		$data["remarks"] = $this->input->post('remarks');
		$data["created_by"] = $login_user_data["id"];

		$this->obligations_model->save_new_disbursement($data);
		redirect(site_url("obligations/disbursement?fund_id=" . $this->input->post('fund_id') . "&year=$year&obligation_id=$obligation_id"));
	}


	public function get_obligation_details()
	{
		$message = "";
		$obligation_id = $this->input->post('obligation_id');
		$this->load->model('obligations_model', '', TRUE);

		$obligation_details = $this->obligations_model->get_obligation_details($obligation_id);

		output_to_json($this,array("obligation_details" => $obligation_details,  "message" => $message));
	}

	public function get_obligation_disbursement()
	{
		$message = "";
		$obligation_details_id = $this->input->post('obligation_details_id');
		$this->load->model('obligations_model', '', TRUE);

		$obligation_disbursement = $this->obligations_model->get_obligation_disbursement($obligation_details_id);

		output_to_json($this,array("obligation_disbursement" => $obligation_disbursement,  "message" => $message));
	}

	public function get_obligation_norsa()
	{
		$message = "";
		$obligation_details_id = $this->input->post('obligation_details_id');
		$this->load->model('obligations_model', '', TRUE);

		$obligation_disbursement = $this->obligations_model->get_obligation_norsa($obligation_details_id);

		output_to_json($this,array("obligation_disbursement" => $obligation_disbursement,  "message" => $message));
	}
	
	public function get_fund_obligation_numbers()
	{
		$message = "";
		$this->load->model('obligations_model', '', TRUE);

		$fund_id = $this->input->get('fund_id') == sha1(1) ? 1 : 2;
		$year = $this->input->get('year');

		$login_user_data = $this->login_user_data();
		if($login_user_data["type"] != 1 && $login_user_data["type"] != 3) {
			$fund_obligations = $this->obligations_model->get_fund_obligations_numbers( $year, $fund_id,  false, $login_user_data["id"]);
		} else {
			$fund_obligations = $this->obligations_model->get_fund_obligations_numbers( $year, $fund_id);
		}
		output_to_json($this,array("fund_obligations" => $fund_obligations,  "message" => $message));
	}

	public function select2_fund_obligation_numbers() {

		$message = "";
		$this->load->model('obligations_model', '', TRUE);

		$fund_id = $this->input->get('fund_id') == sha1(1) ? 1 : 2;
		$year = $this->input->get('year');

		$login_user_data = $this->login_user_data();

		$search = isset($_GET['search']) ? trim($_GET['search']) : null;

		if($login_user_data["type"] != 1 && $login_user_data["type"] != 3) {
			$fund_obligations = $this->obligations_model->get_fund_obligations_numbers( $year, $fund_id,  false, $login_user_data["id"]);
		} else {
			$fund_obligations = $this->obligations_model->get_fund_obligations_numbers( $year, $fund_id, true, 0, $search);
		}

		$results = array();
		foreach($fund_obligations as $fo) {

			$_result = array();
			$_result["id"] = $fo->id;
			$_result["text"] = $fo->obligation_no;
			$_result["name"] = $fo->obligation_no;

			array_push($results, $_result);
		//	$obligation_id == $fo->id ? 'selected' : ''  value="<?=$fo->id"><?=$fo->obligation_no
		}

		output_to_json($this,array("results" => $results));


			
	}

	public function check_if_obligation_number_exist()
	{
		$message = "";
		$exist = false;
		$this->load->model('obligations_model', '', TRUE);

		$ors_no = $this->input->post('obligation_no');
		$obligation_id = $this->input->post('obligation_id');
		$year = $this->input->post('year');
		
		if(strlen($ors_no) >= 6 ) {
			if(strlen($ors_no) > 6) {
				$ors_no = substr($ors_no, -6);
			}
			
			$result = $this->obligations_model->check_if_obligation_number_exist($ors_no, $obligation_id, $year);
			if($result !== false) {
				$message = "Obligation number already exist";
				$exist = true;				
			} 
		}

		
		output_to_json($this,array("exist" => $exist,  "message" => $message));
	}

	public function delete_obligation_object()
	{
		$this->load->model('obligations_model', '', TRUE);
		$data = array();
		$id = $this->input->post('obligation_details_id');
		$year = $this->input->post('year');
		$obligation_id = $this->input->post('obligation_id');
		$this->obligations_model->delete_obligation_object($id);
		redirect(site_url("obligations/norsa?fund_id=" . $this->input->post('fund_id') . "&year=$year&obligation_id=$obligation_id"));

	}
	public function delete_obligation()
	{

		$this->load->model('obligations_model', '', TRUE);
		$data = array();
		$id = $this->input->post('obligation_id');
		$year = $this->input->post('year');
		$legal_basis_id = $this->input->post('legal_basis_id');
		$this->obligations_model->delete_obligation($id);
		redirect(site_url("obligations/status?fund_id=" . $this->input->post('fund_id') . "&year=$year&legal_basis_id=$legal_basis_id"));

	}

	public function delete_disbursement()
	{

		$this->load->model('obligations_model', '', TRUE);
		$data = array();
		$disbursement_id = $this->input->post('disbursement_id');
		// $year = $this->input->post('year');
		$this->obligations_model->delete_disbursement($disbursement_id);
		// redirect(site_url("obligations/disbursement?fund_id=" . $this->input->post('fund_id') . "&year=$year"));
		echo json_encode(array("success" => true));
		exit();
	}

	public function add_obligation_object()
	{
		$this->load->model('obligations_model', '', TRUE);
		$login_user_data = $this->login_user_data();
		$data["obligation_id"] = $this->input->post("obligation_id");
		$data["object_id"] = $this->input->post("object_id");
		$data["amount"] = $this->input->post("amount");
		$data["fund_rc_id"] = $this->input->post("fund_rc_id");
		$data["prexc_id"] = $this->input->post("prexc_id");
		$data["created_by"] = $login_user_data['id'];

		$this->obligations_model->add_obligation_object($data);

		redirect(site_url("obligations/norsa?year=".$this->input->post("year")."&fund_id=".$this->input->post("fund_id")."&obligation_id=".$this->input->post("obligation_id")));
	}

	public function edit_obligation_details()
	{
		$this->load->model('obligations_model', '', TRUE);
		
		$data = array();
		$data["id"] = $this->input->post("obligation_id");
		$data["payee_id"] = $this->input->post("payee_id");
		$data["office_id"] = $this->input->post("office_id");
		$data["particulars"] = $this->input->post("particulars");
		$data["obligation_no"] = $this->input->post("obligation_no");
		$date = $this->input->post("date");
		$curMonth = date("m", strtotime($date));
		$curQuarter = ceil($curMonth/3);

		$data["date"] =	date("Y-m-d", strtotime($date));

		$this->obligations_model->edit_obligation_details($data);

		redirect(site_url("obligations/status?year=".$this->input->post("year")."&fund_id=".sha1($this->input->post("fund_id"))."&legal_basis_id=".$this->input->post("legal_basis_id")));
	}
}
