<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Office extends MY_Controller {

	public function __construct() {
		parent::__construct();
		$this->isLogin();

	}

	public function index()
	{
		$this->list();
	}

	public function list()
	{
		$this->redirect_disbursement_user();
		$this->load->model('office_model', '', TRUE);
		$this->data['nav_bar'] = array("maintenance","office");
		$this->data['content'] = 'office/list';
		$this->data['office_list'] = $this->office_model->get_office_list();
		$this->load->view('template/admin', $this->data);
	}

	public function add_office()
	{
		$this->load->model('office_model', '', TRUE);
		$data = array();
		$data["name"] = $this->input->post('name');
		$this->office_model->add_office($data);
		redirect(site_url("office/list"));
	}

	public function delete_office()
	{
		$this->load->model('office_model', '', TRUE);
		$data = array();
		$office_id = $this->input->post('office_id');
		$this->office_model->delete_office($office_id);
		redirect(site_url("office/list"));
	}

	public function edit_office()
	{
		$this->load->model('office_model', '', TRUE);
		$data = array();
		$data["id"] = $this->input->post('office_id');
		$data["name"] = $this->input->post('name');
		$this->office_model->edit_office($data);
		redirect(site_url("office/list"));
	}

	

}
