<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Payee extends MY_Controller {

	public function __construct() {
		parent::__construct();
		$this->isLogin();
	}

	public function index()
	{
		$this->list();
	}

	public function list()
	{
		$this->redirect_disbursement_user();
		$this->data['nav_bar'] = array("maintenance","payee");
		$this->load->model('payee_model', '', TRUE);
		$this->data['content'] = 'payee/list';
		$this->data['payee_list'] = $this->payee_model->get_payee_list();
		$this->load->view('template/admin', $this->data);
	}

	public function add_payee()
	{
		$this->load->model('payee_model', '', TRUE);
		$data = array();
		$data["description"] = $this->input->post('description');
		$data["code"] = $this->input->post('code');
		$this->payee_model->add_payee($data);
		
		redirect(site_url("payee/list"));
	}

	public function delete_payee()
	{
		$this->load->model('payee_model', '', TRUE);
		$data = array();
		$payee_id = $this->input->post('payee_id');
		$this->payee_model->delete_payee($payee_id);
		redirect(site_url("payee/list"));
	}

	public function edit_payee()
	{
		$this->load->model('payee_model', '', TRUE);
		$data = array();
		$data["id"] = $this->input->post('payee_id');
		$data["description"] = $this->input->post('description');
		$data["code"] = $this->input->post('code');
		$this->payee_model->edit_payee($data);
		redirect(site_url("payee/list"));
	}

	

}
