<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Prexc extends MY_Controller {

	public function __construct() {
		parent::__construct();
		$this->isLogin();
	}

	public function index()
	{
		$this->list();
	}

	public function list()
	{
		$this->redirect_disbursement_user();
		$this->data['nav_bar'] = array("maintenance","prexc");
		$this->load->model('prexc_model', '', TRUE);
		$this->data['content'] = 'prexc/list';
		$this->data['prexc'] = $this->prexc_model->get_prexc_list();
		$this->load->view('template/admin', $this->data);
	
	}

	public function add_prexc()
	{
		$this->load->model('prexc_model', '', TRUE);

		$data = array();
		$data["code"] = $this->input->post('code');
		$data["description"] = $this->input->post('description');

		$this->prexc_model->add_prexc($data);

		redirect(site_url("prexc/list"));
	}

	public function delete_prexc()
	{
		$this->load->model('prexc_model', '', TRUE);
		$data = array();
		$id = $this->input->post('prexc_id');
		$this->prexc_model->delete_prexc($id);
		redirect(site_url("prexc/list"));
	}

	public function edit_prexc()
	{
		$this->load->model('prexc_model', '', TRUE);
		$data = array();
		$data["id"] = $this->input->post('prexc_id');
		$data["code"] = $this->input->post('code');
		$data["description"] = $this->input->post('description');
		$this->prexc_model->edit_prexc($data);
		redirect(site_url("prexc/list"));
	}

}
