<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Reports extends MY_Controller {

	public function __construct() {
		parent::__construct();
		$this->isLogin();
	}

	public function index()
	{
		$this->data['nav_bar'] = array("reports","generate");
		$this->data['content'] = 'reports/reports';
		// $this->redirect_disbursement_user();
		$this->load->model('responsibility_center_model', '', TRUE);
		$this->load->model('obligations_model', '', TRUE);
		$this->load->model('payee_model', '', TRUE);
		$this->load->model('office_model', '', TRUE);
		$this->load->model('funds_model', '', TRUE);
		$this->load->model('prexc_model', '', TRUE);

		$this->data['prexc'] = $this->prexc_model->get_prexc_list();
		$this->data['year'] = $this->input->get("year") ? $this->input->get("year") : date("Y");
		$this->data['rc'] = $this->funds_model->get_fund_rc_list(sha1(1) , $this->data['year']);

		$this->data['fund_list'] = $this->funds_model->get_fund_list();
		$fund_id = $this->data['fund_list'][0]->id;
		$this->data['fund_obligations'] = $this->obligations_model->get_fund_obligations_numbers($this->data['year'], $fund_id);
		
		$this->data['payees'] = $this->payee_model->get_payee_list();
		$this->data['offices'] = $this->office_model->get_office_list();

		$this->load->view('template/admin', $this->data);
	}

	public function view()
	{
		$this->data['nav_bar'] = array("reports","view");
		$this->data['content'] = 'reports/view';
		// $this->redirect_disbursement_user();
		$this->load->model('responsibility_center_model', '', TRUE);
		$this->load->model('funds_model', '', TRUE);
		$this->load->model('prexc_model', '', TRUE);
		$this->load->model('payee_model', '', TRUE);

		//$this->data['prexc'] = $this->prexc_model->get_prexc_list();
		$this->data['payees'] = $this->payee_model->get_payee_list();
		$this->data['year'] = $this->input->get("year") ? $this->input->get("year") : date("Y");
		$this->data['rc'] = $this->funds_model->get_fund_rc_list(sha1(1) , $this->data['year']);

		$this->data['fund_list'] = $this->funds_model->get_fund_list();

		$this->load->view('template/admin', $this->data); 
	}

	public function view_report()
	{
		$type = $this->input->post('report_type');
		switch($type) {
			case 8: 
				$this->generate_report_end_user();
				break;
		}
		exit();
	}

	public function generate_report()
	{
		$type = $this->input->post('report_type');
		$method = $this->input->post('method');
		switch($type) {
			case 1: 
				$this->generate_report_per_rc($method);
				break;
			case 2: 
				$this->generate_report_allotment_list($method );
				break;
			case 3: 
				$this->generate_report_obligation_list($method);
				break;
			case 4: 
				$this->generate_report_disbursement_list($method);
				break;
			case 5: 
				$this->generate_report_far_one($method);
				break;
			case 6: 
				$this->generate_report_allotment_obligation_disbursement($method);
				break;
			case 7: 
				$this->generate_report_overview($method);
				break;
			case 8: 
				$this->generate_report_end_user($method);
			break;
		}
	}

	public function generate_report_end_user($method)
	{
		// $fund_id  = $this->input->post('fund_id');
		$year = $this->input->post('year');

		$fund_id  = $this->input->post('fund_id') == sha1('1') ? 1 : 2;
		$_group_by = $this->input->post('group_by');
		$obligation_id = $this->input->post('obligation_id');
		$office_id = $this->input->post('office_id');
		$payee_id = $this->input->post('payee_id');
		$fund_rc_id = $this->input->post('fund_rc_id');
		$group_by = "";
		switch($_group_by) {
			case "end_user":
				$group_by = "o.office_id ORDER BY of.name ASC";
			break;
			case "ors":
				$group_by = "o.id ORDER BY o.obligation_no ASC";
			break;
			case "payee":
				$group_by = "o.payee_id ORDER BY p.description ASC";
			break;

			default:
				$group_by = false;
			break;

		}

		$this->load->model('appropriations_model', '', TRUE);

		$report_end_user = $this->appropriations_model->get_end_user_report($fund_id, $year, $group_by, $obligation_id, $office_id, $payee_id, $fund_rc_id);
		
		if($method == "view") {
			$data = [];
			$data['report_end_user'] = $report_end_user;
			$this->load->view('reports/table-source/end-user-table', $data);
		} else {
			error_reporting(E_ALL);
			ini_set('display_errors', TRUE);
			ini_set('display_startup_errors', TRUE);

			require_once APPPATH.'/libraries/PHPExcel/PHPExcel.php';
			require_once APPPATH.'/libraries/PHPExcel/PHPExcel/IOFactory.php';


			$objPHPExcel = new PHPExcel();
			$objPHPExcel->setActiveSheetIndex(0);
			$objPHPExcel->getActiveSheet()->setTitle('Reports');

			$objPHPExcel->getActiveSheet()->getStyle('A1:H1')->getFill()
			->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
			->getStartColor()->setARGB('FFFF00');

			
			$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(30);
			$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(20);

			$xls_col = 0;

			if($this->input->post('group_by') == "ors") {
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($xls_col++, 1, "ORS Number");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($xls_col++, 1, "ORS Date");
			}
			if($this->input->post('group_by') == "ors" || $this->input->post('group_by') == "payee" ) {
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($xls_col++, 1, "Payee / Creditor");
			} 
			if($this->input->post('group_by') == "ors" || $this->input->post('group_by') == "end_user") {
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($xls_col++, 1, "End User");
			}
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($xls_col++, 1, "Responsibility Center");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($xls_col++, 1, "Obligation");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($xls_col++, 1, "Disbursement");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($xls_col++, 1, "Unpaid Obligation");
			$grand_total_obligation = 0; 
			$grand_total_disbursement = 0; 
			$grand_total_unpaid_obligation = 0; 	
			$row = 2;
			
			if($report_end_user) {
				foreach($report_end_user as $res) {
					$xls_col = 0;
					$grand_total_obligation += $res->total_obligation; 
					$grand_total_disbursement += $res->total_disbursement; 
					$grand_total_unpaid_obligation += ($res->total_obligation - $res->total_disbursement); 

					if($this->input->post('group_by') == "ors") {
						$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($xls_col++, $row, $res->obligation_no);
						$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($xls_col++, $row, $res->date);
					}
					if($this->input->post('group_by') == "ors" || $this->input->post('group_by') == "payee" ) {
						$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($xls_col++, $row, $res->payee_description);
					}
					if($this->input->post('group_by') == "ors" || $this->input->post('group_by') == "end_user") {
						$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($xls_col++, $row, $res->office_name);
					}

					$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($xls_col++, $row, $res->rc_code .' - ' . $res->rc_description);
					$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($xls_col++, $row, $res->total_obligation);
					$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($xls_col++, $row, $res->total_disbursement);
					$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($xls_col++, $row, $res->total_obligation - $res->total_disbursement);
					
					$xls_col_letter = $this->input->post('group_by') == "ors" ? 'E' : 'C';
					$objPHPExcel->getActiveSheet()->getStyle($xls_col_letter++ . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
					$objPHPExcel->getActiveSheet()->getStyle($xls_col_letter++ . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
					$objPHPExcel->getActiveSheet()->getStyle($xls_col_letter++ . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
					$objPHPExcel->getActiveSheet()->getStyle($xls_col_letter++. $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
				
					$row++;
				}
			}


		$xls_col = $this->input->post('group_by') == "ors" ? 4 : 1;
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($xls_col++, $row, "Grand Total");
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($xls_col++, $row, $grand_total_obligation);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($xls_col++, $row, $grand_total_disbursement);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($xls_col++, $row, $grand_total_unpaid_obligation);


		$xls_col_letter = $this->input->post('group_by') == "ors" ? 'E' : 'C';
		$objPHPExcel->getActiveSheet()->getStyle($xls_col_letter++ . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
		$objPHPExcel->getActiveSheet()->getStyle($xls_col_letter++. $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
		$objPHPExcel->getActiveSheet()->getStyle($xls_col_letter++ . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
		$objPHPExcel->getActiveSheet()->getStyle($xls_col_letter++ . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);

	
		// Redirect output to a client’s web browser (Excel2007)
		header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
		header('Content-Disposition: attachment;filename="rc_reports.xlsx"');
		header('Cache-Control: max-age=0');
		// If you're serving to IE 9, then the following may be needed
		header('Cache-Control: max-age=1');

		// If you're serving to IE over SSL, then the following may be needed
		header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
		header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
		header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
		header ('Pragma: public'); // HTTP/1.0

		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		ob_end_clean();
		$objWriter->save('php://output');
		
		exit;
		}
	
	}

	public function generate_report_overview($method)
	{
		
		ini_set('display_errors', TRUE);
		ini_set('display_startup_errors', TRUE);

		

		$fund_id  = $this->input->post('fund_id');
		$year = $this->input->post('year');

		$fund_id  = $this->input->post('fund_id') == sha1('1') ? 1 : 2;

		$this->load->model('appropriations_model', '', TRUE);


		$report_overview_fund1 = $this->appropriations_model->get_appropriations_list($fund_id, $year);

		
		if($method == "view") {
			$data = [];
			$data['report_overview_fund1'] = $report_overview_fund1;
			$this->load->view('reports/table-source/overview-table', $data);

		} else {
			require_once APPPATH.'/libraries/PHPExcel/PHPExcel.php';
			require_once APPPATH.'/libraries/PHPExcel/PHPExcel/IOFactory.php';
	
			//PHPExcel_Style_NumberFormat 

			$objPHPExcel = new PHPExcel();
			$objPHPExcel->setActiveSheetIndex(0);
			$objPHPExcel->getActiveSheet()->setTitle('Reports');

			$objPHPExcel->getActiveSheet()->getStyle('A1:H1')->getFill()
				->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
				->getStartColor()->setARGB('FFFF00');

			$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(30);
			$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(20);

			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(0, 1, "Allotment Class");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(1, 1, "Allotment");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(2, 1, "Obligation");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(3, 1, "Unobligated Allotment");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(4, 1, "Disbursement");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(5, 1, "Unpaid Obligation");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(6, 1, "Obligation Rate");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(7, 1, "Disbursement Rate");
			
			$total_new_general_appro = 0; 
			$grand_total_obligation = 0; 
			$grand_total_balance = 0; 
			$amount = 1; 


			$total_allotment = 0; 
			$grand_total_obligation = 0; 
			$grand_total_balance = 0; 	
			$grand_total_disbursement = 0; 	
			$row = 2;
			foreach($report_overview_fund1 as $ngal) {
				$total_new_general_appro += $ngal->total_allotment; 
				$grand_total_obligation += $ngal->total_obligation; 
				$grand_total_disbursement += $ngal->total_disbursement; 
				$grand_total_balance += ($ngal->total_allotment - $ngal->total_obligation); 

				$obligation_rate = ($ngal->total_allotment > 0) ? (($ngal->total_obligation / $ngal->total_allotment) * 100) : 0;
				$disb_rate = ($ngal->total_disbursement > 0) ? (($ngal->total_disbursement / $ngal->total_obligation) * 100) : 0;
			
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(0, $row, $ngal->allotment_class_name);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(1, $row, $ngal->total_allotment);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(2, $row, $ngal->total_obligation);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(3, $row, $ngal->total_allotment - $ngal->total_obligation);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(4, $row, $ngal->total_disbursement);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(5, $row, $ngal->total_obligation - $ngal->total_disbursement);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(6, $row, $obligation_rate);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(7, $row, $disb_rate);
				

				$objPHPExcel->getActiveSheet()->getStyle('B' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
				$objPHPExcel->getActiveSheet()->getStyle('C' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
				$objPHPExcel->getActiveSheet()->getStyle('D' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
				$objPHPExcel->getActiveSheet()->getStyle('E' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
				$objPHPExcel->getActiveSheet()->getStyle('F' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
				$objPHPExcel->getActiveSheet()->getStyle('G' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
				$objPHPExcel->getActiveSheet()->getStyle('H' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
			
				$row++;
			}


			// $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(0, $row, "Grand Total");
			// $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(1, $row, $total_new_general_appro);
			// $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(2, $row, $grand_total_obligation);
			// $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(3, $row, $grand_total_balance);
			// $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(4, $row, $grand_total_disbursement);
			// $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(4, $row, $grand_total_disbursement);

			
			// $objPHPExcel->getActiveSheet()->getStyle('A' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
			// $objPHPExcel->getActiveSheet()->getStyle('B' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
			// $objPHPExcel->getActiveSheet()->getStyle('C' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
			// $objPHPExcel->getActiveSheet()->getStyle('D' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
			// $objPHPExcel->getActiveSheet()->getStyle('E' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);

				

		
			// Redirect output to a client’s web browser (Excel2007)
			header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
			header('Content-Disposition: attachment;filename="rc_reports.xlsx"');
			header('Cache-Control: max-age=0');
			// If you're serving to IE 9, then the following may be needed
			header('Cache-Control: max-age=1');

			// If you're serving to IE over SSL, then the following may be needed
			header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
			header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
			header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
			header ('Pragma: public'); // HTTP/1.0

			$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
			ob_end_clean();
			$objWriter->save('php://output');
			
			exit;
		}
		
	}

	
	public function generate_report_per_rc($method = false)
	{
		error_reporting(E_ALL);
		ini_set('display_errors', TRUE);
		ini_set('display_startup_errors', TRUE);

		require_once APPPATH.'/libraries/PHPExcel/PHPExcel.php';
		require_once APPPATH.'/libraries/PHPExcel/PHPExcel/IOFactory.php';

		//PHPExcel_Style_NumberFormat 

		$this->load->model('funds_model');
		$fund_id  = $this->input->post('fund_id');
		$year = $this->input->post('year');

		$fund_rc_id = $this->input->post('fund_rc_id');
		
		$responsibilities = $this->funds_model->get_report_fund_rc_with_allotment_list($fund_id, $year, $fund_rc_id);
		
		
		if($method == "view") {
			
			$data = [];
			$data['responsibilities'] = $responsibilities;
			$this->load->view('reports/table-source/responsibility-table', $data);

		} else {

			$objPHPExcel = new PHPExcel();
			$objPHPExcel->setActiveSheetIndex(0);
			$objPHPExcel->getActiveSheet()->setTitle('Reports');

			$objPHPExcel->getActiveSheet()->getStyle('A1:E1')->getFill()
				->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
				->getStartColor()->setARGB('FFFF00');

			$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(30);
			$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(200);
			$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);

			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(0, 1, "Responsibility Center Code");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(1, 1, "Responsibility Center Description");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(2, 1, "Total Allotment");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(3, 1, "Total Obligations");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(4, 1, "Total Balance");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(5, 1, "BUR(%)");

			$total_allotment = 0; 
			$grand_total_obligation = 0; 
			$grand_total_balance = 0; 	
			$row = 2;
			foreach($responsibilities as $responsibility) {
				$total_allotment += $responsibility->total_allotment; 
				$grand_total_obligation += $responsibility->total_obligation; 
				$grand_total_balance += ($responsibility->total_allotment - $responsibility->total_obligation); 

				$bur = 0;
				if($responsibility->total_obligation > 0) {
					$bur = ($responsibility->total_obligation / $responsibility->total_allotment);
				}

				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(0, $row, $responsibility->code);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(1, $row, $responsibility->description);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(2, $row, $responsibility->total_allotment);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(3, $row, $responsibility->total_obligation);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(4, $row, ($responsibility->total_allotment - $responsibility->total_obligation));
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(5, $row, $bur);
				

				$objPHPExcel->getActiveSheet()->getStyle('C' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
				$objPHPExcel->getActiveSheet()->getStyle('D' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
				$objPHPExcel->getActiveSheet()->getStyle('E' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
				$objPHPExcel->getActiveSheet()->getStyle('F' . $row)->getNumberFormat()->applyFromArray( 
					array( 
						'code' => PHPExcel_Style_NumberFormat::FORMAT_PERCENTAGE_00
					)
				);

				$row++;
			}

			$bur = 0;
			if($grand_total_obligation > 0) {
				$bur = ($grand_total_obligation / $total_allotment);
			}

			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(1, $row, "Grand Total");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(2, $row, $total_allotment);
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(3, $row, $grand_total_obligation);
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(4, $row, $grand_total_balance);
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(5, $row, $bur);
			
			$objPHPExcel->getActiveSheet()->getStyle('C' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
			$objPHPExcel->getActiveSheet()->getStyle('D' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
			$objPHPExcel->getActiveSheet()->getStyle('E' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
			$objPHPExcel->getActiveSheet()->getStyle('F' . $row)->getNumberFormat()->applyFromArray( 
				array('code' => PHPExcel_Style_NumberFormat::FORMAT_PERCENTAGE_00)
			);
				


			// Redirect output to a client’s web browser (Excel2007)
			header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
			header('Content-Disposition: attachment;filename="rc_reports.xlsx"');
			header('Cache-Control: max-age=0');
			// If you're serving to IE 9, then the following may be needed
			header('Cache-Control: max-age=1');

			// If you're serving to IE over SSL, then the following may be needed
			header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
			header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
			header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
			header ('Pragma: public'); // HTTP/1.0

			$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
			ob_end_clean();
			$objWriter->save('php://output');
			
			exit;
		}
	}

	public function generate_report_allotment_list($method = false)
	{
		error_reporting(E_ALL);
		ini_set('display_errors', TRUE);
		ini_set('display_startup_errors', TRUE);

		require_once APPPATH.'/libraries/PHPExcel/PHPExcel.php';
		require_once APPPATH.'/libraries/PHPExcel/PHPExcel/IOFactory.php';

		//PHPExcel_Style_NumberFormat 

		$this->load->model('allotment_model');
		$fund_id  = $this->input->post('fund_id') == sha1(1) ? 1 : 2;
		$year = $this->input->post('year');
		
		$fund_rc_id = $this->input->post('fund_rc_id');
		$allotments = $this->allotment_model->get_allotment_list_reports($fund_id, $year, $fund_rc_id);
		
		if($method == "view") {
			
			$data = [];
			$data['allotments'] = $allotments;
			$this->load->view('reports/table-source/allotment-received-table', $data);

		} else {
			$objPHPExcel = new PHPExcel();
			$objPHPExcel->setActiveSheetIndex(0);
			$objPHPExcel->getActiveSheet()->setTitle('Reports');

			$objPHPExcel->getActiveSheet()->getStyle('A1:K1')->getFill()
				->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
				->getStartColor()->setARGB('FFFF00');

			$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(30);
			$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(165);
			$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(45);
			$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(20);

			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(0, 1, "Responsibility Center Code");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(1, 1, "Responsibility Center Description");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(2, 1, "PREXC");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(3, 1, "PREXC Description");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(4, 1, "Object Code");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(5, 1, "Object Description");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(6, 1, "1ST QTR");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(7, 1, "2ND QTR");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(8, 1, "3RD QTR");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(9, 1, "4RTH QTR");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(10, 1, "Total Allotment");

			$first_total = 0;
			$second_total = 0;
			$third_total = 0;
			$fourth_total = 0;
			$row = 2;
			foreach($allotments as $allotment) {
				
				$first_total += $allotment->first_amount;
				$second_total += $allotment->second_amount;
				$third_total += $allotment->third_amount;
				$fourth_total += $allotment->fourth_amount;

				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(0, $row, $allotment->rc_code);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(1, $row, $allotment->rc_description);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(2, $row, $allotment->prexc_code);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(3, $row, $allotment->prexc_description);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(4, $row, $allotment->object_code);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(5, $row, $allotment->object_description);

				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(6, $row, $allotment->first_amount);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(7, $row, $allotment->second_amount);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(8, $row, $allotment->third_amount);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(9, $row, $allotment->fourth_amount);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(10, $row, ($allotment->first_amount + $allotment->second_amount + $allotment->third_amount + $allotment->fourth_amount));

				$objPHPExcel->getActiveSheet()->getStyle('G' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
				$objPHPExcel->getActiveSheet()->getStyle('H' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
				$objPHPExcel->getActiveSheet()->getStyle('I' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
				$objPHPExcel->getActiveSheet()->getStyle('J' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
				$objPHPExcel->getActiveSheet()->getStyle('K' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
				
				$row++;
			}

			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(5, $row, "Grand Total");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(6, $row, $first_total);
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(7, $row, $second_total);
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(8, $row, $third_total);
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(9, $row, $fourth_total);
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(10, $row, ( $first_total + $second_total + $third_total + $fourth_total ) );
			
			$objPHPExcel->getActiveSheet()->getStyle('G' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
			$objPHPExcel->getActiveSheet()->getStyle('H' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
			$objPHPExcel->getActiveSheet()->getStyle('I' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
			$objPHPExcel->getActiveSheet()->getStyle('J' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
			$objPHPExcel->getActiveSheet()->getStyle('K' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);


			// Redirect output to a client’s web browser (Excel2007)
			header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
			header('Content-Disposition: attachment;filename="allotment_list_report.xlsx"');
			header('Cache-Control: max-age=0');
			// If you're serving to IE 9, then the following may be needed
			header('Cache-Control: max-age=1');

			// If you're serving to IE over SSL, then the following may be needed
			header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
			header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
			header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
			header ('Pragma: public'); // HTTP/1.0

			$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
			ob_end_clean();
			$objWriter->save('php://output');
			
			exit;
		}
	}

	public function generate_report_allotment_obligation_disbursement($method = false)
	{
		ini_set('max_execution_time', 300);
		error_reporting(E_ALL);
		ini_set('display_errors', TRUE);
		ini_set('display_startup_errors', TRUE);

		require_once APPPATH.'/libraries/PHPExcel/PHPExcel.php';
		require_once APPPATH.'/libraries/PHPExcel/PHPExcel/IOFactory.php';

		//PHPExcel_Style_NumberFormat 

		$this->load->model('reports_model');
		$fund_id  = $this->input->post('fund_id') == sha1(1) ? 1 : 2;
		$year = $this->input->post('year');
		
		$fund_rc_id = $this->input->post('fund_rc_id');
		$quarter = $this->input->post('quarter');
		$allotments = $this->reports_model->get_allotment_obligation_disbursement($fund_id, $year, $fund_rc_id, $quarter);
		$quarter_amount = "first_amount";

		$quarter_string = "";
		switch($quarter) {
			case 1: 
				$quarter_amount = "first_amount";
				$quarter_string = "1ST";
				break;
			case 2: 
				$quarter_amount = "second_amount";
				$quarter_string = "2ND";
				break;
			case 3: 
				$quarter_amount = "third_amount";
				$quarter_string = "3RD";
				break;
			case 4: 
				$quarter_amount = "fourth_amount";
				$quarter_string = "4RTH";
				break;
		}
		
		if($method == "view") {
			$data = [];
			$data['quarter'] = $quarter; 
			$data['year'] = $year; 
			$data['fund_id'] = $fund_id; 
			$data['quarter_amount'] = $quarter_amount;
			$data['quarter_string'] = $quarter_string;
			$data['allotments'] = $allotments;


			

			$this->load->view('reports/table-source/allotment-obligation-disbursement-table', $data);

		} else {

			$objPHPExcel = new PHPExcel();
			$objPHPExcel->setActiveSheetIndex(0);
			$objPHPExcel->getActiveSheet()->setTitle('Reports');

			$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(30);
			$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(165);
			$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(45);
			$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(20);

			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(0, 1, "Responsibility Center Code");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(1, 1, "Responsibility Center Description");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(2, 1, "PREXC");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(3, 1, "PREXC Description");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(4, 1, "Object Code");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(5, 1, "Object Description");

			if($quarter == "all") {
				$objPHPExcel->getActiveSheet()->getStyle('A1:O1')->getFill()
				->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
				->getStartColor()->setARGB('FFFF00');
				
				$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(20);
				$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(20);
				$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(20);
				$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(20);
				$objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(20);
				$objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(20);
				$objPHPExcel->getActiveSheet()->getColumnDimension('N')->setWidth(20);
				$objPHPExcel->getActiveSheet()->getColumnDimension('O')->setWidth(20);

				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(6, 1, "1ST QTR");
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(7, 1, "2ND QTR");
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(8, 1, "3RD QTR");
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(9, 1, "4RTH QTR");
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(10, 1, "Total Allotment");
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(11, 1, "Total Obligation");
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(12, 1, "Amount Checks Issued");
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(13, 1, "Tax");
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(14, 1, "Amount");


			} else {

				$objPHPExcel->getActiveSheet()->getStyle('A1:L1')->getFill()
				->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
				->getStartColor()->setARGB('FFFF00');

				$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(20);
				$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(20);
				$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(20);
				$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(20);
				$objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(20);

				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(6, 1, "$quarter_string QTR");
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(7, 1, "Total Allotment");
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(8, 1, "Total Obligation");
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(9, 1, "Amount Checks Issued");
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(10, 1, "Tax");
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(11, 1, "Amount");
			}

			$first_total = 0;
			$second_total = 0;
			$third_total = 0;
			$fourth_total = 0;
			$row = 2;
			$total_obligation = 0;
			$total_net_amount = 0;
			$total_bir_amount = 0;
			$total_disb_amount = 0;
			$total_quarter = 0;
			foreach($allotments as $allotment) {
				$obligation_amount = 0;
			
				$obligation = $this->get_total_obligations($fund_id, $allotment->fund_rc_id,  $allotment->legal_basis_id, $year, $allotment->prexc_id, $allotment->object_id, $quarter);

				if (count($obligation) > 0) {
					$obligation = $obligation[0];
					$total_obligation += $obligation->total_obligation;
					$total_net_amount = $total_net_amount + $obligation->net_amount;
					$total_bir_amount += $obligation->bir_amount;
					$total_disb_amount += $obligation->total_amount;
				}

				$col_number = 6;

				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(0, $row, $allotment->rc_code);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(1, $row, $allotment->rc_description);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(2, $row, $allotment->prexc_code);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(3, $row, $allotment->prexc_description);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(4, $row, $allotment->object_code);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(5, $row, $allotment->object_description);
				$objPHPExcel->getActiveSheet()->getStyle('G' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
					
				if($quarter == "all") {
					$first_total += $allotment->first_amount;
					$second_total += $allotment->second_amount;
					$third_total += $allotment->third_amount;
					$fourth_total += $allotment->fourth_amount;

					$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_number++, $row, $allotment->first_amount);
					$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_number++, $row, $allotment->second_amount);
					$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_number++, $row, $allotment->third_amount);
					$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_number++, $row, $allotment->fourth_amount);
					$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_number++, $row, ($allotment->first_amount + $allotment->second_amount + $allotment->third_amount + $allotment->fourth_amount));


					$objPHPExcel->getActiveSheet()->getStyle('H' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
					$objPHPExcel->getActiveSheet()->getStyle('I' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
					$objPHPExcel->getActiveSheet()->getStyle('J' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
					$objPHPExcel->getActiveSheet()->getStyle('K' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
					$objPHPExcel->getActiveSheet()->getStyle('L' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
					
					$objPHPExcel->getActiveSheet()->getStyle('M' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
					$objPHPExcel->getActiveSheet()->getStyle('N' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
					$objPHPExcel->getActiveSheet()->getStyle('O' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
					
				} else {
					$total_quarter += $allotment->{$quarter_amount};
			
					$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_number++, $row, $allotment->{$quarter_amount});
					$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_number++, $row, $allotment->{$quarter_amount});

					$objPHPExcel->getActiveSheet()->getStyle('H' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
					$objPHPExcel->getActiveSheet()->getStyle('I' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
					$objPHPExcel->getActiveSheet()->getStyle('J' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
					$objPHPExcel->getActiveSheet()->getStyle('K' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
					$objPHPExcel->getActiveSheet()->getStyle('L' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
				}

				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_number++, $row, isset($obligation->total_obligation ) ? $obligation->total_obligation : 0);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_number++, $row, isset($obligation->net_amount) ? $obligation->net_amount : 0);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_number++, $row, isset($obligation->bir_amount) ? $obligation->bir_amount : 0);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_number++, $row, isset($obligation->total_amount) ? $obligation->total_amount : 0);
				
				$row++;
			}

			$objPHPExcel->getActiveSheet()->getStyle('G' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
			$col_number = 5;
			if($quarter == "all") {
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_number++, $row, "Grand Total");
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_number++, $row, $first_total);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_number++, $row, $second_total);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_number++, $row, $third_total);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_number++, $row, $fourth_total);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_number++, $row, ( $first_total + $second_total + $third_total + $fourth_total ) );
			
				$objPHPExcel->getActiveSheet()->getStyle('H' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
				$objPHPExcel->getActiveSheet()->getStyle('I' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
				$objPHPExcel->getActiveSheet()->getStyle('J' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
				$objPHPExcel->getActiveSheet()->getStyle('K' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
				$objPHPExcel->getActiveSheet()->getStyle('L' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
				$objPHPExcel->getActiveSheet()->getStyle('M' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
				$objPHPExcel->getActiveSheet()->getStyle('N' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
				$objPHPExcel->getActiveSheet()->getStyle('O' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
			} else {
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_number++, $row, "Grand Total");
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_number++, $row, $total_quarter);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_number++, $row, $total_quarter);
				

				$objPHPExcel->getActiveSheet()->getStyle('H' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
				$objPHPExcel->getActiveSheet()->getStyle('I' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
				$objPHPExcel->getActiveSheet()->getStyle('J' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
				$objPHPExcel->getActiveSheet()->getStyle('K' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
				$objPHPExcel->getActiveSheet()->getStyle('L' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
			}
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_number++, $row, $total_obligation);
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_number++, $row, $total_net_amount);
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_number++, $row, $total_bir_amount);
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_number++, $row, $total_disb_amount);

			// Redirect output to a client’s web browser (Excel2007)
			header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
			header('Content-Disposition: attachment;filename="allotment-obligation-disbursement_list_report.xlsx"');
			header('Cache-Control: max-age=0');
			// If you're serving to IE 9, then the following may be needed
			header('Cache-Control: max-age=1');

			// If you're serving to IE over SSL, then the following may be needed
			header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
			header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
			header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
			header ('Pragma: public'); // HTTP/1.0

			$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
			ob_end_clean();
			$objWriter->save('php://output');
			
			exit;
		}
	}

	public function generate_report_obligation_list($method = false)
	{
		ini_set('max_execution_time', 300);
		error_reporting(E_ALL);
		ini_set('display_errors', TRUE);
		ini_set('display_startup_errors', TRUE);

		require_once APPPATH.'/libraries/PHPExcel/PHPExcel.php';
		require_once APPPATH.'/libraries/PHPExcel/PHPExcel/IOFactory.php';

		//PHPExcel_Style_NumberFormat 
		$this->load->model('obligations_model');
		$fund_id  = $this->input->post('fund_id') == sha1(1) ? 1 : 2;
		$year = $this->input->post('year');
		$fund_rc_id = $this->input->post('fund_rc_id');
		$obligations = $this->obligations_model->get_reports_obligation_details($fund_id, $year, $fund_rc_id);
		
		if($method == "view") {
			
			$data = [];
			$data['obligations'] = $obligations;
			$this->load->view('reports/table-source/obligations-table', $data);

		} else {

			$objPHPExcel = new PHPExcel();
			$objPHPExcel->setActiveSheetIndex(0);
			$objPHPExcel->getActiveSheet()->setTitle('Reports');

			$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(30);
			$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(38);
			$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(25);
			$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(100);
			$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(165);
			$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(50);
			$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(37);
			$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(20);

			$objPHPExcel->getActiveSheet()->getStyle('A1:M1')->getFill()
				->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
				->getStartColor()->setARGB('FFFF00');

			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(0, 1, "Obligation Number");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(1, 1, "Payee");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(2, 1, "Date");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(3, 1, "Responsibility Code");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(4, 1, "Responsibility Description");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(5, 1, "PREXC");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(6, 1, "PREXC Description");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(7, 1, "Object Code");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(8, 1, "Object Description");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(9, 1, "Allotement Class");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(10, 1, "Original Amount");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(11, 1, "Adjustment (Based on NORSA)");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(12, 1, "Total Adjusted Amount");

			$total_amount = 0;
			$total_norsa = 0;
			$total_adjusted_amount = 0;
			$row = 2;


			foreach($obligations as $obligation) {

				$total_amount += $obligation->original_amount;
				$total_norsa += $obligation->norsa == NULL  ?  0 : $obligation->norsa ;
				$adjusted_amount = $obligation->norsa == NULL  ? $obligation->original_amount : $obligation->adjusted_amount   ;
				$total_adjusted_amount += $adjusted_amount  ;
				
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(0, $row, $obligation->obligation_no);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(1, $row, $obligation->payee_description);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(2, $row, $obligation->date);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(3, $row, $obligation->rc_code);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(4, $row, $obligation->rc_description);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(5, $row, $obligation->prexc_code);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(6, $row, $obligation->prexc_description);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(7, $row, $obligation->object_code);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(8, $row, $obligation->object_description);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(9, $row, $obligation->allotment_class_name);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(10, $row, $obligation->original_amount);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(11, $row, $obligation->norsa == NULL  ?  0 : $obligation->norsa);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(12, $row, $adjusted_amount);
				
				$objPHPExcel->getActiveSheet()->getStyle('K' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
				$objPHPExcel->getActiveSheet()->getStyle('L' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
				$objPHPExcel->getActiveSheet()->getStyle('M' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
				
				$row++;
			}

			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(9, $row, "Grand Total");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(10, $row, $total_amount);
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(11, $row, $total_norsa);
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(12, $row, $total_adjusted_amount);

			$objPHPExcel->getActiveSheet()->getStyle('K' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
			$objPHPExcel->getActiveSheet()->getStyle('L' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
			$objPHPExcel->getActiveSheet()->getStyle('M' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);


			// Redirect output to a client’s web browser (Excel2007)
			header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
			header('Content-Disposition: attachment;filename="obligaiton_list_report.xlsx"');
			header('Cache-Control: max-age=0');
			// If you're serving to IE 9, then the following may be needed
			header('Cache-Control: max-age=1');

			// If you're serving to IE over SSL, then the following may be needed
			header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
			header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
			header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
			header ('Pragma: public'); // HTTP/1.0

			$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
			ob_end_clean();
			$objWriter->save('php://output');
			
			exit;
		}
	}
	
	public function generate_report_disbursement_list($method = false)
	{
		error_reporting(E_ALL);
		ini_set('display_errors', TRUE);
		ini_set('display_startup_errors', TRUE);

		require_once APPPATH.'/libraries/PHPExcel/PHPExcel.php';
		require_once APPPATH.'/libraries/PHPExcel/PHPExcel/IOFactory.php';

		//PHPExcel_Style_NumberFormat 
		$this->load->model('obligations_model');
		$fund_id  = $this->input->post('fund_id') == sha1(1) ? 1 : 2;
		$year = $this->input->post('year');
		$fund_rc_id = $this->input->post('fund_rc_id');
		$disbursements = $this->obligations_model->get_reports_disbursement($fund_id, $year, $fund_rc_id);
		if($method == "view") {
			
			$data = [];
			$data['disbursements'] = $disbursements;
			$this->load->view('reports/table-source/disbursements-table', $data);

		} else {

			$objPHPExcel = new PHPExcel();
			$objPHPExcel->setActiveSheetIndex(0);
			$objPHPExcel->getActiveSheet()->setTitle('Reports');

			$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(10);
			$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(15);
			$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(17);
			$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(13);
			$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(30);
			$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(37);
			$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(17);
			$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(35);
			$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(40);
			$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(15);
			$objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('O')->setWidth(20);

			$objPHPExcel->getActiveSheet()->getStyle('A1:O1')->getFill()
				->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
				->getStartColor()->setARGB('FFFF00');

			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(0, 1, "Date");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(1, 1, "ORS NO");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(2, 1, "RCI/ADA/ROD No.");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(3, 1, "DV NO.");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(4, 1, "PAYEE");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(5, 1, "AUTHORIZATION TYPE / BUDGET SOURCE");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(6, 1, "PREXC");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(7, 1, "PREXC Description");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(8, 1, "RC Code");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(9, 1, "Allotement Class");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(10, 1, "Object Code");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(11, 1, "Amount Checks Issued");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(12, 1, "Tax");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(13, 1, "Amount");

			$total_amount = 0;
			$total_amount_check = 0;
			$total_tax = 0;
			$row = 2;


			foreach($disbursements as $disbursement) {

				$total_amount_check += $disbursement->net_amount;
				$total_tax += $disbursement->bir_amount;
				$total_amount += $disbursement->total_amount;
				

				
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(0, $row, $disbursement->date);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(1, $row, $disbursement->obligation_no);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(2, $row, $disbursement->ada_number);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(3, $row, $disbursement->dv_number);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(4, $row, $disbursement->payee_description);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(5, $row, $disbursement->fund_id == 1 ? 'New General Appropriations' : 'Continuing Appropriations');
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(6, $row, $disbursement->prexc_code);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(7, $row, $disbursement->prexc_description);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(8, $row, $disbursement->rc_code);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(9, $row, $disbursement->allotment_class_name);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(10, $row, $disbursement->object_code);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(11, $row, $disbursement->net_amount);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(12, $row, $disbursement->bir_amount);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(13, $row, $disbursement->total_amount);
				
				$objPHPExcel->getActiveSheet()->getStyle('O' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
				$objPHPExcel->getActiveSheet()->getStyle('L' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
				$objPHPExcel->getActiveSheet()->getStyle('M' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
				$objPHPExcel->getActiveSheet()->getStyle('N' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
				
				$row++;
			}

			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(10, $row, "Grand Total");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(11, $row, $total_amount_check);
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(12, $row, $total_tax);
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(13, $row, $total_amount);

			$objPHPExcel->getActiveSheet()->getStyle('L' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
			$objPHPExcel->getActiveSheet()->getStyle('M' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
			$objPHPExcel->getActiveSheet()->getStyle('N' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);


			// Redirect output to a client’s web browser (Excel2007)
			header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
			header('Content-Disposition: attachment;filename="disbursement_list_report.xlsx"');
			header('Cache-Control: max-age=0');
			// If you're serving to IE 9, then the following may be needed
			header('Cache-Control: max-age=1');

			// If you're serving to IE over SSL, then the following may be needed
			header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
			header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
			header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
			header ('Pragma: public'); // HTTP/1.0

			$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
			ob_end_clean();
			$objWriter->save('php://output');
			
			exit;
		}
	}

	public function generate_report_far_one($method = false)
	{
		error_reporting(E_ALL);
		ini_set('display_errors', TRUE);
		ini_set('display_startup_errors', TRUE);

		require_once APPPATH.'/libraries/PHPExcel/PHPExcel.php';
		require_once APPPATH.'/libraries/PHPExcel/PHPExcel/IOFactory.php';

		//PHPExcel_Style_NumberFormat 
		$this->load->model('reports_model');
		$fund_id  = $this->input->post('fund_id') == sha1(1) ? 1 : 2;
		$year = $this->input->post('year');
		$fund_rc_id = $this->input->post('fund_rc_id');
		$prexc_ids = $this->input->post('prexc_ids');
		// print_r($prexc_ids) ;
		// exit();
		$quarter = $this->input->post('quarter');
		// $prexc_id = 2;
		// $quarter = 1;
		$quarter_string = "1st Quarter Ending of March";
		switch($quarter) {
			case 2: 
				$quarter_string = "2nd Quarter Ending of June";
			break;

			case 3: 
				$quarter_string = "3rd Quarter Ending of September";
			break;

			case 4: 
				$quarter_string = "4rth Quarter Ending of December";
			break;
		}
		// far_one_report($fund_id, $year, $quarter_string){
		$far_one = $this->reports_model->far_one_report($fund_id, $year, $prexc_ids , $quarter  );
		if($method == "view") {
			
			$data = [];
			$data['far_one'] = $far_one;
			$data['quarter_string'] = $quarter_string;
			$this->load->view('reports/table-source/far-one-table', $data);

		} else {
			$objPHPExcel = new PHPExcel();
			$objPHPExcel->setActiveSheetIndex(0);
			$objPHPExcel->getActiveSheet()->setTitle('Reports');

			$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(15);
			$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(35);
			$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(15);
			$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(50);
			$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(30);
			$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(37);
			$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(25);
			$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(20);

			$objPHPExcel->getActiveSheet()->getStyle('A1:J1')->getFill()
				->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
				->getStartColor()->setARGB('FFFF00');

			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(0, 1, "PREXC");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(1, 1, "PREXC Description");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(2, 1, "Object Code");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(3, 1, "Object Description");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(4, 1, "Adjusted Total Allotments");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(5, 1, $quarter_string . " (Obligations)" );
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(6, 1, "Total (Obligations)");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(7, 1, $quarter_string . " (Disbursement)");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(8, 1, "Total (Disbursement)");
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(9, 1, "Unobligated Allotments");

			$row = 2;

			foreach($far_one as $fo) {
				
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(0, $row, $fo->prexc_code);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(1, $row, $fo->prexc_description);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(2, $row, $fo->object_code);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(3, $row, $fo->object_description);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(4, $row, $fo->total_allotment);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(5, $row, $fo->total_obligation);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(6, $row, $fo->total_obligation);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(7, $row, $fo->total_disbursement);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(8, $row, $fo->total_disbursement);
				$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(9, $row, $fo->total_allotment - $fo->total_obligation);
				
				$objPHPExcel->getActiveSheet()->getStyle('E' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
				$objPHPExcel->getActiveSheet()->getStyle('F' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
				$objPHPExcel->getActiveSheet()->getStyle('G' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
				$objPHPExcel->getActiveSheet()->getStyle('H' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
				$objPHPExcel->getActiveSheet()->getStyle('I' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
				$objPHPExcel->getActiveSheet()->getStyle('J' . $row)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
				
				$row++;
			}

			// Redirect output to a client’s web browser (Excel2007)
			header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
			header('Content-Disposition: attachment;filename="far_one_report.xlsx"');
			header('Cache-Control: max-age=0');
			// If you're serving to IE 9, then the following may be needed
			header('Cache-Control: max-age=1');

			// If you're serving to IE over SSL, then the following may be needed
			header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
			header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
			header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
			header ('Pragma: public'); // HTTP/1.0

			$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
			ob_end_clean();
			$objWriter->save('php://output');
			
			exit;
		}
	}

	public function get_total_obligations($fund_id, $fund_rc_id,  $legal_basis_id, $year, $prexc_id, $object_id, $quarter = 1)
	{
		$this->load->model('reports_model');
		return $this->reports_model->get_total_obligations($fund_id, $fund_rc_id,  $legal_basis_id, $year, $prexc_id, $object_id, $quarter);
	}
	

}