<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Responsibility_center extends MY_Controller {

	public function __construct() {
		parent::__construct();
		$this->isLogin();
	}

	public function index()
	{
		$this->list();
	}

	public function list()
	{
		$this->redirect_disbursement_user();
		$this->data['nav_bar'] = array("maintenance","rc_list");
		$this->load->model('responsibility_center_model', '', TRUE);
		$this->data['content'] = 'responsibility_center/list';
		$this->data['responsibility'] = $this->responsibility_center_model->get_responsibility_center_list();
		$this->load->view('template/admin', $this->data);
	}

	public function allotment_received()
	{
		$this->data['nav_bar'] = array("rc","budget");
		$this->load->model('responsibility_center_model', '', TRUE);
		$this->load->model('funds_model', '', TRUE);
		$this->data['year'] = $this->input->get("year") ? $this->input->get("year") : date("Y");
		$this->data["fund_id"] = $this->input->get("fund_id") ? $this->input->get("fund_id") : sha1(1);
		$this->data['content'] = 'responsibility_center/budget';
		$this->data['responsibility_budget'] = $this->responsibility_center_model->get_responsibility_center_budget($this->data["year"], $this->data["fund_id"]);
		$this->data['fund_list'] = $this->funds_model->get_fund_list();
		$this->data['rc_new_budget'] = $this->responsibility_center_model->get_rc_new_budget_list($this->data["year"], $this->data["fund_id"]);
		$this->load->view('template/admin', $this->data);
	}

	public function get_fund_rc()
	{
		$message = "";
		$year = $this->input->get('year');
		$fund_id = $this->input->get('fund_id')	 ;
		$this->load->model('responsibility_center_model', '', TRUE);

		$fund_rc = $this->responsibility_center_model->get_responsibility_center_budget($year, $fund_id);

		output_to_json($this,array("fund_rc" => $fund_rc,  "message" => $message));
	}

	public function add_responsibility_center()
	{
		$this->load->model('responsibility_center_model', '', TRUE);

		$data = array();
		$data["code"] = $this->input->post('code');
		$data["description"] = $this->input->post('description');

		$this->responsibility_center_model->add_responsibility_center($data);

		redirect(site_url("responsibility_center/list"));
	}

	public function delete_responsibility_center()
	{
		$this->load->model('responsibility_center_model', '', TRUE);
		$data = array();
		$id = $this->input->post('rc_id');
		$this->responsibility_center_model->delete_responsibility_center($id);
		redirect(site_url("responsibility_center/list"));
	}

	public function edit_responsibility_center()
	{
		$this->load->model('responsibility_center_model', '', TRUE);
		$data = array();
		$data["id"] = $this->input->post('rc_id');
		$data["code"] = $this->input->post('code');
		$data["description"] = $this->input->post('description');
		$this->responsibility_center_model->edit_responsibility_center($data);
		redirect(site_url("responsibility_center/list"));
	}

	public function add_responsibility_center_budget()
	{
		$this->load->model('responsibility_center_model', '', TRUE);

		$data = array();
		$data["rc_id"] = $this->input->post('rc_id');
		$data["year"] = $this->input->post('year');
		$data["fund_id"] = $this->input->post('fund_id') == sha1(1) ? 1 : 2;
		$data["amount"] = $this->input->post('amount');

		$this->responsibility_center_model->add_responsibility_center_budget($data);

		redirect(site_url("responsibility_center/budget?fund_id=" . $this->input->post('fund_id')));
	}

	public function edit_responsibility_center_budget()
	{
		$this->load->model('responsibility_center_model', '', TRUE);
		$data = array();
		$rc_budget_id = $this->input->post('rc_budget_id');
		$data["year"] = $this->input->post('year');
		$data["fund_id"] = $this->input->post('fund_id') == sha1(1) ? 1 : 2;
		$data["amount"] = $this->input->post('amount');
		$this->responsibility_center_model->edit_responsibility_center_budget($data, $rc_budget_id);
		redirect(site_url("responsibility_center/budget?fund_id=" . $this->input->post('fund_id')));
	}

	// public function edit_responsibility_center_budget()
	// {
	// 	$this->load->model('responsibility_center_model', '', TRUE);
	// 	$data = array();
	// 	$year = $this->input->post('year');
	// 	$fund_id = $this->input->post('fund_id') == sha1(1) ? 1 : 2;
	// 	$amounts = $this->input->post('amounts');
	// 	$data = array();
	// 	foreach ($amounts as $rc_id => $amount) {
	// 		$temp_data = array();
	// 		$temp_data["amount"] = $amount;
	// 		$temp_data["year"] = 2018;
	// 		$temp_data["rc_id"] = $rc_id;
	// 		$temp_data["fund_id"] = $fund_id;
	// 		$data[] = $temp_data;
	// 	}
	// 	$this->responsibility_center_model->edit_responsibility_center_budget($data, $fund_id, $year);
	// 	redirect(site_url("responsibility_center/budget?fund_id=" . $this->input->post('fund_id')));
	// }

	public function objects()
	{
		$this->load->model('responsibility_center_model', '', TRUE);
		$this->data['content'] = 'responsibility_center/objects';
		$this->data['rc_details'] = $this->responsibility_center_model->get_rc_details($this->input->get('rc'));
		$this->data['rc_objects'] = $this->responsibility_center_model->get_rc_object_list($this->input->get('rc'));
		$this->data['rc_new_objects'] = $this->responsibility_center_model->get_rc_new_object_list($this->input->get('rc'));

		$this->load->view('template/admin', $this->data);
	}

	public function add_rc_objects()
	{
		$this->load->model('responsibility_center_model', '', TRUE);

		$data = array();
		$rc_id = $this->input->post('rc_id');
		foreach($this->input->post('object_id') as $obj_id) {
			$temp_data = array();
			$temp_data["rc_id"] = $rc_id;
			$temp_data["object_id"] = $obj_id;
			$data[] = $temp_data;
		}

		$this->responsibility_center_model->add_rc_objects($data);

		redirect(site_url("responsibility_center/objects?rc=" . sha1("rc".$rc_id)));
	}

	
	public function get_total_rc_budget()
	{
		$message = "";
		$available_amount = 0;
		$fund_id = $this->input->get('fund_id') == sha1(1) ? 1 : 2;
		$this->load->model('responsibility_center_model', '', TRUE);

		$total_rc_budget = $this->responsibility_center_model->get_total_rc_budget($this->input->get('year'), $fund_id);

		output_to_json($this,array("total_rc_budget" => $total_rc_budget,  "message" => $message));
	}

	public function get_available_rc_budget($json = true)
	{
		$message = "";
		$available_amount = 0;
		$fund_id = $this->input->get('fund_id') == sha1(1) ? 1 : 2;
		$rc_budget_id = $this->input->get('rc_budget_id');
		$this->load->model('allotment_model', '', TRUE);
		$this->load->model('responsibility_center_model', '', TRUE);
		$total_rc_budget = $this->responsibility_center_model->get_total_rc_budget($this->input->get('year'), $fund_id, $rc_budget_id);

		$total_allotment_budget = $this->allotment_model->get_total_amount_allotment_class_budget($this->input->get('year'), $fund_id);

		$available_amount = ($total_allotment_budget - $total_rc_budget);
		$result = array("available_amount" => $available_amount,  "message" => $message);
		if($json) {
			output_to_json($this, $result);
		} else {
			return $result;
		}
	}

	/**
	 * 
	 * 
	 */
	public function get_available_rc_budget_by_allotment()
	{
		$message = "";
		$available_amount = 0;
		$fund_id = $this->input->get('fund_id') == sha1(1) ? 1 : 2;
		$this->load->model('allotment_model', '', TRUE);
		$this->load->model('responsibility_center_model', '', TRUE);
		$total_rc_budget = $this->responsibility_center_model->get_total_rc_budget($this->input->get('year'), $fund_id);
		$total_allotment_budget = $this->allotment_model->get_total_amount_allotment_class_budget($this->input->get('year'), $fund_id);
		$available_amount = ($total_allotment_budget - $total_rc_budget);
		$result = array("available_amount" => $available_amount,  "message" => $message);
		if($json) {
			output_to_json($this, $result);
		} else {
			return $result;
		}
	}

}
