<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Superadmin extends MY_Controller {

	public function __construct() {
		parent::__construct();
		$this->isLogin();
		if($this->login_user_data["type"] != 4) {
			redirect('authentication/user_default_page');
		}
	}

	public function index()
	{
		$this->allotment_list();
	}

	public function allotment_list()
	{
		
		$this->load->model('allotment_model', '', TRUE);
		$this->load->model('responsibility_center_model', '', TRUE);
		$this->load->model('funds_model', '', TRUE);
		$this->load->model('prexc_model', '', TRUE);
		$this->load->model('superadmin_model', '', TRUE);
		$this->data['nav_bar'] = array("maintenance","allotment_recieved");
		$this->data['content'] = 'superadmin/allotment_list';

		$this->data['fund_list'] = $this->funds_model->get_fund_list();
		$this->data["fund_id"] = $this->input->get("fund_id") ? $this->input->get("fund_id") : sha1($this->data['fund_list'][0]->id);
		$fund_id = $this->data["fund_id"] == sha1(1) ? 1 : 2;
		
		$this->data['year'] = $this->input->get("year") ? $this->input->get("year") : date("Y");

		$this->data["error_message"] = "";
		
		$this->data['allotment_list'] = $this->superadmin_model->get_allotment_list($fund_id, $this->data['year'], true);
	
		$this->load->view('template/admin', $this->data);
	}


	public function obligation_list()
	{
		$this->data['nav_bar'] = array("maintenance","obligations");
		$this->load->model('obligations_model', '', TRUE);
		$this->load->model('funds_model', '', TRUE);
		$this->load->model('legal_basis_model', '', TRUE);
		$this->data['content'] = 'superadmin/obligations';
		
		$this->data['fund_list'] = $this->funds_model->get_fund_list();
		$this->data["fund_id"] = $this->input->get("fund_id") ? $this->input->get("fund_id") : sha1($this->data['fund_list'][0]->id);
		$fund_id = $this->data["fund_id"] == sha1(1) ? 1 : 2;
		$this->data['year'] = $this->input->get("year") ? $this->input->get("year") : date("Y");
		
		$this->data['fund_legal_basis'] = $this->legal_basis_model->get_fund_legal_basis($fund_id, $this->data['year']);
		$this->data['legal_basis_id'] = $this->input->get("legal_basis_id") ? $this->input->get("legal_basis_id") : (count( $this->data['fund_legal_basis']) > 0 ? $this->data['fund_legal_basis'][0]->id : 0);
				

		$this->data['obligations'] = $this->obligations_model->get_obligation_list($this->data['year'], $fund_id, $this->data['legal_basis_id']);

		$this->load->view('template/admin', $this->data);
	
	}

	public function migrate_fund_structure()
	{
		$this->login_user_data;
		
		$this->data['nav_bar'] = array("funds","obligations");
		$this->load->model('funds_model', '', TRUE);
		$this->data['content'] = 'superadmin/obligations';
		
		$this->data['from_year'] = $this->input->get("from_year") ? $this->input->get("year") : (date("Y") - 1);
		$this->data['to_year'] = $this->input->get("from_year") ? $this->input->get("year") : date("Y");
		
		$result = $this->funds_model->migrate_fund_structure($this->data['from_year'], $this->data['to_year'], $this->login_user_data['id']);
		if($result){
			//redirect to avoid refres or reinsert of data
			redirect('superadmin/migrate_fund_structure_success');
		} else {
			echo "Migration fail, Contact your developer.";
		}

		exit();
	}	

	public function migrate_fund_structure_success()
	{
		echo "Migration success, dont do that again. See you next year.. (ui is under construction)";
	
		exit();	
	}	

	public function delete_obligation()
	{
		$this->load->model('obligations_model', '', TRUE);
		$data = array();
		$id = $this->input->post('obligation_id');
		$year = $this->input->post('year');
		$legal_basis_id = $this->input->post('legal_basis_id');
		$this->obligations_model->delete_obligation($id);
		redirect(site_url("superadmin/obligation_list?fund_id=" . $this->input->post('fund_id') . "&year=$year&legal_basis_id=$legal_basis_id"));

	}

	public function delete_allotment()
	{
		$this->load->model('superadmin_model', '', TRUE);
		$data = array();
		$year = $this->input->post('year');
		$fund_id = $this->input->post('fund_id') == sha1('1') ? 1 : 2;
		$allotment_id = $this->input->post('allotment_id');

		$this->superadmin_model->delete_allotment($allotment_id, $fund_id);

		redirect(site_url("superadmin/allotment_list?fund_id=" . $this->input->post('fund_id') . "&year=$year"));
	}
}
