<?php
	class Allotment_model extends CI_Model
	{
		public function __construct()
		{
			parent::__construct();
		}

		public function edit_allotment($allotment_received, $allotment_received_details, $fund_rc_id, $prexc_id, $legal_basis_id){
			$this->db->trans_begin();
				$this->db->where('fund_rc_id', $fund_rc_id);
				$this->db->where('legal_basis_id', $legal_basis_id);
				$this->db->where('prexc_id',  $prexc_id);
				$this->db->update('allotment_received', array("status"=>"UPDATED")); 

				$this->db->insert('allotment_received', $allotment_received); 
				$allotment_received_id = $this->db->insert_id();

				foreach($allotment_received_details as $key => $allotment_received_detail) {
					$allotment_received_details[$key]["allotment_received_id"] = $allotment_received_id;
				}

				$this->db->insert_batch('allotment_received_details', $allotment_received_details);

			if ($this->db->trans_status() === FALSE) {
				
				$this->db->trans_rollback();
			} else {
				$this->db->trans_commit();
			}
		}

		// public function get_total_amount_allotment_class_budget($year, $fund_id){
		// 	$query_string = "SELECT IF(ISNULL(sum(amount)), 0, sum(amount) ) as total_amount FROM `allotment_class_budget` WHERE year = ? AND fund_id = ?";
		// 	$result = $this->db->query($query_string, array($year, $fund_id))->result_object(); 
		// 	return $result[0]->total_amount;
		// }

		// public function get_total_amount_allotment_class_budget_by_id($year, $allotment_class_id){
		// 	$query_string = "SELECT IF(ISNULL(sum(amount)), 0, sum(amount) ) as total_amount FROM `allotment_class_budget` WHERE year = ? AND allotment_class_id = ?";
		// 	$result = $this->db->query($query_string, array($year, $allotment_class_id))->result_object(); 
		// 	return $result[0]->total_amount;
		// }

		// public function get_allotment_list($year, $fund_id, $rc_id, $prexc_id){
		// 	$query_string = "SELECT 
		// 						obj.id as object_id, obj.code as object_code, obj.description as object_description,
		// 						a.id as allotment_id,
		// 							IF(ISNULL(a.`first_amount`), 0, a.`first_amount`) as first_amount,
		// 							IF(ISNULL(a.`second_amount`), 0, a.`second_amount`) as second_amount,
		// 							IF(ISNULL(a.`third_amount`), 0, a.`third_amount`) as third_amount,
		// 							IF(ISNULL(a.`fourth_amount`), 0, a.`fourth_amount`) as fourth_amount,
		// 								ac.id as allotment_class_id,
		// 								ac.name as allotment_class,
		// 							IF(ISNULL(total_obligations.total_obligation), 0, total_obligations.total_obligation ) as total_obligation
		// 							FROM rc_objects as rcobj
		// 									LEFT JOIN allotment as a ON rcobj.rc_id = a.rc_id AND a.object_id = rcobj.object_id  AND a.year = ? AND a.fund_id =  ? AND a.prexc_id = ?
		// 									LEFT JOIN object_of_expenditures as obj ON obj.id = rcobj.object_id
		// 									LEFT JOIN allotment_class as ac ON ac.id = obj.allotment_class_id
		// 									LEFT JOIN (
		// 												SELECT SUM(amount) as total_obligation, od.object_id
		// 												FROM obligation_details as od
		// 												INNER JOIN obligations as obl on obl.id = od.obligation_id
		// 												WHERE obl.date BETWEEN '$year-01-01' AND '$year-12-31'
		// 												AND obl.fund_id = $fund_id AND obl.rc_id = $rc_id AND obl.prexc_id = $prexc_id
		// 												GROUP BY  od.object_id
		// 												) as total_obligations on total_obligations.object_id =  obj.id
		// 								WHERE rcobj.rc_id = ? 
		// 								ORDER BY object_code ASC;";		
		// 	return $this->db->query($query_string, array($year, $fund_id, $prexc_id,  $rc_id,))->result_object(); 
		// }
		public function get_allotment_list($year, $fund_id, $fund_rc_id, $prexc_id, $legal_basis_id, $filter_active = false){
			
			$filter_active_sql = $filter_active==true  ? "AND frc_obj.status = 'ACTIVE'" : "";
			$query_string = "SELECT obj.id as object_id, obj.code as object_code, obj.description as object_description,
								a.id as allotment_id,
									IF(ISNULL(a.`first_amount`), 0, a.`first_amount`) as first_amount,
									IF(ISNULL(a.`second_amount`), 0, a.`second_amount`) as second_amount,
									IF(ISNULL(a.`third_amount`), 0, a.`third_amount`) as third_amount,
									IF(ISNULL(a.`fourth_amount`), 0, a.`fourth_amount`) as fourth_amount,
										ac.id as allotment_class_id,
										ac.name as allotment_class,
									IF(ISNULL(total_obligations.total_obligation), 0, total_obligations.total_obligation ) as total_obligation
									FROM fund_rc_objects as frc_obj
										LEFT JOIN (
											SELECT ard.*
											FROM allotment_received ar
											INNER JOIN allotment_received_details as ard ON ard.allotment_received_id = ar.id
											WHERE ar.prexc_id = ? AND ar.legal_basis_id = ? AND ar.fund_rc_id = ? AND ar.`status` = 'ACTIVE'
										) as a ON frc_obj.object_id = a.object_id
										LEFT JOIN object_of_expenditures as obj ON obj.id = frc_obj.object_id
										LEFT JOIN allotment_class as ac ON ac.id = obj.allotment_class_id
										LEFT JOIN (
													SELECT SUM(amount) - SUM(IF(ISNULL(obn.norsa), 0, obn.norsa)) as total_obligation, od.object_id
														FROM obligation_details as od
														INNER JOIN obligations as obl on obl.id = od.obligation_id
														LEFT JOIN obligation_norsa as obn on obn.obligation_details_id = od.id AND obn.status = 'ACTIVE'
													WHERE obl.date BETWEEN '$year-01-01' AND '$year-12-31'
														AND obl.fund_id = $fund_id AND obl.legal_basis_id = $legal_basis_id
														AND od.fund_rc_id = $fund_rc_id AND od.prexc_id = $prexc_id  
														GROUP BY od.object_id
													) as total_obligations on total_obligations.object_id =  obj.id
											WHERE frc_obj.fund_rc_id = ? $filter_active_sql
										ORDER BY object_code ASC;";
			return $this->db->query($query_string, array($prexc_id, $legal_basis_id, $fund_rc_id, $fund_rc_id))->result_object(); 
		}

		public function get_available_allotment_recieved_per_object($year, $fund_id, $fund_rc_id, $prexc_id, $legal_basis_id, $object_id) {
			$query_string = "SELECT (
										IF(ISNULL(a.`first_amount`), 0, a.`first_amount`) +
										IF(ISNULL(a.`second_amount`), 0, a.`second_amount`) +
										IF(ISNULL(a.`third_amount`), 0, a.`third_amount`) +
										IF(ISNULL(a.`fourth_amount`), 0, a.`fourth_amount`)
									) - IF(ISNULL(total_obligations.total_obligation), 0, total_obligations.total_obligation ) as total_available_amount
									FROM fund_rc_objects as frc_obj
										LEFT JOIN (
											SELECT ard.*
											FROM allotment_received ar
											INNER JOIN allotment_received_details as ard ON ard.allotment_received_id = ar.id
											WHERE ar.prexc_id = ? AND ar.legal_basis_id = ? AND ar.fund_rc_id = ? AND ar.`status` = 'ACTIVE'
										) as a ON frc_obj.object_id = a.object_id
										LEFT JOIN (
													SELECT SUM(amount) - SUM(IF(ISNULL(obn.norsa), 0, obn.norsa)) as total_obligation, od.object_id
														FROM obligation_details as od
														INNER JOIN obligations as obl on obl.id = od.obligation_id
														LEFT JOIN obligation_norsa as obn on obn.obligation_details_id = od.id AND obn.status = 'ACTIVE'
													WHERE obl.date BETWEEN '$year-01-01' AND '$year-12-31'
														AND obl.fund_id = $fund_id AND obl.legal_basis_id = $legal_basis_id
														AND od.fund_rc_id = $fund_rc_id AND od.prexc_id = $prexc_id  
														GROUP BY od.object_id
													) as total_obligations on total_obligations.object_id = frc_obj.object_id 
															
											WHERE frc_obj.fund_rc_id = ?  AND frc_obj.object_id  = $object_id;";

			$result = $this->db->query($query_string, array($prexc_id, $legal_basis_id, $fund_rc_id, $fund_rc_id))->result_object(); 

			 return $result[0]->total_available_amount;
		}


		// public function get_total_allotment($year, $fund_id){
		// 	$query_string = "SELECT IF(ISNULL(sum(first_amount)), 0, sum(first_amount) ) as total_first_amount,
		// 		IF(ISNULL(sum(second_amount)), 0, sum(second_amount) ) as total_second_amount,
		// 		IF(ISNULL(sum(third_amount)), 0, sum(third_amount) ) as total_third_amount,
		// 		IF(ISNULL(sum(fourth_amount)), 0, sum(fourth_amount) ) as total_fourth_amount
		// 		FROM `allotment` WHERE year = ? AND fund_id = ?;";
		// 	$result = $this->db->query($query_string, array($year, $fund_id))->result_object(); 
		// 	return ($result[0]->total_first_amount + $result[0]->total_second_amount + $result[0]->total_third_amount + $result[0]->total_fourth_amount);
		// }

		public function get_available_object_allotment_class_fund($year, $fund_id, $rc_id, $prexc_id, $object_ids, $allotment_class_id ) {
			$query_string = "SELECT 
									(SELECT IF(ISNULL(amount), 0, amount) as amount FROM allotment_class_budget WHERE allotment_class_id = ? AND fund_id = ? AND year = ? ) - 
									IF(ISNULL(al.id), 0,(SUM(al.first_amount) + SUM(al.second_amount) +  SUM(al.third_amount) + SUM(al.fourth_amount)))
								 as total_available_amount
								FROM `allotment`as al
								LEFT JOIN
								(SELECT * FROM `allotment`
								WHERE rc_id = ? AND year = ? AND fund_id = ? AND 
								prexc_id = ? AND object_id in ?
								)
								as al2 on al.id = al2.id
								INNER JOIN object_of_expenditures as ooe ON ooe.id = al.object_id AND ooe.allotment_class_id = ?
								WHERE al2.id is NULL AND al.fund_id = ?";

			$result = $this->db->query($query_string, array($allotment_class_id,  $fund_id, $year, $rc_id, $year, $fund_id, 
														$prexc_id, $object_ids, $allotment_class_id, $fund_id))->result_object(); 

			return $result[0]->total_available_amount;
		}


		public function check_if_allotment_list_has_data($fund_rc_id, $prexc_id, $legal_basis_id){
			$query_string = "SELECT count(*) as total_results FROM `allotment_received` WHERE  fund_rc_id = ?  AND prexc_id = ? AND legal_basis_id = ? ;";
			$result = $this->db->query($query_string, array($fund_rc_id, $prexc_id, $legal_basis_id))->result_object(); 
			if($result[0]->total_results > 0) {
				return true;
			} else {
				return false;	
			}
		}

		public function get_allotment_list_reports( $fund_id, $year, $fund_rc_id = "all"){
			$filter_by_rc = "";
			if($fund_rc_id != "all") {
				$filter_by_rc = " AND frc.id = $fund_rc_id ";
			}

			$query_string = "SELECT rc.id as rc_id, rc.code as rc_code, rc.description as rc_description,
							prxc.code as prexc_code, prxc.description as prexc_description, prxc.id as prexc_id,
							obj.id as object_id, obj.code as object_code, obj.description as object_description,
															allotment.first_amount, allotment.second_amount, allotment.third_amount, allotment.fourth_amount,
															frc.status
										FROM fund_rc as frc
											LEFT JOIN (
												SELECT frc.id, ar.prexc_id, frc_obj.object_id,
													IF(ISNULL(ard.`first_amount`), 0, ard.`first_amount`) as first_amount, IF(ISNULL(ard.`second_amount`), 0, ard.`second_amount`) as second_amount,
													IF(ISNULL(ard.`third_amount`), 0, ard.`third_amount`) as third_amount, IF(ISNULL(ard.`fourth_amount`), 0, ard.`fourth_amount`) as fourth_amount
														FROM `fund_rc` as frc
														INNER JOIN `fund_rc_objects` as frc_obj ON frc_obj.fund_rc_id = frc.id AND frc_obj.`status` ='ACTIVE'
														INNER JOIN allotment_received as ar ON ar.fund_rc_id = frc.id AND ar.`status` = 'ACTIVE'
														INNER JOIN allotment_received_details as ard ON ard.allotment_received_id = ar.id AND ard.object_id = frc_obj.object_id
														WHERE frc.fund_id = $fund_id AND frc.year = $year
													) as allotment ON allotment.id = frc.id
											INNER JOIN responsibility_center as rc on rc.id = frc.rc_id
											INNER JOIN prexc as prxc on prxc.id = allotment.prexc_id
											INNER JOIN object_of_expenditures as obj ON obj.id = allotment.object_id
											INNER JOIN allotment_class as ac ON ac.id = obj.allotment_class_id
										WHERE frc.fund_id = $fund_id AND frc.year = $year $filter_by_rc AND frc.status = 'ACTIVE' 
										ORDER BY rc.code, rc.description, prxc.code, prxc.description, obj.code, obj.description  ASC;";
			return $this->db->query($query_string, array($year, $fund_id))->result_object(); 
		}

	}
?>

