<?php
	class Appropriations_model extends CI_Model
	{
		public function __construct()
		{
			parent::__construct();
		}

		public function get_appropriations_list($fund_id, $year, $all=true, $user_id = 0){
			ini_set('max_execution_time', 300);
			$created_by_obl = "";
			$created_by_frc = "";
			if(!$all) {
				$created_by_obl = " AND obl.created_by = $user_id ";
				$created_by_frc = " AND frc.created_by = $user_id ";
			}

			$query_string = "SELECT ac.id, ac.name as allotment_class_name, IF(ISNULL(obligation_disbursement.total_disbursement), 0, obligation_disbursement.total_disbursement) as total_disbursement,
								IF (ISNULL(allotment_received.amount), 0, allotment_received.amount ) as total_allotment,
								IF(ISNULL(total_obligations.total_obligation), 0, total_obligations.total_obligation ) as total_obligation
								FROM `allotment_class` as ac
								LEFT JOIN (
										SELECT obj.allotment_class_id, SUM(first_amount) + sum(second_amount) + SUM(third_amount) + sum(fourth_amount) as amount
											FROM `fund_rc` as frc
											INNER JOIN `fund_rc_objects` as frc_obj ON frc_obj.fund_rc_id = frc.id AND frc_obj.`status` = 'ACTIVE'
											INNER JOIN allotment_received as ar ON ar.fund_rc_id = frc.id AND ar.`status` = 'ACTIVE'
											INNER JOIN allotment_received_details as ard ON ard.allotment_received_id = ar.id AND ard.object_id = frc_obj.object_id
											INNER JOIN object_of_expenditures as obj ON obj.id = ard.object_id
											INNER JOIN responsibility_center as rc on rc.id = frc.rc_id
											WHERE frc.year = ? AND frc.fund_id = ? $created_by_frc AND frc.status = 'ACTIVE'
											GROUP BY obj.allotment_class_id
								) as allotment_received ON allotment_received.allotment_class_id = ac.id
								LEFT JOIN (
									SELECT  SUM(od.amount) - SUM(IF(ISNULL(obn.norsa), 0, obn.norsa)) as total_obligation, ooe.allotment_class_id 

									FROM `fund_rc` as frc
									INNER JOIN `fund_rc_objects` as frc_obj ON frc_obj.fund_rc_id = frc.id AND frc_obj.`status` = 'ACTIVE'
									INNER JOIN allotment_received as ar ON ar.fund_rc_id = frc.id AND ar.`status` = 'ACTIVE'
									INNER JOIN allotment_received_details as ard ON ard.allotment_received_id = ar.id AND ard.object_id = frc_obj.object_id 
									INNER JOIN object_of_expenditures as ooe ON ooe.id = ard.object_id
									INNER JOIN obligation_details as od on od.fund_rc_id = frc.id and od.object_id = frc_obj.object_id  and od.prexc_id = ar.prexc_id
									INNER JOIN obligations as obl on obl.date BETWEEN '$year-01-01' AND '$year-12-31' and obl.id = od.obligation_id  $created_by_obl
									LEFT JOIN obligation_norsa as obn on obn.obligation_details_id = od.id AND obn.status = 'ACTIVE'
									WHERE obl.fund_id = '$fund_id'  AND frc.status = 'ACTIVE'
									GROUP BY  ooe.allotment_class_id
									
									) as total_obligations on total_obligations.allotment_class_id = ac.id
								LEFT JOIN (
									SELECT  SUM(IF(ISNULL(disb.total_amount), 0, disb.total_amount)) as total_disbursement , ooe.allotment_class_id

									FROM `fund_rc` as frc
									INNER JOIN `fund_rc_objects` as frc_obj ON frc_obj.fund_rc_id = frc.id AND frc_obj.`status` = 'ACTIVE'
									INNER JOIN allotment_received as ar ON ar.fund_rc_id = frc.id AND ar.`status` = 'ACTIVE'
									INNER JOIN allotment_received_details as ard ON ard.allotment_received_id = ar.id AND ard.object_id = frc_obj.object_id 
									INNER JOIN object_of_expenditures as ooe ON ooe.id = ard.object_id
									INNER JOIN obligation_details as od on od.fund_rc_id = frc.id and od.object_id = frc_obj.object_id  and od.prexc_id = ar.prexc_id
									INNER JOIN obligations as obl on obl.date BETWEEN '$year-01-01' AND '$year-12-31' and obl.id = od.obligation_id  $created_by_obl
									LEFT JOIN obligation_disbursement as disb on disb.obligation_details_id = od.id
									WHERE obl.fund_id = '$fund_id'  AND frc.status = 'ACTIVE'
									GROUP BY  ooe.allotment_class_id
								) as obligation_disbursement on obligation_disbursement.allotment_class_id = ac.id
								";
			return $this->db->query($query_string, array($year, $fund_id))->result_object(); 
		}

		public function get_end_user_report($fund_id, $year, $group_by = false, $obligation_id = false , $office_id = false, $payee_id = false, $fund_rc_id = false){
			$group_by_str = "o.id ORDER BY o.obligation_no ASC";
			if($group_by) {
				$group_by_str =  $group_by;
			}

			$obligation_id_str = "";
			if($obligation_id ) {
				$obligation_id_str = " AND o.id = $obligation_id ";
			}

			$office_id_str = "";
			if($office_id ) {
				$office_id_str = " AND o.office_id = $office_id ";
			}

			$payee_id_str = "";
			if($payee_id ) {
				$payee_id_str = " AND o.payee_id = $payee_id ";
			}

			$filter_by_rc = "";
			if($fund_rc_id != "all") {
				$filter_by_rc = " AND frc.id = $fund_rc_id ";
			}

			$query_string = "SELECT rc.code as rc_code, rc.description as  rc_description, o.id as obligation_id, o.obligation_no, o.date, o.payee_id, p.description as payee_description, 
									SUM(od.amount) - SUM(IF(ISNULL(obn.norsa), 0, obn.norsa)) as total_obligation,
									SUM(IF(ISNULL(disb.total_disbursement), 0, disb.total_disbursement)) as total_disbursement,
									o.office_id, of.name as office_name
								FROM obligations as o
								INNER JOIN payee as p on p.id = o.payee_id
								INNER JOIN obligation_details	as od on od.obligation_id = o.id
								LEFT JOIN obligation_norsa as obn on obn.obligation_details_id = od.id AND obn.status = 'ACTIVE'
								LEFT JOIN (
									SELECT SUM(IF(ISNULL(disb.total_amount), 0, disb.total_amount)) as total_disbursement, od.id as obligation_details_id
									FROM obligation_details as od
									LEFT JOIN obligation_disbursement as disb on disb.obligation_details_id = od.id
									GROUP BY  od.obligation_id
								) as disb on disb.obligation_details_id = od.id
								INNER JOIN office as of ON of.id = o.office_id			
								INNER JOIN fund_rc as frc ON frc.id = od.fund_rc_id	
								INNER JOIN responsibility_center as rc ON rc.id = frc.rc_id				
								WHERE o.date BETWEEN '$year-01-01' AND '$year-12-31' AND o.fund_id = ? $obligation_id_str $payee_id_str $office_id_str $filter_by_rc
								GROUP BY  $group_by_str ;
								";
			return $this->db->query($query_string, array($fund_id))->result_object(); 
		}


		public function get_allotment_list($year, $fund_id, $fund_rc_id, $prexc_id, $legal_basis_id){
			$query_string = "SELECT obj.id as object_id, obj.code as object_code, obj.description as object_description,
								a.id as allotment_id,
									IF(ISNULL(a.`first_amount`), 0, a.`first_amount`) as first_amount,
									IF(ISNULL(a.`second_amount`), 0, a.`second_amount`) as second_amount,
									IF(ISNULL(a.`third_amount`), 0, a.`third_amount`) as third_amount,
									IF(ISNULL(a.`fourth_amount`), 0, a.`fourth_amount`) as fourth_amount,
										ac.id as allotment_class_id,
										ac.name as allotment_class,
									IF(ISNULL(total_obligations.total_obligation), 0, total_obligations.total_obligation ) as total_obligation
									FROM fund_rc_objects as frc_obj
										LEFT JOIN (
											SELECT ard.*
											FROM allotment_received ar
											INNER JOIN allotment_received_details as ard ON ard.allotment_received_id = ar.id
											WHERE ar.prexc_id = ? AND ar.legal_basis_id = ? AND ar.fund_rc_id = ? AND ar.`status` = 'ACTIVE'
										) as a ON frc_obj.object_id = a.object_id
										LEFT JOIN object_of_expenditures as obj ON obj.id = frc_obj.object_id
										LEFT JOIN allotment_class as ac ON ac.id = obj.allotment_class_id
										LEFT JOIN (
													SELECT SUM(amount) - SUM(IF(ISNULL(obn.norsa), 0, obn.norsa)) as total_obligation, od.object_id
														FROM obligation_details as od
														INNER JOIN obligations as obl on obl.id = od.obligation_id
													WHERE obl.date BETWEEN '$year-01-01' AND '$year-12-31'
														AND obl.fund_id = $fund_id AND obl.legal_basis_id = $legal_basis_id
														AND od.fund_rc_id = $fund_rc_id AND od.prexc_id = $prexc_id  
														GROUP BY od.object_id
													) as total_obligations on total_obligations.object_id =  obj.id
													LEFT JOIN obligation_norsa as obn on obn.obligation_details_id = od.id AND obn.status = 'ACTIVE'
											WHERE frc_obj.fund_rc_id = ? AND  frc.status = 'ACTIVE' 
										ORDER BY object_code ASC;";
			return $this->db->query($query_string, array($prexc_id, $legal_basis_id, $fund_rc_id, $fund_rc_id))->result_object(); 
		}
	}
?>

