<?php
	class Funds_model extends CI_Model
	{
		public function __construct()
		{
			parent::__construct();
		}

		public function add_legal_basis($data){
				
				$this->db->insert('fund_legal_basis', $data); 
			
				
		}
		
		public function add_fund_rc($data){
			$this->db->trans_begin();
				
				$this->db->insert('fund_rc', $data["fund_rc"]); 
			
				if(count($data["fund_rc_objects"]) > 0){
					$fund_rc_id = $this->db->insert_id();
					$fund_rc_objects = array();
					foreach($data["fund_rc_objects"] as $object_id) {
						$fund_rc_objects[] = array( "object_id" => $object_id, "fund_rc_id" => $fund_rc_id) ;
					}
					
					$this->add_fund_rc_objects($fund_rc_objects); 
				}
			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
			} else {
				$this->db->trans_commit();
			}
		}

		public function delete_legal_basis($fund_legal_basis_id, $action){
			$this->db->where('id', $fund_legal_basis_id); 
			$this->db->update('fund_legal_basis', array('status' => $action)); 
		}
		
		public function delete_fund_rc($fund_rc_id, $action){
			$this->db->where('id', $fund_rc_id); 
			$this->db->update('fund_rc', array('status' => $action)); 
		}

		public function update_fund_rc($fund_rc_id, $data){
			$this->db->where('id', $fund_rc_id); 
			$this->db->update('fund_rc', $data); 
		}

		public function add_fund_rc_objects($data){
			$this->db->insert_batch('fund_rc_objects', $data); 
		}

		public function delete_fund_rc_objects($fund_rc_object_id, $action){
			$this->db->where('id', $fund_rc_object_id); 
			$this->db->update('fund_rc_objects', array('status' => $action)); 
		}

		public function get_fund_list(){
			$this->db->select('*');
			$this->db->from('fund');
			$this->db->order_by("name", "DESC"); 
			return $this->db->get()->result_object(); 
		}

		public function get_fund_rc_with_allotment_list( $fund_id, $year, $all=true, $user_id=0, $fund_rc_status = 'ACTIVE'){

			$crated_by_query = "";
			if(!$all) {
				$crated_by_query = " AND frc.created_by = $user_id ";
			}

			$status_query = "";
			if($fund_rc_status !== null) {
				$status_query = " AND frc.status = '$fund_rc_status' ";
			}

			$query_string = "SELECT  frc.id as fund_rc_id, rc.id , rc.code, rc.description, 
			  					IF (ISNULL(fund_rc_obligations.amount), 0, fund_rc_obligations.amount ) as total_allotment,
  								IF(ISNULL(total_obligations.total_obligation), 0, total_obligations.total_obligation ) as total_obligation, frc.status
								  , frc.created_by,  bui.name as created_name
								FROM fund_rc as frc
								LEFT JOIN (
									SELECT SUM(first_amount) + sum(second_amount) + SUM(third_amount) + sum(fourth_amount) as amount, frc.id
									FROM `fund_rc` as frc
									INNER JOIN `fund_rc_objects` as frc_obj ON frc_obj.fund_rc_id = frc.id AND frc_obj.`status` ='ACTIVE'
									INNER JOIN allotment_received as ar ON ar.fund_rc_id = frc.id AND ar.`status` = 'ACTIVE'
									INNER JOIN allotment_received_details as ard ON ard.allotment_received_id = ar.id AND ard.object_id = frc_obj.object_id
									WHERE sha1(frc.fund_id) = '$fund_id' AND frc.year = $year
									GROUP BY frc.id
								) as fund_rc_obligations ON fund_rc_obligations.id = frc.id
								LEFT JOIN (
									SELECT SUM(IF(ISNULL(obn.adjusted_amount), od.amount, obn.adjusted_amount)) as total_obligation, od.fund_rc_id 
										FROM obligation_details as od
											INNER JOIN obligations as obl on obl.id = od.obligation_id
											LEFT JOIN obligation_norsa as obn on obn.obligation_details_id = od.id AND obn.status = 'ACTIVE'
											WHERE obl.date BETWEEN '$year-01-01' AND '$year-12-31'
											AND sha1(obl.fund_id) = '$fund_id'
											GROUP BY od.fund_rc_id
								) as total_obligations on total_obligations.fund_rc_id = frc.id
								INNER JOIN responsibility_center as rc on rc.id = frc.rc_id
								INNER JOIN backend_user_info as bui on frc.created_by = bui.id
								WHERE sha1(frc.fund_id) = ? AND frc.year = ? $crated_by_query 
								$status_query
								
							ORDER BY rc.code ASC;";
			return 	$this->db->query($query_string, array( $fund_id, $year))->result_object(); 
		}

		public function get_report_fund_rc_with_allotment_list( $fund_id, $year, $fund_rc_id = "all"){

			$filter_by_rc = "";
			if($fund_rc_id != "all") {
				$filter_by_rc = " AND frc.id = $fund_rc_id ";
			}

			$query_string = "SELECT  frc.id as fund_rc_id, rc.id , rc.code, rc.description, 
			  					IF (ISNULL(fund_rc_obligations.amount), 0, fund_rc_obligations.amount ) as total_allotment,
  								IF(ISNULL(total_obligations.total_obligation), 0, total_obligations.total_obligation ) as total_obligation, frc.status
								FROM fund_rc as frc
								LEFT JOIN (
									SELECT SUM(first_amount) + sum(second_amount) + SUM(third_amount) + sum(fourth_amount) as amount, frc.id
									FROM `fund_rc` as frc
									INNER JOIN `fund_rc_objects` as frc_obj ON frc_obj.fund_rc_id = frc.id AND frc_obj.`status` ='ACTIVE'
									INNER JOIN allotment_received as ar ON ar.fund_rc_id = frc.id AND ar.`status` = 'ACTIVE'
									INNER JOIN allotment_received_details as ard ON ard.allotment_received_id = ar.id AND ard.object_id = frc_obj.object_id
									WHERE sha1(frc.fund_id) = '$fund_id' AND frc.year = $year
									GROUP BY frc.id
								) as fund_rc_obligations ON fund_rc_obligations.id = frc.id
								LEFT JOIN (
									SELECT SUM(IF(ISNULL(obn.adjusted_amount), od.amount, obn.adjusted_amount)) as total_obligation, od.fund_rc_id 
										FROM obligation_details as od
											INNER JOIN obligations as obl on obl.id = od.obligation_id
											LEFT JOIN obligation_norsa as obn on obn.obligation_details_id = od.id AND obn.status = 'ACTIVE'
											WHERE obl.date BETWEEN '$year-01-01' AND '$year-12-31'
											AND sha1(obl.fund_id) = '$fund_id'
											GROUP BY od.fund_rc_id
								) as total_obligations on total_obligations.fund_rc_id = frc.id
								INNER JOIN responsibility_center as rc on rc.id = frc.rc_id
								WHERE sha1(frc.fund_id) = ? AND frc.year = ? $filter_by_rc AND frc.status = 'ACTIVE'
							ORDER BY rc.code ASC;";
			return 	$this->db->query($query_string, array( $fund_id, $year))->result_object(); 
		}

		public function get_fund_rc_list( $fund_id, $year, $filter_active = false, $all=true, $user_id=0){
			$crated_by_query = "";
			if(!$all) {
				$crated_by_query = " AND created_by = $user_id ";
			}
			$filter_active_sql = $filter_active ? "AND frc.status = 'ACTIVE'" : "";
			$query_string = "SELECT  frc.id as fund_rc_id, rc.id , rc.code, rc.description, frc.status
								FROM fund_rc as frc
								INNER JOIN responsibility_center as rc on rc.id = frc.rc_id
								WHERE sha1(frc.fund_id) = ? AND frc.year = ? $filter_active_sql $crated_by_query
							ORDER BY rc.code ASC;";
			return 	$this->db->query($query_string, array( $fund_id, $year))->result_object(); 
		}

		public function get_fund_rc_object_list($fund_rc_id){

			$query_string = "SELECT frc_obj.id as fund_rc_object_id, obj.id as object_id,  obj.code, obj.description,obj.allotment_class_id , ac.name as allotment_class,
								frc_obj.`status` as `status`
								FROM fund_rc_objects as frc_obj
								INNER JOIN object_of_expenditures as obj on obj.id = frc_obj.object_id
								INNER JOIN allotment_class as ac on obj.allotment_class_id = ac.id
								WHERE frc_obj.fund_rc_id = ?
								ORDER BY obj.code ASC;";
			return 	$this->db->query($query_string, array( $fund_rc_id))->result_object(); 
		}


		public function get_new_fund_lb_list($fund_id, $year){

			$query_string = "
						SELECT lb.id, lb.name FROM legal_basis lb
								LEFT JOIN fund_legal_basis as flb ON flb.legal_basis_id = lb.id  AND `year` = ? AND sha1(flb.fund_id) = ?
								WHERE flb.legal_basis_id IS NULL ORDER BY lb.name ASC;;
			";

			return 	$this->db->query($query_string, array($year, $fund_id))->result_object(); 
		}

		public function get_new_fund_rc_list($fund_id, $year){

			$query_string = "
				SELECT rc.id, rc.code, rc.description FROM responsibility_center rc
					LEFT JOIN fund_rc as frc ON frc.rc_id = rc.id  AND year = ? AND sha1(frc.fund_id) = ?
					WHERE frc.rc_id IS NULL ORDER BY rc.code, rc.description ASC;
			";

			return 	$this->db->query($query_string, array($year, $fund_id))->result_object(); 
		}

		public function get_new_fund_rc_object_list($fund_rc_id){

			$query_string = "SELECT obj.id as object_id, obj.code, obj.description, obj.allotment_class_id, ac.name as allotment_class
								FROM object_of_expenditures obj
								LEFT JOIN fund_rc_objects as frc_obj ON frc_obj.object_id = obj.id AND frc_obj.fund_rc_id = ?
								INNER JOIN allotment_class as ac on obj.allotment_class_id = ac.id
								WHERE frc_obj.object_id IS NULL
								ORDER BY obj.code, obj.description ASC;";
			return 	$this->db->query($query_string, array( $fund_rc_id))->result_object(); 
		}


		public function migrate_fund_structure($from_year, $to_year, $user){

			$funds = $this->db->query("SELECT * FROM fund")->result_object(); 
			
			$this->db->trans_begin();
			
			foreach($funds as $fund){
				//legal basis
				$select_fund_legal_basis = "SELECT * FROM fund_legal_basis where fund_id = ? AND year = ?";
				$fund_legal_basis = $this->db->query($select_fund_legal_basis, array($fund->id, $from_year))->result_object(); 
				if(count($fund_legal_basis) > 0) {
					foreach($fund_legal_basis as $legal_basis) {
						$insert_fund_legal_basis = array(
										"fund_id" => $fund->id,
										"legal_basis_id" => $legal_basis->legal_basis_id,
										"year" => $to_year,
									);
						$this->db->insert('fund_legal_basis', $insert_fund_legal_basis);
					}
				}

				//rc and rc objects
				$fund_rc_and_objects = "SELECT frc.rc_id as rc_id,  frc.status as frc_status, 
											frco.object_id as object_id, frco.status as frco_status
											FROM fund_rc as frc
										INNER JOIN fund_rc_objects as frco on frco.fund_rc_id = frc.id
										WHERE frc.fund_id = ? AND frc.year = ? and frc.rc_id != 0
										ORDER BY frc.rc_id ASC";

				$rc_and_objects = $this->db->query($fund_rc_and_objects, array($fund->id, $from_year))->result_object(); 
				if(count($rc_and_objects) > 0) {
					$rc_id = 0;
					$fund_rc_id = 0;
					foreach($rc_and_objects as $rc_and_object) {
						if($rc_id != $rc_and_object->rc_id){
							$rc_id = $rc_and_object->rc_id;
							$insert_fund_rc = array(
											"fund_id" => $fund->id,
											"rc_id" => $rc_and_object->rc_id,
											"year" => $to_year,
											"status" => $rc_and_object->frc_status,
											"created_by" => $user,
										);
							$this->db->insert('fund_rc', $insert_fund_rc);

							$fund_rc_id = $this->db->insert_id();	
						}

						$insert_fund_rc_objects = array(
							"fund_rc_id" => $fund_rc_id,
							"object_id" => $rc_and_object->object_id,
							"status" => $rc_and_object->frco_status,
						);

						$this->db->insert('fund_rc_objects', $insert_fund_rc_objects);
					}
				}
			}			
		
			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
				return false;
			} else {
				$this->db->trans_commit();
				return true;
				
			}

			/*		
				/// DELETE structure for the year	  
			  DELETE frc, frco
			 	FROM fund_rc as frc
				INNER JOIN fund_rc_objects as frco on frco.fund_rc_id = frc.id
				WHERE frc.year = 2019;

				DELETE 
					FROM fund_legal_basis
				WHERE year = 2019;
			 */
		}
		
	}
?>

