<?php
	class Legal_basis_model extends CI_Model
	{
		public function __construct()
		{
			parent::__construct();
		}

		public function add_legal_basis($data){
			$this->db->insert('legal_basis', $data); 
		}
		public function edit_legal_basis($data){
			$this->db->where('id', $data["id"]); 
			$this->db->update('legal_basis', $data);
		}

		public function delete_legal_basis($id){
			$this->db->delete('legal_basis', array('id' => $id)); 
		}

		public function get_legal_basis_list(){
			$this->db->select('legal_basis.id, legal_basis.name, legal_basis.description');
			$this->db->from('legal_basis');
			$this->db->order_by("legal_basis.name", "ASC"); 
			return $this->db->get()->result_object(); 
		}

		public function get_fund_legal_basis( $fund_id, $year, $filter_active = false){
			$filter_active_sql = $filter_active ? "AND flb.status = 'ACTIVE'" : "";
			$query_string = "SELECT  lb.*, flb.id as fund_legal_basis_id , flb.status
								FROM fund_legal_basis as flb
								INNER JOIN legal_basis as lb on lb.id = flb.legal_basis_id
								WHERE flb.fund_id = ? AND year = ? $filter_active_sql
							ORDER BY lb.name desc;";
			return 	$this->db->query($query_string, array($fund_id, $year))->result_object(); 

		}
	}
?>