<?php
	class Object_of_expenditures_model extends CI_Model
	{
		public function __construct()
		{
			parent::__construct();
		}

		public function add_object($data){
			$this->db->insert('object_of_expenditures', $data); 
		}

		public function edit_object($data){
			$this->db->where('id', $data["id"]); 
			$this->db->update('object_of_expenditures', $data);
		}

		public function delete_object($id){
			$this->db->delete('object_of_expenditures', array('id' => $id)); 
		}

		public function get_object_list(){
			$this->db->select('object_of_expenditures.id, object_of_expenditures.code, object_of_expenditures.description, allotment_class.id as allotemt_id, allotment_class.name as allotment_class');
			$this->db->from('object_of_expenditures');
			$this->db->join('allotment_class', 'object_of_expenditures.allotment_class_id = allotment_class.id');
			$this->db->order_by("object_of_expenditures.code", "ASC"); 
			return $this->db->get()->result_object(); 
		}

		public function get_allotment_class_by_object($object_id){
			$this->db->select('allotment_class.id, allotment_class.name as name');
			$this->db->from('object_of_expenditures');
			$this->db->join('allotment_class', 'object_of_expenditures.allotment_class_id = allotment_class.id');
			$this->db->where("object_of_expenditures.id", $object_id); 
			$this->db->limit(1); 
			$result = $this->db->get()->result_object(); 
			return $result[0];
		}

		public function get_object_by_ids($ids){
			$this->db->select('object_of_expenditures.id, object_of_expenditures.code, object_of_expenditures.description, allotment_class.id as allotment_class_id, allotment_class.name as allotment_class');
			$this->db->from('object_of_expenditures');
			$this->db->join('allotment_class', 'object_of_expenditures.allotment_class_id = allotment_class.id');
			$this->db->where_in('object_of_expenditures.id', $ids);
			$this->db->order_by("object_of_expenditures.allotment_class_id, object_of_expenditures.code", "ASC"); 
			return $this->db->get()->result_object(); 
		}
		
		
	}
?>

