<?php
	class Obligations_model extends CI_Model
	{
		public function __construct()
		{
			parent::__construct();
		}

		public function add_obligation($data){
			$this->db->insert('obligations', $data["obligations"]); 
			$obligation_id = $this->db->insert_id();

			foreach($data["obligation_details"] as $key => $obligation_detail) {
				$data["obligation_details"][$key]["obligation_id"] = $obligation_id;
			}
			$this->db->insert_batch('obligation_details', $data["obligation_details"]); 
		}

		public function add_obligation_object($data){
			$this->db->insert('obligation_details', $data); 
		}

		public function save_new_disbursement($data){
			$this->db->insert('obligation_disbursement', $data);
		}

		public function edit_adjusted_obligation_amount($adjusted_amount, $obligation_details_id ){

			$this->db->trans_begin();
			$this->db->select('*');
			$this->db->from('obligation_details');
			$this->db->where('id', $obligation_details_id); 
			$obligation_details = $this->db->get()->result_object(); 

			if(count($obligation_details) > 0) {
				$this->db->where('obligation_details_id',  $obligation_details_id);
				$this->db->update('obligation_norsa', array("status"=>"UPDATED")); 

				$data = array( 
					"obligation_details_id" => $obligation_details_id,
					"adjusted_amount" => $adjusted_amount,
					"norsa" => ($obligation_details[0]->amount - $adjusted_amount)
				);
				$this->db->insert('obligation_norsa', $data); 
			}

			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
			} else {
				$this->db->trans_commit();
			}
			
		}

		public function edit_norsa_amount($norsa, $obligation_details_id ){

			$this->db->trans_begin();
			$this->db->select('*');
			$this->db->from('obligation_details');
			$this->db->where('id', $obligation_details_id); 
			$obligation_details = $this->db->get()->result_object(); 

			if(count($obligation_details) > 0) {
				$this->db->where('obligation_details_id',  $obligation_details_id);
				$this->db->update('obligation_norsa', array("status"=>"UPDATED")); 

				$data = array( 
					"obligation_details_id" => $obligation_details_id,
					"norsa" => $norsa,
					"adjusted_amount" => ($obligation_details[0]->amount - $norsa)
				);
				$this->db->insert('obligation_norsa', $data); 
			}

			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
			} else {
				$this->db->trans_commit();
			}
			
		}

		private function obligation_list_query_string($year, $fund_id, $legal_basis_id, $all = true, $user_id = 0, $search = "", $limit = 0, $offset = false ,  $count = false) {
			$crated_by_query = "";
			if(!$all) {
				$crated_by_query = " AND o.created_by = $user_id ";
			}

			if(!$count) {
				$column = " o.id as obligation_id,
				o.obligation_no, DATE_FORMAT(o.date, '%m/%d/%Y')  as `date` , o.payee_id, p.description as payee_description, o.office_id, of.name as office_name, 
				address, particulars, o.fund_id, f.name as fund_name, norsa.has_norsa , disb.has_disbursement, norsa.total_obligation, o.created_by as obligation_created_id, buf.name as obligation_created_name
				";

				
			} else {
				$column = " count(*) as num_rows";	
			}
				

			$query_string = "SELECT 
								$column 
								FROM `obligations` o
								LEFT JOIN payee as p ON p.id = o.payee_id
								LEFT JOIN office as of ON of.id = o.office_id
								INNER JOIN fund as f ON f.id = o.fund_id
								INNER JOIN backend_user_info as buf ON buf.id = o.created_by 
								LEFT JOIN (
									SELECT IF(ISNULL(SUM(obn.norsa)), 0, 1) as has_norsa , od.obligation_id,
									SUM(od.amount) - SUM(IF(ISNULL(obn.norsa), 0, obn.norsa)) as total_obligation
									FROM `obligation_details` as od
									LEFT JOIN `obligation_norsa` as obn ON obn.obligation_details_id = od.id
									WHERE (obn.status = 'ACTIVE' OR ISNULL(obn.status))
									group by od.obligation_id
								) as norsa on norsa.obligation_id = o.id

								LEFT JOIN (
											SELECT IF(ISNULL(sum(disb.total_amount)), 0, 1) as has_disbursement, od.obligation_id
											FROM `obligation_details` as od
											LEFT JOIN `obligation_disbursement` as disb ON disb.obligation_details_id = od.id
											group by od.obligation_id
															) as disb on disb.obligation_id = o.id
							WHERE o.date BETWEEN '$year-01-01' AND '$year-12-31' AND o.fund_id = ? AND o.legal_basis_id = $legal_basis_id $crated_by_query  ";

				if(trim($search) != ""){
					$query_string .= " AND ( o.obligation_no LIKE '%$search%' ";
					$query_string .= "  OR  DATE_FORMAT(o.date, '%m/%d/%Y') LIKE '%$search%' ";
					$query_string .= "  OR  p.description LIKE '%$search%' ";
					$query_string .= "  OR  of.name LIKE '%$search%' ";
					$query_string .= "  OR  norsa.total_obligation LIKE '%$search%' ";
					$query_string .= "  OR  buf.name LIKE '%$search%' ";
					$query_string .= "  ) ";
				}		

				$query_string .= " ORDER BY o.id DESC ";
				
				if($limit != 0){
					$query_string .= " LIMIT $limit ";
				}

				if($offset){
					$query_string .= " offset $offset ";
				}

				return $query_string;
		}

		public function get_obligation_list_count($year, $fund_id, $legal_basis_id, $all = true, $user_id = 0, $search = ""){
			$query_string = $this->obligation_list_query_string($year, $fund_id, $legal_basis_id, $all, $user_id, $search, 0, false, true );
		
			$query = $this->db->query($query_string,array($fund_id))->result_array();
			
			return  $query[0]["num_rows"];
		}

		public function get_obligation_list($year, $fund_id, $legal_basis_id, $all = true, $user_id = 0,  $search = "", $limit = 0, $offset = false){
			$query_string = $this->obligation_list_query_string($year, $fund_id, $legal_basis_id, $all, $user_id , $search, $limit, $offset);
			return $this->db->query($query_string,array($fund_id))->result_object(); 
		}

		public function get_obligation_details($obligation_id){
			$query_string = "SELECT DATE_FORMAT(o.date, '%m/%d/%Y') as `date`, od.id as id,
								od.object_id, ooe.code as object_code, ooe.description as object_description,
									IF(ISNULL(obn.adjusted_amount), od.amount, obn.adjusted_amount) as current_amount,
									od.amount as amount , IF(ISNULL(disb.total_amount_paid), 0, disb.total_amount_paid) as total_amount_paid, o.obligation_no,  
										IF(ISNULL(obn.norsa), 0, obn.norsa) as norsa, 
										IF(ISNULL(obn.adjusted_amount), 0, obn.adjusted_amount) as adjusted_amount,
										IF(ISNULL(obn.adjusted_amount),(od.amount - IF(ISNULL(disb.total_amount_paid), 0, disb.total_amount_paid) ),(IF(ISNULL(obn.adjusted_amount), 0, obn.adjusted_amount) - IF(ISNULL(disb.total_amount_paid), 0, disb.total_amount_paid) )) 
										as unpaid_obligation,
										IF(ISNULL(disb.has_disbursement) , 0, disb.has_disbursement) as has_disbursement,
										IF(ISNULL(obn.id) , 0, 1) as has_norsa,
										rc.code as rc_code, rc.description as  rc_description,
										prxc.code as prexc_code, prxc.description as prexc_description, prxc.id as prexc_id,
										od.fund_rc_id as fund_rc_id,
										od.created_by as created_id, buf.name as created_name
									FROM `obligation_details` as od
									INNER JOIN obligations as o on o.id = od.obligation_id
									LEFT JOIN (
										SELECT obligation_details_id, SUM(total_amount) as total_amount_paid, IF(ISNULL(total_amount) , 0, 1) as has_disbursement
										FROM `obligation_disbursement`
										GROUP BY  obligation_details_id
									) as disb on disb.obligation_details_id = od.id
									LEFT JOIN obligation_norsa as obn on obn.obligation_details_id = od.id AND obn.status = 'ACTIVE'
									INNER JOIN object_of_expenditures as ooe on ooe.id = od.object_id
									INNER JOIN prexc as prxc on prxc.id = od.prexc_id
									INNER JOIN fund_rc as frc on frc.id = od.fund_rc_id
									INNER JOIN responsibility_center as rc on rc.id = frc.rc_id
									INNER JOIN backend_user_info as buf ON buf.id = od.created_by
									WHERE od.obligation_id = ?;";
			return $this->db->query($query_string,array($obligation_id))->result_object(); 
			
		}

		public function get_reports_obligation_details($fund_id, $year, $fund_rc_id = "all"){
			$filter_by_rc = "";
			if($fund_rc_id != "all") {
				$filter_by_rc = " AND frc.id = $fund_rc_id ";
			}

			$query_string = "SELECT DISTINCT od.amount as original_amount, obn.norsa, obn.adjusted_amount,
								o.payee_id, p.description as payee_description, o.obligation_no, ac.name as allotment_class_name,DATE_FORMAT(o.date, '%m/%d/%Y') as `date`,
								od.object_id, ooe.code as object_code, ooe.description as object_description,
								rc.code as rc_code, rc.description as  rc_description,
								prxc.code as prexc_code, prxc.description as prexc_description, prxc.id as prexc_id,
								od.fund_rc_id as fund_rc_id
								FROM `fund_rc` as frc
								INNER JOIN fund_rc_objects as frco on frco.fund_rc_id = frc.id AND frc.status = 'ACTIVE'
								INNER JOIN `obligation_details` as od on od.fund_rc_id = frc.id AND od.object_id = frco.object_id
								LEFT JOIN obligation_norsa as obn on obn.obligation_details_id = od.id AND obn.status = 'ACTIVE'
								INNER JOIN `obligations` as o on o.id = od.obligation_id
								INNER JOIN responsibility_center as rc on rc.id = frc.rc_id
								INNER JOIN prexc as prxc on prxc.id = od.prexc_id
								INNER JOIN object_of_expenditures as ooe on ooe.id = od.object_id
								INNER JOIN allotment_class as ac on ac.id = ooe.allotment_class_id
								LEFT JOIN payee as p ON p.id = o.payee_id
								WHERE frc.status = 'ACTIVE' AND frc.fund_id = ? AND o.date BETWEEN '$year-01-01' AND '$year-12-31' $filter_by_rc
								ORDER BY o.obligation_no ASC";
			return $this->db->query($query_string,array($fund_id))->result_object(); 
		}

		public function get_obligation_data($obligation_id){
			$query_string = "SELECT * FROM `obligations` WHERE id = ?;";
			$result = $this->db->query($query_string,array($obligation_id))->result_object(); 
			if(count($result) > 0) {
				return $result[0];
			} else {
				return false;
			}
			
		}

		public function get_reports_disbursement($fund_id, $year, $fund_rc_id = "all"){
			$filter_by_rc = "";
			if($fund_rc_id != "all") {
				$filter_by_rc = " AND frc.id = $fund_rc_id ";
			}

			$query_string = "SELECT o.payee_id, p.description as payee_description, o.obligation_no, ac.name as allotment_class_name,DATE_FORMAT(o.date, '%m/%d/%Y') as `date`,
									od.object_id, ooe.code as object_code, ooe.description as object_description,
									rc.code as rc_code, rc.description as  rc_description,
									prxc.code as prexc_code, prxc.description as prexc_description, prxc.id as prexc_id,
									od.fund_rc_id as fund_rc_id,
									DATE_FORMAT(disb.date, '%m/%d/%Y') as `date`,
									disb.ada_number, disb.dv_number, disb.net_amount, disb.bir_amount, disb.total_amount,  disb.remarks,
									frc.fund_id as fund_id
									FROM `obligation_disbursement` as disb
									INNER JOIN `obligation_details` as od on od.id = disb.obligation_details_id
									INNER JOIN `fund_rc` as frc on frc.id = od.fund_rc_id AND frc.status = 'ACTIVE'
									INNER JOIN fund_rc_objects as frco on frco.fund_rc_id = frc.id AND frco.status = 'ACTIVE'
									INNER JOIN `obligations` as o on o.id = od.obligation_id
									INNER JOIN payee as p ON p.id = o.payee_id
									INNER JOIN prexc as prxc on prxc.id = od.prexc_id
									INNER JOIN object_of_expenditures as ooe on ooe.id = od.object_id
									INNER JOIN allotment_class as ac on ac.id = ooe.allotment_class_id
									INNER JOIN responsibility_center as rc on rc.id = frc.rc_id
								WHERE  frc.fund_id = ? AND o.date BETWEEN '$year-01-01' AND '$year-12-31' $filter_by_rc
									GROUP BY disb.id
									ORDER BY disb.date ASC;";
			return $this->db->query($query_string,array($fund_id))->result_object(); 
		}

		//ors = obligation_no
		public function get_obligation_by_ors($obligation_no){
			$query_string = "SELECT * FROM `obligations` WHERE obligation_no = ? ;";
			$result = $this->db->query($query_string,array($obligation_no))->result_object(); 

			if(count($result) > 0) {
				return $result[0];
			} else {
				return false;
			}
		}

		public function check_if_obligation_number_exist($obligation_no, $obligation_id, $year){
			//$query_string = "sSELECT * FROM `obligations` WHERE obligation_no like '%".$obligation_no."';";
			// $result = $this->db->query($query_string,array($obligation_no))->result_object(); 
			$this->db->like('obligation_no', $obligation_no);
			if($obligation_id) {
				$this->db->where('id !=', $obligation_id);
			}
			if($year) {
				$this->db->where('year(date)', $year);
			}
			$result = $this->db->get('obligations')->result_object();
			
			if(count($result) > 0) {
				return $result[0];
			} else {
				return false;
			}
		}
	
		public function get_obligation_disbursement($obligation_details_id){
			$query_string = "SELECT disb.id, DATE_FORMAT(disb.date, '%m/%d/%Y') as `date`, disb.ada_number, disb.dv_number, disb.net_amount, disb.bir_amount, 
									disb.total_amount, ooe.id as object_id, ooe.code as object_code, ooe.description as object_description, IF(ISNULL(disb.remarks) , '', disb.remarks ) as remarks
									FROM `obligation_disbursement` disb
									INNER JOIN `obligation_details` as od ON od.id = disb.obligation_details_id
									INNER JOIN object_of_expenditures as ooe on ooe.id = od.object_id
								WHERE disb.obligation_details_id = ?
								ORDER by disb.id ASC;";

			return $this->db->query($query_string, array($obligation_details_id))->result_object(); 
		}

		public function get_obligation_norsa($obligation_details_id){
			$query_string = "SELECT norsa.id, DATE_FORMAT(norsa.date, '%m/%d/%Y') as `date`, norsa.norsa, norsa.adjusted_amount, ooe.id as object_id, ooe.code as object_code, ooe.description as object_description 
									FROM `obligation_norsa` norsa
									INNER JOIN `obligation_details` as od ON od.id = norsa.obligation_details_id
									INNER JOIN object_of_expenditures as ooe on ooe.id = od.object_id
								WHERE norsa.obligation_details_id = ?
								ORDER by norsa.id ASC;";

			return $this->db->query($query_string, array($obligation_details_id))->result_object(); 
		}

		public function get_fund_obligations_numbers($year, $fund_id, $all=true, $user_id=0, $search_obligation_no=null){
			$crated_by_query = "";
			if(!$all) {
				$crated_by_query = " AND created_by = $user_id ";
			}

			$search_obligation_no_query = "";
			if($search_obligation_no != null){
				$search_obligation_no_query = " AND instr(obligation_no,  '".$search_obligation_no."')";
			}

			$query_string = "SELECT id, obligation_no FROM `obligations` where fund_id = ? AND date BETWEEN '$year-01-01' AND '$year-12-31'  $crated_by_query $search_obligation_no_query ;";		
			return $this->db->query($query_string, array($fund_id))->result_object(); 
		}

		public function delete_obligation_object($id){
			$this->db->delete('obligation_details', array('id' => $id)); 
		}

		public function delete_obligation($id){
			$this->db->delete('obligations', array('id' => $id)); 
		}

		public function delete_disbursement($id){
			$this->db->delete('obligation_disbursement', array('id' => $id)); 
		}

		public function edit_obligation_details($data){
			$this->db->where('id', $data["id"]); 
			$this->db->update('obligations', $data); 
		}
		
	}
?>

