<?php
	class Reports_model extends CI_Model
	{
		public function __construct()
		{
			parent::__construct();
		}

		public function far_one_report($fund_id, $year, $prexc_ids, $quarter = 1){

			//default first quarter
			// $quater_column = "SUM(ard.first_amount) as total_allotment";
			$quarter_string = "YEAR(obl.date) = $year AND MONTH(obl.date) in (1,2,3)";
			switch($quarter) {
				case 2: 
					$quarter_string = "YEAR(obl.date) = $year AND MONTH(obl.date) in (4,5,6)";
					break;
				case 3: 
					// $quater_column = "SUM(ard.third_amount) as total_allotment";
					$quarter_string = "YEAR(obl.date) = $year AND MONTH(obl.date) in (7,8,9)";
					break;
				case 4: 
					// $quater_column = "SUM(ard.fourth_amount) as total_allotment";
					$quarter_string = "YEAR(obl.date) = $year AND MONTH(obl.date) in (10,11,12)";
					break;
			}
			
			$query_string = "SELECT
								IF(ISNULL(total_obligations.total_obligation), 0, total_obligations.total_obligation)  as total_obligation, 
								IF(ISNULL(total_obligations.total_disbursement), 0, total_obligations.total_disbursement) as total_disbursement,
								ard.object_id, ooe.code as object_code, ooe.description as object_description,
								prxc.code as prexc_code, prxc.description as prexc_description, prxc.id as prexc_id, 
								SUM(
									ard.second_amount + ard.first_amount + ard.third_amount + ard.fourth_amount
								) as total_allotment
								FROM `allotment_received` as ar
									INNER JOIN fund_rc as frc on frc.id = ar.fund_rc_id AND frc.status = 'ACTIVE'
								INNER JOIN allotment_received_details as ard on ard.allotment_received_id = ar.id
								INNER JOIN fund_rc_objects as frco on frco.object_id = ard.object_id AND frc.id = frco.fund_rc_id AND frco.status = 'ACTIVE'
								LEFT JOIN (
										SELECT od.prexc_id ,  SUM(amount) - SUM(IF(ISNULL(obn.norsa), 0, obn.norsa)) as total_obligation, od.object_id ,  SUM(disb.total_amount) as total_disbursement
											FROM obligation_details as od
											INNER JOIN obligations as obl on obl.id = od.obligation_id
											LEFT JOIN `obligation_disbursement` as disb on disb.obligation_details_id = od.id
											LEFT JOIN obligation_norsa as obn on obn.obligation_details_id = od.id AND obn.status = 'ACTIVE'
											WHERE $quarter_string AND od.prexc_id in ?
											GROUP BY od.object_id
											) as total_obligations on total_obligations.object_id = ard.object_id AND total_obligations.prexc_id = ar.prexc_id
								INNER JOIN prexc as prxc on prxc.id = ar.prexc_id
								INNER JOIN object_of_expenditures as ooe on ooe.id = ard.object_id
								WHERE ar.status = 'ACTIVE' AND frc.fund_id = ? AND frc.year = ? AND ar.prexc_id in ?
								Group by ard.object_id ORDER BY ar.prexc_id ASC, ard.object_id ASC";

			return $this->db->query($query_string,array($prexc_ids, $fund_id, $year, $prexc_ids))->result_object(); 
		}

		

		public function get_allotment_obligation_disbursement( $fund_id, $year, $fund_rc_id = "all", $quarter = "all"){
			$filter_by_rc = "";
			if($fund_rc_id != "all") {
				$filter_by_rc = " AND frc.id = $fund_rc_id ";
			}

			$filter_by_quarter_col1 = "";
			$filter_by_quarter_col2 = "";
			if($quarter != "all") {
				
				$filter_by_quarter_col1 = " allotment.first_amount, ";
				$filter_by_quarter_col2 = " IF(ISNULL(ard.`first_amount`), 0, ard.`first_amount`) as first_amount ";
					switch($quarter) {
						case 2: 
							$filter_by_quarter_col1 = " allotment.second_amount, ";
							$filter_by_quarter_col2 = " IF(ISNULL(ard.`second_amount`), 0, ard.`second_amount`) as second_amount ";
							break;
						case 3: 
							$filter_by_quarter_col1 = " allotment.third_amount, ";
							$filter_by_quarter_col2 = " IF(ISNULL(ard.`third_amount`), 0, ard.`third_amount`) as third_amount ";
							break;
						case 4: 
							$filter_by_quarter_col2 = " IF(ISNULL(ard.`fourth_amount`), 0, ard.`fourth_amount`) as fourth_amount  ";
							$filter_by_quarter_col1 = " allotment.third_amount, ";
							$filter_by_quarter_col2 = " IF(ISNULL(ard.`fourth_amount`), 0, ard.`fourth_amount`) as fourth_amount  ";
							break;
					}
			} else {
				$quarter_string = "obl.date BETWEEN '$year-01-01' AND '$year-12-31'";
				$filter_by_quarter_col1 = " allotment.first_amount, allotment.second_amount, allotment.third_amount, allotment.fourth_amount, ";
				$filter_by_quarter_col2 = " IF(ISNULL(ard.`first_amount`), 0, ard.`first_amount`) as first_amount, 
											IF(ISNULL(ard.`second_amount`), 0, ard.`second_amount`) as second_amount,
											IF(ISNULL(ard.`third_amount`), 0, ard.`third_amount`) as third_amount, 
											IF(ISNULL(ard.`fourth_amount`), 0, ard.`fourth_amount`) as fourth_amount ";
			}

			$query_string = "SELECT frc.id as fund_rc_id,  rc.id as rc_id, rc.code as rc_code, rc.description as rc_description, allotment.legal_basis_id, 
								prxc.code as prexc_code, prxc.description as prexc_description, prxc.id as prexc_id,
								obj.id as object_id, obj.code as object_code, obj.description as object_description,
											$filter_by_quarter_col1
											frc.status
											FROM fund_rc as frc
												LEFT JOIN (
													SELECT frc.id, ar.prexc_id, frc_obj.object_id, ar.legal_basis_id as legal_basis_id,
															$filter_by_quarter_col2
															FROM `fund_rc` as frc
															INNER JOIN `fund_rc_objects` as frc_obj ON frc_obj.fund_rc_id = frc.id AND frc_obj.`status` ='ACTIVE'
															INNER JOIN allotment_received as ar ON ar.fund_rc_id = frc.id AND ar.`status` = 'ACTIVE'
															INNER JOIN allotment_received_details as ard ON ard.allotment_received_id = ar.id AND ard.object_id = frc_obj.object_id
															WHERE frc.fund_id = $fund_id AND frc.year = $year AND frc.status = 'ACTIVE'
														) as allotment ON allotment.id = frc.id
												INNER JOIN responsibility_center as rc on rc.id = frc.rc_id
												INNER JOIN prexc as prxc on prxc.id = allotment.prexc_id
												INNER JOIN object_of_expenditures as obj ON obj.id = allotment.object_id
												INNER JOIN allotment_class as ac ON ac.id = obj.allotment_class_id
											WHERE frc.fund_id = $fund_id AND frc.year = $year $filter_by_rc  AND frc.status = 'ACTIVE'
											ORDER BY rc.code, rc.description, prxc.code, prxc.description, obj.code, obj.description  ASC;";
			return $this->db->query($query_string, array($year, $fund_id))->result_object(); 
		}

		public function get_total_obligations($fund_id, $fund_rc_id,  $legal_basis_id, $year, $prexc_id, $object_id, $quarter = 1){
		
			switch($quarter) {
				case 1: 
					$quarter_string = "YEAR(obl.date) = $year AND MONTH(obl.date) in (1,2,3)";
					break;
				case 2: 
					$quarter_string = "YEAR(obl.date) = $year AND MONTH(obl.date) in (4,5,6)";
					break;
				case 3: 
					// $quater_column = "SUM(ard.third_amount) as total_allotment";
					$quarter_string = "YEAR(obl.date) = $year AND MONTH(obl.date) in (7,8,9)";
					break;
				case 4: 
					// $quater_column = "SUM(ard.fourth_amount) as total_allotment";
					$quarter_string = "YEAR(obl.date) = $year AND MONTH(obl.date) in (10,11,12)";
					break;
				default:
					$quarter_string = "obl.date BETWEEN '$year-01-01' AND '$year-12-31'";
				
			}
			

					$query_string = "SELECT SUM(amount) - SUM(IF(ISNULL(obn.norsa), 0, obn.norsa)) as total_obligation, 
														IF(ISNULL(disb.net_amount),0, disb.net_amount) as net_amount, 
														IF(ISNULL(disb.bir_amount),0, disb.bir_amount) as bir_amount, 
														IF(ISNULL(disb.total_amount),0, disb.total_amount)  as total_amount
														FROM obligation_details as od
														INNER JOIN obligations as obl on obl.id = od.obligation_id
														LEFT JOIN obligation_norsa as obn on obn.obligation_details_id = od.id AND obn.status = 'ACTIVE'
														-- LEFT JOIN obligation_disbursement as disb on disb.obligation_details_id = od.id
														LEFT JOIN ( 
														 SELECT id, obligation_details_id, sum(net_amount) as net_amount, sum(bir_amount) as bir_amount, sum(total_amount) as total_amount 
														 FROM `obligation_disbursement` 
														  WHERE `date` BETWEEN '$year-01-01' AND '$year-12-31' 
														 group by obligation_details_id 
														) as disb on disb.obligation_details_id = od.id 
													WHERE $quarter_string
														AND obl.fund_id = $fund_id AND obl.legal_basis_id = $legal_basis_id
														AND od.fund_rc_id = $fund_rc_id AND od.prexc_id = $prexc_id  
														AND od.object_id = $object_id
														GROUP BY od.object_id
												";

			return $this->db->query($query_string)->result_object(); 
		}

		// 
	}
?>

