<?php
	class Superadmin_model extends CI_Model
	{
		public function __construct()
		{
			parent::__construct();
		}

		public function get_allotment_list($fund_id, $year){
			$query_string = "SELECT ar.id, ar.legal_basis_id, lb.name as legal_basis_name, ar.prexc_id, 
								prc.code as prexc_code,  prc.description as prexc_description,
								frc.rc_id as rc_id, rc.code as rc_code, rc.description as rc_description, 
								ar.date_created
									FROM `allotment_received` ar
								LEFT JOIN prexc as prc  on prc.id = ar.prexc_id
								LEFt JOIN legal_basis as lb on ar.legal_basis_id = lb.id
								INNER JOIN fund_rc as frc on ar.fund_rc_id = frc.id
								LEFt JOIN responsibility_center as rc on frc.rc_id = rc.id
								WHERE ar.status = 'ACTIVE' AND frc.fund_id = ? AND frc.year = ?
								ORDER by date_created";
			return $this->db->query($query_string, array($fund_id, $year))->result_object(); 
		}
		
		public function delete_allotment($id, $fund_id){
			$this->db->trans_begin();
				$allotment = "SELECT * FROM `allotment_received` where id = ?;";
				$allotment_list = $this->db->query($allotment, array($id))->result_object(); 

				if(count($allotment_list) > 0){
					$allotment_list = $allotment_list[0];
					$query_string = "DELETE od FROM `obligations` o
									LEFT JOIN obligation_details as od on od.obligation_id = o.id
									WHERE o.legal_basis_id = ? AND od.prexc_id = ? AND o.fund_id = ? and od.fund_rc_id = ?;";
					$this->db->query($query_string, array($allotment_list->legal_basis_id, $allotment_list->prexc_id, $fund_id, $allotment_list->fund_rc_id)); 
					$this->db->delete('allotment_received', array('id' => $id)); 
				}
			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
			} else {
				$this->db->trans_commit();
			}
		}

	}
?>

