<!-- Content Wrapper. Contains page content -->

<div class="content-wrapper">
<!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
        Allotment
        <small></small>
        </h1>
        <ol class="breadcrumb">
        <li><a href="#"> Home</a></li>
        <li><a href="#">Tables</a></li>
        <li class="active">Data tables</li>
        </ol>
    </section>

    <section class="content">
        <div class="row">
            <div class="col-xs-12">
                <div class="box box-primary">
                    <div class="box-header">
                        <h3 class="box-title">Add New</h3>
                    </div>
                    <div class="box-body">
                        <form method="POST" id="form_new_data" action="<?php echo base_url(); ?>allotment/save_new">
                            <div class="row"> 
                                <div class="col-xs-12">
                                    <div class="row">
                                        <div class="col-xs-12 col-md-2">
                                            <div class="form-group">
                                                <label>Year</label>
                                                <select class="form-control" name="year">
                                                    <!-- <?php //for($year=date("Y"); $year >= (date("Y") - 2); $year--): ?>
                                                    <?php //endfor; ?> -->
                                                    <option value="2018">2018</option>

                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row"> 
                                <div class="col-xs-12">
                                    <div class="form-group">
                                        <label>Fund</label>
                                        <select class="form-control select_two" id="fund_id" name="fund_id" style="width: 100%;" >
                                            <?php foreach($fund_list as $fl): ?>
                                                <option value="<?=$fl->id?>"><?=$fl->name?></option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="row"> 
                                <div class="col-xs-12">
                                    <div class="form-group">
                                    <label>Legal Basis</label>
                                        <select class="form-control select_two" id="legal_basis_id" name="legal_basis_id"  style="width: 100%;">
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="row"> 
                                <div class="col-xs-12">
                                    <div class="form-group">
                                        <label>P.P.A/PREXC</label>
                                        <select class="form-control select_two" name="prexc_id" style="width: 100%">
                                            <?php if(count($prexc) > 0): ?>
                                                <?php foreach($prexc as $ppa): ?>
                                                    <option value="<?=$ppa->id?>"><?=$ppa->code ." - " . $ppa->description ?></option>
                                                <?php endforeach; ?>
                                            <?php endif;?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="row"> 
                                <div class="col-xs-12">
                                    <div class="form-group">
                                    <label>Responsibility Center</label>
                                        <select class="form-control select_two" name="rc_id"  id="rc_id" style="width: 100%">
                                            <?php if(count($rc) > 0): ?>
                                                <?php foreach($rc as $res_center): ?>
                                                    <option value="<?=$res_center->id?>"><?=$res_center->code . " - " .  $res_center->description ?></option>
                                                <?php endforeach; ?>
                                            <?php endif;?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <br/>
                            <div class="row"> 
                                <div class="col-xs-12">
                                    <label>Details</label>
                                    <div class="pull-right">
                                    </div>
                                    <table id="details_table" class="table table-bordered">
                                        <tr>
                                            <th>Object of Expenditures</th>
                                            <th style="width:100px;">1st Qtr</th>
                                            <th style="width:100px;">2nd Qtr</th>
                                            <th style="width:100px;">3rd Qtr</th>
                                            <th style="width:100px;">4rth Qtr</th>
                                            <!-- <th>Action</th> -->
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="box-footer">
                        <div class="pull-right">
                        <button type="button" id="submit_new_allotment_btn" class="btn btn-primary">Submit</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<script type="text/javascript">
    $(document).ready(function() {

        
        $("#submit_new_allotment_btn").click(function(e) {
            $("#form_new_data").submit();
        });

        $("#fund_id").change(function(e) {
            get_fund_legal_basis();
        });

        $("#rc_id").change(function(e) {
            get_rc_objects_json();
        });
        get_fund_legal_basis();
        get_rc_objects_json();


        $("#add_details_btn").click(function() {
            $("#add_error_message").hide();
            var total_new_budget_amount = 0;
            $("input.add_budget_amount").each(function(){
                if (/^\d+$/.test($(this).val())) {
                    total_new_budget_amount +=  parseInt($(this).val()); 
                } else {
                    $(this).val(0);
                }
            });
            if(total_new_budget_amount > 0) {
                $.post('<?=base_url();?>allotment/get_available_allotment_class_budget',{ object_id: $("#object_of_expenditures").val() },
                    function(e){
                        if(e.available_amount >= total_new_budget_amount) {
                           // $("form#add_alottment_class_budget").submit(); 
                            var new_details = "<tr>";
                            new_details += "<td>" + $("#ppa").text() + "</td>";
                            new_details += "<td>" + $("#rc").text() + "</td>";
                            new_details += "<td>" + $("#object_of_expenditures").text() + "</td>";
                            new_details += "<td><input class='add_budget_amount' type='hidden' value='"+ $("#1st").val() +"'/>" + $("#1st").val() + "</td>";
                            new_details += "<td><input class='add_budget_amount' type='hidden' value='"+ $("#2nd").val() +"'/>" + $("#2nd").val() + "</td>";
                            new_details += "<td><input class='add_budget_amount' type='hidden' value='"+ $("#3rd").val() +"'/>" + $("#3rd").val() + "</td>";
                            new_details += "<td><input class='add_budget_amount' type='hidden' value='"+ $("#4rth").val() +"'/>" + $("#4rth").val() + "</td>";

                           // new_details += "<td align='center'><button type='button' class='btn btn-xs btn-danger' onclick='remove_details(this);'>x</button></td>";
                            new_details += "<tr>";

                            $("#details_table").append(new_details);
                            $("#add_details_modal").modal("hide");
                        } else {
                            $("#add_error_message").show();
                            $("#add_error_message").html("<p>Insufficient <strong><a href='<?=base_url()?>/allotment/allotment_class_budget' target='_blank'>"+ e.allotment_class.name +"</a></strong> funds, Please check.</p>");
                        }
                    }
                );
            } else {
                $("#add_error_message").show();
                $("#add_error_message").html("<p>Total budget amount must greater than zero.</p>");
            }
        }); 

        $("#show_add_details_modal").click(function() {
            $("#1st").val(""); 
            $("#2nd").val(""); 
            $("#3rd").val(""); 
            $("#4rth").val(""); 
            $("#add_details_modal").modal("show");
        });
    });

    function remove_details(btn) {
        $(btn).closest("tr").remove();
    }

    function get_fund_legal_basis() {
        $.get("<?=base_url();?>legal_basis/get_fund_legal_basis?fund_id=" + $("#fund_id").val(), 
            function(e) {
                var lb_options = "";
                $.each(e.fund_legal_basis, function (i,flb) {
                    lb_options += "<option value='" + flb.id + "'>" + flb.name + "</option>";
                });
                $("#legal_basis_id").html(lb_options);
            }
        );
    }

    function get_rc_objects_json() {
        $.get("<?=base_url();?>object_of_expenditures/get_rc_objects_json?rc_id=" + $("#rc_id").val(), 
            function(e) {
                $("#details_table").find("tr:gt(0)").remove();
                $.each(e.rc_objects, function (i,obj) {
                    var new_details = "<tr>";
                    new_details += "<td><input name='obj_id[]' type='hidden' value='" + obj.object_id + "' />" + obj.code + " - " + obj.allotment_class + " - " + obj.description +"</td>";
                    new_details += "<td><input class='form-control input-sm add_budget_amount' name='1st_amount[]' type='number' value='0'/></td>";
                    new_details += "<td><input class='form-control input-sm add_budget_amount' name='2nd_amount[]' type='number' value='0'/></td>";
                    new_details += "<td><input class='form-control input-sm add_budget_amount' name='3rd_amount[]' type='number' value='0'/></td>";
                    new_details += "<td><input class='form-control input-sm add_budget_amount' name='4rth_amount[]' type='number' value='0'/></td>";

                    // new_details += "<td align='center'><button type='button' class='btn btn-xs btn-danger' onclick='remove_details(this);'>x</button></td>";
                    new_details += "<tr>";
                    $("#details_table").append(new_details);
                });
                   
            }
        );
    }

    // <tr>
    //     <td><input class="form-control input-sm add_budget_amount" name="obj_id[]" type="hidden" value="1" />50201010-00 - Maintenance and Other Operating Expense - Travelling Expenses - Local</td>
    //     <td><input class="form-control input-sm add_budget_amount" name="1st_amount[]" type="number" value="1" /></td>
    //     <td><input class="form-control input-sm add_budget_amount" name="2nd_amount[]" type="number" value="1" /></td>
    //     <td><input class="form-control input-sm add_budget_amount" name="3rd_amount[]" type="number" value="1" /></td>
    //     <td><input class="form-control input-sm add_budget_amount" name="4rth_amount[]" type="number" value="1" /></td>
    //     <td align="center"><button type="button" class="btn btn-xs btn-danger" onclick="remove_details(this);">x</button></td>
    // </tr>
    
   
</script>