<div class="content-wrapper">
<!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            Ogmentation
        <small></small>
        </h1>
        <ol class="breadcrumb">
        <li><a href="#"> Home</a></li>
        <li><a href="#">Tables</a></li>
        <li class="active">Data tables</li>
        </ol>
    </section>

    <section class="content">
        <p>
            <a class="btn btn-primary" data-toggle="collapse" href="#collapseExample" role="button" aria-expanded="false" aria-controls="collapseExample">
                RC Filter
            </a>
        </p>
    <div class="collapse" id="collapseExample">
        <div class="row">
            <div class="col-xs-12 col-md-12">
                <div class="row">
                    <div class="col-xs-12 col-md-3">
                        <div class="form-group">
                            <label>Year</label>
                            <select class="form-control" id="select_year" name="select_year">
                                <?php for($dyear=(date("Y") - 1); $dyear <= (date("Y") + 2); $dyear++): ?>
                                    <option <?= $year == $dyear ? 'selected' : '' ?> value="<?=$dyear?>" ><?=$dyear?></option>
                                <?php  endfor; ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-xs-6">
                        <div class="form-group">
                            <label>Funds</label>
                            <select class="form-control select_two" id="select_fund_id" name="select_fund_id" onchange="get_fund_legal_basis()" style="width: 100%;">
                                <?php foreach($fund_list as $fl): ?>
                                    <option <?= $fund_id == sha1($fl->id) ? 'selected' : '' ?> value="<?= sha1($fl->id)?>"><?=$fl->name?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-xs-12 col-md-6">
                        <div class="row">
                            <div class="col-xs-12">
                                <div class="form-group">
                                    <h4 class="text-light-blue">From:</h4>
                                    <label>Legal Basis</label>
                                    <select class="form-control select_two" id="select_legal_basis_id_from" name="select_legal_basis_id_from" style="width: 100%;">
                                        <?php foreach($fund_legal_basis as $flb): ?>
                                            <option <?= $legal_basis_id_from == $flb->id ? 'selected' : '' ?> value="<?=$flb->id?>"><?=$flb->name?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-xs-12">
                                <div class="form-group">
                                    <label>Prexc</label>
                                    <select class="form-control select_two" id="select_prexc_id_from" name="select_prexc_id_from" style="width: 100%;">
                                        <?php foreach($prexc as $prx): ?>
                                            <option <?= $prexc_id_from == $prx->id? 'selected' : '' ?> value="<?=$prx->id?>"><?=$prx->code . " - " .  $prx->description ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>
                            <? $fund_rc_id = ""; ?>
                            <div class="col-xs-12">
                                <div class="form-group">
                                    <label>Responsibility Center</label>
                                    <select class="form-control select_two" id="select_fund_rc_id_from" name="select_fund_rc_id_from" style="width: 100%;">
                                        <?php foreach($rc as $res_center): ?>
                                            <option <?= $fund_rc_id_from == $res_center->fund_rc_id? 'selected' : '' ?> value="<?=$res_center->fund_rc_id?>"  <?= $fund_rc_id_to == $res_center->fund_rc_id? 'disabled' : '' ?>><?=$res_center->code . " - " .  $res_center->description ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div> 
                    <div class="col-xs-12 col-md-6">
                        <div class="row">
                            <div class="col-xs-12">
                                <div class="form-group">
                                    <h4 class="text-light-blue">To:</h4>
                                    <label>Legal Basis</label>
                                    <select class="form-control select_two" id="select_legal_basis_id_to" name="select_legal_basis_id_to" style="width: 100%;">
                                        <?php foreach($fund_legal_basis as $flb): ?>
                                            <option <?= $legal_basis_id_to == $flb->id ? 'selected' : '' ?> value="<?=$flb->id?>"><?=$flb->name?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-xs-12">
                                <div class="form-group">
                                    <label>Prexc</label>
                                    <select class="form-control select_two" id="select_prexc_id_to" name="select_prexc_id_to" style="width: 100%;">
                                        <?php foreach($prexc as $prx): ?>
                                            <option <?= $prexc_id_to == $prx->id? 'selected' : '' ?> value="<?=$prx->id?>"><?=$prx->code . " - " .  $prx->description ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-xs-12">
                                <div class="form-group">
                                    <label>Responsibility Center</label>
                                    <select class="form-control select_two" id="select_fund_rc_id_to" name="select_fund_rc_id_to" style="width: 100%;">
                                        <?php foreach($rc as $res_center): ?>
                                            <option <?= $fund_rc_id_to == $res_center->fund_rc_id? 'selected' : '' ?> value="<?=$res_center->fund_rc_id?>" <?= $fund_rc_id_from == $res_center->fund_rc_id? 'disabled' : '' ?>><?=$res_center->code . " - " .  $res_center->description ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div> 
                </div>
                <div class="row">
                    <div class="col-xs-12 col-md-1 pull-right">
                        <div style="padding-top:24px;">
                            <input type="button" class="btn btn-primary" style="width: 100%;" onclick="show_filtered_list()" value="Show" />
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <br/>
        <div id="div_message">
            <div class="callout callout-danger " id="edit_error_message" <?=$error_message ? '' : 'style="display:none;"' ?> >
                <?=$error_message ? $error_message : '' ?>
            </div>
        </div>
        <div class="row">
        <div class="col-md-12">
          <!-- Custom Tabs -->
          <div class="nav-tabs-custom">
            <ul class="nav nav-tabs">
                <li class="active"><a href="#tab_1" data-toggle="tab" aria-expanded="true">From</a></li>
                <li class=""><a href="#tab_2" data-toggle="tab" aria-expanded="false">To</a></li>
                <li class="pull-right"><a onclick="alert('Page is under Construction');"><i class="fa fa-save"></i> Save</a></li>
            </ul>
            <div class="tab-content">
                <div class="tab-pane active data_list" id="tab_1">
                    <?php if($show_table) :?>
                        <?php $allotment_class = ""; ?>
                            <table class="table table-bordered allotement-table">
                            <?php foreach($allotment_list_from_by_class as $allotment_class => $ac): ?>
                                <tr><td colspan="8" style="border: 1px solid #ffffff00;"><h4><?=$allotment_class?></h4></td></tr>
                                <tr>
                                    <th style="width: 230px;vertical-align:middle">Object</th>
                                    <th class="align-middle-center">1st QTR</th>
                                    <th class="align-middle-center">2nd QTR</th>
                                    <th class="align-middle-center">3rd QTR</th>
                                    <th class="align-middle-center">4rth QTR</th>
                                    <th style="width:125px;" class="align-middle-center">Allotment Amount</th>
                                    <th style="width:125px;" class="align-middle-center">Obligated Amount</th>
                                    <th style="width:125px;" class="align-middle-center">Unobligated Allotment</th>
                                </tr>
                                <?php foreach( $ac["list"] as $al): ?>
                                    <tr>
                                        <td><?=$al->object_code .' - '. $al->object_description?></td>
                                        <td align="center" class="align-middle-center">
                                            <span class="span_amount"><?=money_format($al->first_amount)?></span>
                                            <input type="number" name="first_amounts[<?=$al->object_id?>]" value="<?=$al->first_amount?>" style="display: none;" onchange="update_edit_total_amount(this)" 
                                                class="add_budget_amount form-control input-sm <?=in_array($al->allotment_class, $error_allotment_class ) ? 'input-has-error' : ''?>" />
                                        </td>
                                        <td align="center" class="align-middle-center">
                                            <span class="span_amount"><?=money_format($al->second_amount)?></span>
                                            <input type="number" name="second_amounts[<?=$al->object_id?>]" value="<?=$al->second_amount?>" style="display: none;" onchange="update_edit_total_amount(this)" class="add_budget_amount form-control input-sm <?=in_array($al->allotment_class, $error_allotment_class ) ? 'input-has-error' : ''?>" />
                                        </td>
                                        <td align="center" class="align-middle-center">
                                            <span class="span_amount"><?=money_format($al->third_amount)?></span>
                                            <input type="number" name="third_amounts[<?=$al->object_id?>]" value="<?=$al->third_amount?>" style="display: none;" onchange="update_edit_total_amount(this)" class="add_budget_amount form-control input-sm <?=in_array($al->allotment_class, $error_allotment_class ) ? 'input-has-error' : ''?>" />
                                        </td>
                                        <td align="center" style=" text-align:center; vertical-align: middle">
                                            <span class="span_amount"><?=money_format($al->fourth_amount)?></span>
                                            <input type="number" name="fourth_amounts[<?=$al->object_id?>]" value="<?=$al->fourth_amount?>" style="display: none;" onchange="update_edit_total_amount(this)" class="add_budget_amount form-control input-sm <?=in_array($al->allotment_class, $error_allotment_class ) ? 'input-has-error' : ''?>" />
                                        </td>
                                        <td align="center" class="align-middle-center">
                                            <span class="total_row_amount"><?=money_format($al->total_allotment)?></span>
                                            <span class="edit_total_row_amount" style="display: none;"><?=money_format($al->total_allotment)?></span>
                                        </td>
                                        <td class="align-middle-center ">
                                            <span class="total_row_obligations"><?=money_format($al->total_obligation)?></span>
                                            <span class="edit_total_row_obligations" style="display: none;"><?=money_format($al->total_obligation)?></span>
                                        </td>
                                        <td class="align-middle-center">
                                            <span class="total_row_balance"><?=money_format($al->total_allotment - $al->total_obligation)?></span>
                                            <span class="edit_total_row_balance" style="display: none;"><?=money_format($al->total_allotment - $al->total_obligation)?></span>
                                        </td>
                                    </tr>
                                        
                                <?php endforeach; ?>
                                    <tr>
                                        <td colspan="5" style="text-align:right" ><strong>Sub-total<strong></td>
                                        <td style="text-align:center">
                                            <strong>
                                                <span class="total_amount"><?=money_format($ac["grand_total_allotment"])?></span>
                                                <span class="edit_total_amount" style="display: none;"><?=money_format($ac["grand_total_allotment"])?></span>
                                            </strong>
                                        </td>
                                        <td style="text-align:center">
                                            <strong>
                                                <span class="total_obligations"><?=money_format($ac["grand_total_obligation"])?></span>
                                                <span class="edit_obligations" style="display: none;"><?=money_format($ac["grand_total_allotment"])?></span>
                                            </strong>
                                        </td>
                                        <td style="text-align:center">
                                            <strong>
                                                <span class="total_balance"><?=money_format($ac["grand_total_allotment"] - $ac["grand_total_obligation"]); ?></span>
                                                <span class="edit_total_balance" style="display: none;"><?=money_format($ac["grand_total_allotment"] - $ac["grand_total_obligation"]); ?></span>
                                            </strong>
                                        </td>
                                    </tr>
                            <?php endforeach; ?>
                            
                            <tr>
                                <td colspan="8" style="border-right-color: #ffffff00; border-left-color: #ffffff00;"></td>
                            </tr>
                            <tr>
                                <td colspan="5" style="text-align:right" ><strong>Grand Total<strong></td>
                                <td class="align-middle-center">
                                    <strong>
                                        <span class="grand_total_amount"><?=money_format($grand_total_from["allotment"])?></span>
                                        <span class="edit_grand_total_amount" style="display: none;"><?=money_format($grand_total_from["allotment"])?></span>
                                    </strong>
                                </td>
                                <td style="text-align:center">
                                    <strong>
                                        <span class="grand_total_obligations"><?=money_format($grand_total_from["obligation"])?></span>
                                        <span class="edit_grand_obligations" style="display: none;"><?=money_format($grand_total_from["obligation"])?></span>
                                    </strong>
                                </td>
                                <td style="text-align:center">
                                    <strong>
                                        <span class="grand_total_balance"><?=money_format($grand_total_from["allotment"] - $grand_total_from["obligation"]); ?></span>
                                        <span class="edit_grand_total_balance" style="display: none;"><?=money_format($grand_total_from["allotment"] - $grand_total_from["obligation"]); ?></span>
                                    </strong>
                                </td>
                            </tr>
                        </table>
                    <?php endif;?>
                </div>

                <div class="tab-pane data_list" id="tab_2">
                <?php if($show_table) :?>
                        <?php $allotment_class = ""; ?>
                            <table class="table table-bordered allotement-table">
                            <?php foreach($allotment_list_to_by_class as $allotment_class => $ac): ?>
                                <tr><td colspan="8" style="border: 1px solid #ffffff00;"><h4><?=$allotment_class?></h4></td></tr>
                                <tr>
                                    <th style="width: 230px;vertical-align:middle; background-color: #00a65a;">Object</th>
                                    <th style="background-color: #00a65a;" class="align-middle-center">1st QTR</th>
                                    <th style="background-color: #00a65a;" class="align-middle-center">2nd QTR</th>
                                    <th style="background-color: #00a65a;" class="align-middle-center">3rd QTR</th>
                                    <th style="background-color: #00a65a;" class="align-middle-center">4rth QTR</th>
                                    <th style="width:125px; background-color: #00a65a;" class="align-middle-center">Allotment Amount</th>
                                    <th style="width:125px; background-color: #00a65a;" class="align-middle-center">Obligated Amount</th>
                                    <th style="width:125px; background-color: #00a65a;" class="align-middle-center">Unobligated Allotment</th>
                                </tr>
                                <?php foreach( $ac["list"] as $al): ?>
                                    <tr>
                                        <td><?=$al->object_code .' - '. $al->object_description?></td>
                                        <td align="center" class="align-middle-center">
                                            <span class="span_amount"><?=money_format($al->first_amount)?></span>
                                            <input type="number" name="first_amounts[<?=$al->object_id?>]" value="<?=$al->first_amount?>" style="display: none;" onchange="update_edit_total_amount(this)" 
                                                class="add_budget_amount form-control input-sm <?=in_array($al->allotment_class, $error_allotment_class ) ? 'input-has-error' : ''?>" />
                                        </td>
                                        <td align="center" class="align-middle-center">
                                            <span class="span_amount"><?=money_format($al->second_amount)?></span>
                                            <input type="number" name="second_amounts[<?=$al->object_id?>]" value="<?=$al->second_amount?>" style="display: none;" onchange="update_edit_total_amount(this)" class="add_budget_amount form-control input-sm <?=in_array($al->allotment_class, $error_allotment_class ) ? 'input-has-error' : ''?>" />
                                        </td>
                                        <td align="center" class="align-middle-center">
                                            <span class="span_amount"><?=money_format($al->third_amount)?></span>
                                            <input type="number" name="third_amounts[<?=$al->object_id?>]" value="<?=$al->third_amount?>" style="display: none;" onchange="update_edit_total_amount(this)" class="add_budget_amount form-control input-sm <?=in_array($al->allotment_class, $error_allotment_class ) ? 'input-has-error' : ''?>" />
                                        </td>
                                        <td align="center" style=" text-align:center; vertical-align: middle">
                                            <span class="span_amount"><?=money_format($al->fourth_amount)?></span>
                                            <input type="number" name="fourth_amounts[<?=$al->object_id?>]" value="<?=$al->fourth_amount?>" style="display: none;" onchange="update_edit_total_amount(this)" class="add_budget_amount form-control input-sm <?=in_array($al->allotment_class, $error_allotment_class ) ? 'input-has-error' : ''?>" />
                                        </td>
                                        <td align="center" class="align-middle-center">
                                            <span class="total_row_amount"><?=money_format($al->total_allotment)?></span>
                                            <span class="edit_total_row_amount" style="display: none;"><?=money_format($al->total_allotment)?></span>
                                        </td>
                                        <td class="align-middle-center ">
                                            <span class="total_row_obligations"><?=money_format($al->total_obligation)?></span>
                                            <span class="edit_total_row_obligations" style="display: none;"><?=money_format($al->total_obligation)?></span>
                                        </td>
                                        <td class="align-middle-center">
                                            <span class="total_row_balance"><?=money_format($al->total_allotment - $al->total_obligation)?></span>
                                            <span class="edit_total_row_balance" style="display: none;"><?=money_format($al->total_allotment - $al->total_obligation)?></span>
                                        </td>
                                    </tr>
                                        
                                <?php endforeach; ?>
                                    <tr>
                                        <td colspan="5" style="text-align:right" ><strong>Sub-total<strong></td>
                                        <td style="text-align:center">
                                            <strong>
                                                <span class="total_amount"><?=money_format($ac["grand_total_allotment"])?></span>
                                                <span class="edit_total_amount" style="display: none;"><?=money_format($ac["grand_total_allotment"])?></span>
                                            </strong>
                                        </td>
                                        <td style="text-align:center">
                                            <strong>
                                                <span class="total_obligations"><?=money_format($ac["grand_total_obligation"])?></span>
                                                <span class="edit_obligations" style="display: none;"><?=money_format($ac["grand_total_allotment"])?></span>
                                            </strong>
                                        </td>
                                        <td style="text-align:center">
                                            <strong>
                                                <span class="total_balance"><?=money_format($ac["grand_total_allotment"] - $ac["grand_total_obligation"]); ?></span>
                                                <span class="edit_total_balance" style="display: none;"><?=money_format($ac["grand_total_allotment"] - $ac["grand_total_obligation"]); ?></span>
                                            </strong>
                                        </td>
                                    </tr>
                            <?php endforeach; ?>
                                <tr>
                                    <td colspan="8" style="border-right-color: #ffffff00; border-left-color: #ffffff00;"></td>
                                </tr>
                                <tr>
                                    <td colspan="5" style="text-align:right" ><strong>Grand Total<strong></td>
                                    <td class="align-middle-center">
                                        <strong>
                                            <span class="grand_total_amount"><?=money_format($grand_total_from["allotment"])?></span>
                                            <span class="edit_grand_total_amount" style="display: none;"><?=money_format($grand_total_from["allotment"])?></span>
                                        </strong>
                                    </td>
                                    <td style="text-align:center">
                                        <strong>
                                            <span class="grand_total_obligations"><?=money_format($grand_total_from["obligation"])?></span>
                                            <span class="edit_grand_obligations" style="display: none;"><?=money_format($grand_total_from["obligation"])?></span>
                                        </strong>
                                    </td>
                                    <td style="text-align:center">
                                        <strong>
                                            <span class="grand_total_balance"><?=money_format($grand_total_from["allotment"] - $grand_total_from["obligation"]); ?></span>
                                            <span class="edit_grand_total_balance" style="display: none;"><?=money_format($grand_total_from["allotment"] - $grand_total_from["obligation"]); ?></span>
                                        </strong>
                                    </td>
                                </tr>
                        </table>
                        
                    <?php endif;?>
                </div>
            </div>
          </div>
        </div>
    
      </div>
        
        <div class="row">

            <div class="col-xs-12">
                <div class="box">
                    <div class="box-header">
                    <h3 class="box-title" ></h3>
                    <div class="box-tools">

                          
                    </div>
                </div>

                    <div class="box-body table-responsive">
                    <table class="table table-bordered allotement-table">
                        <tr>
                            <th class="align-middle-center" style="background-color:#00c0ef !important">From (Original Amount) </th>
                            <th class="align-middle-center" style="background-color:#00c0ef !important">To (Original Amount)</th>
                            <th class="align-middle-center" style="background-color:#00c0ef !important">Grand Total</th>
                        </tr>
                        <tr>
                            <td class="align-middle-center"><?=money_format($grand_total_from["allotment"])?></td>
                            <td class="align-middle-center"><?=money_format($grand_total_to["allotment"])?></td>
                            <td class="align-middle-center"><?=money_format($grand_total_from["allotment"] + $grand_total_to["allotment"])?></td>
                        </tr>
                    </table>
                    
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<script type="text/javascript">
    $(document).ready(function() {
        show_edit_data();
        $(".add_budget_amount").click(function () {
            $(this).select();
       
        });
    });

    function money_format(n) {
        n = parseFloat(n).toFixed(2);
        return Number(n).toLocaleString('en');
    }

    function show_filtered_list() {
        location.href = this.create_allotment_url();
    }
    function create_allotment_url() {
        return  '<?=base_url()?>allotment/ogmentation?fund_id=' + $("#select_fund_id").find("option:selected").val()
                       + '&year=' + $("#select_year").find("option:selected").val()
                       + '&legal_basis_id_from=' + $("#select_legal_basis_id_from").find("option:selected").val()
                       + '&fund_rc_id_from=' + $("#select_fund_rc_id_from").find("option:selected").val()
                       + '&prexc_id_from=' + $("#select_prexc_id_from").find("option:selected").val()
                       + '&legal_basis_id_to=' + $("#select_legal_basis_id_to").find("option:selected").val()
                       + '&fund_rc_id_to=' + $("#select_fund_rc_id_to").find("option:selected").val()
                       + '&prexc_id_to=' + $("#select_prexc_id_to").find("option:selected").val()
    }

    function get_fund_legal_basis() {
        $("#select_legal_basis_id_from").prop("disabled", true); 
        $.get("<?=base_url();?>legal_basis/get_fund_legal_basis?fund_id=" + $("#select_fund_id").val() + "&year=<?=$year?>", 
            function(e) {
                var lb_options = "";
                $.each(e.fund_legal_basis, function (i,flb) {
                    lb_options += "<option value='" + flb.id + "'>" + flb.name + "</option>";
                });
                $("#select_legal_basis_id_from").prop("disabled", false); 
                $("#select_legal_basis_id_from").html(lb_options);
            }
        );
        $("#select_legal_basis_id_to").prop("disabled", true); 
        $.get("<?=base_url();?>legal_basis/get_fund_legal_basis?fund_id=" + $("#select_fund_id").val() + "&year=<?=$year?>", 
            function(e) {
                var lb_options = "";
                $.each(e.fund_legal_basis, function (i,flb) {
                    lb_options += "<option value='" + flb.id + "'>" + flb.name + "</option>";
                });
                $("#select_legal_basis_id_to").prop("disabled", false); 
                $("#select_legal_basis_id_to").html(lb_options);
            }
        );

        $("#select_fund_rc_id_from").prop("disabled", true); 
        $.get("<?=base_url();?>funds/get_fund_rc?fund_id=" + $("#select_fund_id").val() + "&year=<?=$year?>", 
            function(e) {
                var rc_options = "";
                $.each(e.fund_rc, function (i,frc) {
                    rc_options += "<option value='" + frc.fund_rc_id + "'";
                    if(i == 0) {
                        rc_options += "selected";
                    } else if(i == 1) {
                        rc_options += "disabled";
                    }
                    rc_options += ">" + frc.code + " - " + frc.description + "</option>";
                });
                $("#select_fund_rc_id_from").prop("disabled", false); 
                $("#select_fund_rc_id_from").html(rc_options);
            }
        );

        $("#select_fund_rc_id_to").prop("disabled", true); 
        $.get("<?=base_url();?>funds/get_fund_rc?fund_id=" + $("#select_fund_id").val() + "&year=<?=$year?>", 
            function(e) {
                var rc_options = "";
                $.each(e.fund_rc, function (i,frc) {
                    rc_options += "<option value='" + frc.fund_rc_id + "'";
                    if(i == 1) {
                        rc_options += "selected";
                    } else if(i == 0) {
                        rc_options += "disabled";
                    }
                    rc_options += ">" + frc.code + " - " + frc.description + "</option>";
                });
                $("#select_fund_rc_id_to").prop("disabled", false); 
                $("#select_fund_rc_id_to").html(rc_options);
            }
        );
    }

    function show_edit_data() {
        var data_list =  $(".data_list");
        $(data_list).find(".add_budget_amount").show();
        $(data_list).find(".span_amount").hide();
        $(data_list).find(".total_amount").hide();
        $(data_list).find(".edit_total_amount").show();
        $(data_list).find(".total_row_amount").hide();
        $(data_list).find(".edit_total_row_amount").show();
        $(data_list).find(".total_row_balance").hide();
        $(data_list).find(".edit_total_row_balance").show();
        $(data_list).find(".total_balance").hide();
        $(data_list).find(".edit_total_balance").show();


        $(data_list).find(".grand_total_amount").hide();
        $(data_list).find(".edit_grand_total_amount").show();
        $(data_list).find(".grand_total_balance").hide();
        $(data_list).find(".edit_grand_total_balance").show();
    }

    function cancel_edit_data(elm) {
        $(box_tools).find(".btn_edit_new_data").show();
        $(box_tools).find(".btns_save_new_data").hide();
        var data_list =  $(elm).closest(".data_list");
        $(data_list).find(".span_amount").show();
        $(data_list).find(".add_budget_amount").hide();
        $("#add_error_message").hide();
        $(data_list).find(".total_amount").show();
        $(data_list).find(".edit_total_amount").hide();
        $(data_list).find(".total_row_amount").show();
        $(data_list).find(".edit_total_row_amount").hide();
        $(".text-danger").removeClass('text-danger');
        $(".input-has-error").removeClass('input-has-error');
        $("#edit_error_message").hide();
        $(data_list).find(".edit_total_row_balance").hide();
        $(data_list).find(".total_row_balance").show();
        $(data_list).find(".edit_total_balance").hide();
        $(data_list).find(".total_balance").show();


        $(data_list).find(".grand_total_amount").show();
        $(data_list).find(".edit_grand_total_amount").hide();
        $(data_list).find(".grand_total_balance").show();
        $(data_list).find(".edit_grand_total_balance").hide();

    }

    function save_edit_data(elm) {
        $(".text-danger").removeClass("text-danger");
        $("#edit_error_message").hide();
        var total_new_budget_amount = 0;
        var data_list = $(elm).closest(".data_list");

        var has_negative_obl = false;
        $(data_list).find(".edit_total_row_balance").each(function(i, tbl) {
            if(parseFloat($(this).html()) < 0) {
                has_negative_obl = true;
                $(this).closest("tr").addClass("text-danger");
            }
        });
        if(has_negative_obl) {
            $("#edit_error_message").html("<p>Unobligated allotment must not be negative.</p>").show();
        } else {
            $(data_list).find("form.edit_form_data").submit();
        }
    }

    function update_edit_total_amount(elm) {
        if (!$(elm).val()) {
            $(elm).val(0);
        }
        var data_list = $(elm).closest(".data_list");
        var table = $(elm).closest("table");
        var tr = $(elm).closest("tr");
        var total_amount = 0;
        var total_balance = 0;
        var row_amount = 0;
        var row_obligations = parseFloat($(table).find(".edit_total_row_obligations").html());
        var total_obligations = parseFloat($(table).find(".edit_obligations").html());
        var grand_obligations = parseFloat($(data_list).find(".edit_grand_obligations").html());

        $(tr).find(".add_budget_amount").each(function(i, amt){
            row_amount += parseFloat($(amt).val());
        });

        $(tr).find("span.edit_total_row_amount").text(money_format(row_amount));
        $(tr).find(".edit_total_row_balance").html(money_format(row_amount - row_obligations));

        $(table).find(".add_budget_amount").each(function(i, sa) {
            total_amount += parseFloat($(this).val()); 
        });

        $(table).find(".edit_total_amount").text(money_format(total_amount));
        $(table).find(".edit_total_balance").text(money_format(total_amount - total_obligations));

        var grand_amount = 0;
        var grand_balance = 0;

        $(data_list).find(".add_budget_amount").each(function(i, tbl) {
            grand_amount += parseFloat($(this).val()); 
        });

        $(data_list).find(".edit_grand_total_amount").text(money_format(grand_amount));
        $(data_list).find(".edit_grand_total_balance").text(money_format(grand_amount - grand_obligations));
    }
</script>