<div class="content-wrapper">
<!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
        <?=$fund_id==sha1(1) ? 'New General Appropriations' : 'Continuing Appropriations' ?>
        <small></small>
        </h1>
        <ol class="breadcrumb">
        <li><a href="#"> Home</a></li>
        <li><a href="#">Fund</a></li>
        <li class="active">Legal Basis</li>
        </ol>
    </section>

    <section class="content">
        <div class="callout callout-danger" id="error_message" style="display: none;">
        </div>
        <div class="row">
            <div class="col-xs-12 col-md-12">
                <div class="row">
                    <div class="col-xs-12 col-md-2">
                        <div class="form-group">
                            <label>Year</label>
                            <select class="form-control" name="year" id="select_year">
                                <?php for($dyear=2018; $dyear <= (date("Y") + 2); $dyear++): ?>
                                    <option <?= $year == $dyear ? 'selected' : '' ?> value="<?=$dyear?>" ><?=$dyear?></option>
                                <?php  endfor; ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-xs-12 col-md-7">
                        <div class="form-group">
                            <label>Funds</label>
                            <select class="form-control select_two" name="fund_id" id="select_fund_id">
                                <?php foreach($fund_list as $fl): ?>
                                    <option <?= $fund_id == sha1($fl->id) ? 'selected' : '' ?> value="<?= sha1($fl->id)?>"><?=$fl->name?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-xs-12 col-md-1">
                        <div style="padding-top:24px;">
                            <input type="button" class="btn btn-primary" style="width: 100%;" onclick="select_fund()" value="Show" />
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-xs-12">
                    <div class="box">
                        <div class="box-header">
                        <h3 class="box-title">Legal Basis</h3>
                        <div class="box-tools">
                            <a class="btn"  id="show_add_data_modal">
                                <i class="fa fa-plus"></i> Add
                            </a>
                        </div>
                    </div>
                    <div class="box-body table-responsive">
                        <table class="table table-bordered">
                            <tr>
                                <th  class="align-middle">Name</th>
                                <th  style="width:100px;" class="align-middle-center">Active</th>
                                <th  style="width:100px; text-align: center;">Action</th>
                            </tr>
                            <?php if(count($fund_legal_basis) > 0): ?>
                                <?php foreach($fund_legal_basis as $lb): ?>
                                    <tr>
                                        <td class="align-middle"><?=$lb->name?></td>
                                        <td class="align-middle-center">
                                            <i class="fa <?=$lb->status == 'ACTIVE' ? 'fa-check' : 'fa-remove';?>"></i>
                                        </td>
                                        <td style="vertical-align:middle; text-align: center;">
                                            <a class="Delete" title="<?=ucfirst($lb->status == 'ACTIVE' ? 'Activate' : 'Deactivate');?>" onclick="show_confirm_delete_data_modal('<?=$lb->fund_legal_basis_id?>', '<?=$lb->name?>', '<?=$lb->status =='ACTIVE' ? 'INACTIVE' : 'ACTIVE'?>')" style="cursor:pointer">
                                                <i class="fa <?=$lb->status  == 'ACTIVE' ? 'fa-remove' : 'fa-check';?>"></i>
                                            </a> 
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="3" align="center">No Result(s) found.</td>
                                </tr>
                            <?php endif;?>
                        </table>
                        </div>
                    </div>
            </div>
        </div>

        <div class="modal fade" id="add_data_modal">
            <div class="modal-dialog">
                <form method="POST" id="form_data_model" action="<?php echo base_url(); ?>funds/add_legal_basis">
                    <input  type="hidden" name="year" value="<?=$year?>" required/>
                    <input  type="hidden" name="fund_id" value="<?=$fund_id?>" required/>
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span></button>
                            <h4 class="modal-title">Add Legal Basis</h4>
                        </div>
                        <div class="modal-body">
                            <div class="callout callout-danger" id="add_error_message" style="display:none;" >
                                <p>Insufficient funds, Please check.</p>
                            </div>
                            <div class="row"> 
                                <div class="col-xs-12">
                                    <div class="form-group">
                                        <label>Legal Basis</label>
                                        <select class="form-control select_two" name="legal_basis_id" id="add_legal_basis_id" style="width: 100%" required>
                                            <?php if(count($new_fund_lb_list) > 0): ?>
                                                <?php foreach($new_fund_lb_list as $lb): ?>
                                                    <option value="<?=$lb->id?>"><?=$lb->name?></option>
                                                <?php endforeach; ?>
                                            <?php endif;?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Cancel</button>
                            <button type="button" class="btn btn-primary" id="add_data_btn">Add</button>
                        </div>
                    </div>
                </form>
                <!-- /.modal-content -->
            </div>
            <!-- /.modal-dialog -->
        </div>
        <div class="modal fade" id="confirm_delete_data_modal">
            <div class="modal-dialog">
                <form method="POST"  action="<?php echo base_url(); ?>funds/delete_legal_basis">
                    <input  type="hidden" name="year" value="<?=$year?>" />
                    <input  type="hidden" name="fund_id" value="<?=$fund_id?>" />
                    <input  type="hidden" name="fund_legal_basis_id" id="delete_id"  />
                    <input  type="hidden" name="action" id="delete_action"  />
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span></button>
                            <h4 class="modal-title">Confirm Delete</h4>
                        </div>
                        <div class="modal-body">
                            <div class="callout callout-danger" id="add_error_message" style="display:none;" >
                                <p>Insufficient funds, Please check.</p>
                            </div>
                            <p> Are You sure you want to <span id="delete_action_text"></span> this (<span id="delete_text"></span>)? </p>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Cancel</button>
                            <button type="submit" class="btn btn-Primary" >Proceed</button>
                        </div>
                    </div>
                </form>
                <!-- /.modal-content -->
            </div>
            <!-- /.modal-dialog -->
        </div>
    </section>
</div>
<script type="text/javascript">
    $(document).ready(function() {
        $("#show_add_data_modal").click(function() {
            $("#add_data_modal").modal("show");
        });

        $("#add_data_btn").click(function() {
            if ($("#add_legal_basis_id").val()) {
                $("form#form_data_model").submit();
            } else {
                $("#add_error_message").show();
                $("#add_error_message").html("<p>Please select a legal basis.</p>");
            }
        });
    });

    function show_confirm_delete_data_modal(delete_id, delete_text, action) {
        $("#delete_id").val(delete_id);
        $("#delete_text").html(delete_text);
        $("#delete_action").val(action);
        if(action == "ACTIVE") {
            $("#delete_action_text").html("Activate");
        } else {
            $("#delete_action_text").html("Deactivate");
        }
        $("#confirm_delete_data_modal").modal("show");
    }

    function select_fund() {
        location.href = '<?=base_url()?>funds/legal_basis?fund_id=' + $("#select_fund_id").find("option:selected").val() + '&year=' + $("#select_year").find("option:selected").val();
    }
</script>