<div class="content-wrapper">
<!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
        <?=$fund_id==sha1(1) ? 'New General Appropriations' : 'Continuing Appropriations' ?> (RC <?=count($rc) > 0 ? $rc[0]->code : ""?>)
        <small></small>
        </h1>
        <ol class="breadcrumb">
        <li>Home></li>
        <li><a href="<?=base_url()?>responsibility_center/list">Responsibility Center</a></li>
        <li class="active">Data tables</li>
        </ol>
    </section>

    <section class="content">
    <div class="row">
            <div class="col-xs-12 col-md-12">
                <div class="row">
                    <div class="col-xs-12 col-md-3">
                        <div class="form-group">
                            <label>Year</label>
                            <select class="form-control" id="select_year" name="select_year">
                                <?php for($dyear=(date("Y") - 1); $dyear <= (date("Y") + 2); $dyear++): ?>
                                    <option <?= $year == $dyear ? 'selected' : '' ?> value="<?=$dyear?>" ><?=$dyear?></option>
                                <?php  endfor; ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-xs-12 col-md-5">
                        <div class="form-group">
                            <label>Funds</label>
                            <select class="form-control select_two" id="select_fund_id" name="select_fund_id" onchange="on_fund_change()" style="width: 100%;">
                                <?php foreach($fund_list as $fl): ?>
                                    <option <?= $fund_id == sha1($fl->id) ? 'selected' : '' ?> value="<?= sha1($fl->id)?>"><?=$fl->name?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-xs-12 col-md-3">
                        <div class="form-group">
                            <label>Responsibility Center</label>
                            <select class="form-control select_two" id="select_fund_rc_id" name="select_fund_rc_id" style="width: 100%;">
                                <?php foreach($rc as $res_center): ?>
                                    <option <?= $fund_rc_id == $res_center->fund_rc_id? 'selected' : '' ?> value="<?=$res_center->fund_rc_id?>"><?=$res_center->code . " - " .  $res_center->description ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>

                    <div class="col-xs-12 col-md-1">
                        <div style="padding-top:24px;">
                            <input type="button" class="btn btn-primary" style="width: 100%;" onclick="show_filtered_list()" value="Show" />
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-xs-12">
                <div class="box">
                    <div class="box-header">
                    <h3 class="box-title">Objects</h3>
                        <div class="box-tools">
                            <a class="btn"  id="show_add_data_modal">
                                <i class="fa fa-plus"></i> Add
                            </a>
                        </div>
                </div>
                <div class="box-body table-responsive">
                    <table class="table table-bordered">
                        <tr>
                            <th style="width:200px;">Code</th>
                            <th>Allotment Class</th>
                            <th>Description</th>
                            <th>Active</th>
                            <th style="width:100px; text-align: center;">Action</th>
                        </tr>
                        <?php if(count($objects) > 0): ?>
                            <?php foreach($objects as $obj): ?>
                                <tr>
                                    <td><?=$obj->code?></td>
                                    <td><?=$obj->allotment_class?></td>
                                    <td><?=$obj->description?></td>
                                    <td class="align-middle-center">
                                        <i class="fa <?=$obj->status == 'ACTIVE' ? 'fa-check' : 'fa-remove';?>"></i>
                                    </td>
                                    <td style="width:100px; text-align: center;">
                                        <a class="Delete"  title="<?=ucfirst($obj->status == 'ACTIVE' ? 'Activate' : 'Deactivate');?>" onclick="show_confirm_delete_data_modal('<?=$obj->fund_rc_object_id?>', '<?=$obj->code ." - " . $obj->allotment_class . ' - ' .  $obj->description ?>', '<?=$obj->status =='ACTIVE' ? 'INACTIVE' : 'ACTIVE'?>')" style="cursor:pointer">
                                            <i class="fa <?=$obj->status  == 'ACTIVE' ? 'fa-remove' : 'fa-check';?>"></i>
                                        </a> 
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="4" align="center">No Result(s) found.</td>
                            </tr>
                        <?php endif;?>
                    </table>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <div class="modal fade" id="add_data_modal">
        <div class="modal-dialog">
            <form method="POST" action="<?php echo base_url(); ?>funds/add_fund_rc_objects">
                <input name="fund_rc_id" value="<?=$fund_rc_id?>" type="hidden" />
                <input name="year" value="<?=$year?>" type="hidden" />
                <input name="fund_id" value="<?=$fund_id?>" type="hidden" />
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span></button>
                        <h4 class="modal-title">Add Object(s)</h4>
                    </div>
                    <div class="modal-body">
                        <div class="row"> 
                            <div class="col-xs-12">
                                <div class="form-group">
                                    <label>Object of Expenditures</label>
                                    <select class="form-control select_two" multiple="multiple" name="object_ids[]" style="width: 100%" required>
                                        <?php if(count($fund_rc_new_objects) > 0): ?>
                                            <?php foreach($fund_rc_new_objects as $obj): ?>
                                                <option value="<?=$obj->object_id?>"><?=$obj->code ." - " . $obj->allotment_class . " - " .  $obj->description ?></option>
                                            <?php endforeach; ?>
                                        <?php endif;?>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-primary" id="add_data_btn">Add</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

     <div class="modal fade" id="confirm_delete_data_modal">
        <div class="modal-dialog">
            <form method="POST"  action="<?php echo base_url(); ?>funds/delete_fund_rc_objects">
                <input  type="hidden" name="year" value="<?=$year?>" />
                <input  type="hidden" name="fund_id" value="<?=$fund_id?>" />
                <input  type="hidden" name="fund_rc_id" value="<?=$fund_rc_id?>" />
                <input  type="hidden" name="fund_rc_object_id" id="delete_id"  />
                <input  type="hidden" name="action" id="delete_action"  />
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span></button>
                        <h4 class="modal-title">Confirm Delete</h4>
                    </div>
                    <div class="modal-body">
                        <div class="callout callout-danger" id="add_error_message" style="display:none;" >
                            <p>Insufficient funds, Please check.</p>
                        </div>
                        <p> Are You sure you want to <span id="delete_action_text"></span> this (<span id="delete_text"></span>)? </p>
                        
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-primary" >Proceed</button>
                    </div>
                </div>
            </form>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
</div>
<script type="text/javascript">
    $(document).ready(function() {
        $("#show_add_data_modal").click(function() {
            $("#add_data_modal").modal("show");
        });

        $("#show_confirm_delete_data_modal").click(function() {
            $("#confirm_delete_data_modal").modal("show");
        });
    });

    function show_confirm_delete_data_modal(delete_id, delete_text, action) {
        $("#delete_id").val(delete_id);
        $("#delete_text").html(delete_text);
        $("#delete_action").val(action);
        if(action == "ACTIVE") {
            $("#delete_action_text").html("Activate");
        } else {
            $("#delete_action_text").html("Deactivate");
        }
        $("#confirm_delete_data_modal").modal("show");
    }

    function on_fund_change() {
        $("#select_fund_rc_id").prop("disabled", true);  
        $("#select_fund_rc_id").html("");

        $.get("<?=base_url();?>funds/get_fund_rc?fund_id=" + $("#select_fund_id").val() + "&year=<?=$year?>", 
            function(e) {
                var rc_options = "";
                $.each(e.fund_rc, function (i,frc) {
                    rc_options += "<option value='" + frc.fund_rc_id + "'>" + frc.code + " - " + frc.description + "</option>";
                });
                $("#select_fund_rc_id").prop("disabled", false); 
                $("#select_fund_rc_id").html(rc_options);
            }
        );
    }

    function show_filtered_list() {
        location.href = '<?=base_url()?>funds/objects?fund_id=' + $("#select_fund_id").find("option:selected").val() + '&year=' + $("#select_year").find("option:selected").val() + '&fund_rc_id=' + $("#select_fund_rc_id").find("option:selected").val();
    }
</script>