<div class="content-wrapper">
<!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
        <?=$fund_id==sha1(1) ? 'New General Appropriations' : 'Continuing Appropriations' ?>
        <small></small>
        </h1>
        <ol class="breadcrumb">
        <li><a href="#"> Home</a></li>
        <li><a href="#">Fund</a></li>
        <li class="active">Responsibility Center</li>
        </ol>
    </section>

    <section class="content">
        <div class="callout callout-danger" id="error_message" style="display: none;">
        </div>
        <div class="row">
            <div class="col-xs-12 col-md-12">
                <div class="row">
                   
                    <div class="col-xs-12 col-md-2">
                        <div class="form-group">
                            <label>Year</label>
                            <select class="form-control" name="year" id="select_year">
                                <?php for($dyear=2018; $dyear <= (date("Y") + 2); $dyear++): ?>
                                    <option <?= $year == $dyear ? 'selected' : '' ?> value="<?=$dyear?>" ><?=$dyear?></option>
                                <?php  endfor; ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-xs-12 col-md-7">
                        <div class="form-group">
                            <label>Funds</label>
                            <select class="form-control select_two" name="fund_id" id="select_fund_id">
                                <?php foreach($fund_list as $fl): ?>
                                    <option <?= $fund_id == sha1($fl->id) ? 'selected' : '' ?> value="<?= sha1($fl->id)?>"><?=$fl->name?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-xs-12 col-md-1">
                        <div style="padding-top:24px;">
                            <input type="button" class="btn btn-primary" style="width: 100%;" onclick="select_fund()" value="Show" />
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-xs-12">
                    <div class="box">
                        <div class="box-header">
                        <h3 class="box-title">Responsibility Center</h3>
                        <div class="box-tools">
                            <a class="btn"  id="show_add_data_modal">
                                <i class="fa fa-plus"></i> Add
                            </a>
                        </div>
                    </div>
                    <div class="box-body table-responsive">
                        <table class="table table-bordered">
                            <tr>
                                <th  class="align-middle" style="width:200px;">Code</th>
                                <th  class="align-middle" >Description</th>
                                <th class="align-middle-center">Total Amount</th>
                                <th class="align-middle-center">Total Obligations</th>
                                <th class="align-middle-center">Total Balance</th>
                                <th class="align-middle-center">Active</th>
                                <th class="align-middle-center" style="width: 160px;" title="Created or Assigned user">User</th>
                                <th  style="width:100px; text-align: center;">Action</th>
                            </tr>
                            <?php if(count($responsibility) > 0): ?>
                                <?php $total_allotment = 0; ?>
                                <?php $grand_total_obligation = 0; ?>
                                <?php $grand_total_balance = 0; ?>
                                <?php $amount = 1; ?>
                                <?php foreach($responsibility as $res): ?>
                                    <?php $total_allotment += $res->total_allotment; ?>
                                    <?php $grand_total_obligation += $res->total_obligation; ?>
                                    <?php $grand_total_balance += ($res->total_allotment - $res->total_obligation); ?>
                                    <tr>
                                        <td class="align-middle"><?=$res->code?></td>
                                        <td class="align-middle"><?=$res->description?></td>
                                        <td class="align-middle-center"><?=money_format($res->total_allotment); ?></td>
                                        <td class="align-middle-center"><?=money_format($res->total_obligation)?></td>
                                        <td class="align-middle-center"><?=money_format($res->total_allotment - $res->total_obligation)?></td>
                                        <td class="align-middle-center">
                                            <i class="fa <?=$res->status == 'ACTIVE' ? 'fa-check' : 'fa-remove';?>"></i>
                                        </td>
                                        <td class="align-middle-center" >
                                            <?php if($login_user_data["type"] != 1)  :?>
                                                <?=ucfirst($res->created_name); ?>
                                            <?php else: ?>
                                                <a href="#" onclick="show_change_user(<?=$res->created_by?>, <?= $res->fund_rc_id?>, '<?=$res->code?>'); return false;" title="View Change User">
                                                    <?=ucfirst($res->created_name); ?> <i class="fa fa-cog"></i>
                                                </a>
                                            <?php endif; ?>
                                        </td>
                                        <td style="width:100px; vertical-align:middle; text-align: center;">
                                            <input type="hidden" name="rc_description" class="rc_description" value="<?=$res->code . ' - ' .  $res->description ?>" />
                                           
                                            <a href="<?=base_url();?>funds/objects?fund_id=<?=$fund_id?>&year=<?=$year?>&fund_rc_id=<?=$res->fund_rc_id?>" style="padding-right: 10px; cursor:pointer" title="Objects">
                                                <i class="fa fa-object-ungroup"></i>
                                            </a>
                                            <a class="Delete" title="<?=ucfirst($res->status != 'ACTIVE' ? 'Activate' : 'Deactivate');?>" onclick="show_confirm_delete_data_modal('<?=$res->fund_rc_id?>', '<?=$res->status == 'ACTIVE' ? 'INACTIVE' : 'ACTIVE';?>', this)" style="cursor:pointer">
                                                <i class="fa <?=$res->status  == 'ACTIVE' ? 'fa-remove' : 'fa-check';?>"></i>
                                            </a> 
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                                <tr>
                                    <td style="text-align:right" colspan="2"><strong>Grand Total<strong></td>
                                    <td style="text-align:center">
                                        <strong>
                                            <span class="total_amount"><?=money_format($total_allotment)?></span>
                                        </strong>
                                    </td>
                                    <td style="text-align:center"><strong><?=money_format($grand_total_obligation); ?></strong></td>
                                    <td style="text-align:center"><strong><?=money_format($grand_total_balance);?></strong></td>
                                    <td style="text-align:center" colspan="2"></td>
                                </tr>
                            <?php else: ?>
                                <tr>
                                    <td colspan="6" align="center">No Result(s) found.</td>
                                </tr>
                            <?php endif;?>
                        </table>
                        </div>
                    </div>
            </div>
        </div>

        <div class="modal fade" id="add_data_modal">
            <div class="modal-dialog">
                <form method="POST" id="form_data_model" action="<?php echo base_url(); ?>funds/add_fund_rc">
                    <input  type="hidden" name="year" value="<?=$year?>" required/>
                    <input  type="hidden" name="fund_id" value="<?=$fund_id?>" required/>
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span></button>
                            <h4 class="modal-title">Add Responsibility Center</h4>
                        </div>
                        <div class="modal-body">
                            <div class="callout callout-danger" id="add_error_message" style="display:none;" >
                                <p>Insufficient funds, Please check.</p>
                            </div>
                            <div class="row"> 
                                <div class="col-xs-12">
                                    <div class="form-group">
                                        <label>Responsibility Center</label>
                                        <select class="form-control select_two"  id="add_rc_id" name="rc_id" style="width: 100%" required>
                                            <?php if(count($new_fund_rc_list) > 0): ?>
                                                <?php foreach($new_fund_rc_list as $rc): ?>
                                                    <option value="<?=$rc->id?>"><?=$rc->code . " - " .  $rc->description ?></option>
                                                <?php endforeach; ?>
                                            <?php endif;?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="row"> 
                                <div class="col-xs-12">
                                    <div class="form-group">
                                        <label>Object of Expenditures</label>
                                        <select class="form-control select_two" multiple="multiple" name="object_ids[]" style="width: 100%" required>
                                            <?php if(count($objects) > 0): ?>
                                                <?php foreach($objects as $obj): ?>
                                                    <option value="<?=$obj->id?>"><?=$obj->code ." - " . $obj->allotment_class . " - " .  $obj->description ?></option>
                                                <?php endforeach; ?>
                                            <?php endif;?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Cancel</button>
                            <button type="button" class="btn btn-primary" id="add_data_btn">Add</button>
                        </div>
                    </div>
                </form>
                <!-- /.modal-content -->
            </div>
            <!-- /.modal-dialog -->
        </div>
        <div class="modal fade" id="confirm_delete_data_modal">
            <div class="modal-dialog">
                <form method="POST"  action="<?php echo base_url(); ?>funds/delete_fund_rc">
                    <input  type="hidden" name="year" value="<?=$year?>" />
                    <input  type="hidden" name="fund_id" value="<?=$fund_id?>" />
                    <input  type="hidden" name="fund_rc_id" id="delete_fund_rc_id"  />
                    <input  type="hidden" name="action" id="delete_action"  />
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span></button>
                            <h4 class="modal-title">Confirm Action</h4>
                        </div>
                        <div class="modal-body">
                            <div class="callout callout-danger" id="add_error_message" style="display:none;" >
                                <p>Insufficient funds, Please check.</p>
                            </div>
                            <p> Are You sure you want to <span id="delete_action_text"></span> this (<span id="delete_text"></span>)? </p>
                           
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Cancel</button>
                            <button type="submit" class="btn btn-primary" >Proceed</button>
                        </div>
                    </div>
                </form>
                <!-- /.modal-content -->
            </div>
            <!-- /.modal-dialog -->
        </div>
        <div class="modal fade" id="show_change_user_modal">
            <div class="modal-dialog">
                <form method="POST"  action="<?php echo base_url(); ?>funds/update_fund_rc">
                    <input  type="hidden" name="year" value="<?=$year?>" />
                    <input  type="hidden" name="fund_id" value="<?=$fund_id?>" />
                    <input  type="hidden" name="fund_rc_id" id="change_user_fund_rc_id"  />

                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span></button>
                            <h4 class="modal-title">Update Responsibility Center </h4>
                        </div>
                        <div class="modal-body">
                             <div class="form-group">
                                <label>Code</label>
                                <input value="" id="change_rc_code" class="form-control" readonly/>
                             </div>
                             <div class="form-group">
                                <label>Users</label>
                                <select class="form-control" name="user_id" id="user_id">
                                    <?php foreach($users as $user): ?>
                                        <option  value="<?=$user->id?>" ><?=ucfirst( $user->name)?></option>
                                    <?php  endforeach; ?>
                                </select>
                             </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Cancel</button>
                            <button type="submit" class="btn btn-primary" >Update</button>
                        </div>
                    </div>
                </form>
                <!-- /.modal-content -->
            </div>
            <!-- /.modal-dialog -->
        </div>
    </section>
</div>
<script type="text/javascript">
    $(document).ready(function() {
        $("#show_add_data_modal").click(function() {
            $("#add_data_modal").modal("show");
        });

        $("#add_data_btn").click(function() {
            if ($("#add_rc_id").val()) {
                $("form#form_data_model").submit();
            } else {
                $("#add_error_message").show();
                $("#add_error_message").html("<p>Please select a responsibility center.</p>");
            }
        });
    });

    function show_confirm_delete_data_modal(delete_fund_rc_id, action, em) {
        $("#delete_fund_rc_id").val(delete_fund_rc_id);

        $("#delete_text").html($(em).closest("td").find(".rc_description").val());
        $("#delete_action").val(action);
        if(action == "ACTIVE") {
            $("#delete_action_text").html("Activate");
        } else {
            $("#delete_action_text").html("Deactivate");
        }
        $("#confirm_delete_data_modal").modal("show");
    }

    function show_change_user(user_id, frc_id, code) {
        $("#user_id").val(user_id);
        $("#change_rc_code").val(code);
        $("#change_user_fund_rc_id").val(frc_id);
        $("#show_change_user_modal").modal("show");
    }

    function select_fund() {
        location.href = '<?=base_url()?>funds/responsibility_center?fund_id=' + $("#select_fund_id").find("option:selected").val() + '&year=' + $("#select_year").find("option:selected").val();
    }
</script>