
<div class="content-wrapper">
<!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
        Disbursement
        <small></small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="#"> Home</a></li>
            <li><a href="#">Tables</a></li>
            <li class="active">Data tables</li>
        </ol>
    </section>
    <section class="content">
        <div class="row">
            <div class="col-xs-12 col-md-12">
                <div class="row">
                    <div class="col-xs-12 col-md-2">
                        <div class="form-group">
                            <label>Year</label>
                            <select class="form-control" name="year" id="select_year">
                                <?php for($dyear=(date("Y") - 1); $dyear <= (date("Y") + 2); $dyear++): ?>
                                    <option <?= $year == $dyear ? 'selected' : '' ?> value="<?=$dyear?>" ><?=$dyear?></option>
                                <?php  endfor; ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-xs-12 col-md-6">
                        <div class="form-group">
                            <label>Funds</label>
                            <select class="form-control select_two" name="fund_id" id="select_fund_id" onchange="get_fund_obligation_numbers()">
                                <?php foreach($fund_list as $fl): ?>
                                    <option <?= $fund_id == sha1($fl->id) ? 'selected' : '' ?> value="<?= sha1($fl->id)?>"><?=$fl->name?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-xs-12 col-md-3">
                        <div class="form-group">
                            <label>Obligation Number</label>
                            <select class="form-control select2_obligation_number" id="select_obligation_id" name="select_obligation_id" style="width: 100%;">
                            <?php foreach($fund_obligations as $fo): ?>
                                    <option <?= $obligation_id == $fo->id ? 'selected' : '' ?> value="<?=$fo->id?>"><?=$fo->obligation_no?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-xs-12 col-md-1">
                        <div style="padding-top:24px;">
                            <input type="button" class="btn btn-primary" style="width: 100%;" onclick="select_fund()" value="Show" />
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-xs-12">
                <div class="box">
                    <div class="box-header">
                        <h3 class="box-title"><?=$fund_id==sha1(1) ? 'New General Appropriations' : 'Continuing Appropriations' ?></h3>
                        
                    </div>
                    <div class="box-body table-responsive">
                    <table class="table table-bordered">
                        <tr>
                                <th class="align-middle">Date</th>
                                <th class="align-middle">Object</th>
                                <th class="align-middle">RC</th>
                                <th class="align-middle">Prexc</th>
                                <th class="align-middle-center">Obligation</th>
                                <th class="align-middle-center">Unpaid Obligation</th>
                                <th class="align-middle-center">Disbursement</th>

                            <th style="width:100px; text-align: center;">Action</th>
                        </tr>
                        <?php if(count($obligation_details) > 0): ?>
                            <?php foreach($obligation_details as $od): ?>
                                <tr>
                                    <td ><input type="hidden" class="obligation_details_id" value="<?=$od->id?>"><?=$od->date?></td>
                                    <td class="object_details"><?=$od->object_code ." - " . $od->object_description?></td>
                                    <td class="object_details"><?=$od->rc_code ." - " . $od->rc_description?></td>
                                    <td class="object_details"><?=$od->prexc_code ." - " . $od->prexc_description?></td>
                                    <td class="align-middle-center">
                                        <?=money_format($od->current_amount)?>
                                    </td>
                                    <td class="align-middle-center">
                                        <input type="hidden" class="unpaid_obligation" value="<?=$od->unpaid_obligation?>">
                                        <?=money_format($od->unpaid_obligation)?>
                                    </td>
                                    <td class="align-middle-center">
                                        <a href="#" onclick="show_disbursement_history(this); return false;" title="View Disbursement History">
                                            <?=money_format($od->total_amount_paid)?> <i class="fa fa-search"></i>
                                        </a>
                                    </td>
                                    <td class="align-middle-center" >
                                        <a class="" onclick="show_add_disbursement(this);" title="Add Disbursement" style=" cursor:pointer" >
                                            <i class="fa fa-pencil-square-o"></i> 
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="7" align="center">No Result(s) found.</td>
                            </tr>
                        <?php endif;?>
                    </table>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <div class="modal fade" id="disbursement_history_modal">
        <div class="modal-dialog modal-lg">
            <form method="POST" action="<?php echo base_url(); ?>prexc/add_prexc">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">Disbursement History</h4>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-xs-12">
                                <div class="box-body table-responsive">
                                    <table class="table table-bordered" id="disbursement_table">
                                        <tr  class="initial-tr" style="background-color: #626263;">
                                            <th>Date</th>
                                            <th>Object</th>
                                            <th>ADA Number</th>
                                            <th>DV Number</th>
                                            <th>Net Amount</th>
                                            <th>Bir Amount</th>
                                            <th>Total Amount</th>
                                            <th>Actions</th>
                                        </tr>
                                    </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary" data-dismiss="modal" id="add_data_btn">Close</button>
                    </div>
                </div>
            </form>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>

    <div class="modal fade" id="edit_adjusted_amount_modal">
        <div class="modal-dialog">
            <form method="POST" id="edit_form_data_model" action="<?php echo base_url(); ?>obligations/edit_adjusted_obligation_amount">
                <input  type="hidden" name="year" value="<?=$year?>" required/>
                <input  type="hidden" name="fund_id" value="<?=$fund_id?>" required/>
                <input  type="hidden" name="obligation_id" value="<?=$obligation_id?>" required/>
                <input  type="hidden" id="edit_original_amount" value="" required/>
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span></button>
                        <h4 class="modal-title">Adjusted Obligation</h4>
                    </div>
                    <div class="modal-body">
                        <div class="callout callout-danger" id="edit_error_message" style="display:none;" >
                            <p>Insufficient funds, Please check.</p>
                        </div>
                        <div class="row"> 
                            <div class="col-xs-12">
                                <div class="form-group">
                                    <label>Object</label>
                                    <input type="hidden" id="edit_obligation_details_id" name="obligation_details_id" value=""/>
                                    <input type="text" readonly="readonly" id="edit_object_details" class="form-control" value=""/>
                                </div>
                            </div>
                        </div>
                        <div class="row"> 
                            <div class="col-xs-12">
                                <div class="form-group">
                                    <label>Amount</label>
                                    <input class="form-control" type="number" id="edit_adjusted_obligation_amount" name="adjusted_amount" value="0" required/>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Cancel</button>
                        <button type="button" class="btn btn-primary" id="edit_adjusted_obligation_amount_btn">Update</button>
                    </div>
                </div>
            </form>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
    <div class="modal fade" id="add_disbursement">
        <div class="modal-dialog">
            <form method="POST" id="add_form_data_model" action="<?php echo base_url(); ?>obligations/save_new_disbursement">
                <input  type="hidden" name="year" value="<?=$year?>" required/>
                <input  type="hidden" name="fund_id" value="<?=$fund_id?>" required/>
                <input  type="hidden" name="obligation_id" value="<?=$obligation_id?>" required/>
                <input  type="hidden" id="add_obligation_details_id" name="obligation_details_id" value="" required/>
                <input  type="hidden" id="add_unpaid_obligation" value="" required/>
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span></button>
                        <h4 class="modal-title">Add Disbursement</h4>
                    </div>
                    <div class="modal-body">
                        <div class="callout callout-danger" id="add_error_message" style="display:none;" ></div>
                        <div class="row"> 
                            <div class="col-xs-12 col-md-5">
                                <div class="form-group">
                                    <label>Date</label>
                                    <div class="input-group date">
                                        <div class="input-group-addon">
                                            <i class="fa fa-calendar"></i>
                                        </div>
                                        <input type="text" class="form-control pull-right" readonly value="<?=date("m/d/Y");?>" name="date" id="date">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row"> 
                            <div class="col-xs-6">
                                <div class="form-group">
                                    <label>ADA Number</label>
                                    <input class="form-control" type="text" id="add_ada_number" name="ada_number" value="" required/>
                                </div>
                            </div>

                            <div class="col-xs-6">
                                <div class="form-group">
                                    <label>DV Number</label>
                                    <input class="form-control" type="text" id="add_dv_number" name="dv_number" value="" required/>
                                </div>
                            </div>
                        </div>
                        <div class="row"> 
                            <div class="col-xs-6">
                                <div class="form-group">
                                    <label>Net</label>
                                    <input class="form-control" type="number" id="add_net_amount" onchange="update_add_total_amount()" name="net_amount" value="0" required/>
                                </div>
                            </div>
                            <div class="col-xs-6">
                                <div class="form-group">
                                    <label>BIR</label>
                                    <input class="form-control" type="number" id="add_bir_amount" onchange="update_add_total_amount()" name="bir_amount" value="0" required/>
                                </div>
                            </div>
                        </div>
                        <div class="row"> 
                            <div class="col-xs-12">
                                <div class="form-group">
                                    <label>Total Amount</label>
                                    <input class="form-control" type="number" id="add_total_amount" readonly name="total_amount" value="" required/>
                                </div>
                            </div>
                        </div>
                        <div class="row"> 
                            <div class="col-xs-12">
                                <div class="form-group">
                                    <label>Remarks</label>
                                    <textarea class="form-control" id="add_remarks" name="remarks"></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Cancel</button>
                        <button type="button" class="btn btn-primary" id="submit_new_disbursement_btn">Add</button>
                    </div>
                </div>
            </form>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>

     <div class="modal fade" id="confirm_delete_data_modal">
            <div class="modal-dialog">
                <form method="POST" action="<?php echo base_url(); ?>obligations/delete_disbursement">
                    <input type="hidden" id="delete_id" name="disbursement_id" value="" />
                    <input type="hidden" id="delete_obligation_details_id" name="delete_obligation_details_id" value="" />
                    <input type="hidden" name="year" value="<?=$year?>" />
                    <input type="hidden" name="fund_id" value="<?=$fund_id?>" />
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span></button>
                            <h4 class="modal-title">Confirm Delete</h4>
                        </div>
                        <div class="modal-body">
                            <p> Are you sure you want to delete this Disbursement (ADA No:<span id="delete_text"></span>) ? </p>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Cancel</button>
                            <button type="button" onclick="delete_disbursement();" class="btn btn-danger" >Delete</button>
                        </div>
                    </div>
                </form>
                <!-- /.modal-content -->
            </div>
            <!-- /.modal-dialog -->
        </div>
</div>
<script type="text/javascript">
    $(document).ready(function() {
        

        $('#date').datepicker({
          autoclose: true
        }); 
        $("#edit_adjusted_obligation_amount_btn").click(function() {
            $("#edit_error_message").hide();
           var orig_amount = $("#edit_original_amount").val();
           var adjusted_amount = parseFloat($("#edit_adjusted_obligation_amount").val());
            if ( adjusted_amount > 0)  {
                if(orig_amount >= adjusted_amount) {
                   $("form#edit_form_data_model").submit();
                } else {
                    $("#edit_error_message").show();
                    $("#edit_error_message").html("<p>Amount must not be greater than the <strong>Original Amount (" + orig_amount + ")</strong>.</p>");
                }
            } else {
                $("#edit_error_message").show();
                $("#edit_error_message").html("<p>Please input amount.</p>");
            }
        });

        $("#submit_new_disbursement_btn").click(function() {
            $("#add_error_message").hide();
            $(".has-error").removeClass("has-error");
            if($.trim($("#add_dv_number").val()) == "" || $.trim($("#add_ada_number").val()) == ""  
                || $.trim($("#add_net_amount").val()) == "" || $.trim($("#add_bir_amount").val()) == "" 
                || $.trim($("#add_total_amount").val()) == ""  ) {
                $("#add_error_message").html(
                    "<p>Please fill up all the fields.</p>"
                );

                $("#add_dv_number, #add_ada_number, #add_bir_amount, #add_net_amount, #add_total_amount").each(function (i,e) {
                    if($.trim($(e).val()) == "") {
                        $(e).closest(".form-group").addClass("has-error");
                    }
                });

                $("#add_error_message").show();
            } else {
                var total_amount = parseFloat($("#add_total_amount").val()); 
                var unpaid_obligation = parseFloat($("#add_unpaid_obligation").val());
                if (total_amount > unpaid_obligation) {   
                    $("#add_total_amount").closest(".form-group").addClass("has-error");
                    $("#add_error_message").html("<p>Total amount must not greater than <strong>Unpaid Obligation (Php " + money_format(unpaid_obligation) + ")</strong>.</p>");
                    $("#add_error_message").show();
                } else {
                    $("form#add_form_data_model").submit();
                }
              
            }
        });
    });

    function show_disbursement_history(elm) {
        var tr =  $(elm).closest("tr");
        $("#disbursement_history_modal").modal("show");
        $("#disbursement_table tr:not(.initial-tr)").each(function() {
            $(this).remove();
        });
        
        var obligation_details_id = $(tr).find(".obligation_details_id").val();
        refresh_disburse_table(obligation_details_id);
    }

    function refresh_disburse_table(obligation_details_id) {
        $.post('<?=base_url();?>obligations/get_obligation_disbursement', {obligation_details_id: obligation_details_id},
            function(e){
                var new_details = "";
                var grand_total = 0;
                $(e.obligation_disbursement).each(function(a, element) {
                    new_details += "<tr>";
                    new_details += "<td><a href='#' title='Remarks' data-toggle='popover' data-placement='top'  data-trigger='hover' data-content='" + element.remarks + "'>" + element.date + "</a></td>";
                    new_details += "<td>" + element.object_code + " - " + element.object_description + "</td>";
                    new_details += "<td>" + element.ada_number + "</td>";
                    new_details += "<td>" + element.dv_number + "</td>";
                    new_details += "<td style='text-align:center'>" +  money_format(element.net_amount) + "</td>";
                    new_details += "<td style='text-align:center'>" +  money_format(element.bir_amount) + "</td>";
                    new_details += "<td style='text-align:center'>" +  money_format(element.total_amount) + "</td>";
                    new_details += "<td style='text-align:center'>" ;
                    new_details += "<a class='btn_show_details' href='javascript:void(0);' onclick='show_confirm_delete_data_modal("+ element.id + ', "'+ element.ada_number +'"' + "," + obligation_details_id + ")' title='Delete Disbursement'  style='cursor:pointer'>";
                    new_details += "<i class='fa fa-trash-o'></i>";
                    new_details += "</a>";
                    new_details += "</td>";
                    new_details += "</tr>";
                    grand_total +=  parseFloat(element.total_amount);
                });

                new_details += "<tr class='grand_total_row'>";
                    new_details += "<td colspan='6' align='right'><strong>Grand Total</strong></td>";
                    new_details += "<td style='text-align:center'><strong>" +  money_format(grand_total) + "</strong></td>";
                    new_details += "<td></td>";
                    new_details += "</tr>";
                $("#disbursement_table").append(new_details);

                popover_show();
            }
        );
    }

    function show_add_disbursement(elm) {
        $("#add_error_message").hide();
        $(".has-error").removeClass("has-error");
        var tr =  $(elm).closest("tr");

        $("#add_unpaid_obligation").val( $(tr).find(".unpaid_obligation").val())
        $("#add_obligation_details_id").val( $(tr).find(".obligation_details_id").val());

        $("#add_dv_number").val("");
        $("#add_ada_number").val("");  
        $("#add_net_amount").val(0); 
        $("#add_bir_amount").val(0); 
        $("#add_total_amount").val(0);
        $("#add_disbursement").modal("show");
        return false;
    }

    function update_add_total_amount() {
        var bir_amount = parseFloat($("#add_bir_amount").val());
        var net_amount = parseFloat($("#add_net_amount").val());
        
        $("#add_total_amount").val(parseFloat(bir_amount + net_amount).toFixed(2));
    }

    function show_edit_adjusted_amount(elm) {
        var tr =  $(elm).closest("tr");
        $("#edit_original_amount").val( $(tr).find(".original_amount").val())
        $("#edit_adjusted_obligation_amount").val( $(tr).find(".adjusted_obligation_amount").val());
        $("#edit_obligation_details_id").val( $(tr).find(".obligation_details_id").val());
        $("#edit_object_details").val($(tr).find(".object_details").html());
        $("#edit_adjusted_amount_modal").modal("show");
    }
    

    function select_fund() {
        location.href = '<?=base_url()?>obligations/disbursement?fund_id=' + $("#select_fund_id").find("option:selected").val() + '&year=' + $("#select_year").find("option:selected").val() + '&obligation_id=' + $("#select_obligation_id").find("option:selected").val();
    }

    function money_format(n) {
        n = parseFloat(n).toFixed(2);
        return Number(n).toLocaleString('en');
    }

    function get_fund_obligation_numbers() {
        $("#select_obligation_id").prop("disabled", true); 
        $.get("<?=base_url();?>obligations/get_fund_obligation_numbers?fund_id=" + $("#select_fund_id").find("option:selected").val() + "&year=" +  $("#select_year").find("option:selected").val(), 
            function(e) {
                var data_options = "";
                $.each(e.fund_obligations, function (i, data) {
                    data_options += "<option value='" + data.id + "'>" + data.obligation_no + "</option>";
                });
                $("#select_obligation_id").prop("disabled", false); 
                $("#select_obligation_id").html(data_options);
            }
        );
    }

    function popover_show() {
        $('[data-toggle="popover"]').popover(); 
    }

    function show_confirm_delete_data_modal(delete_id, delete_text, obligation_details_id) {
        $("#delete_id").val(delete_id);
        $("#delete_obligation_details_id").val(obligation_details_id);
        $("#delete_text").html(delete_text);
        $("#confirm_delete_data_modal").modal("show");
    }

    function delete_disbursement() {
        param = { disbursement_id: $("#delete_id").val() };
        $("#disbursement_history_modal").modal("show");
        $("#disbursement_table tr:not(.initial-tr)").each(function() {
            $(this).remove();
        });
        $("#confirm_delete_data_modal").modal('toggle');

        $.post("<?php echo base_url(); ?>obligations/delete_disbursement", param, function(e) {
            if(e.success) {
               
              
                refresh_disburse_table( $("#delete_obligation_details_id").val());
            }
        }, 'json');

    }
</script>