
<div class="content-wrapper">
<!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
        NORSA
        <small></small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="#"> Home</a></li>
            <li><a href="#">Tables</a></li>
            <li class="active">Data tables</li>
        </ol>
    </section>
    <section class="content">
        <div class="row">
            <div class="col-xs-12 col-md-12">
                <div class="row">
                    <div class="col-xs-12 col-md-2">
                        <div class="form-group">
                            <label>Year</label>
                            <select class="form-control" name="year" id="select_year">
                                <?php for($dyear=(date("Y") - 1); $dyear <= (date("Y") + 2); $dyear++): ?>
                                    <option <?= $year == $dyear ? 'selected' : '' ?> value="<?=$dyear?>" ><?=$dyear?></option>
                                <?php  endfor; ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-xs-12 col-md-6">
                        <div class="form-group">
                            <label>Funds</label>
                            <select class="form-control select_two" name="fund_id" id="select_fund_id" onchange="get_fund_obligation_numbers()">
                                <?php foreach($fund_list as $fl): ?>
                                    <option <?= $fund_id == sha1($fl->id) ? 'selected' : '' ?> value="<?= sha1($fl->id)?>"><?=$fl->name?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-xs-12 col-md-3">
                        <div class="form-group">
                            <label>Obligation Number</label>
                            <select class="form-control select2_obligation_number" id="select_obligation_id" name="select_obligation_id" style="width: 100%;" disabled>
                                <?php foreach($fund_obligations as $fo): ?>
                                    <option <?= $obligation_id == $fo->id ? 'selected' : '' ?> value="<?=$fo->id?>"><?=$fo->obligation_no?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-xs-12 col-md-1">
                        <div style="padding-top:24px;">
                            <input type="button" class="btn btn-primary" style="width: 100%;" onclick="select_fund()" value="Show" />
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-xs-12">
                <div class="box">
                    <div class="box-header">
                        <h3 class="box-title"><?=$fund_id==sha1(1) ? 'New General Appropriations' : 'Continuing Appropriations' ?></h3>
                        <div class=" pull-right">
                            <a clas="btn" href="javascript:void(0)" id="show_add_details_modal">
                                <i class="fa fa-plus"></i> New Object
                            </a>
                        </div>
                    </div>
                    <div class="box-body table-responsive">
                    <table class="table table-bordered">
                        <tr>
                            <th class="align-middle">Date</th>
                            <th class="align-middle">Object</th>
                            <th class="align-middle">RC</th>
                            <th class="align-middle">Prexc</th>
                            <th style="width:150px; " class="align-middle-center">Obligation</th>
                            <th style="width:150px; " class="align-middle-center">NORSA</th>
                            <th style="width:150px; " class="align-middle-center">Adjusted Obligation</th>
                            <th style="width:150px; " class="align-middle-center">Creator</th>
                            <th style="width:100px; text-align: center;">Action</th>
                        </tr>
                        <?php if(count($obligation_details) > 0): ?>
                            <?php $grand_total = 0; ?>
                            <?php foreach($obligation_details as $od): ?>
                                <?php $grand_total += ($od->norsa == 0) ?  $od->amount : $od->adjusted_amount; ?>
                                <tr>
                                    <td>
                                        <input type="hidden" class="obligation_details_id" value="<?=$od->id?>">
                                        <input type="hidden" class="total_amount_paid" value="<?=$od->total_amount_paid?>">
                                        <input type="hidden" class="object_id" value="<?=$od->object_id?>">
                                        <input type="hidden" class="fund_rc_id" value="<?=$od->fund_rc_id?>">
                                        <input type="hidden" class="prexc_id" value="<?=$od->prexc_id?>">
                                        <input type="hidden" class="norsa_amount" value="<?=$od->norsa?>">
                                        <?=$od->date?>
                                    </td>
                                    <td class="object_details"><?=$od->object_code ." - " . $od->object_description?></td>
                                    <td class="object_details"><?=$od->rc_code ." - " . $od->rc_description?></td>
                                    <td class="object_details"><?=$od->prexc_code ." - " . $od->prexc_description?></td>
                                    <td class="align-middle-center"><input type="hidden" class="original_amount" value="<?=$od->amount?>"><?=money_format($od->amount)?></td>
                                    <td class="align-middle-center">
                                        <a href="#" onclick="show_norsa_history(this); return false;" title="View NORSA History">
                                            <?=money_format($od->norsa)?> <i class="fa fa-search"></i>
                                        </a>
                                    </td>
                                    <td class="align-middle-center"><?=money_format(($od->norsa == 0) ?  $od->amount : $od->adjusted_amount)?></td>
                                    <td class="align-middle-center"><?=$od->created_name?></td>
                                    <td class="align-middle-center" style="width:100px; text-align: left; padding-left: 30px;">
                                        <input type="hidden" class="adjusted_obligation_amount" value="<?=$od->adjusted_amount?>">
                                        <?php $onclick_edit = "alert('Only the creator and admin can update this ORS NORSA'); return false;";   ?>
                                        <?php if($login_user_data["id"]  == $od->created_id || $login_user_data["type"] == 1 ) : ?>
                                            <?php $onclick_edit = "show_edit_adjusted_amount(this); return false;"; ?>
                                        <?php endif; ?>
                                        <a href="#" onclick="<?=$onclick_edit?>" title="Update adjusted obligation" style="padding-right: 10px; <?= ($login_user_data["id"]  == $od->created_id || $login_user_data["type"] == 1) ? 'cursor:pointer;' :  'cursor: not-allowed;' ?> " >
                                            <i class="fa fa-pencil-square-o"></i> 
                                        </a>

                                        <?php if(!$od->has_disbursement && !$od->has_norsa && $login_user_data['type'] == 1) : ?>
                                            <a class="btn_show_details" href="javascript:void(0);" onclick='show_confirm_delete_data_modal("<?=$od->id?>", "<?=$od->rc_code . " - " . $od->rc_description ;?>",  "<?=$od->prexc_code . " - " . $od->prexc_description ;?>", "<?=$od->object_code . " - " . $od->object_description ;?>")' title="Delete" onclick="" style="cursor:pointer">
                                                <i class="fa fa-trash-o"></i> 
                                            </a>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                            <tr>
                                <td colspan="6" align="right">Grand Total</td>
                                <td align="center"><?=money_format($grand_total)?></td>
                                <td></td>
                                <td></td>
                            </tr>
                        <?php else: ?>
                            <tr>
                                <td colspan="9" align="center">No Result(s) found.</td>
                            </tr>
                        <?php endif;?>
                            
                    </table>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <div class="modal fade" id="norsa_history_modal">
        <div class="modal-dialog modal-lg">
            <form method="POST" action="<?php echo base_url(); ?>prexc/add_prexc">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">NORSA History</h4>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-xs-12">
                                <div class="box-body table-responsive">
                                    <table class="table table-bordered" id="norsa_table">
                                        <tr  class="initial-tr" style="background-color: #626263;">
                                            <th>Date</th>
                                            <th>Object</th>
                                            <th>NORSA</th>
                                            <th>Adjusted Obligation</th>
                                        </tr>
                                    </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary" data-dismiss="modal" id="add_data_btn">Close</button>
                    </div>
                </div>
            </form>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>

    <div class="modal fade" id="edit_adjusted_amount_modal">
        <div class="modal-dialog">
            <form method="POST" id="edit_form_data_model" action="<?php echo base_url(); ?>obligations/edit_norsa_amount">
                <input  type="hidden" name="year" value="<?=$year?>" required/>
                <input  type="hidden" name="fund_id" value="<?=$fund_id?>" required/>
                <input  type="hidden" name="obligation_id" value="<?=$obligation_id?>" required/>
                <input  type="hidden" id="edit_total_amount_paid" value=""/>
                <input  type="hidden" id="edit_original_amount" value="" required/>
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span></button>
                        <h4 class="modal-title">NORSA</h4>
                    </div>
                    <div class="modal-body">
                        <div class="callout callout-danger" id="edit_error_message" style="display:none;" >
                            <p>Insufficient funds, Please check.</p>
                        </div>
                        <div class="row"> 
                            <div class="col-xs-12">
                                <div class="form-group">
                                    <label>Object</label>
                                    <input type="hidden" id="edit_obligation_details_id" name="obligation_details_id" value=""/>
                                    <input type="text" readonly="readonly" id="edit_object_details" class="form-control" value=""/>
                                </div>
                            </div>
                        </div>
                        <div class="row"> 
                            <div class="col-xs-12">
                                <div class="form-group">
                                    <label>NORSA Amount</label>
                                    <input class="form-control" type="number" id="edit_norsa_amount" name="adjusted_amount" value="0" required/>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Cancel</button>
                        <button type="button" class="btn btn-primary" id="edit_norsa_amount_btn">Update</button>
                    </div>
                </div>
            </form>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>

    <div class="modal fade" id="confirm_delete_data_modal">
        <div class="modal-dialog">
            <form method="POST" action="<?php echo base_url(); ?>obligations/delete_obligation_object">
                <input type="hidden" id="delete_id" name="obligation_details_id" value="" />
                <input type="hidden" name="year" value="<?=$year?>" />
                <input type="hidden" name="obligation_id" value="<?=$obligation_id?>" />
                <input type="hidden" name="fund_id" value="<?=$fund_id?>" />
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span></button>
                        <h4 class="modal-title">Confirm Delete</h4>
                    </div>
                    <div class="modal-body">
                        <p> Are You sure you want to delete this? </p>
                        <br/>
                        <table class="table table-bordered">
                            <tr>
                                <th class="align-middle">Object</th>
                                <th class="align-middle">RC</th>
                                <th class="align-middle">Prexc</th>
                            </tr>
                            <td class="align-middle" id="delete_object"></td>
                            <td class="align-middle" id="delete_rc"></td>
                            <td class="align-middle" id="delete_prexc"></td>
                        </table>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-danger" >Delete</button>
                    </div>
                </div>
            </form>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>

    <div class="modal fade" id="add_details_modal">
        <div class="modal-dialog">
            <form method="POST" id="form_add_details" action="<?php echo base_url(); ?>obligations/add_obligation_object">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span></button>
                        <h4 class="modal-title">Add Details</h4>
                    </div>
                    <div class="modal-body">
                        <div class="callout callout-danger" id="add_error_message" style="display:none;" >
                            <p>Insufficient funds, Please check.</p>
                        </div>

                        <input type="hidden" name="obligation_id" value="<?=$obligation_id?>" >
                        <input type="hidden" name="fund_id" value="<?=$fund_id?>" >
                        <input type="hidden" name="year" value="<?=$year?>" >
                        <div class="row"> 
                            <div class="col-xs-12">
                                <div class="form-group">
                                    <label>Prexc</label>
                                    <select class="form-control select_two" id="select_prexc_id" name="prexc_id" style="width: 100%">
                                        <?php if(count($prexc) > 0): ?>
                                            <?php foreach($prexc as $ppa): ?>
                                                <option value="<?=$ppa->id?>"><?=$ppa->code ." - " . $ppa->description ?></option>
                                            <?php endforeach; ?>
                                        <?php endif;?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row"> 
                            <div class="col-xs-12">
                                <div class="form-group">
                                <label>Responsibility Center</label>
                                    <select class="form-control select_two" id="select_fund_rc_id" name="fund_rc_id" style="width: 100%">
                                    </select>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row"> 
                            <div class="col-xs-12">
                                <div class="form-group">
                                <label>Object of Expenditures</label>
                                    <select class="form-control select_two" id="select_object_id" name="object_id" style="width: 100%">
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row"> 
                            <div class="col-xs-12">
                                <div class="form-group">
                                <label>Amount</label>
                                    <input type="number" id="amount" name="amount" class="form-control" />
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Cancel</button>
                        <button type="button" class="btn btn-primary" id="add_details_btn">Add</button>
                    </div>
                </div>
            </form>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
    
</div>
<script type="text/javascript">
    $(document).ready(function() {
        $("#select_obligation_id").prop("disabled", false)
        
        $('#date').datepicker({
          autoclose: true
        });
        $("#edit_norsa_amount_btn").click(function() {
            $("#edit_error_message").hide();
            var orig_amount = $("#edit_original_amount").val();
            var total_amount_paid = $("#edit_total_amount_paid").val();
            var unpaid_obligation = parseFloat(orig_amount - total_amount_paid).toFixed(2); ;
            var adjusted_amount = parseFloat($("#edit_norsa_amount").val());

            if (adjusted_amount <= unpaid_obligation)  { 
                if(orig_amount >= adjusted_amount) {
                    $("form#edit_form_data_model").submit();
                } else {
                    $("#edit_error_message").show();
                    $("#edit_error_message").html("<p>Amount must not be greater than the <strong>Original Amount (" + orig_amount + ")</strong>.</p>");
                }
            } else {
                $("#edit_error_message").show();
                $("#edit_error_message").html("<p>Amount must not be greater than the <strong>Unpaid Obligation Amount (" + total_amount_paid + ")</strong>.</p>");
            }
        });

        $("#select_fund_rc_id").change(function(){
            get_rc_objects_json();
        });

        $("#add_details_btn").click(function() {
            $("#add_error_message").hide();
            //check if duplicate
            var fund_rc_id = $("#select_fund_rc_id").find(":selected").val();
            var prexc_id = $("#select_prexc_id").find(":selected").val();
            var object_id = $("#select_object_id").find(":selected").val();
            var is_duplicate = false;
            if ($(".object_id").length > 0) {
                $(".object_id").each(function (i,td_obj) {
                    var _tr = $(td_obj).closest("tr");
                    if($(td_obj).val() == object_id && $(_tr).find(".fund_rc_id").val() == fund_rc_id && $(_tr).find(".prexc_id").val() == prexc_id ){
                        $("#add_error_message").show();
                        $("#add_error_message").html("<p>Duplicate <strong>Object</storng> with same <strong>RC (Responsibility Center)</storng> and <strong>PREXC</storng> is not allowed.</p>");
                        is_duplicate = true;
                        return false;
                    }
                });
            }

            if(!is_duplicate) {
                if($("#amount").val() > 0) {
                    var _data = {
                            object_id: $("#select_object_id").val(),
                            fund_id: "<?=sha1($fund_id);?>",
                            fund_rc_id: $("#select_fund_rc_id").val(),
                            prexc_id: $("#select_prexc_id").val(),
                            date: "<?=$obligation ? $obligation->date : '' ;?>",
                            legal_basis_id: "<?=$obligation ? $obligation->legal_basis_id : '';?>",
                        };
                        $.post('<?=base_url();?>allotment/get_available_allotment_received', _data,
                            function(e){

                                if(e.available_amount >= parseFloat($("#amount").val())) {
                                    $("form#form_add_details").submit();
                                
                                
                                } else {
                                    $("#add_error_message").show();
                                    $("#add_error_message").html("<p>Insufficient <strong><a href='<?=base_url()?>/allotment/list?"+ e.url_param +"' target='_blank'>Allotment Received (Php "+ money_format(e.available_amount.toString()) +")</a>  for this Object</strong>, Please check.</p>");
                                }
                            }
                        );
                
                } else {
                    $("#add_error_message").show();
                    $("#add_error_message").html("<p>Please input amount.</p>");
                }
            }
        });

        $("#show_add_details_modal").click(function() {
            var date = new Date($("#date").val());
            $("#amount").val(0);
            $("#add_details_modal").modal("show");
            $.get("<?=base_url();?>funds/get_fund_rc?fund_id=<?=$fund_id?>&year=<?=$year?>", 
                function(e) {
                    var rc_options = "";
                    $.each(e.fund_rc, function (i,frc) {
                        rc_options += "<option value='" + frc.fund_rc_id + "'>" + frc.code + " - " + frc.description + "</option>";
                    });
                    $("#select_fund_rc_id").html(rc_options);
                    get_rc_objects_json();
                }
            );
        });
    });

    function get_rc_objects_json() {
        var fund_rc_id = $("#select_fund_rc_id").find(":selected").val();
        var prexc_id = $("#select_prexc_id").find(":selected").val();
        $.get("<?=base_url();?>funds/get_rc_objects_json?fund_rc_id=" + fund_rc_id, 
            function(e) {

                var objects = "";
                $.each(e.rc_objects, function (i,obj) {
                    //var not_duplicate = true;
                    // if ($(".object_id").length > 0) {
                    //     $(".object_id").each(function (i,td_obj) {
                    //         var _tr = $(td_obj).closest("tr");
                    //         if($(td_obj).val() ==  obj.object_id && $(_tr).find(".fund_rc_id").val() == fund_rc_id && $(_tr).find(".prexc_id").val() == prexc_id ){
                    //             not_duplicate = false;
                    //         }
                    //     });
                    // }

                    //if(not_duplicate ) {
                        objects = objects + "<option value='" + obj.object_id + "'>" + obj.code + " - " + obj.allotment_class + " - " + obj.description  + "</option>";
                    //}
                });


                $("#select_object_id").html(objects);
            }
        );
    }

    function show_norsa_history(elm) {
        var tr =  $(elm).closest("tr");
        $("#norsa_history_modal").modal("show");
        $("#norsa_table tr:not(.initial-tr)").each(function() {
            $(this).remove();
        });
        $.post('<?=base_url();?>obligations/get_obligation_norsa', {obligation_details_id: $(tr).find(".obligation_details_id").val()},
            function(e){
                var new_details = "";
                var grand_total = 0;
                $(e.obligation_disbursement).each(function(a, elm) {
                    new_details += "<tr>";
                    new_details += "<td>" + elm.date + "</td>";
                    new_details += "<td>" + elm.object_code + " - " + elm.object_description + "</td>";
                    new_details += "<td>" + elm.norsa + "</td>";
                    new_details += "<td>" + elm.adjusted_amount + "</td>";
                    new_details += "</tr>";
                });

                $("#norsa_table").append(new_details);
            }
        );
    }

    function show_edit_adjusted_amount(elm) {
        var tr =  $(elm).closest("tr");
        $("#edit_original_amount").val( $(tr).find(".original_amount").val());
        $("#edit_total_amount_paid").val( $(tr).find(".total_amount_paid").val());
        $("#edit_norsa_amount").val( $(tr).find(".norsa_amount").val());
        $("#edit_obligation_details_id").val( $(tr).find(".obligation_details_id").val());
        $("#edit_object_details").val($(tr).find(".object_details").html());
        $("#edit_adjusted_amount_modal").modal("show");
    }
    

    function select_fund() {
        location.href = '<?=base_url()?>obligations/norsa?fund_id=' + $("#select_fund_id").find("option:selected").val() + '&year=' + $("#select_year").find("option:selected").val() + '&obligation_id=' + $("#select_obligation_id").find("option:selected").val();
    }

    function money_format(n) {
        n = parseFloat(n).toFixed(2);
        return Number(n).toLocaleString('en');
    }

    function get_fund_obligation_numbers() {
        $("#select_obligation_id").prop("disabled", true); 
        $.get("<?=base_url();?>obligations/get_fund_obligation_numbers?fund_id=" + $("#select_fund_id").find("option:selected").val() + "&year=" +  $("#select_year").find("option:selected").val(), 
            function(e) {
                var data_options = "";
                $.each(e.fund_obligations, function (i, data) {
                    data_options += "<option value='" + data.id + "'>" + data.obligation_no + "</option>";
                });
                $("#select_obligation_id").prop("disabled", false); 
                $("#select_obligation_id").html(data_options);
            }
        );
    }

    function show_confirm_delete_data_modal(delete_id, rc, prexc, object) {
        $("#delete_id").val(delete_id);
        $("#delete_rc").html(rc);
        $("#delete_prexc").html(prexc);
        $("#delete_object").html(object);
        $("#confirm_delete_data_modal").modal("show");
    }
</script>