<style>
   .has-error > .select2-container--default .select2-selection--single {
    border: 1px solid #dd4b39 !important;
   }
</style>

<!-- Content Wrapper. Contains page content -->

<div class="content-wrapper">
<!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
        Obligation Request
        <small></small>
        </h1>
        <ol class="breadcrumb">
        <li><a href="#"> Home</a></li>
        <li><a href="#">Tables</a></li>
        <li class="active">Data tables</li>
        </ol>
    </section>

    <section class="content">
        <div class="callout callout-danger" id="main_error_message" style="display:none;" >
            <p>Please Fill up all the fields.</p>
        </div>
        <div class="row">
            <div class="col-xs-12">
                <div class="box box-primary">
                    <div class="box-header">
                        <h3 class="box-title">Request</h3>
                    </div>
                    <div class="box-body">
                        <form method="POST" id="form_new_data" action="<?php echo base_url(); ?>obligations/save_new">
                            <div class="row"> 
                                <div class="col-xs-12 col-md-3">
                                    <div class="form-group">
                                        <label>No.</label>
                                        <div class="input-group date">
                                            <span class="input-group-addon" id="prefix_ors"><?=date("Y-m-");?></span>
                                            <input type="number" maxlength="6" onkeypress="return (event.charCode == 8 || event.charCode == 0 || event.charCode == 13) ? null : event.charCode >= 48 && event.charCode <= 57" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" placeholder="Last 6 digits on ORS number" id="obligation_no_text" class="form-control"/>
                                        </div>
                                        <input name="obligation_no" type="hidden" id="obligation_no" class="form-control"/>
                                    </div>
                                </div>
                                <div class="col-xs-12 col-md-3">
                                    <div class="form-group">
                                        <label>Date</label>
                                        <div class="input-group date">
                                            <div class="input-group-addon">
                                                <i class="fa fa-calendar"></i>
                                            </div>
                                            <input type="text" class="form-control pull-right" readonly value="<?=date("m/d/Y");?>" name="date" id="date">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row"> 
                                <div class="col-xs-12">
                                    <div class="form-group">
                                        <label>Fund</label>
                                        <select class="form-control select_two" id="select_fund_id" name="fund_id" onchange="get_fund_legal_basis()" style="width: 100%;" >
                                            <?php foreach($fund_list as $fl): ?>
                                                <option value="<?= sha1($fl->id)?>"><?=$fl->name?></option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="row"> 
                                <div class="col-xs-12">
                                    <div class="form-group">
                                        <label>Legal Basis</label>
                                        <select class="form-control select_two" id="select_legal_basis_id" name="legal_basis_id" style="width: 100%;">
                                            <?php foreach($fund_legal_basis as $flb): ?>
                                                <option value="<?=$flb->id?>"  <?=strpos($flb->name, date("Y")) !== false ? 'SELECTED' : ''?> ><?=$flb->name?></option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div class="row"> 
                                <div class="col-xs-12">
                                    <div class="form-group">
                                    <label>Payee</label>
                                        <select class="form-control select_two" id="select_payee_id" name="payee_id" style="width: 100%;" >
                                            <option value=""></option> <!--added by:pido-->
                                            <?php foreach($payees as $p): ?>
                                                <option value="<?=$p->id?>"><?=$p->description?></option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="row"> 
                                <div class="col-xs-12">
                                    <div class="form-group">
                                    <label>Office</label>
                                        <select class="form-control select_two" id="select_office_id" name="office_id" style="width: 100%;" >
                                            <option value=""></option> <!--added by:pido-->
                                            <?php foreach($offices as $office): ?>
                                                <option value="<?=$office->id?>"><?=$office->name?></option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="row"> 
                                <div class="col-xs-12">
                                    <div class="form-group">
                                    <label>Address</label>
                                        <textarea class="form-control" id="address" name="address"></textarea>
                                    </div>
                                </div>
                            </div>
                            <div class="row"> 
                                <div class="col-xs-12">
                                    <div class="form-group">
                                    <label>Particulars</label>
                                        <textarea class="form-control" id="particulars" name="particulars"></textarea>
                                    </div>
                                </div>
                            </div>
                                                
                            <br/>
                            <div class="row"> 
                                <div class="col-xs-12">
                                    <label>Details</label>
                                    <div class="pull-right">
                                        <a class="btn" id="show_add_details_modal">
                                            <i class="fa fa-plus"></i> Add
                                        </a>
                                    </div>
                                    <table id="details_table" class="table table-bordered">
                                        <tr>
                                            <th>Prexc</th>
                                            <th>Responsibility Center</th>
                                            <th>Object</th>
                                            <th style="width:100px; text-align:center;">Amount</th>
                                            <th style='width:70px; text-align:center;'>Action</th>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                            
                        </form>
                    </div>
                    <div class="box-footer">
                        <div class="pull-right">
                        <button type="button" id="submit_new_allotment_btn" class="btn btn-primary">Submit</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="modal fade" id="add_details_modal">
            <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span></button>
                            <h4 class="modal-title">Add Details</h4>
                        </div>
                        <div class="modal-body">
                            <div class="callout callout-danger" id="add_error_message" style="display:none;" >
                                <p>Insufficient funds, Please check.</p>
                            </div>
                            <div class="row"> 
                                <div class="col-xs-12">
                                    <div class="form-group">
                                        <label>Prexc</label>
                                        <select class="form-control select_two" id="select_prexc_id" style="width: 100%">
                                            <?php if(count($prexc) > 0): ?>
                                                <option value=""></option>
                                                <?php foreach($prexc as $ppa): ?>
                                                    <option value="<?=$ppa->id?>"><?=$ppa->code ." - " . $ppa->description ?></option>
                                                <?php endforeach; ?>
                                            <?php endif;?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row"> 
                                <div class="col-xs-12">
                                    <div class="form-group">
                                    <label>Responsibility Center</label>
                                        <select class="form-control select_two" id="select_fund_rc_id" style="width: 100%">
                                        </select>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row"> 
                                <div class="col-xs-12">
                                    <div class="form-group">
                                    <label>Object of Expenditures</label>
                                        <select class="form-control select_two" id="select_object_id" style="width: 100%">
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="row"> 
                                <div class="col-xs-12">
                                    <div class="form-group">
                                    <label>Amount</label>
                                        <input type="number" id="amount" class="form-control" />
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Cancel</button>
                            <button type="button" class="btn btn-primary" id="add_details_btn">Add</button>
                        </div>
                    </div>
                </form>
                <!-- /.modal-content -->
            </div>
            <!-- /.modal-dialog -->
        </div>
    </section>
</div>
<script type="text/javascript">

    $(document).ready(function() {
       
        $("#obligation_no").blur(function() {
            
        });

        $('#date').datepicker({
          autoclose: true
        });

        $('#date, #obligation_no_text').change(function() {
            get_fund_legal_basis();
            var obligation_no_text = $("#obligation_no_text").val();
            var date = $('#date').val().split("/");
            var prefix_ors = date[2] + "-" + date[0] + "-";
            var ors_number = prefix_ors + $.trim($("#obligation_no_text").val());
            // var ors_number = $.trim($("#obligation_no_text").val());
            $("#prefix_ors").text(prefix_ors);
            $("#obligation_no").val(ors_number);
                $("#main_error_message").hide();
                $("#obligation_no_text").closest(".form-group").removeClass("has-error");
                $('#submit_new_allotment_btn').prop('disabled', false);
            
            if(obligation_no_text.length < 6) {
                $("#main_error_message").html( "<p>ORS Number mas be 6 digits and number only</p>");
                $("#obligation_no_text").closest(".form-group").addClass("has-error");
                $("#main_error_message").show();
                $('#submit_new_allotment_btn').prop('disabled', true);
            } else {
                
                $.post('<?=base_url();?>obligations/check_if_obligation_number_exist', {obligation_no: ors_number , obligation_id: false, year: date[2] },
                    function(e){
                        if(e.exist) {
                            
                            $("#main_error_message").html( "<p>"+e.message+".</p>");
                            $("#obligation_no_text").closest(".form-group").addClass("has-error");
                            $("#main_error_message").show();
                            $('#submit_new_allotment_btn').prop('disabled', true);
                        } else {
                            $('#submit_new_allotment_btn').prop('disabled', false);
                        }
                },'JSON');
            }
        });

         $("#select_fund_rc_id").change(function(){
            get_rc_objects_json();
         });

        
        $("#submit_new_allotment_btn").click(function() {
            $("#main_error_message").hide();
            $(".has-error").removeClass("has-error");
            if( $("#select_payee_id option:selected").val() == "" || $("#select_office_id option:selected").val() == "" || 
                $.trim($("#particulars").val()) == "" || $.trim($("#obligation_no").val()) == ""  || $(".add_amount").length <= 0  ) {
                $("#main_error_message").html(
                    "<p>Please fill up all the fields.</p>"
                );
                $("#particulars, #obligation_no").each(function (i,e) {
                    if($.trim($(e).val()) == "") {
                        $(e).closest(".form-group").addClass("has-error");
                    }
                });

                if ($("#select_payee_id option:selected").val() == "") {
                    $("#select_payee_id").closest(".form-group").addClass("has-error");
                    $("#main_error_message").append("<p>Please Choose payee.</p>");
                }
                
                if ($("#select_office_id option:selected").val() == "") {
                    $("#select_office_id").closest(".form-group").addClass("has-error");
                    $("#main_error_message").append("<p>Please choose office.</p>");
                }

                if ($(".add_amount").length <= 0) {
                    $("#details_table").closest(".form-group").addClass("has-error");
                    $("#main_error_message").append("<p>Please add details.</p>");
                }

               
                $("#main_error_message").show();
            } else {
                $("form#form_new_data").submit();
            }
        });

        $("#add_details_btn").click(function() {
            $("#add_error_message").hide();
            //check if duplicate
            var fund_rc_id = $("#select_fund_rc_id").find(":selected").val();
            var prexc_id = $("#select_prexc_id").find(":selected").val();
            var object_id = $("#select_object_id").find(":selected").val();
            var is_duplicate = false;
            if ($(".add_object_id").length > 0) {
                $(".add_object_id").each(function (i,td_obj) {
                    var _tr = $(td_obj).closest("tr"); 
                    if($(td_obj).val() == object_id && $(_tr).find(".add_fund_rc_id").val() == fund_rc_id && $(_tr).find(".add_prexc_id").val() == prexc_id ){
                        $("#add_error_message").show();
                        $("#add_error_message").html("<p>Duplicate <strong>Object</storng> with same <strong>RC (Responsibility Center)</storng> and <strong>PREXC</storng> is not allowed.</p>");
                        is_duplicate = true;
                        return false;
                    }
                });
            }

            if(!is_duplicate) {
                if($("#amount").val() > 0) {
                    var _data = {
                            object_id: $("#select_object_id").val(),
                            fund_id: $("#select_fund_id").val(),
                            fund_rc_id: $("#select_fund_rc_id").val(),
                            prexc_id: $("#select_prexc_id").val(),
                            date: $("#date").val(),
                            legal_basis_id: $("#select_legal_basis_id").val(),
                        };
                        $.post('<?=base_url();?>allotment/get_available_allotment_received', _data,
                            function(e){

                                if(e.available_amount >= parseFloat($("#amount").val())) {
                                    var new_details = "<tr>";
                                        new_details += "<td><input class='add_prexc_id' name='prexc_ids[]' type='hidden' value='"+ $("#select_prexc_id").val() +"'/>" + $("#select_prexc_id").find(":selected").text() + "</td>";
                                        new_details += "<td><input class='add_fund_rc_id' name='fund_rc_ids[]' type='hidden' value='"+ $("#select_fund_rc_id").val() +"'/>" + $("#select_fund_rc_id").find(":selected").text() + "</td>";
                                        new_details += "<td><input class='add_object_id' name='object_ids[]' type='hidden' value='"+ $("#select_object_id").val() +"'/>" + $("#select_object_id").find(":selected").text() + "</td>";
                                        new_details += "<td style='text-align:center; vertical-align:middle;'><input class='add_amount' name='amounts[]' type='hidden' value='"+ $("#amount").val() +"'/>" + money_format($("#amount").val()) + "</td>";
                                        new_details += "<td style='text-align:center;'><a class='btn' title='Delete' onclick='remove_details(this);'><i class='fa fa-trash-o'></i></a>";
                                    new_details += "<tr>";
                                
                                $("#details_table").append(new_details);
                                $("#add_details_modal").modal("hide");

                                } else {
                                    $("#add_error_message").show();
                                    $("#add_error_message").html("<p>Insufficient <strong><a href='<?=base_url()?>/allotment/list?"+ e.url_param +"' target='_blank'>Allotment Received (Php "+ money_format(e.available_amount.toString()) +")</a>  for this Object</strong>, Please check.</p>");
                                }
                            }
                        );
                
                } else {
                    $("#add_error_message").show();
                    $("#add_error_message").html("<p>Please input amount.</p>");
                }
            }
        });

        function money_format(n) {
            n = parseFloat(n).toFixed(2);
            return Number(n).toLocaleString('en');
        }

        $("#show_add_details_modal").click(function() {
            $("#add_error_message").hide();
            var date = new Date($("#date").val());
            $("#amount").val(0);
            $("#add_details_modal").modal("show");
            $.get("<?=base_url();?>funds/get_fund_rc?fund_id=" + $("#select_fund_id").val() + "&year=" + date.getFullYear(), 
                function(e) {
                    var rc_options = "<option></option>"; //added <option></option> by: pido
                    $.each(e.fund_rc, function (i,frc) {
                        rc_options += "<option value='" + frc.fund_rc_id + "'>" + frc.code + " - " + frc.description + "</option>";
                    });
                    $("#select_fund_rc_id").html(rc_options);
                    get_rc_objects_json();
                }
            );
        });
    });

    function remove_details(btn) {
        $(btn).closest("tr").remove();
    }

    function get_rc_objects_json() {
        var fund_rc_id = $("#select_fund_rc_id").find(":selected").val();
        $.get("<?=base_url();?>funds/get_rc_objects_json?fund_rc_id=" + fund_rc_id, 
            function(e) {
                var objects = "<option value=''></option>";//Added <option value=''></option> - by: pido
                $.each(e.rc_objects, function (i,obj) {
                    // var not_duplicate = true;
                    // if ($(".add_object_id").length > 0) {
                    //     $(".add_object_id").each(function (i,td_obj) {
                    //         var _tr = $(td_obj).closest("tr");
                    //         if($(td_obj).val() ==  obj.object_id && $(_tr).find(".add_fund_rc_id").val() == fund_rc_id){
                    //             not_duplicate = false;
                    //         }
                    //     });
                    // }

                    // if(not_duplicate ) {
                        objects = objects + "<option value='" + obj.object_id + "'>" + obj.code + " - " + obj.allotment_class + " - " + obj.description  + "</option>";
                    // }
                });


                $("#select_object_id").html(objects);
            }
        );
    }

    function get_fund_legal_basis() {
        var date = $('#date').val().split("/");
        var year = date[2];

        $.get("<?=base_url();?>legal_basis/get_fund_legal_basis?fund_id=" + $("#select_fund_id").val()  +  "&year=" + year, 
            function(e) {
                var lb_options = "";
                $.each(e.fund_legal_basis, function (i,flb) {
                    lb_options += "<option value='" + flb.id + "'>" + flb.name + "</option>";
                });
                $("#select_legal_basis_id").html(lb_options);
            }
        );
    }
</script>