<div class="content-wrapper">
<!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
        Obligation Status
        <small></small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="#"> Home</a></li>
            <li><a href="#">Tables</a></li>
            <li class="active">Data tables</li>
        </ol>
    </section>
    <section class="content">
        <div class="row">
            <div class="col-xs-12 col-md-12">
                <div class="row">
                    <div class="col-xs-12 col-md-2">
                        <div class="form-group">
                            <label>Year</label>
                            <select class="form-control" name="year" id="select_year" onchange="get_fund_legal_basis()">
                                <?php for($dyear=(date("Y") - 1); $dyear <= (date("Y") + 2); $dyear++): ?>
                                    <option <?= $year == $dyear ? 'selected' : '' ?> value="<?=$dyear?>" ><?=$dyear?></option>
                                <?php  endfor; ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-xs-12 col-md-6">
                        <div class="form-group">
                            <label>Funds</label>
                            <select class="form-control select_two" name="fund_id" id="select_fund_id" onchange="get_fund_legal_basis()">
                                <?php foreach($fund_list as $fl): ?>
                                    <option <?= $fund_id == sha1($fl->id) ? 'selected' : '' ?> value="<?= sha1($fl->id)?>"><?=$fl->name?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-xs-12 col-md-3">
                        <div class="form-group">
                            <label>Legal Basis</label>
                            <select class="form-control select_two" id="select_legal_basis_id" name="select_legal_basis_id" style="width: 100%;">
                                <?php foreach($fund_legal_basis as $flb): ?>
                                    <option <?= $legal_basis_id == $flb->id ? 'selected' : '' ?> value="<?=$flb->id?>"><?=$flb->name?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-xs-12 col-md-1">
                        <div style="padding-top:24px;">
                            <input type="button" class="btn btn-primary" style="width: 100%;" onclick="select_fund()" id="show_btn" value="Show" />
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-xs-12">
                <div class="box">
                    <div class="box-header">
                        <h3 class="box-title"><?=$fund_id==sha1(1) ? 'New General Appropriations' : 'Continuing Appropriations' ?></h3>
                        <?php if($login_user_data["type"] == 2 || $login_user_data["type"] == 1) : ?>
                            <div class=" pull-right">
                                <a clas="btn" href="<?=base_url();?>obligations/request">
                                    <i class="fa fa-plus"></i> Request
                                </a>
                            </div>
                        <?php endif;?>
                    </div>

                    
                    <div class="box-body table-responsive">
                    <table class="table table-bordered obligation-data-table" style="display:none;">
                        <thead>
                            <tr>
                                <th style="width:150px;">Obligation No</th>
                                <th style="width:80px;">Date</th>
                                <th style="width:150px;">Payee</th>
                                <th style="width: 100px;">Office</th>
                                <th >Particulars</th>
                                <th class="align-middle-center" style="width: 100px;">Total Amount</th>
                                <th class="align-middle-center" style="width:80px;">Creator</th>
                                <th style="width:100px; text-align: center;">Action</th>
                            </tr>
                        </thead>
                       
                    </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="modal fade" id="confirm_delete_data_modal">
            <div class="modal-dialog">
                <form method="POST" action="<?php echo base_url(); ?>obligations/delete_obligation">
                    <input type="hidden" id="delete_id" name="obligation_id" value="" />
                    <input type="hidden" name="year" value="<?=$year?>" />
                    <input type="hidden" name="legal_basis_id" value="<?=$legal_basis_id?>" />
                    <input type="hidden" name="fund_id" value="<?=$fund_id?>" />
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span></button>
                            <h4 class="modal-title">Confirm Delete</h4>
                        </div>
                        <div class="modal-body">
                            <p> Are You sure you want to delete this Obligation ( No:<span id="delete_text"></span> )? </p>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Cancel</button>
                            <button type="submit" class="btn btn-danger" >Delete</button>
                        </div>
                    </div>
                </form>
                <!-- /.modal-content -->
            </div>
            <!-- /.modal-dialog -->
        </div>

        <div class="modal fade" id="edit_obligation_modal">
        <div class="modal-dialog">
            <form method="POST" id="edit_form_obligation_details" action="<?php echo base_url(); ?>obligations/edit_obligation_details">
                <input  type="hidden" name="year" value="<?=$year?>" required/>
                <input  type="hidden" name="fund_id" value="<?=$fund_id?>" required/>
                <input  type="hidden" name="fund_id" value="<?=$legal_basis_id?>" />
                <input  type="hidden"  id="edit_obligation_id" name="obligation_id" value="" />
                <input  type="hidden"  id="edit_obligation_no_old" value="" />

                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span></button>
                        <h4 class="modal-title">Edit Obligation Details</h4>
                    </div>
                    <div class="modal-body">
                        <div class="callout callout-danger" id="edit_obligation_error_message" style="display:none;" >
                            <p>Insufficient funds, Please check.</p>
                        </div>
                        <div class="row"> 
                                <div class="col-xs-12 ">
                                    <div class="form-group">
                                        <label>No.</label>
                                        <input name="obligation_no" id="edit_obligation_no" class="form-control"/>
                                    </div>
                                </div>
                        </div>
                        <div class="row"> 
                            <div class="col-xs-12 ">
                                <div class="form-group">
                                    <label>Date</label>
                                    <div class="input-group date">
                                        <div class="input-group-addon">
                                            <i class="fa fa-calendar"></i>
                                        </div>
                                        <input type="text" class="form-control pull-right" readonly  name="date" id="edit_date">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row"> 
                            <div class="col-xs-12">
                                <div class="form-group">
                                <label>Payee</label>
                                    <select class="form-control select_two" id="edit_payee_id" name="payee_id" style="width: 100%;" >
                                        <?php foreach($payees as $p): ?>
                                            <option value="<?=$p->id?>"><?=$p->description?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row"> 
                            <div class="col-xs-12">
                                <div class="form-group">
                                <label>Office</label>
                                    <select class="form-control select_two" id="edit_office_id" name="office_id" style="width: 100%;" >
                                        <?php foreach($offices as $office): ?>
                                            <option value="<?=$office->id?>"><?=$office->name?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row"> 
                            <div class="col-xs-12">
                                <div class="form-group">
                                <label>Particulars</label>
                                    <textarea class="form-control" id="edit_particulars" name="particulars"></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Cancel</button>
                        <button type="button" class="btn btn-primary" id="edit_obligation_submit_btn">Update</button>
                    </div>
                </div>
            </form>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
    </section>

</div>
<script type="text/javascript">

    $(document).ready(function() {
        // $('#edit_date').datepicker({
        //   autoclose: true
        // });
        var data_columns = new Array();
            data_columns.push({data: 'formatted_obligation_no'});
            data_columns.push({data: 'date'});
            data_columns.push({data: 'payee_description'});
            data_columns.push({data: 'office_name'});
            data_columns.push({data: 'particulars'});
            data_columns.push({data: 'formatted_total_obligation'});
            data_columns.push({data: 'obligation_created_name'});
            data_columns.push({data: 'actions'});

        $('.obligation-data-table').DataTable( {
            'paging'      : true,
            'lengthChange': false,
           // 'searching'   : true,
            'ordering'    : false,
            'info'        : true,
            'autoWidth'   : false,
            "processing": true,
            "serverSide": true,
            "ajax": {
                url: "<?=base_url();?>obligations/get_dt_obligation_list?fund_id=<?=$fund_id?>&year=<?=$year?>&legal_basis_id=<?=$legal_basis_id?>",
                type: 'POST'
            },
            'iDisplayLength': 10,
            "columns": data_columns,
           
        } );

        $('table.obligation-data-tabl').removeClass('dataTable');
        $('.obligation-data-table').show();

        $("#edit_obligation_submit_btn").click(function() {
            $("#edit_obligation_error_message").hide();
            $(".has-error").removeClass("has-error");
            if($.trim($("#edit_particulars").val()) == "" || $.trim($("#edit_obligation_no").val()) == "") {
                $("#edit_obligation_error_message").html(
                    "<p>Please fill up all the fields.</p>"
                );
                $("#edit_particulars, #edit_obligation_no").each(function (i,e) {
                    if($.trim($(e).val()) == "") {
                        $(e).closest(".form-group").addClass("has-error");
                    }
                });

                $("#edit_obligation_error_message").show();
            } else {
                
               if($.trim($("#edit_obligation_no_old").val()) !== $.trim($("#edit_obligation_no").val())) {
                    var _date = $('#edit_date').val().split("/");
                    $.post('<?=base_url();?>obligations/check_if_obligation_number_exist', {obligation_no: $("#edit_obligation_no").val(), obligation_id: $("#edit_obligation_id").val(), year: _date[2] },
                        function(e){
                            if(e.exist) {
                                $("#edit_obligation_error_message").html( "<p>"+e.message+".</p>");
                                $("#edit_obligation_no").closest(".form-group").addClass("has-error");
                                $("#edit_obligation_error_message").show();
                            } else {
                               $("form#edit_form_obligation_details").submit();
                            }
                    },'JSON');
               } else {
                  $("form#edit_form_obligation_details").submit();
               }
            }
        });

    } );

    function select_fund() {
        location.href = '<?=base_url()?>obligations/status?fund_id=' + $("#select_fund_id").find("option:selected").val() + '&year=' + $("#select_year").find("option:selected").val() + '&legal_basis_id=' + $("#select_legal_basis_id").find("option:selected").val();
    }

    function money_format(n) {
        n = parseFloat(n).toFixed(2);
        return Number(n).toLocaleString('en');
    }

    function get_fund_legal_basis() {
        $("#select_legal_basis_id").prop("disabled", true); 
        $.get("<?=base_url();?>legal_basis/get_fund_legal_basis?fund_id=" + $("#select_fund_id").val() + "&year=" + $("#select_year").val(), 
            function(e) {
                var lb_options = "";
                $.each(e.fund_legal_basis, function (i,flb) {
                    lb_options += "<option value='" + flb.id + "'>" + flb.name + "</option>";
                });
                $("#select_legal_basis_id").prop("disabled", false); 
                $("#select_legal_basis_id").html(lb_options);

                if(lb_options != "") {
                    $("#show_btn").prop("disabled", false); 
                } else {
                    $("#show_btn").prop("disabled", true); 
                }

            }
        );
    }

    function show_edit_obligation_modal(elm) {
        var tr =  $(elm).closest("tr");
        $("#edit_obligation_id").val( $(tr).find(".obligation_id").val());
        $("#edit_obligation_no").val( $(tr).find(".obligation_no").val());
        $("#edit_obligation_no_old").val( $(tr).find(".obligation_no").val());
        $("#edit_payee_id").val( $(tr).find(".payee_id").val()).change();
        $("#edit_office_id").val( $(tr).find(".office_id").val()).change();
        $("#edit_particulars").val($(tr).find(".particulars").val());
        $("#edit_date").datepicker("update", $(tr).find(".date").val());
        $("#edit_obligation_modal").modal("show");
    }

    function show_confirm_delete_data_modal(delete_id, delete_text) {
        $("#delete_id").val(delete_id);
        $("#delete_text").html(delete_text);

        $("#confirm_delete_data_modal").modal("show");
    }
</script>