
<div class="content-wrapper">

<!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
        Reports
        <small></small>
        </h1>
        <ol class="breadcrumb">
        <li><a href="#"> Home</a></li>
        <li><a href="#">Tables</a></li>
        <li class="active">Data tables</li>
        </ol>
    </section>

    <section class="content" id="section_content">
        <form method="POST" id="form_new_data" action="<?php echo base_url(); ?>reports/generate_report">
            <div class="row">
                <div class="col-xs-12 col-md-12">
                <div class="row">
                    <div class="col-xs-12 col-md-2">
                        <div class="form-group">
                            <label>Year</label>
                            <select class="form-control" name="year" onchange="get_fund_rc()" id="select_year">
                                <?php for($dyear=2018; $dyear <= (date("Y") + 2); $dyear++): ?>
                                    <option <?= $year == $dyear ? 'selected' : '' ?> value="<?=$dyear?>" ><?=$dyear?></option>
                                <?php  endfor; ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-xs-12 col-md-2">
                        <div class="form-group">
                            <label>Funds</label>
                            <select class="form-control select_two" onchange="get_fund_rc()" id="select_fund_id" name="fund_id"  style="width: 100%;">
                                <?php foreach($fund_list as $fl): ?>
                                    <option  value="<?= sha1($fl->id)?>"><?=$fl->name?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>

                    <div class="col-xs-12 col-md-2">
                        <div class="form-group">
                            <label>Report Type</label>
                            <select class="form-control select_two" id="select_report_type" name="report_type"  style="width: 100%;">
                                <option value="7">Overview</option>
                                <option value="8">End User - Payee - ORS</option>
                                <option value="1">Responsibility Center</option>
                                <option value="2">Allotment Received</option>
                                <option value="3">Obligations</option>
                                <option value="4">Disbursement</option>
                                <option value="6">Allotment - Obligations - Disbursement</option>
                                <option value="5">FAR1</option>
                            </select>
                        </div>
                    </div>
                <div id="group_by_div" style="display:none; ">
                    <div class="col-xs-12 col-md-2"  >
                        <div class="form-group">
                            <label>Group by</label>
                            <select class="form-control select_two" id="select_group_by" name="group_by"  style="width: 100%;">
                                <option selected value="ors">Obligation Number (ORS)</option>
                                <option value="end_user">End User</option>
                                <option value="payee">Payee / Creditor</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div id="obligation_div" style="display:none; ">
                    <div class="col-xs-12 col-md-2">
                        <div class="form-group">
                            <label>Obligation Number</label>
                            <select class="form-control select_two" id="select_obligation_id" name="select_obligation_id" style="width: 100%;">
                                <option value=''>All</option>
                                <?php foreach($fund_obligations as $fo): ?>
                                    <option value="<?=$fo->id?>"><?=$fo->obligation_no?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                </div>
                <div id="office_div" style="display:none; ">
                    <div class="col-xs-12 col-md-2">
                        <div class="form-group">
                            <label>End User</label>
                            <select class="form-control select_two" id="select_office_id" name="office_id" style="width: 100%;" >
                                <option value="">All</option>
                                <?php foreach($offices as $office): ?>
                                    <option value="<?=$office->id?>"><?=$office->name?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                </div>
                <div id="payee_div" style="display:none;">
                    <div class="col-xs-12 col-md-2">
                        <div class="form-group">
                            <label>Payee</label>
                            <select class="form-control select_two" id="select_payee_id" name="payee_id" style="width: 100%;" >
                                <option value="">All</option>
                                <?php foreach($payees as $p): ?>
                                    <option value="<?=$p->id?>"><?=$p->description?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                </div>

                <div id="rc_div" style="display:none;">
                    <div class="col-xs-12 col-md-2">
                        <div class="form-group">
                            <label>Responsibility Center</label>
                            <select class="form-control select_two" id="select_fund_rc_id" name="fund_rc_id" style="width: 100%;">
                                <option value="all">Show All</option>
                                <?php foreach($rc as $res_center): ?>
                                    <option  value="<?=$res_center->fund_rc_id?>"><?=$res_center->code . " - " .  $res_center->description ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                </div>
                <div id="prexc_div" style="display:none;">
                    <div class="col-xs-12 col-md-2">
                        <div class="form-group">
                            <label>Prexc</label>
                            <select class="form-control select_two" id="select_prexc_id" name="prexc_ids[]" style="width: 100%;" multiple>
                                <?php foreach($prexc as $prx): ?>
                                    <option  value="<?=$prx->id?>"><?=$prx->code . " - " .  $prx->description ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                </div> 
                <div id="quarter_div" style="display:none;">
                    <div class="col-xs-12 col-md-2" >
                        <div class="form-group">
                            <label>Quarter</label>
                            <select class="form-control select_two" id="select_quarter" name="quarter" style="width: 100%;">
                                <option  value="all" selected>Show All</option>
                                <option  value="1">1st</option>
                                <option  value="2">2nd</option>
                                <option  value="3">3rd</option>
                                <option  value="4">4rth</option>
                            </select>
                        </div>
                    </div>
                </div>
               
                <div class="col-xs-12 col-md-2">
                    <div class="form-inline"  style="padding-top:24px;">
                        <div class="form-group">
                            <label> &nbsp;</label>
                            <input type="button" class="btn btn-primary" id="show_report_btn"  onclick="view_report()" value="Show" />
                        </div>
                        <div class="form-group">
                            <label> &nbsp;</label>
                            <button type="submit" class="btn btn-primary" id="download_report_btn">Download</button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-xs-12 appropriation_list">
                    <div class="callout callout-danger edit_error_message" style="display:none;" >
                        <p>Insufficient funds, Please check.</p>
                    </div>
                    <div class="box ">
                        <div class="box-header">
                        <h3 class="box-title">View Reports</h3>
                        <div class="box-tools"></div>
                    </div>
                    <div class="box-body loading" style="min-height: 400px;">
                        <div id="loader" class="custom-loader" style="display:none"></div>
                        <div class="box-body table-responsive" id="div_table"></div>
                    </div>
                    <div class="box-footer"></div>
                </div>
            </div>
        </div>
        </div>
        </div>
        </form>
                
    </section>
</div>
<script type="text/javascript">

    $(document).ready(function () {
        $("#select_report_type").change(function() {
            $("#rc_div").hide();
            $("#group_by_div").hide();
            $("#obligation_div").hide(); 
            $("#office_div").hide(); 
            $("#payee_div").hide(); 

            $('#select_fund_rc_id').prop('selectedIndex', 0).trigger('change');
            $('#select_group_by').prop('selectedIndex', 0).trigger('change');
            $('#select_obligation_id').prop('selectedIndex', 0).trigger('change');
            $('#select_office_id').prop('selectedIndex', 0).trigger('change');
            $('#select_payee_id').prop('selectedIndex', 0).trigger('change');

            if($("#select_report_type option:selected").val() == 5) {
                $("#prexc_div").show();
                $("#quarter_div").show();
                $("#rc_div").hide();
              
            } else if($("#select_report_type option:selected").val() == 6) {
                $("#prexc_div").hide();
                $("#quarter_div").show();
                $("#rc_div").show();
            }  else if($("#select_report_type option:selected").val() == 7 ) { 
                $("#prexc_div").hide();
                $("#quarter_div").hide();
                $("#rc_div").hide();
            } else if ( $("#select_report_type option:selected").val() == 8 ) {
                $("#prexc_div").hide();
                $("#quarter_div").hide();
                $("#rc_div").show();
                $("#obligation_div").show();
                $("#group_by_div").show();
                $("#office_div").show(); 
                $("#payee_div").show(); 
              //  $("#show_report_btn").prop("disabled", false);
            }  else {
              //  $("#show_report_btn").prop("disabled", true);
                $("#prexc_div").hide();
                $("#quarter_div").hide();
                $("#rc_div").show();
            }
        });
    });
    function get_fund_rc() {
        
        $("#select_fund_rc_id").prop("disabled", true); 
        $.get("<?=base_url();?>funds/get_fund_rc?fund_id=" + $("#select_fund_id").val() + "&year=" + $("#select_year").val(), 
            function(e) {
                var rc_options = "<option selected value='all'>Show All</option>";
                $.each(e.fund_rc, function (i,frc) {
                    rc_options += "<option value='" + frc.fund_rc_id + "'>" + frc.code + " - " + frc.description + "</option>";
                });
                $("#select_fund_rc_id").prop("disabled", false); 
                $("#select_fund_rc_id").html(rc_options);
                get_fund_obligation_numbers();
            }
        );
    }

     function view_report() {
      
        $("#div_table").html('');
        $("#loader").show();
        param = { 
            year: $("#select_year").val(),
            fund_id: $("#select_fund_id").val(),
            group_by: $("#select_group_by").val(),
            obligation_id: $("#select_obligation_id").val(),
            payee_id: $("#select_payee_id").val(),
            office_id: $("#select_office_id").val(),
            report_type: $("#select_report_type").val(),
            fund_rc_id: $("#select_fund_rc_id").val(),
            prexc_ids: $("#select_prexc_id").val(),
            quarter: $("#select_quarter").val(),
            
            method: "view",
            filter_by: $("#select_filter_by").val()
        };

        $.post("<?php echo base_url();?>reports/generate_report", param , function(html) {
            $("#div_table").html(html);
            var DT =  $("#div_table").find("table.dt");
            $("#loader").hide();
            $("#div_table").fadeIn();
            if(DT.length > 0) {
                $(DT).DataTable( {
                    "scrollY":        "300px",
                    "scrollX": true,
                   // "scrollCollapse": true,
                    'lengthChange': false,
                    'searching'   : false,
                    'ordering'    : false,
                    "paging":         false,
                    'autoWidth'   : true,
                } );
            }
          
        });
    }

    function get_fund_obligation_numbers() {
        $("#select_obligation_id").prop("disabled", true); 
        $.get("<?=base_url();?>obligations/get_fund_obligation_numbers?fund_id=" + $("#select_fund_id").find("option:selected").val() + "&year=" +  $("#select_year").find("option:selected").val(), 
            function(e) {
                var data_options = "";
                data_options += "<option value=''>All</option>";
                $.each(e.fund_obligations, function (i, data) {
                    data_options += "<option value='" + data.id + "'>" + data.obligation_no + "</option>";
                });
                $("#select_obligation_id").prop("disabled", false); 
                $("#select_obligation_id").html(data_options);
            }
        );
    }
</script>