<table class="table table-bordered dt">
    <thead>
        <tr>
            <th class="align-middle">Responsibility Center Code</th>
            <th class="align-middle">Responsibility Center Description</th>
            <th class="align-middle">PREXC</th>
            <th class="align-middle">PREXC Description</th>
            <th class="align-middle">Object Code</th>
            <th class="align-middle">Object Description</th>
            <?php if($quarter == "all") { ?>
                <th class="align-middle">1ST QTR</th>
                <th class="align-middle">2ND QTR</th>
                <th class="align-middle">3RD QTR</th>
                <th class="align-middle">4RTH QTR</th>
            <?php } else  { ?>
                <th class="align-middle"><?=$quarter_string ?> QTR</th>
            <?php } ?>
            <th class="align-middle">Total Allotment</th>
            <th class="align-middle">Total Obligation</th>
            <th class="align-middle">Amount Checks Issued</th>
            <th class="align-middle">Tax</th>
            <th class="align-middle">Amount</th>
        </tr>
    </thead>
    <?php  
        $first_total = 0;
        $second_total = 0;
        $third_total = 0;
        $fourth_total = 0;
        $row = 2;
        $total_obligation = 0;
        $total_net_amount = 0;
        $total_bir_amount = 0;
        $total_disb_amount = 0;
        $total_quarter = 0;
    ?>
    <?php if(count($allotments) > 0): ?>
        <tbody>
            <?php foreach($allotments as $allotment) : ?>
            <?php  
                $obligation_amount = 0;
                $CI=&get_instance();
            //  $CI->get_category_name($product->cat_id);
                $obligation = $CI->get_total_obligations($fund_id, $allotment->fund_rc_id,  $allotment->legal_basis_id, $year, $allotment->prexc_id, $allotment->object_id, $quarter);
                if (count($obligation) > 0) {
                    $obligation = $obligation[0];
                    $total_obligation += $obligation->total_obligation;
                    $total_net_amount = $total_net_amount + $obligation->net_amount;
                    $total_bir_amount += $obligation->bir_amount;
                    $total_disb_amount += $obligation->total_amount;
                }
                $col_number = 6;
            ?>
                <tr>
                    <td ><?=$allotment->rc_code?></td>
                    <td ><?=$allotment->rc_description?></td>
                    <td ><?=$allotment->prexc_code?></td>
                    <td ><?=$allotment->prexc_description?></td>
                    <td ><?=$allotment->object_code?></td>
                    <td ><?=$allotment->object_description?></td>

                    <?php if($quarter == "all") { ?>
                        <?php  
                            $first_total += $allotment->first_amount;
                            $second_total += $allotment->second_amount;
                            $third_total += $allotment->third_amount;
                            $fourth_total += $allotment->fourth_amount;
                        ?>
                        <td ><?=money_format($allotment->first_amount)?></td>
                        <td ><?=money_format($allotment->second_amount)?></td>
                        <td ><?=money_format($allotment->third_amount)?></td>
                        <td ><?=money_format($allotment->fourth_amount)?></td>
                        <td ><?=money_format($allotment->first_amount + $allotment->second_amount + $allotment->third_amount + $allotment->fourth_amount)?></td>
                    <?php } else { ?>
                        <?php $total_quarter += $allotment->{$quarter_amount}; ?>
                        <td ><?=money_format($allotment->first_amount);?></td>
                        <td ><?=money_format($allotment->first_amount);?></td>
                    <?php } ?>

                    <td ><?=money_format(isset($obligation->total_obligation ) ? $obligation->total_obligation : 0);?></td>
                    <td ><?=money_format(isset($obligation->net_amount) ? $obligation->net_amount : 0);?></td>
                    <td ><?=money_format(isset($obligation->bir_amount) ? $obligation->bir_amount : 0);?></td>
                    <td ><?=money_format(isset($obligation->total_amount) ? $obligation->total_amount : 0);?></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
        <tfoot>
            <tr>
            <?php if($quarter == "all") { ?>
                <td colspan="6" >Grand Total</td>
                <td ><?=money_format($first_total);?></td>
                <td ><?=money_format($second_total);?></td>
                <td ><?=money_format($third_total);?></td>
                <td ><?=money_format($fourth_total);?></td>
                <td ><?=money_format(($first_total + $second_total + $third_total + $fourth_total ));?></td>	
            <?php } else { ?>
                <td colspan="6" >Grand Total</td>
                <td ><?=money_format($total_quarter);?></td>
                <td ><?=money_format($total_quarter);?></td>
            <?php } ?>
                <td ><?=money_format($total_obligation);?></td>
                <td ><?=money_format($total_net_amount);?></td>
                <td ><?=money_format($total_bir_amount);?></td>
                <td ><?=money_format($total_disb_amount);?></td>
            </tr>
        </tfoot>
    <?php else: ?>
        <tr>
            <td colspan="10" align="center">No Result(s) found.</td>
        </tr>
    <?php endif;?>
</table>