<table class="table display table-bordered table-responsive dt"  style="width:100%">
    <thead>
        <tr>
            <th class="align-middle">Date</th>
            <th class="align-middle">ORS NO</th>
            <th class="align-middle">RCI/ADA/ROD No.</th>
            <th class="align-middle">DV NO.</th>
            <th class="align-middle">PAYEE</th>
            <th class="align-middle">AUTHORIZATION TYPE / BUDGET SOURCE</th>
            <th class="align-middle">PREXC</th>
            <th class="align-middle">PREXC Description</th>
            <th class="align-middle">RC Code</th>
            <th class="align-middle">Allotement Class</th>
            <th class="align-middle">"Object Code</th>
            <th class="align-middle-center" style="width: 200px;">Amount Checks Issued</th>
            <th class="align-middle-center">Tax</th>
            <th class="align-middle-center">Amount</th>
        </tr>
    </thead>
    <?php  
        $total_amount = 0;
        $total_amount_check = 0;
        $total_tax = 0;
    ?>
    <?php if(count($disbursements) > 0): ?>
        <tbody>
        <?php foreach($disbursements as $disbursement) : ?>
            <?php  
                $total_amount_check += $disbursement->net_amount;
                $total_tax += $disbursement->bir_amount;
                $total_amount += $disbursement->total_amount;
            ?>
            <tr>
                <td ><?=$disbursement->date?></td>
                <td ><?=$disbursement->obligation_no?></td>
                <td ><?=$disbursement->ada_number?></td>
                <td ><?=$disbursement->dv_number?></td>
                <td ><?=$disbursement->payee_description?></td>
                <td ><?=$disbursement->fund_id == 1 ? 'New General Appropriations' : 'Continuing Appropriations'?></td>
                <td ><?=$disbursement->prexc_code?></td>
                <td ><?=$disbursement->prexc_description?></td>
                <td ><?=$disbursement->rc_code?></td>
                <td ><?=$disbursement->allotment_class_name?></td>
                <td ><?=$disbursement->object_code?></td>
                <td ><?=money_format($disbursement->net_amount);?></td>
                <td ><?=money_format($disbursement->bir_amount);?></td>
                <td ><?=money_format($disbursement->total_amount);?></td>
            </tr>
        <?php endforeach; ?>
        </tbody>
        <tfoot>
            <tr>
                <td colspan="11" >Grand Total</td>
                <td ><?=money_format($total_amount_check);?></td>
                <td ><?=money_format($total_tax);?></td>
                <td ><?=money_format($total_amount);?></td>
            </tr>
        </tfoot>
    <?php else: ?>
        <tr>
            <td colspan="14" align="center">No Result(s) found.</td>
        </tr>
    <?php endif;?>
</table>