<table class="table table-bordered dt" >
    <thead>
        <tr>
            <th class="align-middle">Obligation Number</th>
            <th class="align-middle">Payee</th>
            <th class="align-middle">Date</th>
            <th class="align-middle">Responsibility Code</th>
            <th class="align-middle">Responsibility Description</th>
            <th class="align-middle">PREXC</th>
            <th class="align-middle">PREXC Description</th>
            <th class="align-middle">Object Code</th>
            <th class="align-middle">Object Description</th>
            <th class="align-middle">Allotement Class</th>
            <th class="align-middle-center">Original Amount</th>
            <th class="align-middle-center">Adjustment (Based on NORSA)</th>
            <th class="align-middle-center">Total Adjusted Amount</th>
        </tr>
    </thead>
    <?php  
        $total_amount = 0;
        $total_norsa = 0;
        $total_adjusted_amount = 0;
        $row = 2;
    ?>
    <?php if(count($obligations) > 0): ?>
        <tbody>
            <?php foreach($obligations as $obligation) : ?>
            <?php  
                $total_amount += $obligation->original_amount;
                $total_norsa += $obligation->norsa == NULL  ?  0 : $obligation->norsa ;
                $adjusted_amount = $obligation->norsa == NULL  ? $obligation->original_amount : $obligation->adjusted_amount   ;
                $total_adjusted_amount += $adjusted_amount  ;
            ?>
                <tr>
                    <td ><?=$obligation->obligation_no?></td>
                    <td ><?=$obligation->payee_description?></td>
                    <td ><?=$obligation->date?></td>
                    <td ><?=$obligation->rc_code?></td>
                    <td ><?=$obligation->rc_description?></td>
                    <td ><?=$obligation->prexc_code?></td>
                    <td ><?=$obligation->prexc_description?></td>
                    <td ><?=$obligation->object_code?></td>
                    <td ><?=$obligation->object_description?></td>
                    <td ><?=$obligation->allotment_class_name?></td>
                    <td ><?=money_format($obligation->original_amount);?></td>
                    <td ><?=money_format(($obligation->norsa == NULL  ?  0 : $obligation->norsa));?></td>
                    <td ><?=money_format($obligation->adjusted_amount);?></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
        <tfoot>
            <tr>
                <td colspan="10" >Grand Total</td>
                <td ><?=money_format($total_amount);?></td>
                <td ><?=money_format($total_norsa);?></td>
                <td ><?=money_format($total_adjusted_amount);?></td>
            </tr>
        </tfoot>
    <?php else: ?>
        <tr>
            <td colspan="13" align="center">No Result(s) found.</td>
        </tr>
    <?php endif;?>
</table>