<div class="content-wrapper">
<!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
        <?=$fund_id==sha1(1) ? 'New General Appropriations' : 'Continuing Appropriations' ?>
        <small></small>
        </h1>
        <ol class="breadcrumb">
        <li><a href="#"> Home</a></li>
        <li><a href="#">Fund</a></li>
        <li class="active">Responsibility Center</li>
        </ol>
    </section>

    <section class="content">
        <div class="callout callout-danger" id="error_message" style="display: none;">
        </div>
        <div class="row">
            <div class="col-xs-12 col-md-12">
                <div class="row">
                   
                    <div class="col-xs-12 col-md-2">
                        <div class="form-group">
                            <label>Year</label>
                            <select class="form-control" name="year" id="select_year">
                                <?php for($dyear=2018; $dyear <= (date("Y") + 2); $dyear++): ?>
                                    <option <?= $year == $dyear ? 'selected' : '' ?> value="<?=$dyear?>" ><?=$dyear?></option>
                                <?php  endfor; ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-xs-12 col-md-7">
                        <div class="form-group">
                            <label>Funds</label>
                            <select class="form-control select_two" name="fund_id" id="select_fund_id">
                                <?php foreach($fund_list as $fl): ?>
                                    <option <?= $fund_id == sha1($fl->id) ? 'selected' : '' ?> value="<?= sha1($fl->id)?>"><?=$fl->name?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-xs-12 col-md-1">
                        <div style="padding-top:24px;">
                            <input type="button" class="btn btn-primary" style="width: 100%;" onclick="select_fund()" value="Show" />
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-xs-12">
                    <div class="box">
                        <div class="box-header">
                        <h3 class="box-title">Responsibility Center</h3>
                    </div>
                    <div class="box-body table-responsive">
                        <table class="table table-bordered data-table">
                            <thead>
                                <tr>
                                    <th class="align-middle">RC</th>
                                    <th class="align-middle" >PREXC</th>
                                    <th style="width:250px;" class="align-middle">Legal Basis</th>
                                    <th style="width:100px;" class="align-middle-center">Date</th>
                                    <th style="width:100px; text-align: center;">Action</th>
                                </tr>
                            </thead>
                            <?php if(count($allotment_list) > 0): ?>
                                <?php foreach($allotment_list as $al): ?>
                                    <tr>
                                        <td class="align-middle"><?=$al->rc_code . " - " . $al->rc_description?></td>
                                        <td class="align-middle"><?=$al->prexc_code . " - " . $al->prexc_description?></td>
                                        <td class="align-middle"><?=$al->legal_basis_name?></td>
                                        <td class="align-middle-center"><?= date('m/d/Y', strtotime($al->date_created));?></td>
                                      
                                        
                                        <td style="width:100px; vertical-align:middle; text-align: center;">
                                            <a class="Delete" title="Delete" onclick='show_confirm_delete_data_modal("<?=$al->id?>", "<?=$al->rc_code . " - " .  htmlentities($al->rc_description, ENT_QUOTES) ?>")' style="cursor:pointer">
                                                <i class="fa fa-trash"></i>
                                             </a> 
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="6" align="center">No Result(s) found.</td>
                                </tr>
                            <?php endif;?>
                        </table>
                        </div>
                    </div>
            </div>
        </div>

        <div class="modal fade" id="confirm_delete_data_modal">
            <div class="modal-dialog">
                <form method="POST"  action="<?php echo base_url(); ?>superadmin/delete_allotment">
                    <input  type="hidden" name="year" value="<?=$year?>" />
                    <input  type="hidden" name="fund_id" value="<?=$fund_id?>" />
                    <input  type="hidden" name="allotment_id" id="delete_id"  />
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span></button>
                            <h4 class="modal-title">Confirm Action</h4>
                        </div>
                        <div class="modal-body">
                            <div class="callout callout-danger" style="display:none;" >

                            </div>
                            <p> Are You sure you want to delete this (<span id="delete_text"></span>)? </p>
                           
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Cancel</button>
                            <button type="submit" class="btn btn-primary" >Proceed</button>
                        </div>
                    </div>
                </form>
                <!-- /.modal-content -->
            </div>
            <!-- /.modal-dialog -->
        </div>
    </section>
</div>
<script type="text/javascript">
    $(document).ready(function() {
    });

    function show_confirm_delete_data_modal(delete_allotment_id, delete_text, ) {
        $("#delete_id").val(delete_allotment_id);
        $("#delete_text").html(delete_text);
        $("#confirm_delete_data_modal").modal("show");
    }

    function select_fund() {
        location.href = '<?=base_url()?>funds/responsibility_center?fund_id=' + $("#select_fund_id").find("option:selected").val() + '&year=' + $("#select_year").find("option:selected").val();
    }
</script>