<div class="content-wrapper">
<!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
        Obligations
        <small></small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="#"> Home</a></li>
            <li><a href="#">Tables</a></li>
            <li class="active">Data tables</li>
        </ol>
    </section>
    <section class="content">
        <div class="row">
            <div class="col-xs-12 col-md-12">
                <div class="row">
                    <div class="col-xs-12 col-md-2">
                        <div class="form-group">
                            <label>Year</label>
                            <select class="form-control" name="year" id="select_year" onchange="get_fund_legal_basis();">
                                <?php for($dyear=(date("Y") - 1); $dyear <= (date("Y") + 2); $dyear++): ?>
                                    <option <?= $year == $dyear ? 'selected' : '' ?> value="<?=$dyear?>" ><?=$dyear?></option>
                                <?php  endfor; ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-xs-12 col-md-6">
                        <div class="form-group">
                            <label>Funds</label>
                            <select class="form-control select_two" name="fund_id" id="select_fund_id" onchange="get_fund_legal_basis()">
                                <?php foreach($fund_list as $fl): ?>
                                    <option <?= $fund_id == sha1($fl->id) ? 'selected' : '' ?> value="<?= sha1($fl->id)?>"><?=$fl->name?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-xs-12 col-md-3">
                        <div class="form-group">
                            <label>Legal Basis</label>
                            <select class="form-control select_two" id="select_legal_basis_id" name="select_legal_basis_id" style="width: 100%;">
                                <?php foreach($fund_legal_basis as $flb): ?>
                                    <option <?= $legal_basis_id == $flb->id ? 'selected' : '' ?> value="<?=$flb->id?>"><?=$flb->name?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-xs-12 col-md-1">
                        <div style="padding-top:24px;">
                            <input type="button" class="btn btn-primary" style="width: 100%;" onclick="select_fund()" value="Show" />
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-xs-12">
                <div class="box">
                    <div class="box-header">
                        <h3 class="box-title"><?=$fund_id==sha1(1) ? 'New General Appropriations' : 'Continuing Appropriations' ?></h3>
                        <?php if($login_user_data["type"] == 2 || $login_user_data["type"] == 1) : ?>
                            <div class=" pull-right">
                                <a clas="btn" href="<?=base_url();?>obligations/request">
                                    <i class="fa fa-plus"></i> Request
                                </a>
                            </div>
                        <?php endif;?>
                    </div>
                    <div class="box-body table-responsive">

                    <table class="table table-bordered obligation-data-table" style="display:none;">
                        <thead>
                            <tr>
                                <th style="width:200px;">Obligation No</th>
                                <th>Date</th>
                                <th>Payee</th>
                                <th>Office</th>
                                <th>Particulars</th>
                                <th style="width:100px; text-align: center;">Action</th>
                            </tr>
                        </thead>
                        <?php if(count($obligations) > 0): ?>
                            <?php foreach($obligations as $obligation): ?>
                                <tr>
                                    <td><?=$obligation->obligation_no?></td>
                                    <td><?=$obligation->date?></td>
                                    <td><?=$obligation->payee_description?></td>
                                    <td><?=$obligation->office_name?></td>
                                    <td><?=$obligation->particulars?></td>
                                    <td class="align-middle-center" >
                                        <a class="btn_show_details" href="javascript:void(0);" onclick='show_confirm_delete_data_modal("<?=$obligation->obligation_id?>", "<?=$obligation->obligation_no?>")' title="Cancel Obligation" onclick="" style="cursor:pointer">
                                            <i class="fa fa-trash-o"></i> 
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="7" align="center">No Result(s) found.</td>
                            </tr>
                        <?php endif;?>
                    </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="modal fade" id="confirm_delete_data_modal">
            <div class="modal-dialog">
                <form method="POST" action="<?php echo base_url(); ?>superadmin/delete_obligation">
                    <input type="hidden" id="delete_id" name="obligation_id" value="" />
                    <input type="hidden" name="year" value="<?=$year?>" />
                    <input type="hidden" name="legal_basis_id" value="<?=$legal_basis_id?>" />
                    <input type="hidden" name="fund_id" value="<?=$fund_id?>" />
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span></button>
                            <h4 class="modal-title">Confirm Delete</h4>
                        </div>
                        <div class="modal-body">
                            <p> Are You sure you want to delete this Obligation ( No:<span id="delete_text"></span> )? </p>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Cancel</button>
                            <button type="submit" class="btn btn-danger" >Delete</button>
                        </div>
                    </div>
                </form>
                <!-- /.modal-content -->
            </div>
            <!-- /.modal-dialog -->
        </div>
    </section>

</div>
<script type="text/javascript">
   <?php if(count($obligations) > 0): ?>                
        $(document).ready(function() {
            $('.obligation-data-table').DataTable( {
            'paging'      : true,
            'lengthChange': false,
            'searching'   : true,
            'ordering'    : true,
            'info'        : true,
            'autoWidth'   : false
            } );

            $('table.obligation-data-tabl').removeClass('dataTable');
            $('.obligation-data-table').show();
        } );
    <?php endif; ?>
                      

    function select_fund() {
        location.href = '<?=base_url()?>superadmin/obligation_list?fund_id=' + $("#select_fund_id").find("option:selected").val() + '&year=' + $("#select_year").find("option:selected").val() + '&legal_basis_id=' + $("#select_legal_basis_id").find("option:selected").val();
    }

    function money_format(n) {
        n = parseFloat(n).toFixed(2);
        return Number(n).toLocaleString('en');
    }

    function get_fund_legal_basis() {
        $("#select_legal_basis_id").prop("disabled", true); 
        $.get("<?=base_url();?>legal_basis/get_fund_legal_basis?fund_id=" + $("#select_fund_id").val() + "&year=" + $("#select_year").val(), 
            function(e) {
                var lb_options = "";
                $.each(e.fund_legal_basis, function (i,flb) {
                    lb_options += "<option value='" + flb.id + "'>" + flb.name + "</option>";
                });
                $("#select_legal_basis_id").prop("disabled", false); 
                $("#select_legal_basis_id").html(lb_options);
            }
        );
    }

    function show_confirm_delete_data_modal(delete_id, delete_text) {
        $("#delete_id").val(delete_id);
        $("#delete_text").html(delete_text);

        $("#confirm_delete_data_modal").modal("show");
    }
</script>