<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>ERDB | Data Tables</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.7 -->
  <link rel="stylesheet" href="<?php echo base_url(); ?>assets/bower_components/bootstrap/dist/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="<?php echo base_url(); ?>assets/bower_components/font-awesome/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="<?php echo base_url(); ?>assets/bower_components/Ionicons/css/ionicons.min.css">
  <!-- DataTables -->
  <link rel="stylesheet" href="<?php echo base_url(); ?>assets/bower_components/datatables.net-bs/css/dataTables.bootstrap.min.css">

  <link rel="stylesheet" href="<?php echo base_url(); ?>assets/bower_components/bootstrap-datepicker/dist/css/bootstrap-datepicker.min.css">
  <link rel="stylesheet" href="<?php echo base_url();?>assets/bower_components/select2/dist/css/select2.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="<?php echo base_url(); ?>assets/dist/css/AdminLTE.css">
  <link rel="stylesheet" href="<?php echo base_url(); ?>assets/dist/css/main.css">
  <link rel="stylesheet" href="<?php echo base_url(); ?>assets/dist/css/skins/skin-green.min.css">

  <!-- Google Font -->
  <!-- <link rel="stylesheet"
        href="<?php //echo base_url(); ?>assets/dist/css/font_Source_Sans_Pro_italic.css"> -->
  <!-- ./wrapper -->

  <!-- jQuery 3 -->
  <script src="<?php echo base_url(); ?>assets/bower_components/jquery/dist/jquery.min.js"></script>
</head>
<body class="hold-transition skin-green sidebar-mini <?=$body_class?>">
<div class="wrapper">

  <header class="main-header">
    <!-- Logo -->
    <a class="logo">
      <!-- mini logo for sidebar mini 50x50 pixels -->
      <span class="logo-mini"><b>E</b>Bgt</span>
      <!-- logo for regular state and mobile devices -->
      <span class="logo-lg"><b>ERDB</b> Budget</span>
    </a>
    <!-- Header Navbar: style can be found in header.less -->
    <nav class="navbar navbar-static-top">
      <!-- Sidebar toggle button-->
      <a href="#" class="sidebar-toggle" data-toggle="push-menu" role="button">
        <span class="sr-only">Toggle navigation</span>
        <span class="icon-bar"></span>
        <span class="icon-bar"></span>
        <span class="icon-bar"></span>
      </a>

      <div class="navbar-custom-menu">
        <ul class="nav navbar-nav">
         
          <!-- User Account: style can be found in dropdown.less -->
          <li class="dropdown user user-menu">
            <a href="#" class="dropdown-toggle" data-toggle="dropdown">
              <img src="<?php echo base_url(); ?>assets/dist/img/portrait_placeholder.png" class="user-image" alt="User Image">
              <span class="hidden-xs"><?=ucwords($login_user_data["name"])?></span>
            </a>

            <ul class="dropdown-menu">
              <!-- User image -->
              <li class="user-header">
                <img src="<?php echo base_url(); ?>assets/dist/img/portrait_placeholder.png" class="img-circle" alt="User Image">

                <p>
                <?=ucwords($login_user_data["name"])?> - <?=$login_user_data["type_name"]?>
                </p>
              </li>
              <!-- Menu Footer-->
              <li class="user-footer">
                <div class="pull-left">
                  <a href="javascript:void(0)" id="show_profile_modal" class="btn btn-default btn-flat">Profile</a>
                 </div>
                <div class="pull-right">
                  <a href="<?php echo base_url(); ?>authentication/logout" class="btn btn-default btn-flat">Sign out</a>
                </div>
              </li>
            </ul>
          </li>
        </ul>
      </div>
    </nav>
  </header>
  <!-- Left side column. contains the logo and sidebar -->
  <aside class="main-sidebar">
    <!-- sidebar: style can be found in sidebar.less -->
    <section class="sidebar">
      <!-- Sidebar user panel -->
      <div class="user-panel">
        <div class="pull-left image">
          <img src="<?php echo base_url(); ?>assets/dist/img/portrait_placeholder.png" class="img-circle" alt="User Image">
        </div>
        <div class="pull-left info">
          <p><?=ucwords($login_user_data["name"])?></p>
          <a href="#">
            <?=$login_user_data["type_name"]?>
          </a>
        </div>
      </div>
      <ul class="sidebar-menu" data-widget="tree">
        <li class="header">MAIN NAVIGATION</li>
        <?php if($login_user_data["type"] == 4 ) : ?>
          <li class="treeview <?=$nav_bar[0] == 'maintenance' ? 'active' : ''?>">
            <a href="#">
              <i class="fa  fa-gears"></i>
              <span>Maintenance</span>
              <span class="pull-right-container">
                <i class="fa fa-angle-left pull-right"></i>
              </span>
            </a>
            <ul class="treeview-menu">
              <li class="<?=in_array('allotment_recieved',$nav_bar) ? 'active' : ''?>">  <a href="<?php echo base_url();?>superadmin/allotment_list"><i class="fa fa-circle-o"></i><span>Allotment Received</span></a></li>
              <li class="<?=in_array('obligations',$nav_bar) ? 'active' : ''?>">  <a href="<?php echo base_url();?>superadmin/obligation_list"><i class="fa fa-circle-o"></i><span>Obligations</span></a></li>
            </ul>
          </li>
       
        <?php else : ?>
          <?php if($login_user_data["type"] !=3 ) : ?>
            <li class="<?=in_array('appropriations',$nav_bar) ? 'active' : ''?>"><a href="<?php echo base_url();?>appropriations/list"><i class="fa fa-list-ol"></i> <span>Appropriations</span></a></li>
          <!-- <li class="<?//=in_array('allotment',$nav_bar) ? 'active' : ''?>">
            <a href="<?php //echo base_url();?>allotment/list">
              <i class="fa fa-calculator"></i> <span>Allotment Recieved</span>
            </a>
          </li> -->
          
            <li class="treeview <?=in_array('allotment',$nav_bar) ? 'active' : ''?>">
              <a href="#">
                <i class="fa fa-calculator"></i>
                <span>Allotment</span>
                <span class="pull-right-container">
                  <i class="fa fa-angle-left pull-right"></i>
                </span>
              </a>
              <ul class="treeview-menu">
                <li class="<?=in_array('received',$nav_bar) ? 'active' : ''?>"><a href="<?php echo base_url();?>allotment/list"><i class="fa fa-circle-o"></i>Recieved</a></li>
                <li class="<?=in_array('realignment',$nav_bar) ? 'active' : ''?>"><a href="<?php echo base_url();?>allotment/list?type=realignment"><i class="fa fa-circle-o"></i>Realignment</a></li>
                <!-- <li class="<?//=in_array('ogmentation',$nav_bar) ? 'active' : ''?>"><a href="<?php //echo base_url();?>allotment/ogmentation"><i class="fa fa-circle-o"></i>Ogmentation</a></li> -->
              </ul>
            </li>
            <li class="treeview <?=$nav_bar[0] == 'obligations' ? 'active' : ''?>">
              <a href="#">
                <i class="fa fa-list"></i>
                <span>Obligations</span>
                <span class="pull-right-container">
                  <i class="fa fa-angle-left pull-right"></i>
                </span>
              </a>
              <ul class="treeview-menu">
                <li class="<?=in_array('request',$nav_bar) ? 'active' : ''?>"><a href="<?php echo base_url();?>obligations/request"><i class="fa fa-circle-o"></i>Request</a></li>
                <li class="<?=in_array('status',$nav_bar) ? 'active' : ''?>"><a href="<?php echo base_url();?>obligations/status"><i class="fa fa-circle-o"></i>Status</a></li>
                <li class="<?=in_array('norsa',$nav_bar) ? 'active' : ''?>"><a href="<?php echo base_url();?>obligations/norsa"><i class="fa fa-circle-o"></i>NORSA</a></li>
              </ul>
            </li>
            <?php if($login_user_data["type"] == 1 ) :  ?>
              <li class="<?=in_array('disbursement',$nav_bar) ? 'active' : ''?>"><a href="<?php echo base_url();?>obligations/disbursement"><i class="fa fa-book"></i> <span>Disbursement</span></a></li>
            <?php endif; ?>   
            <li class="treeview <?=$nav_bar[0] == 'funds' ? 'active' : ''?>">
              <a href="#">
                <i class="fa fa-outdent"></i>
                <span>Funds</span>
                <span class="pull-right-container">
                  <i class="fa fa-angle-left pull-right"></i>
                </span>
              </a>
              <ul class="treeview-menu">
                <li class="<?=in_array('legal_basis', $nav_bar) ? 'active' : ''?>"><a href="<?php echo base_url();?>funds/legal_basis"><i class="fa fa-circle-o"></i>Legal Basis</a></li>
                <li class="<?=in_array('rc', $nav_bar) ? 'active' : ''?>"><a href="<?php echo base_url();?>funds"><i class="fa fa-circle-o"></i>Responsibility Center</a></li>
                <li class="<?=in_array('objects', $nav_bar) ? 'active' : ''?>"><a href="<?php echo base_url();?>funds/objects"><i class="fa fa-circle-o"></i>Objects</a></li>
              </ul>
            </li>
            <li class="<?=$nav_bar[0] == 'reports' ? 'active' : ''?>"><a href="<?php echo base_url();?>reports/"><i class="fa fa-file-excel-o"></i> <span>Reports</span></a></li>
            <li class="treeview <?=$nav_bar[0] == 'maintenance' ? 'active' : ''?>">
              <a href="#">
                <i class="fa  fa-gears"></i>
                <span>Maintenance</span>
                <span class="pull-right-container">
                  <i class="fa fa-angle-left pull-right"></i>
                </span>
              </a>
              <ul class="treeview-menu">
                <li class="<?=in_array('rc_list',$nav_bar) ? 'active' : ''?>">  <a href="<?php echo base_url();?>responsibility_center"><i class="fa fa-circle-o"></i><span>Responsibility Center</span></a></li>
                <li class="<?=in_array('object_of_expenditures',$nav_bar) ? 'active' : ''?>">  <a href="<?php echo base_url();?>object_of_expenditures"><i class="fa fa-circle-o"></i><span>Object</span></a></li>
                <li class="<?=in_array('prexc',$nav_bar) ? 'active' : ''?>" ><a href="<?php echo base_url();?>prexc"><i class="fa fa-circle-o"></i><span>Prexc</span></a></li>
                <li class="<?=in_array('legal_basis',$nav_bar) ? 'active' : ''?>"><a href="<?php echo base_url();?>legal_basis"><i class="fa fa-circle-o"></i><span>Legal Basis</span></a></li>
                <li class="<?=in_array('office',$nav_bar) ? 'active' : ''?>"><a href="<?php echo base_url();?>office"><i class="fa fa-circle-o"></i><span>Office</span></a></li>
                <li class="<?=in_array('payee',$nav_bar) ? 'active' : ''?>"><a href="<?php echo base_url();?>payee"><i class="fa fa-circle-o"></i><span>Payee</span></a></li>
              </ul>
            </li>
          <?php else : ?>
            <li class="treeview <?=$nav_bar[0] == 'obligations' ? 'active' : ''?>">
              <a href="#">
                <i class="fa fa-list"></i>
                <span>Obligations</span>
                <span class="pull-right-container">
                  <i class="fa fa-angle-left pull-right"></i>
                </span>
              </a>
              <ul class="treeview-menu">
                <li class="<?=in_array('status',$nav_bar) ? 'active' : ''?>"><a href="<?php echo base_url();?>obligations/status"><i class="fa fa-circle-o"></i>Status</a></li>
              </ul>
            </li>
            <?php if($login_user_data["type"] == 3 ) :  ?>
              <li class="<?=in_array('disbursement',$nav_bar) ? 'active' : ''?>"><a href="<?php echo base_url();?>obligations/disbursement"><i class="fa fa-book"></i> <span>Disbursement</span></a></li>
            <?php endif ?>
            <li class="<?=$nav_bar[0] == 'reports' ? 'active' : ''?>"><a href="<?php echo base_url();?>reports/"><i class="fa fa-file-excel-o"></i> <span>Reports</span></a></li>
           
          <?php endif; ?>   
        <?php endif; ?>
      </ul>

    </section>
    <!-- /.sidebar -->
  </aside>
      <div class="modal fade" id="profile_modal">
        <div class="modal-dialog">
          <div class="modal-content">
              <div class="modal-header">
                  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span></button>
                  <h4 class="modal-title">Profile</h4>
              </div>
              <div class="modal-body">
                  <div class="callout callout-danger" id="profile_error_message" style="display:none;" >
                      <p>Insufficient funds, Please check.</p>
                  </div>
                  <div class="row"> 
                      <div class="col-xs-12">
                          <div class="form-group">
                              <label>Full Name*</label>
                              <input class="form-control" name="profile_name" id="profile_name" value="<?=$login_user_data["name"]?>"/>
                          </div>
                      </div>
                  </div>
                  <div class="row"> 
                      <div class="col-xs-12">
                        <div class="checkbox">
                          <label>
                            <input type="checkbox" name="change_password" id="change_password"> Change Password
                          </label>
                        </div>
                      </div>
                  </div>
                  <div class="row"> 
                      <div class="col-xs-12">
                          <div class="form-group">
                              <label>Old Password</label>
                              <input type="password" class="form-control" name="profile_opassword" id="profile_opassword" placeholder="" disabled />
                          </div>
                      </div>
                  </div>
                  <div class="row"> 
                      <div class="col-xs-12">
                          <div class="form-group">
                              <label>New Password</label>
                              <input type="password" value="" class="form-control" name="profile_npassword" id="profile_npassword" placeholder="" disabled />
                          </div>
                      </div>
                  </div>
                  <div class="row"> 
                      <div class="col-xs-12">
                          <div class="form-group">
                              <label>Confirm Password</label>
                              <input type="password" value="" class="form-control" name="profile_cpassword" id="profile_cpassword" placeholder="" disabled/>
                          </div>
                      </div>
                  </div>
              </div>
              <div class="modal-footer">
                  <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Cancel</button>
                  <button type="button" class="btn btn-primary" id="update_profile_btn">Update</button>
              </div>
          </div>
            <!-- /.modal-content -->
        </div>
      </div>
        <!-- /.modal-dialog -->
    <?php  $this->load->view($content); ?>
  <!-- /.content-wrapper -->
  <footer class="main-footer">
    <div class="pull-right hidden-xs">
      <b>ERDB</b> Budget 1.0
    </div>
    <strong>Copyright &copy; 2018 </strong> All rights
    reserved.
  </footer>
</div>

<!-- page script -->
</body>
</html>


<!-- Bootstrap 3.3.7 -->
<script src="<?php echo base_url(); ?>assets/bower_components/bootstrap/dist/js/bootstrap.min.js"></script>
<script src="<?php echo base_url(); ?>assets/bower_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>
<script src="<?php echo base_url(); ?>assets/bower_components/select2/dist/js/select2.full.js"></script>
<!-- DataTables -->
<script src="<?php echo base_url(); ?>assets/bower_components/datatables.net/js/jquery.dataTables.min.js"></script>
<script src="<?php echo base_url(); ?>assets/bower_components/datatables.net-bs/js/dataTables.bootstrap.min.js"></script>
<!-- SlimScroll -->
<script src="<?php echo base_url(); ?>assets/bower_components/jquery-slimscroll/jquery.slimscroll.min.js"></script>
<!-- FastClick -->
<script src="<?php echo base_url(); ?>assets/bower_components/fastclick/lib/fastclick.js"></script>
<!-- AdminLTE App -->
<script src="<?php echo base_url(); ?>assets/dist/js/adminlte.min.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="<?php echo base_url(); ?>assets/dist/js/demo.js"></script>


<script type="text/javascript" >
    $(document).ready(function () {
        $("#show_profile_modal").click(function() {
            $("#profile_modal").modal("show");

            $("#profile_cpassword").prop("disabled", true);
            $("#profile_cpassword").val("").prop("disabled", true);
            $("#profile_opassword").val("").prop("disabled", true);
            $("#profile_npassword").val("").prop("disabled", true);
            $("#profile_error_message").hide();

        });
        $("#change_password").click(function() {
          if($('#change_password:checked').length > 0){
            $("#profile_cpassword").prop("disabled", false);
            $("#profile_opassword").prop("disabled", false);
            $("#profile_npassword").prop("disabled", false);
          } else {
            $("#profile_cpassword").prop("disabled", true);
            $("#profile_opassword").prop("disabled", true);
            $("#profile_npassword").prop("disabled", true);
          }

        });

        $("#update_profile_btn").click(function() {
          var err_msg = "";
          
          if($('#change_password:checked').length > 0) {
              if($.trim($('#profile_npassword').val()).length <= 0 ||  $.trim($('#profile_npassword').val()) != $.trim($('#profile_cpassword').val())) {
                err_msg += "<p>New Password does not match.</p>";
              }

              if($.trim($('#profile_npassword').val()).length < 8) {
                err_msg += "<p>New Password must be minimum of 8 characters.</p>";
              }
          }

          if($.trim($('#profile_name').val()) == "") {
            err_msg += "<p>Please input name.</p>";
          }
         

          if(err_msg == "") {
            var pdata = {};
              pdata.name = $.trim($('#profile_name').val());
              pdata.opassword = $.trim($('#profile_opassword').val());
              pdata.npassword = $.trim($('#profile_npassword').val());
              if($('#change_password:checked').length > 0) {
                pdata.change_password = true;
              } else {
                pdata.change_password = false;
              }
            $.post('<?=base_url()?>/authentication/update_profile', pdata,
              function(e) {
                if(!e.success) {
                  err_msg += "<p>Old Password does not match.</p>";
                } else {
                  location.reload();
                }
              }
            );
          } else {
            $("#profile_error_message").html(err_msg).show();
          }

        });

        $('.select2_obligation_number').select2({
            ajax: {
                url: '<?=base_url();?>obligations/select2_fund_obligation_numbers', 
                // delay: 300,
                data: function (params) {
                  var query = {
                    search: params.term,
                    fund_id: $("#select_fund_id").find("option:selected").val(),
                    year: $("#select_year").find("option:selected").val()
                  }
                  return query;
                }
                
            }
        });
        $('.select_two').select2();
        
        $('.data-table').DataTable({
          'paging'      : true,
          'lengthChange': false,
          'searching'   : true,
          'ordering'    : false,
          'info'        : true,
          'autoWidth'   : false
        });
        $('table.data-table').removeClass('dataTable');
        $('.data-table').show();
    });
</script>