<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Authentication extends MY_Controller {

	public function __construct() {
		parent::__construct();
		//load google login library
        	$this->load->library('googleplus');
	}
	
	public function index()
	{
		$this->login_page();
	}
	
	public function login_page()
	{
		if(!isset($this->session->userdata['logged_in']))
		{

			$this->data['page_title'] = 'Login';
			$this->data['content'] = 'admin/login_view';
			$this->data['validation_message'] = '';
			$this->data['login_url'] = $this->googleplus->loginURL();
			$this->load->view('authentication/login', $this->data);
		} else {
			redirect(site_url("dashboard"));
		}
	}
	
	public function login()
	{
		$message = "Not Validation";
		

		if(trim($this->input->post('username')) != "" && trim($this->input->post('password')) != "")
		{
			$username = $this->input->post('username');
			$password = $this->input->post('password');		
		
			$this->load->model('user_information_model', '', TRUE);
				$user_information = $this->user_information_model->backend_authentication_details($username, $password);
				
				if($user_information != false) 
				{

					$session_data = new stdClass();
					$session_data->uid = $user_information->uid;
					$session_data->username = $user_information->username;
					$session_data->password = $user_information->password;
					$session_data->fname = $user_information->fname." ".$user_information->lname;
					$session_data->privilege = $user_information->privilege;
					$session_data->userdp = $user_information->userdp;
					$session_data->division =  $user_information->division;
					$session_data->unit =  $user_information->unit;
					$this->session->set_userdata('logged_in', $session_data);
					$message = "Completed";
				}
				else
				{
					$message = "Please enter correct username and password";
				}					
		} 
		else 
		{
			$message = "Please enter correct values";					
		}	

		output_to_json($this, $message);	
	}	

	public function google_call_back(){
			if (isset($_GET['code'])) {
				
				$this->googleplus->getAuthenticate();
				$this->session->set_userdata('login',true);
				$this->session->set_userdata('user_profile',$this->googleplus->getUserInfo());
				$data = $this->session->userdata('user_profile');
				echo '<img src="'.$data['picture'].'" />';
				echo '<h1>HELLO YOU ARE '.$data['given_name']." ".$data['family_name'];
				
				exit();
				
			} 
		}

	public function logout()
	{
		$sess_array = array(
		'username' => ''
		);
		$this->session->unset_userdata('logged_in', $sess_array);
		$data['message_display'] = '<strong>Info:</strong> Successfully Logout';
		redirect('authentication');
	}
	
}
