<?php
	class Allotment_model extends CI_Model
	{
		public function __construct()
		{
			parent::__construct();
		}

		public function get_allotment_class_budget(){

			$query_string = "SELECT ac.id, ac.name as allotment_class_name, 2018 as `year`,
				IF (ISNULL(acb.amount), 0, acb.amount ) as amount
				FROM `allotment_class` as ac
				LEFT JOIN (SELECT orig_acb.allotment_class_id, SUM(orig_acb.amount) as amount FROM
				`allotment_class_budget`as orig_acb WHERE orig_acb.year = 2018 group by orig_acb.allotment_class_id
				) as acb ON acb.allotment_class_id = ac.id";
			$this->db->query($query_string);

			return $this->db->query($query_string)->result_object(); 
		}

		public function get_total_amount_allotment_class_budget($year){
			$query_string = "SELECT IF(ISNULL(sum(amount)), 0, sum(amount) ) as total_amount FROM `allotment_class_budget` WHERE year = ?";
			$result = $this->db->query($query_string, array($year))->result_object(); 
			return $result[0]->total_amount;
		}

		public function get_total_amount_allotment_class_budget_by_id($year, $allotment_class_id){
			$query_string = "SELECT IF(ISNULL(sum(amount)), 0, sum(amount) ) as total_amount FROM `allotment_class_budget` WHERE year = ? AND allotment_class_id = ?";
			$result = $this->db->query($query_string, array($year, $allotment_class_id))->result_object(); 
			return $result[0]->total_amount;
		}

		public function add_allotment_class_budget($data){
			$this->db->insert_batch('allotment_class_budget', $data); 
		}

	}
?>

