<!-- Content Wrapper. Contains page content -->

<div class="content-wrapper">
<!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
        Allotment
        <small></small>
        </h1>
        <ol class="breadcrumb">
        <li><a href="#"> Home</a></li>
        <li><a href="#">Tables</a></li>
        <li class="active">Data tables</li>
        </ol>
    </section>

    <section class="content">
        <div class="row">
            <div class="col-xs-12">
                <div class="box box-primary">
                    <div class="box-header">
                        <h3 class="box-title">Add New</h3>
                    </div>
                    <div class="box-body">
                        <div class="row"> 
                            <div class="col-xs-12">
                                <div class="row">
                                    <div class="col-xs-12 col-md-3">
                                        <div class="form-group">
                                            <label>Year</label>
                                            <select class="form-control">
                                                <?php for($year=date("Y"); $year >= (date("Y") - 2); $year--): ?>
                                                    <option value="<?=$year?>"><?=$year?></option>
                                                <?php endfor; ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row"> 
                            <div class="col-xs-12">
                                <div class="form-group">
                                    <label>Fund</label>
                                    <select class="form-control select2">
                                        <option value="1">Regular Agency Fund - General Fund - New General Appropriations - Specific Budgets of National Government Agencies</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row"> 
                            <div class="col-xs-12">
                                <div class="form-group">
                                 <label>Legal Basis</label>
                                    <select class="form-control select2" >
                                        <option value="1">RA 10964 Regular 2018 CURRENT</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <br/>

                        <div class="row"> 
                            <div class="col-xs-12">
                                <label>Details</label>
                                <div class="pull-right">
                                    
                                    <a class="btn"  id="show_add_details_modal">
                                        <i class="fa fa-plus"></i> Add
                                    </a>
                                </div>
                                <table id="details_table" class="table table-bordered">
                                    <tr>
                                        <th>P.P.A/PREXC</th>
                                        <th>Responsibility Center</th>
                                        <th>Object of Expenditures</th>
                                        <th>1st Qtr</th>
                                        <th>2nd Qtr</th>
                                        <th>3rd Qtr</th>
                                        <th>4rth Qtr</th>
                                        <th>Action</th>
                                    </tr>
                                    <!-- <tr>
                                        <td>183</td>
                                        <td>John Doe</td>
                                        <td>11-7-2014</td>
                                        <td>Approved</td>
                                    </tr> -->
                                </table>
                            </div>
                        </div>

                        <div class="modal fade" id="add_details_modal">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                <div class="modal-header">
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span></button>
                                    <h4 class="modal-title">Details</h4>
                                </div>
                                <div class="modal-body">
                                    <div class="callout callout-danger" id="add_error_message" style="display:none;" >
                                        <p>Insufficient funds, Please check.</p>
                                    </div>
                                    <div class="row"> 
                                        <div class="col-xs-12">
                                            <div class="form-group">
                                                <label>P.P.A/PREXC</label>
                                                <select class="form-control select2" id="ppa" style="width: 100%">
                                                    <?php if(count($prexc) > 0): ?>
                                                        <?php foreach($prexc as $ppa): ?>
                                                            <option value="<?=$ppa->id?>"><?=$ppa->code ." - " . $ppa->description ?></option>
                                                        <?php endforeach; ?>
                                                    <?php endif;?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row"> 
                                        <div class="col-xs-12">
                                            <div class="form-group">
                                            <label>Responsibility Center</label>
                                                <select class="form-control select2"  id="rc" style="width: 100%">
                                                    <?php if(count($rc) > 0): ?>
                                                        <?php foreach($rc as $res_center): ?>
                                                            <option value="<?=$res_center->id?>"><?=$res_center->code . " - " .  $res_center->description ?></option>
                                                        <?php endforeach; ?>
                                                    <?php endif;?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row"> 
                                        <div class="col-xs-12">
                                            <div class="form-group">
                                            <label>Object of Expenditures</label>
                                                <select class="form-control select2" id="object_of_expenditures" style="width: 100%">
                                                    <?php if(count($objects) > 0): ?>
                                                        <?php foreach($objects as $obj): ?>
                                                            <option value="<?=$obj->id?>"><?=$obj->code ." - " . $obj->allotment_class . " - " .  $obj->description ?></option>
                                                        <?php endforeach; ?>
                                                    <?php endif;?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <label>Amount</label>
                                    <div class="row">
                                        <div class="col-xs-6">
                                            <div class="form-group">
                                                <input type="number" name="1st" id="1st" placeholder="1st Quarter"  class="add_budget_amount form-control" />
                                            </div>
                                        </div>
                                        <div class="col-xs-6">
                                            <div class="form-group">
                                                <input type="number"  name="2nd" id="2nd" placeholder="2nd Quarter" class="add_budget_amount form-control" />
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-xs-6">
                                            <div class="form-group">
                                                <input type="number"  name="3rd" id="3rd" placeholder="3rd Quarter"  class="add_budget_amount form-control" />
                                            </div>
                                        </div>
                                        <div class="col-xs-6">
                                            <div class="form-group">
                                                <input type="number"  name="4rth" id="4rth" placeholder="4rth Quarter" class="add_budget_amount form-control" />
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Cancel</button>
                                    <button type="button" class="btn btn-primary" id="add_details_btn">Add</button>
                                </div>
                                </div>
                                <!-- /.modal-content -->
                            </div>
                            <!-- /.modal-dialog -->
                            </div>
                    </div>
                    <div class="box-footer">
                        <div class="pull-right">
                        <button type="button" class="btn btn-primary">Submit</button>
                        </div>
                    </div>
                <!-- /.box-body -->
                </div>
            </div>
        </div>
    </section>
<!-- /.content -->
</div>
<script type="text/javascript">
    $(document).ready(function() {
        $("#add_details_btn").click(function() {
            

            $("#add_error_message").hide();
            var total_new_budget_amount = 0;
            $("input.add_budget_amount").each(function(){
                if (/^\d+$/.test($(this).val())) {
                    total_new_budget_amount +=  parseInt($(this).val()); 
                } else {
                    $(this).val(0);
                }
            });
            if(total_new_budget_amount > 0) {
                $.post('<?=base_url();?>allotment/get_available_allotment_class_budget',{ object_id: $("#object_of_expenditures").val() },
                    function(e){
                        if(e.available_amount >= total_new_budget_amount) {
                           // $("form#add_alottment_class_budget").submit(); 
                            var new_details = "<tr>";
                            new_details += "<td>" + $("#ppa").text() + "</td>";
                            new_details += "<td>" + $("#rc").text() + "</td>";
                            new_details += "<td>" + $("#object_of_expenditures").text() + "</td>";
                            new_details += "<td><input class='add_budget_amount' type='hidden' value='"+ $("#1st").val() +"'/>" + $("#1st").val() + "</td>";
                            new_details += "<td><input class='add_budget_amount' type='hidden' value='"+ $("#2nd").val() +"'/>" + $("#2nd").val() + "</td>";
                            new_details += "<td><input class='add_budget_amount' type='hidden' value='"+ $("#3rd").val() +"'/>" + $("#3rd").val() + "</td>";
                            new_details += "<td><input class='add_budget_amount' type='hidden' value='"+ $("#4rth").val() +"'/>" + $("#4rth").val() + "</td>";

                            new_details += "<td align='center'><button type='button' class='btn btn-xs btn-danger' onclick='remove_details(this);'>x</button></td>";
                            new_details += "<tr>";

                            $("#details_table").append(new_details);
                            $("#add_details_modal").modal("hide");
                        } else {
                            $("#add_error_message").show();
                            $("#add_error_message").html("<p>Insufficient <strong><a href='<?=base_url()?>/allotment/allotment_class_budget' target='_blank'>"+ e.allotment_class.name +"</a></strong> funds, Please check.</p>");
                        }
                    }
                );
            } else {
                $("#add_error_message").show();
                $("#add_error_message").html("<p>Total budget amount must greater than zero.</p>");
            }
        }); 

        $("#show_add_details_modal").click(function() {
            $("#1st").val(""); 
            $("#2nd").val(""); 
            $("#3rd").val(""); 
            $("#4rth").val(""); 
            $("#add_details_modal").modal("show");
        });


    });

    function remove_details(btn) {
        $(btn).closest("tr").remove();
    }
</script>