<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class dashboard extends MY_Controller {

	public function __construct() {
		parent::__construct();
		$this->isLogin();
	}

	public function index()
	{
		$this->list();
	
	}

	public function add_program()
	{
		$this->load->model('dashboard_model', '', TRUE);

		$data = array();
		$data["parent_id"] = $this->input->post('parent_id');
		$data["code"] = $this->input->post('code');
		$data["acronym"] = $this->input->post('acronym');
		$data["description"] = $this->input->post('description');

		$this->dashboard_model->add_program($data);

		redirect(site_url("dashboard/list"));
	}


	public function edit_program()
	{
		$this->load->model('dashboard_model', '', TRUE);

		$data = array();
		$data["parent_id"] = $this->input->post('parent_id');
		$data["code"] = $this->input->post('code');
		$data["acronym"] = $this->input->post('acronym');
		$data["description"] = $this->input->post('description');
		$id = $this->input->post('id');

		$this->dashboard_model->edit_program($data,$id);

		redirect(site_url("dashboard/list"));
	}

	public function list()
	{
		$this->data['userdata'] = $this->session->userdata('logged_in');
		$this->data['content'] = 'dashboard/list';
		$this->load->model('dashboard_model', '', TRUE);

		$this->data['program_list'] = $this->dashboard_model->all_program();
		
		$this->load->view('template/admin', $this->data);
	}
	public function table_row(){
		//$this->output->enable_profiler(TRUE);
		//$this->benchmark->mark('starting_point');
		$this->load->model('dashboard_model', '', TRUE);

			$columns = array( 
                            0 =>'ID', 
                            1 =>'code',
                            2=> 'acronym',
                            3=> 'description',
                            4=> 'action',
                        );
			$limit = $this->input->post('length');
	        	$start = $this->input->post('start');
	        	$order = $columns[$this->input->post('order')[0]['column']];
	        	$dir = $this->input->post('order')[0]['dir'];

			$totalData = $this->dashboard_model->count_program_list();
            
        		$totalFiltered = $totalData; 
			if(empty($this->input->post('search')['value']))
				{            
			      $program_table = $this->dashboard_model->program_list($limit,$start,$order,$dir);
				}
			else {
			       $search = $this->input->post('search')['value']; 

			       $program_table =  $this->dashboard_model->search_program_list($limit,$start,$order,$dir,$search);

			       $totalFiltered = $this->dashboard_model->count_search_program_list($search);
				}
			$data = array();
			        if(!empty($program_table))
			        {
			            foreach ($program_table as $prog)
			            {
			                $nestedData['ID'] = $prog->id;
			                $nestedData['code'] = $prog->code;
			                $nestedData['acronym'] = $prog->acronym;
			                $nestedData['description'] = $prog->description;
			                $nestedData['action'] = '<a href="#" id="edit" class="edit" prog_id="'.$prog->id.'" code="'.$prog->code.'" acronym="'.$prog->acronym.'" description="'.$prog->description.'"  parent_id="'.$prog->parent_id.'" >
                                   <i class="fa fa-edit"></i> 
                               </a> | ';
			                $data[] = $nestedData;

			            }
			        }	
			 $json_data = array(
			                    "draw"            => intval($this->input->post('draw')),  
			                    "recordsTotal"    => intval($totalData),  
			                    "recordsFiltered" => intval($totalFiltered), 
			                    "data"            => $data   
			                    );
			            
			        echo json_encode($json_data); 	
			       // $this->benchmark->mark('ending_point');
				//echo $this->benchmark->elapsed_time('starting_point', 'ending_point');
	}
}
