<?php
	class indicator_model extends CI_Model
	{
		public function __construct()
		{
			parent::__construct();
		}

		public function add_indicator($data){
			$this->db->insert('performance_indicator', $data); 
			return $this->db->insert_id();
		}
		public function insert_to_accomplishment($pi_id){
			$data = array('pi_id' => $pi_id); 
			$this->db->insert('accomplishments',$data); 
			return $this->db->insert_id();
		}		

		public function insert_to_accomplishment_status($acc_id){
			$data = array(
			   array(
			      'acc_id' => $acc_id ,
			      'month' => 'jan' ,
			   ),
			   array(
			      'acc_id' => $acc_id ,
			      'month' => 'feb' ,
			   ),
			   array(
			      'acc_id' => $acc_id ,
			      'month' => 'mar' ,
			   ),
			   array(
			      'acc_id' => $acc_id ,
			      'month' => 'apr' ,
			   ),
			   array(
			      'acc_id' => $acc_id ,
			      'month' => 'may' ,
			   ),
			   array(
			      'acc_id' => $acc_id ,
			      'month' => 'jun' ,
			   ),
			   array(
			      'acc_id' => $acc_id ,
			      'month' => 'jul' ,
			   ),
			   array(
			      'acc_id' => $acc_id ,
			      'month' => 'aug' ,
			   ),
			   array(
			      'acc_id' => $acc_id ,
			      'month' => 'sep' ,
			   ),
			   array(
			      'acc_id' => $acc_id ,
			      'month' => 'oct' ,
			   ),
			   array(
			      'acc_id' => $acc_id ,
			      'month' => 'nov' ,
			   ),
			   array(
			      'acc_id' => $acc_id ,
			      'month' => 'decem' ,
			   )
			); 
			$this->db->insert_batch('accomplishment_status',$data); 
		}
		public function indicator_status($data){
			$this->db->insert('indicator_status', $data); 
		}
		public function indicator_status_checker($project_id,$year){
			$this->db->select('*');
			$this->db->from('indicator_status');
			$this->db->WHERE('project_id',$project_id);
			$this->db->WHERE('year',$year);
			return $this->db->get()->result_object(); 
		}
		public function acc_status_checker($project_id,$year){
			$this->db->select('*');
			$this->db->from('accomplishment_status');
			$this->db->WHERE('project_id',$project_id);
			$this->db->WHERE('year',$year);
			return $this->db->get()->result_object(); 
		}
		public function project_list(){
			$this->db->select('*');
			$this->db->from('responsibility_center');
			$this->db->order_by('id','desc');
			return $this->db->get()->result_object(); 
		}
		public function indicator_list($project_id,$year){
			$this->db->select('*');
			$this->db->from('performance_indicator');
			$this->db->WHERE('year',$year);
			$this->db->WHERE('project_id',$project_id);
			$this->db->order_by('pi_id','ASC');
			return $this->db->get()->result_object(); 
		}

		public function finalize_indicator_status($project_id,$year){
			$this->db->set('status', '1');
			$this->db->where('project_id', $project_id); 
			$this->db->where('year', $year); 
			$this->db->update('indicator_status'); 
			//echo $this->db->last_query();
		}

		public function edit_indicator($data,$pi_id){
			$this->db->where('pi_id', $pi_id); 
			$this->db->update('performance_indicator',$data); 
			//echo $this->db->last_query();
		}

	}
?>

