<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class expenses extends MY_Controller {

	public function __construct() {
		parent::__construct();
		$this->isLogin();
	}

	public function index()
	{
		$this->list();
	}

	public function list()
	{
		$this->load->model('expenses_model', '', TRUE);
		$this->data['userdata'] = $this->session->userdata('logged_in');
		$this->data['content'] = 'expenses/list';
		$this->data['expenses_list'] = $this->expenses_model->get_expenses_list();
		$this->load->view('template/admin', $this->data);
	}

	public function add_expenses()
	{
		$this->load->model('expenses_model', '', TRUE);

		$data = array();
		$data["type"] = $this->input->post('type');
		$data["details"] = $this->input->post('details');
		$data["amount"] = $this->input->post('amount');
		$data["date"] = $this->input->post('date');

		$this->expenses_model->add_object($data);

		redirect(site_url("expenses/list"));
	}

	public function edit_expenses()
	{
		$this->load->model('expenses_model', '', TRUE);

		$data = array();
		$data["type"] = $this->input->post('type');
		$data["details"] = $this->input->post('details');
		$data["amount"] = $this->input->post('amount');
		$data["date"] = $this->input->post('date');
		$expenses_id = $this->input->post('expenses_id');

		$this->expenses_model->edit_expenses($data,$expenses_id);

		redirect(site_url("expenses/list"));
	}

}
