<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class product extends MY_Controller {

	public function __construct() {
		parent::__construct();
		$this->isLogin();
	}

	public function index()
	{
		$this->list();
	
	}

	public function add_product()
	{
		$this->load->model('product_model', '', TRUE);

		$data = array();
		$data["brand_name"] = $this->input->post('brand_name');
		$data["product_name"] = $this->input->post('product_name');
		$data["unit"] = $this->input->post('unit');
		$data["srp"] = $this->input->post('srp');
		$data["description"] = $this->input->post('description');

		$this->product_model->add_product($data);

		redirect(site_url("product/list"));
	}

	public function add_stocks()
	{
		$this->load->model('product_model', '', TRUE);

		$data = array();
		$data["product_id"] = $this->input->post('product_id');
		$data["supplier_price"] = $this->input->post('supplier_price');
		$data["stock_quantity"] = $this->input->post('stock_quantity');
		$data["investment"] = $this->input->post('investment');
		$data["exp_date"] = $this->input->post('exp_date');
		$data["stock_date"] = date("Y-m-d H-i-s");

		$this->product_model->add_stocks($data);

		$data2 = new stdclass();
		$data2->product_id = $this->input->post('product_id');
		$data2->stock_quantity = $this->input->post('stock_quantity');

		$this->product_model->update_product_stock($data);

		redirect(site_url("product/stocks_per_product?product_id=".$data["product_id"]));
	}

	public function edit_product()
	{
		$this->load->model('product_model', '', TRUE);

		$data = array();
		$data["brand_name"] = $this->input->post('brand_name');
		$data["product_name"] = $this->input->post('product_name');
		$data["unit"] = $this->input->post('unit');
		$data["srp"] = $this->input->post('srp');
		$data["description"] = $this->input->post('description');
		$product_id = $this->input->post('product_id');

		$this->product_model->edit_product($data,$product_id);

		redirect(site_url("product/list"));
	}

	public function edit_stock()
	{
		$this->load->model('product_model', '', TRUE);

		$data = array();
		$data["supplier_price"] = $this->input->post('supplier_price');
		$data["stock_quantity"] = $this->input->post('stock_quantity');
		$data["investment"] = $this->input->post('investment');
		$data["exp_date"] = $this->input->post('exp_date');
		$stock_id = $this->input->post('stock_id');
		$product_id = $this->input->post('product_id');
		$data2 = array();
		$data2["product_id"]= $product_id;
		$data2["stock_quantity"] = $data["stock_quantity"] - $this->input->post('old_stock');

		$this->product_model->update_product_stock($data2);


		$this->product_model->edit_stock($data,$stock_id);

		redirect(site_url("product/stocks_per_product?product_id=").$product_id);
	}

	public function archive_stock()
	{
		$this->load->model('product_model', '', TRUE);

		$data = array();
		$data["status"] = $this->input->post('archive');
		$stock_id = $this->input->post('stock_id');
		$product_id = $this->input->post('product_id');

		$this->product_model->edit_stock($data,$stock_id);

		redirect(site_url("product/stocks_per_product?product_id=").$product_id);
	}

	public function sale_stock()
	{
		$this->load->model('product_model', '', TRUE);

		$data = array();
		$data["sale_price"] = $this->input->post('sale_price');
		$stock_id = $this->input->post('sstock_id');
		$product_id = $this->input->post('pproduct_id');

		$this->product_model->sale_stock($data,$stock_id);

		redirect(site_url("product/stocks_per_product?product_id=").$product_id);
	}

	public function list()
	{
		$this->data['userdata'] = $this->session->userdata('logged_in');
		$this->data['content'] = 'product/list';
		$this->load->model('product_model', '', TRUE);

		$this->data['product_list'] = $this->product_model->product_list();
		
		$this->load->view('template/admin', $this->data);
	}

	public function stocks_per_product()
	{
		$this->data['userdata'] = $this->session->userdata('logged_in');
		$this->data['content'] = 'product/stocks_per_product';
		$this->load->model('product_model', '', TRUE);
		$product_id = $this->input->get('product_id');

		$this->data['product_details'] = $this->product_model->product_details($product_id);

		$this->data['stocks_list'] = $this->product_model->stocks_per_product($product_id);
		$this->data['product_id']=$product_id;
		$this->load->view('template/admin', $this->data);
	}
}
