<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Responsibility_center extends MY_Controller {

	public function __construct() {
		parent::__construct();
		$this->isLogin();
	}

	public function index()
	{
		$this->list();
	}

	public function list()
	{
		$this->load->model('responsibility_center_model', '', TRUE);
		$this->data['content'] = 'responsibility_center/list';
		$this->data['responsibility'] = $this->responsibility_center_model->get_responsibility_center_list();
		$this->load->view('template/admin', $this->data);
	}

	public function add_responsibility_center()
	{
		$this->load->model('responsibility_center_model', '', TRUE);

		$data = array();
		$data["code"] = $this->input->post('code');
		$data["description"] = $this->input->post('description');

		$this->responsibility_center_model->add_responsibility_center($data);

		redirect(site_url("responsibility_center/list"));
	}

	public function objects()
	{
		$this->load->model('responsibility_center_model', '', TRUE);
		$this->data['content'] = 'responsibility_center/objects';
		$this->data['rc_details'] = $this->responsibility_center_model->get_rc_details($this->input->get('rc'));
		$this->data['rc_objects'] = $this->responsibility_center_model->get_rc_object_list($this->input->get('rc'));
		$this->data['rc_new_objects'] = $this->responsibility_center_model->get_rc_new_object_list($this->input->get('rc'));

		$this->load->view('template/admin', $this->data);
	}

	public function add_rc_objects()
	{
		$this->load->model('responsibility_center_model', '', TRUE);

		$data = array();
		$data["rc_id"] = $this->input->post('rc_id');
		$data["object_id"] = $this->input->post('object_id');

		$this->responsibility_center_model->add_rc_objects($data);

		redirect(site_url("responsibility_center/objects?rc=" . sha1("rc".$data["rc_id"])));
	}

}
