<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class sales extends MY_Controller {

	public function __construct() {
		parent::__construct();
		$this->isLogin();
	}

	public function index()
	{
		$this->place_orders();
	}



	public function place_orders()
	{
		$this->data['userdata'] = $this->session->userdata('logged_in');
		$this->load->model('sales_model', '', TRUE);
		$this->load->model('customers_model', '', TRUE);
		$this->data['content'] = 'sales/place_orders';
		$this->data['stock_list'] = $this->sales_model->get_stock_list();
		$this->data['customers_list'] = $this->customers_model->get_customers_list();
		$this->load->view('template/admin', $this->data);
	
	}
	public function history()
	{
		$this->load->model('sales_model', '', TRUE);
		$this->load->model('product_model', '', TRUE);
		$this->load->model('customers_model', '', TRUE);
		$this->data['product_list'] = $this->product_model->product_list();
		$this->data['customers_list'] = $this->customers_model->get_customers_list();
		$this->data['userdata'] = $this->session->userdata('logged_in');
		$this->data['content'] = 'sales/history';

		$search = $this->input->post('submit');
		if($search == 'Search'){
		$search_data = new stdClass();
		$search_data->date_from = $this->input->post('date_from');
		$search_data->date_to = $this->input->post('date_to');
		$search_data->product_id = $this->input->post('product_id');
		$search_data->remarks = $this->input->post('remarks');
		$search_data->sold_to = $this->input->post('customers_id');
		$this->data['history'] = $this->sales_model->sales_history_search($search_data);
		}
		else
		{
		$this->data['history'] = $this->sales_model->sales_history();
		}		
		$this->load->view('template/admin', $this->data);
	
	}

	public function submit_orders()
	{
		$this->load->model('sales_model', '', TRUE);
		$this->load->model('customers_model', '', TRUE);
		$data = new stdClass();
		foreach($this->input->post('stock_id') as $a){
		$data->stock_id[] = $a;
		}
		foreach($this->input->post('order_quantity') as $b){
		$data->quantity[] = $b;
		}
		foreach($this->input->post('price') as $c){
		$data->price_sold[] = $c;
		}
		foreach($this->input->post('product_id') as $d){
		$data->product_id[] = $d;
		}
		foreach($this->input->post('brand_name') as $e){
		$data->brand_name[] = $e;
		}
		foreach($this->input->post('product_name') as $f){
		$data->product_name[] = $f;
		}
		foreach($this->input->post('unit') as $g){
		$data->unit[] = $g;
		}
		$data->total_price = $this->input->post('total_price');
		$data->amount_tendered = $this->input->post('amount_tendered');
		$data->change = $this->input->post('change');
		$data->date_sold = date("Y-m-d h:i:sa");
		$data->sold_to =  $this->input->post('sold_to');
		$data->remarks =  $this->input->post('remarks');
		$data->used_points =  $this->input->post('used_points');
		$data->leftover =  $this->input->post('leftover');
		$data->customer_name =  $this->input->post('customer_name');

		if($data->used_points > $data->total_price){
			$data->used_points = $data->total_price;
		}

		$amount = ($data->total_price-$data->used_points)+$data->leftover;

		$data->points = floor(($amount / 200)-$data->used_points);
		$data->points_acquired = ($data->points<0)? '0':$data->points;
	
		
		$tempMod = (float)($amount / 200);
 		$tempMod = ($tempMod - (int)$tempMod)*200;

 		$data->leftover = $tempMod;
 		$data->tonext_point = 200-$tempMod;

		$data->transaction_id = $this->sales_model->get_last_trans()+1;

		$this->sales_model->add_quantity_sold($data);
		$this->sales_model->decrease_stocks($data);
		$this->sales_model->submit_orders($data);
		$this->customers_model->update_points_leftover($data);

		$counter = count($data->stock_id);

		$this->session->set_flashdata('message', $data);

		$num = count($data->stock_id);
		redirect(site_url("sales/place_orders"));
	}


	public function void_trans()
	{
		$this->load->model('sales_model', '', TRUE);
		$data = new stdClass();
		$data->sales_id = $this->input->post('sales_id');
		$data->stock_id = $this->input->post('stock_id');
		$data->product_id = $this->input->post('product_id');
		$data->quantity = $this->input->post('quantity');
		$data->total_price = $this->input->post('total_price');

		$this->sales_model->void_trans($data);
		$this->sales_model->void_stock($data);
		$this->sales_model->void_product($data);

		
		$this->session->set_flashdata('message', $data);

		
		redirect(site_url("sales/history"));
	}

}
