<?php
	class product_model extends CI_Model
	{
		public function __construct()
		{
			parent::__construct();
		}

		public function add_product($data){
			$this->db->insert('product', $data); 
		}

		public function add_stocks($data){
			$this->db->insert('stocks', $data); 
		}

		public function edit_product($data,$product_id){
			$this->db->where('product_id', $product_id); 
			$this->db->update('product', $data); 
			//echo $this->db->last_query();
		}
		public function edit_stock($data,$stock_id){
			$this->db->where('stock_id', $stock_id); 
			$this->db->update('stocks', $data); 
			//echo $this->db->last_query();
		}

		public function product_list(){
			$this->db->select('*');
			$this->db->from('product');
			$this->db->order_by("product_id", "desc"); 
			return $this->db->get()->result_object(); 
		}

		public function stocks_per_product($product_id){
			$this->db->select('a.*, b.*');
			$this->db->from('product a');
			$this->db->join('stocks b', 'b.product_id = a.product_id');
			$this->db->where("b.product_id", $product_id); 
			return $this->db->get()->result_object(); 
		}

		public function product_details($product_id){
			$this->db->select('*');
			$this->db->from('product');
			$this->db->where("product_id", $product_id); 
			$this->db->order_by("brand_name"); 
			return $this->db->get()->result_object()[0]; 
		}

		public function update_product_stock($data){
			$this->db->where('product_id', $data['product_id']);
			$this->db->set('total_stocks', 'total_stocks+'.$data['stock_quantity'], FALSE);
			$this->db->update('product'); 
			//echo $this->db->last_query();
		}
		public function sale_stock($data,$stock_id){
			$this->db->where('stock_id', $stock_id);
			$this->db->set('sale_price', $data['sale_price']);
			$this->db->update('stocks'); 
			//echo $this->db->last_query();
		}

	}
?>

