<?php
	class reports_model extends CI_Model
	{
		public function __construct()
		{
			parent::__construct();
		}

		public function search_history_active($data){
			$this->db->select('a.sales_id, a.stock_id, a.quantity, a.price_sold, a.date_sold,a.transaction_id,a.sold_to,a.used_points,a.remarks, b.product_id as p_id, b.product_name, b.brand_name, b.unit, c.product_id, c.supplier_price, d.customers_id,d.fname,d.lname');
			$this->db->from('sales a');
			$this->db->join('stocks c', 'c.stock_id = a.stock_id');
			$this->db->join('product b', 'b.product_id = c.product_id');
			$this->db->join('customers d', 'd.customers_id = a.sold_to','LEFT');
			$this->db->order_by("sales_id", "desc");
			if($data->date_from != ""){
				$date_from = date('Y-m-d H:i:s', strtotime($data->date_from." 00:00:00")); 
				$this->db->WHERE('a.date_sold >=',$date_from);
			}
			if($data->date_to != ""){
				$date_to = date('Y-m-d H:i:s', strtotime($data->date_to." 23:59:59"));
				$this->db->where('a.date_sold <=', $date_to);
			}
			if($data->product_id != ""){
			$this->db->where('b.product_id', $data->product_id);
			}
			if($data->remarks != ""){
			$this->db->like('a.remarks', $data->remarks);
			}
			if($data->sold_to != ""){
			$this->db->where('a.sold_to', $data->sold_to);
			}
			$query = $this->db->get();
			//echo $this->db->last_query();
			return $query->result();
		}

		public function search_history($data){
			$this->db->select('a.sales_id, a.stock_id, a.quantity, a.price_sold, a.date_sold,a.transaction_id,a.sold_to,a.used_points,a.remarks, b.product_id as p_id, b.product_name, b.brand_name, b.unit, c.product_id, c.supplier_price, d.customers_id,d.fname,d.lname');
			$this->db->from('sales a');
			$this->db->join('stocks c', 'c.stock_id = a.stock_id');
			$this->db->join('product b', 'b.product_id = c.product_id');
			$this->db->join('customers d', 'd.customers_id = a.sold_to','LEFT');
			$this->db->order_by("sales_id", "desc");
			$this->db->WHERE('a.date_sold >=',$data->date_from);
			$this->db->where('a.date_sold <=', $data->date_to);
			$query = $this->db->get();
			//echo $this->db->last_query();
			return $query->result();
		}

		public function sum_points_active($data){
			$query = "SELECT SUM(sales.used_points) as most_used_points, sales.sold_to, sales.date_sold, b.fname,b.lname,b.customers_id  FROM (select * from sales GROUP BY transaction_id) sales JOIN `customers` `b` ON `b`.`customers_id` = `sales`.`sold_to`  WHERE `date_sold` >= '.$data->date_from.' AND `date_sold` <= '$data->date_to' group by sales.sold_to ";
			$query = $this->db->query($query);
			$result = $query->result();
			return	$result;
		}
		public function sum_points($data){
			$query = "SELECT SUM(sales.used_points) as most_used_points, sales.sold_to, sales.date_sold, b.fname,b.lname,b.customers_id  FROM (select * from sales GROUP BY transaction_id) sales JOIN `customers` `b` ON `b`.`customers_id` = `sales`.`sold_to`  WHERE `date_sold` >= '.$data->date_from.' AND `date_sold` <= '$data->date_to' group by sales.sold_to ";
			$query = $this->db->query($query);
			$result = $query->result();
			return	$result;
		}
		public function sum_history_active($data){
			$this->db->select('a.sales_id, a.stock_id,a.transaction_id, a.quantity, SUM(a.price_sold) AS total_per_user , a.date_sold,a.sold_to,SUM(a.used_points) AS most_used_points,d.customers_id,d.fname,d.lname');
			$this->db->from('sales a');
			$this->db->join('stocks c', 'c.stock_id = a.stock_id');
			$this->db->join('product b', 'b.product_id = c.product_id');
			$this->db->join('customers d', 'd.customers_id = a.sold_to','LEFT');
			$this->db->order_by("sales_id", "desc");
			if($data->date_from != ""){
				$date_from = date('Y-m-d H:i:s', strtotime($data->date_from." 00:00:00")); 
				$this->db->WHERE('a.date_sold >=',$date_from);
			}
			if($data->date_to != ""){
				$date_to = date('Y-m-d H:i:s', strtotime($data->date_to." 23:59:59"));
				$this->db->where('a.date_sold <=', $date_to);
			}
			if($data->remarks != ""){
			$this->db->like('a.remarks', $data->remarks);
			}
			if($data->sold_to != ""){
			$this->db->where('a.sold_to', $data->sold_to);
			}
			$this->db->group_by('a.sold_to');
			$query = $this->db->get();
			//echo $this->db->last_query();
			return $query->result();
		}
		public function sum_history($data){
			$this->db->select('a.sales_id, a.stock_id,a.transaction_id, a.quantity, SUM(a.price_sold) AS total_per_user , a.date_sold,a.sold_to,SUM(a.used_points) AS most_used_points,d.customers_id,d.fname,d.lname');
			$this->db->from('sales a');
			$this->db->join('stocks c', 'c.stock_id = a.stock_id');
			$this->db->join('product b', 'b.product_id = c.product_id');
			$this->db->join('customers d', 'd.customers_id = a.sold_to','LEFT');
			$this->db->order_by("sales_id", "desc");
			$this->db->WHERE('a.date_sold >=',$data->date_from);
			$this->db->where('a.date_sold <=', $data->date_to);
			$this->db->group_by('a.sold_to');
			$query = $this->db->get();
			//echo $this->db->last_query();
			return $query->result();
		}
		public function sum_product_active($data){
			$this->db->select('a.sales_id, a.stock_id, SUM(a.quantity) as total_quantity, SUM(a.price_sold) AS total_price, a.date_sold,a.sold_to,d.customers_id,d.fname,d.lname,b.product_id as p_id, b.product_name, b.brand_name, b.unit');
			$this->db->from('sales a');
			$this->db->join('stocks c', 'c.stock_id = a.stock_id');
			$this->db->join('product b', 'b.product_id = c.product_id');
			$this->db->join('customers d', 'd.customers_id = a.sold_to','LEFT');
			$this->db->order_by("sales_id", "desc");
			if($data->date_from != ""){
				$date_from = date('Y-m-d H:i:s', strtotime($data->date_from." 00:00:00")); 
				$this->db->WHERE('a.date_sold >=',$date_from);
			}
			if($data->date_to != ""){
				$date_to = date('Y-m-d H:i:s', strtotime($data->date_to." 23:59:59"));
				$this->db->where('a.date_sold <=', $date_to);
			}
			if($data->product_id != ""){
			$this->db->where('b.product_id', $data->product_id);
			}
			if($data->remarks != ""){
			$this->db->like('a.remarks', $data->remarks);
			}
			if($data->sold_to != ""){
			$this->db->where('a.sold_to', $data->sold_to);
			}
			$this->db->group_by('b.product_id');
			$query = $this->db->get();
			//echo $this->db->last_query();
			return $query->result();
		}
		public function sum_product($data){
			$this->db->select('a.sales_id, a.stock_id, SUM(a.quantity) as total_quantity, SUM(a.price_sold) AS total_price, a.date_sold,a.sold_to,d.customers_id,d.fname,d.lname,b.product_id as p_id, b.product_name, b.brand_name, b.unit');
			$this->db->from('sales a');
			$this->db->join('stocks c', 'c.stock_id = a.stock_id');
			$this->db->join('product b', 'b.product_id = c.product_id');
			$this->db->join('customers d', 'd.customers_id = a.sold_to','LEFT');
			$this->db->order_by("sales_id", "desc");
			$this->db->WHERE('a.date_sold >=',$data->date_from);
			$this->db->where('a.date_sold <=', $data->date_to);
			$this->db->group_by('b.product_id');
			$query = $this->db->get();
			//echo $this->db->last_query();
			return $query->result();
		}
		public function search_expenses_active($data){
			$this->db->select('type,details,amount,date');
			$this->db->from('expenses');
			$this->db->order_by("date", "desc");
			if($data->date_from != ""){
				$date_from = date('Y-m-d H:i:s', strtotime($data->date_from." 00:00:00")); 
				$this->db->WHERE('date >=',$date_from);
			}
			if($data->date_to != ""){
				$date_to = date('Y-m-d H:i:s', strtotime($data->date_to." 23:59:59"));
				$this->db->where('date <=', $date_to);
			}
			$query = $this->db->get();
			//echo $this->db->last_query();
			return $query->result();
		}
		public function search_expenses($data){
			$this->db->select('type,details,amount,date');
			$this->db->from('expenses');
			$this->db->order_by("date", "desc");
			$this->db->WHERE('date >=',$data->date_from);
			$this->db->where('date <=', $data->date_to);
			$query = $this->db->get();
			//echo $this->db->last_query();
			return $query->result();
		}

		
	}
?>

